function [K,MC,Ge,Ce,V,DP,btotg,T,B,D,detJt,Bn]=Hexa(E,NU,rho,coordor,n,Ns,Nt,Nu,GyroFlag)

D = (E/((1+NU)*(1-2*NU)))*[1-NU NU NU 0 0 0 ;
    NU 1-NU NU 0 0 0 ;
    NU NU 1- NU 0 0 0 ;
    0 0 0 (1-2*NU)/2 0 0 ;
    0 0 0 0 (1- 2*NU)/2 0 ;
    0 0 0 0 0 (1- 2*NU)/2];

[MC,V,DP,Ge,Ce]=Masses(rho,coordor,n,Ns,Nt,Nu,GyroFlag);

[btotg, detJt,Tra, detra2, B,R,R_]=Bmatrix(coordor,Ns,Nt,Nu);

ACell = repmat({Tra}, 1, 8);
Tr = blkdiag(ACell{:});

B=B/V;

MC=reorder_dof(MC);

if GyroFlag == 1
    Ge=Ge-Ge.';
end

[Ktot,T,Bn]= Kbrick(btotg,D,detJt,detra2,R,R_);
K=Tr'*Ktot*Tr;

end
