function [btotn, detJt, Tra,detra2, BN]=Bmatrix_P3x7(coordor,Ns21,Nt21,Nu21)

b1=zeros(6,45,21);
detJt=zeros(21,1);


% passaggio al sistema di riferimento locale
[coord,Tra,tradef,detra2,traspo]=local_sys_P2(coordor);

xn=coord(:,1);
yn=coord(:,2);
zn=coord(:,3);



% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Normal strain components derivation
for ii=1:21
    
    Nxi=Ns21(ii,:);
    Net=Nt21(ii,:);
    Nze=Nu21(ii,:);
    
    xxi=Nxi*xn;
    
    xze=Nze*xn;
    
    xet=Net*xn;
    
    yxi=Nxi*yn;
    
    yze=Nze*yn;
    
    yet=Net*yn;
    
    zxi=Nxi*zn;
    
    zze=Nze*zn;
    
    zet=Net*zn;
    
    
    J=[xxi, yxi, zxi
        xet, yet, zet
        xze, yze, zze];
    
    detJ=xxi*yet*zze+yxi*zet*xze+zxi*xet*yze-zxi*yet*xze-yxi*xet*zze-xxi*zet*yze;
    % derivate funzioni di forma rispetto a x,y,z
    Nstu=[Nxi;Net;Nze];
    Nxyz=J\Nstu;
    
    Nx=Nxyz(1,:);
    Ny=Nxyz(2,:);
    Nz=Nxyz(3,:);
    
    bn=[Nx,zeros(1,30)
        zeros(1,15),Ny,zeros(1,15)
        zeros(1,30),Nz];
    bs=[Ny,Nx,zeros(1,15)
        zeros(1,15),Nz,Ny
        Nz,zeros(1,15),Nx];
    
    b1(:,:,ii)=[bn; bs];
    detJt(ii,1)=detJ;
    
end

indexdof=zeros(1,45);
for ii=0:14
    indexdof(1,ii*3+1:ii*3+3)=[1+ii,16+ii,31+ii];
end

b1(:,:,:)=b1(:,indexdof,:);


Tr=eye(45);
for ii=1:15
    Tr(ii*3-2:ii*3,ii*3-2:ii*3)=traspo;
end


% applicazione delle trasformazioni di spostamento e coordinate nello spazio
% cartesiano distorto
btotn=zeros(6,45,21);
BN=zeros(6,45);
for ii=1:21
    btotn(:,:,ii)=tradef*b1(:,:,ii)*Tr;
    BN=BN+btotn(:,:,ii)*detJt(ii);
end



end % fucntion end