function   [n,dist]=contact2fem(noditeeth,nodiplane)
% noditeeth = nodi del fianco del dente x y z
% nodiplane = nodi sul piano dei contatti x y z
% 
% Cerco tutte le coppie di nodi tra piano dei contatti e nodi del dente che
% sono pi vicine. L'output n contiene l'indice del nodo appartenente al
% dente pi vicino al nodo del piano considerato, 
% i.e. -- > n(8)=15 --> il nodo in riga 8 di surf1.vertices  il pi vicino
% al nodo 15 del dente che sto guardando, tipo S1.vertices(15,:,3)
% 
% Per calcolare poi la forza applicata su un nodo J del piano dei contatti
% su che nodo K vada applicata al dente si far qualcosa tipo:
% 

% figure;
% hold on;
% plot3(nodiplane(:,1),nodiplane(:,2),nodiplane(:,3),'+b');
% plot3(noditeeth(:,1),noditeeth(:,2),noditeeth(:,3),'*r');
% axis equal, hold off;

%create kdtree
kdtreeobj = KDTreeSearcher(noditeeth,'distance','euclidean');
%get nearest neighbours
[n,dist] = knnsearch(kdtreeobj,nodiplane,'k',2);

% figure;
% hold on;
% % plot3(nodiplane(:,1),nodiplane(:,2),nodiplane(:,3),'.g');
% % plot3(nodiplane(n,1),nodiplane(n,2),nodiplane(n,3),'+b');
% plot3(nodiplane(:,1),nodiplane(:,2),nodiplane(:,3),'+b');
% plot3(noditeeth(n,1),noditeeth(n,2),noditeeth(n,3),'*r');
% axis equal, hold off;


end %function end

