function PlotMesh(coordinates,elements,show)

% coordinates - The nodal coordinates of the mesh
% > coordinates = [X Y Z]
% elements - The nodal connectivity of the elements
% > elements = [node1 node2......]
% show - to display nodal and element numbers - Experimental...
%       0 (default) - do not display
%       1           - display

if nargin == 2
    show = 0 ;
end

dimension = size(coordinates,2) ;  % Dimension of the mesh
nel = length(elements) ;                  % number of elements
nnode = length(coordinates) ;          % total number of nodes in system
nnel = size(elements,2);                % number of nodes per element
%
% Initialization of the required matrices
X = zeros(nnel,nel) ;
Y = zeros(nnel,nel) ;
Z = zeros(nnel,nel) ;

fm = [1 2 6 5; 2 3 7 6; 3 4 8 7; 4 1 5 8; 1 2 3 4; 5 6 7 8];
XYZ = cell(1,nel) ;
for e=1:nel
    nd=elements(e,:);
    X(:,e) = coordinates(nd,1) ;
    Y(:,e) = coordinates(nd,2) ;
    Z(:,e) = coordinates(nd,3) ;
    XYZ{e} = [X(:,e)  Y(:,e) Z(:,e)] ;
end
% Plot FEM mesh
figure
set(gcf,'color','w')
set(gcf,'Color',[1 1 1]);
cellfun(@patch,repmat({'Vertices'},1,nel),XYZ,.......
    repmat({'Faces'},1,nel),repmat({fm},1,nel),......
    repmat({'FaceColor'},1,nel),repmat({'c'},1,nel));
view(3);
axis equal;
xlabel('X [mm]');
ylabel('Y [mm]');
zlabel('Z [mm]');
%set(gca,'XTick',[]) ; set(gca,'YTick',[]); set(gca,'ZTick',[]) ;

% display Node numbers and Element numbers -Experimental...
if show ~= 0
    k = 1:nnode ;
    nd = k' ;
    for i = 1:nel
        text(X(:,i),Y(:,i),Z(:,i),int2str(nd(i)),....
            'fontsize',8,'color','k');
        text(sum(X(:,i))/8,sum(Y(:,i))/8,sum(Z(:,i))/8,int2str(i),.....
            'fontsize',10,'color','r') ;
    end
end

end