function PlotDefoMesh_mod(coordinates,elements,factor,depl,Scale,surffaces,elfa)

% coordinates - The nodal coordinates of the mesh
% > coordinates = [X Y Z]
% elements - nodal connectivity of the elements
% > elements = [node1 node2......]
% factor - Amplification factor
% depl -  Nodal displacements
% > depl = [UX UY UZ]
% Scale -

dimension = size(coordinates,2) ;  % Dimension of the mesh
nel = size(elements,1) ;                       % number of elements
nnode = size(coordinates,1) ;               % total number of nodes in system
nnel = size(elements,2);                     % number of nodes per element
%
% Initialization of the required matrices
% X = zeros(nnel,nel) ; UX = zeros(nnel,nel) ;
% Y = zeros(nnel,nel) ; UY = zeros(nnel,nel) ;
% Z = zeros(nnel,nel) ; UZ = zeros(nnel,nel) ;
% profile = zeros(nnel,nel) ;
%

ux = depl(:,1) ;
uy = depl(:,2) ;
uz = depl(:,3) ;

fm = [1 2 6 5; 2 3 7 6; 3 4 8 7; 4 1 5 8; 1 2 3 4; 5 6 7 8];
XYZ = cell(1,nel) ;
profile = XYZ ;
disp=[ux uy uz]*factor;
displ=coordinates+disp;
%
% for S=1:nnel
%    Scale(S,1)=sum(displ(S,:));
% end

for e=1:nel
    nd=elements(e,:);
    X = coordinates(nd,1)+factor*ux(nd) ;
    Y = coordinates(nd,2)+factor*uy(nd) ;
    Z = coordinates(nd,3)+factor*uz(nd) ;
    XYZ{e} = [X  Y Z] ;
    
    profile{e} = Scale(nd) ;

end
%keyboard
% figh=figure(100); clf;
figure();clf; hold on;
% pos_fig1 = [0 0 1920 1080]; 
% set(figure(100),'Position',pos_fig1);

% u=sqrt(ux.^2+uy.^2+uz.^2);
% u=sqrt(ux.^2+uy.^2);
% u=ux;
u=Scale;
u2=u(elfa',1);

set(gcf,'Color',[1 1 1]);
% cellfun(@patch,repmat({'Vertices'},1,nel),XYZ,.......
%     repmat({'Faces'},1,nel),repmat({fm},1,nel),......
%     repmat({'FaceVertexCdata'},1,nel),profile,......
%     repmat({'FaceColor'},1,nel),repmat({'interp'},1,nel),...
%     repmat({'LineStyle'},1,nel),repmat({'none'},1,nel));
surfverts_d=displ(elfa',:);
trasp=1;
patch('Vertices',surfverts_d,'Faces',surffaces,...
        'FaceColor','interp','CData',u2,'LineStyle','None','FaceAlpha',trasp);axis equal


% box off
% axis off

view([0 0 1])
%set(gca,'XTick',[]) ; set(gca,'YTick',[]); set(gca,'ZTick',[])
% caxis([-0.4 0.4]);
axis equal;
% Colorbar Setting
% SetColorbar(Scale)

% custcol=[flipud(jet(150));jet(150);];
% colormap(custcol);
colormap(jet(150));
xlabel('X [mm]');
ylabel('Y [mm]');
zlabel('Z [mm]');
% titstring=['Mode N ',num2str(n),' ',num2str(fre,'%6.2f'),' Hz'];
% title(titstring)
view([1 1 1]); axis tight;


% %% Shaft
% samer=[];
% % Genero i cilindri dello shaft indeformato
% Npunt=380; count=1;
% for is=1:size(Shaft,1)
%     [xs((is-1)*2+1:(is-1)*2+2,:),ys((is-1)*2+1:(is-1)*2+2,:),~]=cylinder(Shaft(is,1),Npunt);
%     zs((is-1)*2+1:(is-1)*2+2,:)=Shaft(is,2:3)'.*ones(2,Npunt+1);
%     if Shaft(is)==Shaft(is+1) && is<size(Shaft,1)
%         samer(count)=is+1; count=count+1;
%     end
% end
% 
% if ~isempty(samer)
% elim=[(samer-1)*2, (samer-1)*2+1];
% % xsm=xs([1:2:end-1,end],:); xsm(samer,:)=[];
% % ysm=ys([1:2:end-1,end],:); ysm(samer,:)=[];
% % zsm=zs([1:2:end-1,end],:); zsm(samer,:)=[];
% 
% xsm=xs; xsm(elim,:)=[];
% ysm=ys; ysm(elim,:)=[];
% zsm=zs; zsm(elim,:)=[];
% else
%    xsm=xs; 
% ysm=ys; 
% zsm=zs; 
%     
% end
% 
% xe1=reshape([xsm,NaN(size(xsm,1),1)]',[],1);
% ye1=reshape([ysm,NaN(size(ysm,1),1)]',[],1);
% ze1=reshape([zsm,NaN(size(zsm,1),1)]',[],1);
% 
% 
% % Cilindri deformati
% for is=1:size(Shaft,1)
%     % Primo lato
%     % Spostamenti
%     xd1=xs((is-1)*2+1,:)+displbeam((is-1)*6+1);
%     yd1=ys((is-1)*2+1,:)+displbeam((is-1)*6+2);
%     zd1=zs((is-1)*2+1,:)+displbeam((is-1)*6+3);
%     % Rotazioni
% %     X=-dz*ty+dy*tz; dz==0
% %     Y=+dz*tx-dx*tz;
% %     Z=-dy*tx+dx*ty;
% %     rotated(:,1)=ys((is-1)*2+1,:)'*displbeam((is-1)*6+6);
% %     rotated(:,2)=xs((is-1)*2+1,:)'*displbeam((is-1)*6+6);
% %     rotated(:,3)=ys((is-1)*2+1,:)'*displbeam((is-1)*6+4)+xs((is-1)*2+1,:)'*displbeam((is-1)*6+5);
% %     xr((is-1)*2+1,:)=rotated(:,1)'+xd1;
% %     yr((is-1)*2+1,:)=rotated(:,2)'+yd1;
% %     zr((is-1)*2+1,:)=rotated(:,3)'+zd1;
%     % Intorno a X
%     rotx=[1 0 0;
%         0 cos(displbeam((is-1)*6+4)) -sin(displbeam((is-1)*6+4));
%         0 sin(displbeam((is-1)*6+4)) cos(displbeam((is-1)*6+4))];
%     roty=[cos(displbeam((is-1)*6+5)) 0 sin(displbeam((is-1)*6+5));
%         0 1 0;
%         -sin(displbeam((is-1)*6+5)) 0 cos(displbeam((is-1)*6+5))];
%     rotz=[cos(displbeam((is-1)*6+6)) -sin(displbeam((is-1)*6+6)) 0;
%         sin(displbeam((is-1)*6+6)) cos(displbeam((is-1)*6+6)) 0;
%         0 0 1];
%     rotall=rotz*roty*rotx;
%     rotated=rotall'*[xd1;yd1;zd1];
%     xr((is-1)*2+1,:)=rotated(1,:);
%     yr((is-1)*2+1,:)=rotated(2,:);
%     zr((is-1)*2+1,:)=rotated(3,:);
%     
%     % Secondo lato
%     % Spostamenti
%     xd1=xs((is-1)*2+2,:)+displbeam((is)*6+1);
%     yd1=ys((is-1)*2+2,:)+displbeam((is)*6+2);
%     zd1=zs((is-1)*2+2,:)+displbeam((is)*6+3);
%     % Rotazioni
%     clear rotated
% %     rotated(:,1)=ys((is-1)*2+2,:)'*displbeam((is)*6+6);
% %     rotated(:,2)=xs((is-1)*2+2,:)'*displbeam((is)*6+6);
% %     rotated(:,3)=ys((is-1)*2+2,:)'*displbeam((is)*6+4)+xs((is-1)*2+2,:)'*displbeam((is)*6+5);
% %      xr((is-1)*2+2,:)=rotated(:,1)'+xd1;
% %     yr((is-1)*2+2,:)=rotated(:,2)'+yd1;
% %     zr((is-1)*2+2,:)=rotated(:,3)'+zd1;
%     % Intorno a X
%     rotx=[1 0 0;
%         0 cos(displbeam((is)*6+4)) -sin(displbeam((is)*6+4));
%         0 sin(displbeam((is)*6+4)) cos(displbeam((is)*6+4))];
%     roty=[cos(displbeam((is)*6+5)) 0 sin(displbeam((is)*6+5));
%         0 1 0;
%         -sin(displbeam((is)*6+5)) 0 cos(displbeam((is)*6+5))];
%     rotz=[cos(displbeam((is)*6+6)) -sin(displbeam((is)*6+6)) 0;
%         sin(displbeam((is)*6+6)) cos(displbeam((is)*6+6)) 0;
%         0 0 1];
%     rotall=rotz*roty*rotx;
%     rotated=rotall'*[xd1;yd1;zd1];
%     xr((is-1)*2+2,:)=rotated(1,:);
%     yr((is-1)*2+2,:)=rotated(2,:);
%     zr((is-1)*2+2,:)=rotated(3,:);
% end
% 
% displx=xs-xr;
% disply=ys-yr;
% displz=zs-zr;
% 
% sb=sqrt(displx.^2+disply.^2+displz.^2);
% tb=displz(:,3);
% % ub=sqrt(displx.^2+disply.^2);
% 
% % xrm=xs([1:2:end-1,end],:)+displx([1:2:end-1,end],:)*factor; xrm(samer,:)=[];
% % yrm=ys([1:2:end-1,end],:)+disply([1:2:end-1,end],:)*factor; yrm(samer,:)=[];
% % zrm=zs([1:2:end-1,end],:)+displz([1:2:end-1,end],:)*factor; zrm(samer,:)=[];
% if ~isempty(samer)
% xrm=xs-displx*factor; xrm(elim,:)=[];
% yrm=ys-disply*factor; yrm(elim,:)=[];
% zrm=zs-displz*factor; zrm(elim,:)=[];
% else
%  xrm=xs-displx*factor; 
% yrm=ys-disply*factor; 
% zrm=zs-displz*factor; 
%    
%     
% end
% xe1d=reshape([xrm,NaN(size(xrm,1),1)]',[],1);
% ye1d=reshape([yrm,NaN(size(yrm,1),1)]',[],1);
% ze1d=reshape([zrm,NaN(size(zrm,1),1)]',[],1);
% 
% 
% trasp=1;
%     % edge deformati
%     ebd = plot3(xe1d,ye1d,ze1d,'b');
%     %pelle def
%     sbd=surf(xs-displx*factor,ys-disply*factor,zs-displz*factor,'FaceColor','interp','CData',sb,'LineStyle','None','FaceAlpha',trasp);
%     % tappi
%     t1=fill3(xs(1,:)-displx(1,:)*factor,ys(1,:)-disply(1,:)*factor,...
%         zs(1,:)-displz(1,:)*factor,sb(1,:),'FaceColor','interp','LineStyle','None','FaceAlpha',trasp);
%     t2=fill3(xs(end,:)-displx(end,:)*factor,ys(end,:)-disply(end,:)*factor,...
%         zs(end,:)-displz(end,:)*factor,sb(end,:),'FaceColor','interp','LineStyle','None','FaceAlpha',trasp);
%     
% 
% 
% % Box Setting
% % limi(1,1:3)=max(coordinates+factor*disp);
% % limi(2,1:3)=min(coordinates+factor*disp);
% % 
% % linf=min(limi(2,:));
% % lsup=max(limi(1,:));
% % 
% % xlim([1.2*linf 1.2*lsup])
% % ylim([1.2*linf 1.2*lsup])
% xlim([-45 45])
% ylim([-45 45])
% % zlim([1.2*linf 1.2*lsup])
% zlim([-45 45])
% 




% filename='testTm.gif'; tstep=0.05;
% frame = getframe(figh);
%     im = frame2im(frame);
%     [imind,cm] = rgb2ind(im,256,'nodither');
%     if n == 1
%         imwrite(imind,cm,filename,'gif', 'Loopcount',inf,'DelayTime',tstep);
%     else
%         imwrite(imind,cm,filename,'gif','WriteMode','append','DelayTime',tstep);
%     end
end