function PlotDefoMesh(coordinates,elements,factor,depl,Scale)

% coordinates - The nodal coordinates of the mesh
% > coordinates = [X Y Z]
% elements - nodal connectivity of the elements
% > elements = [node1 node2......]
% factor - Amplification factor
% depl -  Nodal displacements
% > depl = [UX UY UZ]
% Scale -

dimension = size(coordinates,2) ;  % Dimension of the mesh
nel = size(elements,1) ;                       % number of elements
nnode = size(coordinates,1) ;               % total number of nodes in system
nnel = size(elements,2);                     % number of nodes per element
%
% Initialization of the required matrices
X = zeros(nnel,nel) ; UX = zeros(nnel,nel) ;
Y = zeros(nnel,nel) ; UY = zeros(nnel,nel) ;
Z = zeros(nnel,nel) ; UZ = zeros(nnel,nel) ;
profile = zeros(nnel,nel) ;
%

ux = depl(:,1) ;
uy = depl(:,2) ;
uz = depl(:,3) ;

fm = [1 2 6 5; 2 3 7 6; 3 4 8 7; 4 1 5 8; 1 2 3 4; 5 6 7 8];
XYZ = cell(1,nel) ;
profile = XYZ ;
disp=[ux uy uz];
displ=coordinates+disp;
%
% for S=1:nnel
%    Scale(S,1)=sum(displ(S,:));
% end

for e=1:nel
    nd=elements(e,:);
    X = coordinates(nd,1)+factor*ux(nd) ;
    Y = coordinates(nd,2)+factor*uy(nd) ;
    Z = coordinates(nd,3)+factor*uz(nd) ;
    XYZ{e} = [X  Y Z] ;
    
    profile{e} = Scale(nd) ;

end
%keyboard
figure
set(gcf,'Color',[1 1 1]);
cellfun(@patch,repmat({'Vertices'},1,nel),XYZ,.......
    repmat({'Faces'},1,nel),repmat({fm},1,nel),......
    repmat({'FaceVertexCdata'},1,nel),profile,......
    repmat({'FaceColor'},1,nel),repmat({'interp'},1,nel));
view(3)
%set(gca,'XTick',[]) ; set(gca,'YTick',[]); set(gca,'ZTick',[])
axis equal;
% Colorbar Setting
SetColorbar(Scale)
colormap('jet');
xlabel('X [mm]');
ylabel('Y [mm]');
zlabel('Z [mm]');

% Box Setting
limi(1,1:3)=max(coordinates+factor*disp);
limi(2,1:3)=min(coordinates+factor*disp);

linf=min(limi(2,:));
lsup=max(limi(1,:));

xlim([1.2*linf 1.2*lsup])
ylim([1.2*linf 1.2*lsup])
zlim([1.2*linf 1.2*lsup])
end