%%STRESS RECOVERY
function [Strain_Gauss, Stress_Gauss, Strain_node, Stress_node] = Elem_Stress(B,D,L,Xstat_g)

%It calculates the mass and stiffness matrices of a Tet solid element
%(four-nodes tetra, first order)
%
% Input:  B       differential operator matrix (6 x g x n_g)
%         D       material matrix (6 x 6)
%         N       shape functions matrix (n x n_g)
%         Xstat_g deformed reslts for static analysis in global dofs (g x 1) Geo matrix contains the coordinates of the nodes
%
% Output: Strain   strain matrix (6 x 1)
%         Stress   stress matrix (6 x 1)
%
% n_g Gauss nodes n_g = 8 Hex
% n nodes n = 8 Hex
% g global dofs = n*6
% First order elements
Strain_Gauss = [];
Stress_Gauss = [];
Strain_node = zeros(6,size(Xstat_g,1)/3);
Stress_node = zeros(6,size(Xstat_g,1)/3);
for count_j = 1:size(B,3)
    Strain_Gauss = [Strain_Gauss, B(:,:,count_j)*Xstat_g];
    Stress_Gauss = [Stress_Gauss, D*B(:,:,count_j)*Xstat_g];
end
for count_i = 1:size(Strain_Gauss,1)
    for count_j = 1:size(Xstat_g,1)/3
        for count_k = 1:size(Strain_Gauss,2)
            Strain_node(count_i,count_j) = Strain_node(count_i,count_j)+Strain_Gauss(count_i,count_k)*L(count_k,count_j);
            Stress_node(count_i,count_j) = Stress_node(count_i,count_j)+Stress_Gauss(count_i,count_k)*L(count_k,count_j);
        end
    end
end