function DMIGtoMATRv2(Nome)

%Conversione da file DMIG (in punch Nastran) in formato tabellare di 'Matr'.dat , nodi'Matr'.dat
%Input files:  'Nome.pch'
%Output files: 'Matr'.dat , nodi'Matr'.dat
%
%function DMIGtoMATR(Nome)

if nargin<1
    Nome = input('Nome file [DMIG] ','s');
end
fileid = fopen(Nome);
while feof(fileid)==0
    linea = fgetl(fileid);
    if length(linea)>5 & linea(1:5)=='DMIG '
        if exist('temp')~=0
            if simm==6
                if sum(sum((temp-temp').^2))~=0
                    temp = temp+(temp-diag(diag(temp)))';
                end
            end
            tempstr = strcat('Nome file Matrice [',Matr,'] ');
            NomeMatr = input(tempstr,'s');
            if isempty(NomeMatr)==1
                NomeMatr = Matr;
            end
            save(NomeMatr,'temp','-mat','-double')
            tempstr = strcat('Nome file Nodi [nodi',NomeMatr,'] ');
            NomeNodi = input(tempstr,'s');
            if isempty(NomeNodi)==1
                NomeNodi = strcat('nodi',NomeMatr);
            end
            fid = fopen(NomeNodi,'w');
            for cont1 = 1 : colonna
                fprintf(fid,'%8.1d%8.1d\r\n',Nodi(cont1,1),Nodi(cont1,2));
            end
            fclose(fid);
        end        
        Matr = strcat(deblank(linea(9:16)),'.mat');
        simm = str2num(linea(25:32));
        colonna = 0;
        clear temp Nodi
    elseif length(linea)>5 & linea(1:5)=='DMIG*'
        nodo1 = str2num(linea(25:40));
        comp1 = str2num(linea(41:56));
        colonna = colonna+1;
        Nodi(colonna,1) = nodo1;
        Nodi(colonna,2) = comp1;
    elseif length(linea)>1 & linea(1)=='*'
        nodo2 = str2num(linea(9:24));
        comp2 = str2num(linea(25:40));
        trovato = 0;
        riga = 1;
        while trovato==0
            if Nodi(riga,1)==nodo2
                trovato = 1;
                if comp2==0
                    temp(riga,colonna) = str2num(linea(41:56));
                else
                    temp((riga+comp2-1),colonna) = str2num(linea(41:56));
                end
            else
                riga = riga+1;
%se la matrice non e' simmetrica, non si conosce a priori l'elenco progressivo dei nodi
%pertanto l'elenco 'Nodi' puo' apparire non sequenziale, ma determinato dalla forma della matrice 'Nome'
                if riga>length(Nodi(:,1))
                    Nodi(length(Nodi(:,1))+1,1) = nodo2;
                    Nodi(length(Nodi(:,1))+1,2) = comp2;
                end
            end
        end
    else
        error('ERRORE in lettura ...')
    end
end
fclose('all');
if simm==6
    if sum(sum((temp-temp').^2))~=0
        temp = temp+(temp-diag(diag(temp))).';
    end
end
tempstr = strcat('Nome file Matrice [',Matr,'] ');
NomeMatr = input(tempstr,'s');
if isempty(NomeMatr)==1
    NomeMatr = Matr;
end
save(NomeMatr,'temp','-mat','-double')
tempstr = strcat('Nome file Nodi [nodi',NomeMatr,'] ');
NomeNodi = input(tempstr,'s');
if isempty(NomeNodi)==1
    NomeNodi = strcat('nodi',NomeMatr);
end
fid = fopen(NomeNodi,'w');
for cont1 = 1 : colonna
    fprintf(fid,'%8.1d%8.1d\r\n',Nodi(cont1,1),Nodi(cont1,2));
end
fclose('all');
%FigMatr(1,'surface',temp,NomeMatr);
