$---------------------------------------------------------------------MDI_HEADER
[MDI_HEADER]
 FILE_TYPE     =  'tpl'
 FILE_VERSION  =  2022.1
 FILE_FORMAT   =  'ASCII'
 HEADER_SIZE   =  9
(COMMENTS)
{comment_string}
'macpherson strut'
$----------------------------------------------------------------TEMPLATE_HEADER
[TEMPLATE_HEADER]
 TEMPLATE_NAME  =  '_modello_rear_susp'
 MAJOR_ROLE     =  'suspension'
 TIMESTAMP      =  '2022/06/25,11:09:28'
 HEADER_SIZE    =  6
$------------------------------------------------------------------------PLUGINS
[PLUGINS]
 PLUGIN_LIST  =  'acar'
 HEADER_SIZE  =  4
!
!-------------------------- Default Units for Model ---------------------------!
!
!
defaults units  &
   length = mm  &
   angle = deg  &
   force = newton  &
   mass = kg  &
   time = sec
!
defaults units  &
   coordinate_system_type = cartesian  &
   orientation_type = body313
!
!------------------------ Default Attributes for Model ------------------------!
!
!
defaults attributes  &
   inheritance = bottom_up  &
   icon_visibility = off  &
   grid_visibility = off  &
   size_of_icons = 50.0  &
   spacing_for_grid = 1000.0
!
!------------------------------ Adams View Model ------------------------------!
!
!
model create  &
   model_name = _modello_rear_susp  &
   comments = "macpherson strut"  &
   title = "Adams/Car template"
!
view erase
!
!-------------------------------- Data storage --------------------------------!
!
!
data_element create variable  &
   variable_name = ._modello_rear_susp._cv_solver_variable  &
   comments = "Dummy for communicators"  &
   function = ""
!
data_element attributes  &
   data_element_name = ._modello_rear_susp._cv_solver_variable  &
   visibility = off
!
data_element create array ic_array  &
   array_name = ._modello_rear_susp.suspension_parameters_ARRAY  &
   comments = "STEER AXIS CALCULATION METHOD=: compliant"  &
   size = 6  &
   numbers = 1.0, 0.0, 0.0, 0.0, 0.0, 0.0
!
data_element create array ic_array  &
   array_name = ._modello_rear_susp._cv_array  &
   comments = "Dummy for communicators"  &
   size = 1  &
   numbers = 0.0
!
data_element attributes  &
   data_element_name = ._modello_rear_susp._cv_array  &
   visibility = off
!
data_element create spline  &
   spline_name = ._modello_rear_susp._cv_spline  &
   comments = "Dummy for communicators"  &
   x = 1.0, 2.0, 3.0, 4.0  &
   y = 1.0, 2.0, 3.0, 4.0, 1.0, 2.0, 3.0, 4.0  &
   z = 1.0, 2.0  &
   linear_extrapolate = no
!
data_element attributes  &
   data_element_name = ._modello_rear_susp._cv_spline  &
   visibility = off
!
data_element create string  &
   string_name = ._modello_rear_susp.minor_role_string  &
   string = "unassigned"
!
data_element attributes  &
   data_element_name = ._modello_rear_susp.minor_role_string  &
   visibility = off
!
!--------------------------------- Materials ----------------------------------!
!
!
material create  &
   material_name = ._modello_rear_susp.steel  &
   density = 7.801E-06  &
   youngs_modulus = 2.07E+05  &
   poissons_ratio = 0.29
!
!-------------------------------- Rigid Parts ---------------------------------!
!
! Create parts and their dependent markers and graphics
!
!----------------------------------- ground -----------------------------------!
!
!
! ****** Ground Part ******
!
part modify rigid_body name_and_position  &
   part_name = ground
!
defaults model  &
   part_name = ground
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.ground.mtl_mount_j_1  &
   location = 0.0, -120.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.mtl_mount_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ground.mtr_mount_j_1  &
   location = 0.0, 120.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.mtr_mount_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ground.mtl_mount_j_2  &
   location = -330.0, -120.1, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.mtl_mount_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ground.mtr_mount_j_2  &
   location = -330.0, 120.1, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.mtr_mount_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfl_spring_lwr_seat  &
   location = 0.0, -120.06, -75.1  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfl_spring_lwr_seat  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfr_spring_lwr_seat  &
   location = 0.0, 120.06, -75.1  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfr_spring_lwr_seat  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfl_spring_upr_seat  &
   location = 0.0, -120.04, 88.74  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfl_spring_upr_seat  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfr_spring_upr_seat  &
   location = 0.0, 120.04, 88.74  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfr_spring_upr_seat  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfl_top_mount  &
   location = 0.0, -120.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfl_top_mount  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfr_top_mount  &
   location = 0.0, 120.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfr_top_mount  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfl_top_mount_jprim_ref1  &
   location = 0.0, -170.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfl_top_mount_jprim_ref1  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfr_top_mount_jprim_ref1  &
   location = 0.0, 170.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfr_top_mount_jprim_ref1  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfs_str_fork_upper_bearing  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfs_str_fork_upper_bearing  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfl_dummy_susp_par_upper_bearing  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfl_dummy_susp_par_upper_bearing  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfr_dummy_susp_par_upper_bearing  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfr_dummy_susp_par_upper_bearing  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfs_strut_to_body  &
   location = 231.9, 0.0, -139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfs_strut_to_body  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.origo  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfs_wheel_center  &
   location = 110.0, 0.0, -74.5  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfs_wheel_center  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfl_top_mount_ext  &
   location = 0.0, -120.0, 167.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfl_top_mount_ext  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfr_top_mount_ext  &
   location = 0.0, 120.0, 167.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfr_top_mount_ext  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground._cv_marker  &
   comments = "Dummy for communicators"  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground._cv_marker  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfl_dummy_susp_parameter  &
   location = 231.9, 0.0, -139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfl_dummy_susp_parameter  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfr_dummy_susp_parameter  &
   location = 231.9, 0.0, -139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfr_dummy_susp_parameter  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfl_lwr_strut_mount  &
   location = 0.0, -114.8, -122.5  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfl_lwr_strut_mount  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfr_lwr_strut_mount  &
   location = 0.0, 114.8, -122.5  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfr_lwr_strut_mount  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfs_wheel_center_marker_ori  &
   location = 110.0, 0.0, -74.5  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfs_wheel_center_marker_ori  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfs_spindle_rise  &
   location = 110.0, 0.0, -74.5  &
   orientation = 180.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfs_spindle_rise  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_rear_susp.ground.cfs_ride_height_ref  &
   location = -330.0, 120.1, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ground.cfs_ride_height_ref  &
   color = MAIZE
!
! ****** Points for current part ******
!
point create  &
   point_name = ._modello_rear_susp.ground.hpl_swing_arm_pivot  &
   location = -330.0, -120.1, 0.0
!
point create  &
   point_name = ._modello_rear_susp.ground.hpr_swing_arm_pivot  &
   location = -330.0, 120.1, 0.0
!
point create  &
   point_name = ._modello_rear_susp.ground.hpl_swing_arm_to_axle  &
   location = 110.0, -143.8, -74.5
!
point create  &
   point_name = ._modello_rear_susp.ground.hpr_swing_arm_to_axle  &
   location = 110.0, 143.8, -74.5
!
point create  &
   point_name = ._modello_rear_susp.ground.hps_wheel_center  &
   location = 110.0, 0.0, -74.5
!
point create  &
   point_name = ._modello_rear_susp.ground.hpl_strut_lwr_mount  &
   location = 0.0, -114.8, -122.5
!
point create  &
   point_name = ._modello_rear_susp.ground.hpr_strut_lwr_mount  &
   location = 0.0, 114.8, -122.5
!
point create  &
   point_name = ._modello_rear_susp.ground.hpl_top_mount  &
   location = 0.0, -120.0, 117.6
!
point create  &
   point_name = ._modello_rear_susp.ground.hpr_top_mount  &
   location = 0.0, 120.0, 117.6
!
point create  &
   point_name = ._modello_rear_susp.ground.hpl_spring_lwr_seat  &
   location = 0.0, -120.06, -75.1
!
point create  &
   point_name = ._modello_rear_susp.ground.hpr_spring_lwr_seat  &
   location = 0.0, 120.06, -75.1
!
point create  &
   point_name = ._modello_rear_susp.ground.hpr_spring_upr_seat  &
   location = 0.0, 120.04, 88.74
!
point create  &
   point_name = ._modello_rear_susp.ground.hpl_spring_upr_seat  &
   location = 0.0, -120.04, 88.74
!
point create  &
   point_name = ._modello_rear_susp.ground.hpl_bumper_upper  &
   location = 0.0, -120.0, 117.6
!
point create  &
   point_name = ._modello_rear_susp.ground.hpr_bumper_upper  &
   location = 0.0, 120.0, 117.6
!
point create  &
   point_name = ._modello_rear_susp.ground.hpl_bumper_lower  &
   location = 0.0, -118.284, 25.0
!
point create  &
   point_name = ._modello_rear_susp.ground.hpr_bumper_lower  &
   location = 0.0, 118.284, 25.0
!
! ****** Graphics for current part ******
!
geometry create shape ellipsoid  &
   ellipsoid_name = ._modello_rear_susp.ground._cv_csolid  &
   center_marker = ._modello_rear_susp.ground._cv_marker  &
   x_scale_factor = 100.0  &
   y_scale_factor = 100.0  &
   z_scale_factor = 100.0
!
geometry attributes  &
   geometry_name = ._modello_rear_susp.ground._cv_csolid  &
   active = off
!
part attributes  &
   part_name = ._modello_rear_susp.ground  &
   visibility = on
!
!----------------------------- mtl_strut_to_body ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.mtl_strut_to_body  &
   location = 0.0, -120.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.mtl_strut_to_body
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.mount_i  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.mount_i  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.bxl_bushing_j_4  &
   location = 0.0, 0.0, 0.0  &
   orientation = 180.0d, 178.7593024423d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.bxl_bushing_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.bxl_bushgeom_j_4  &
   location = 0.0, -0.3247884771, 14.9964833359  &
   orientation = 180.0d, 178.7593024423d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.bxl_bushgeom_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.jxl_joint_j_1  &
   location = 0.0, 0.0, 0.0  &
   orientation = 180.0d, 178.7593024423d, 270.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.jxl_joint_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.bul_bumpstop_i_1  &
   location = 0.0, 0.0, 0.0  &
   orientation = 30.4779416749d, 16.4314449517d, 327.2070037092d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.bul_bumpstop_i_1  &
   visibility = off  &
   name_visibility = off
!
!----------------------------- mtr_strut_to_body ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.mtr_strut_to_body  &
   location = 0.0, 120.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.mtr_strut_to_body
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.mount_i  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.mount_i  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.bxr_bushing_j_4  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 178.7593024423d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.bxr_bushing_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.bxr_bushgeom_j_4  &
   location = 0.0, 0.3247884771, 14.9964833359  &
   orientation = 0.0d, 178.7593024423d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.bxr_bushgeom_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.jxr_joint_j_1  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 178.7593024423d, 270.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.jxr_joint_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.bur_bumpstop_i_1  &
   location = 0.0, 0.0, 0.0  &
   orientation = 149.5220583251d, 16.4314449517d, 212.7929962908d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.bur_bumpstop_i_1  &
   visibility = off  &
   name_visibility = off
!
!--------------------------- mtl_swing_arm_to_body ----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.mtl_swing_arm_to_body  &
   location = -330.0, -120.1, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.mtl_swing_arm_to_body
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.mtl_swing_arm_to_body.mount_i  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtl_swing_arm_to_body.mount_i  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushing_j_2  &
   location = 0.0, 0.0, 0.0  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushing_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushgeom_j_2  &
   location = 0.0, -15.0, 0.0  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushgeom_j_2  &
   visibility = off  &
   name_visibility = off
!
!--------------------------- mtr_swing_arm_to_body ----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.mtr_swing_arm_to_body  &
   location = -330.0, 120.1, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.mtr_swing_arm_to_body
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.mtr_swing_arm_to_body.mount_i  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtr_swing_arm_to_body.mount_i  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushing_j_2  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushing_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushgeom_j_2  &
   location = 0.0, 15.0, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushgeom_j_2  &
   visibility = off  &
   name_visibility = off
!
!-------------------------------- ges_spindle ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ges_spindle  &
   location = 110.0, 0.0, -74.5  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ges_spindle
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.ges_spindle.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_spindle.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_spindle.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ges_spindle.jxs_joint_i_2  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_spindle.jxs_joint_i_2  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_rear_susp.ges_spindle  &
   mass = 0.1  &
   center_of_mass_marker = ._modello_rear_susp.ges_spindle.cm  &
   inertia_marker = ._modello_rear_susp.ges_spindle.inertia_frame  &
   ixx = 100.0  &
   iyy = 100.0  &
   izz = 100.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
!---------------------------------- ges_axle ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ges_axle  &
   location = 110.0, 0.0, -74.5  &
   orientation = 180.0d, 90.0d, 180.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ges_axle
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.mas_kingpin_axis  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.mas_wheel_center  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.kp1_1  &
   location = 121.9, 64.9, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.kp1_2  &
   location = 121.9, 64.9, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.bxl_bushing_j_3  &
   location = 0.0, 0.0, -143.8  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.bxl_bushing_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.bxl_bushgeom_j_3  &
   location = 0.0, 0.0, -158.8  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.bxl_bushgeom_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.bxr_bushing_j_3  &
   location = 0.0, 0.0, 143.8  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.bxr_bushing_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.bxr_bushgeom_j_3  &
   location = 0.0, 0.0, 158.8  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.bxr_bushgeom_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.jxs_joint_j_2  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.jxs_joint_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.gralin_5  &
   location = 0.0, 0.0, -143.8  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.gralin_5  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.coomarker_9  &
   location = 0.0, 0.0, 0.0  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.coomarker_9  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.coomarker_10  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.coomarker_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ges_axle.coomarker_11  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ges_axle.coomarker_11  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_rear_susp.ges_axle  &
   mass = 1.2293604665  &
   center_of_mass_marker = ._modello_rear_susp.ges_axle.cm  &
   inertia_marker = ._modello_rear_susp.ges_axle.inertia_frame  &
   ixx = 5467.755625944  &
   iyy = 5467.755625944  &
   izz = 134.3174101136  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape cylinder  &
   cylinder_name = ._modello_rear_susp.ges_axle.gralin_axle  &
   center_marker = ._modello_rear_susp.ges_axle.gralin_5  &
   angle_extent = 360.0  &
   length = 287.6  &
   radius = 15.0  &
   side_count_for_body = 15  &
   segment_count_for_ends = 15
!
geometry attributes  &
   geometry_name = ._modello_rear_susp.ges_axle.gralin_axle  &
   color = RED
!
!------------------------------- gel_swing_arm --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.gel_swing_arm  &
   location = -110.0, -131.95, -37.25  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.gel_swing_arm
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.kp3_1  &
   location = 110.0, 11.89, -37.85  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_2  &
   location = -220.0, 11.85, 37.25  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_i_2  &
   location = -220.0, -3.15, 37.25  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_3  &
   location = 220.0, -11.85, -37.25  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_i_3  &
   location = 220.0, -26.85, -37.25  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.gralin_3  &
   location = 220.0, -11.85, -37.25  &
   orientation = 266.9168203978d, 80.4035786556d, 90.514470986d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_swing_arm.gralin_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.cm  &
   location = 8.8120104439, 5.8746736292, -8.8120104439  &
   orientation = 90.0d, 45.0d, 297.664451104d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_swing_arm.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.inertia_frame  &
   location = 8.8120104439, 5.8746736292, -8.8120104439  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushing_j_1  &
   location = 110.0, 17.15, -85.25  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushing_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_j_1  &
   location = 110.0, 2.15, -85.25  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_swing_arm.coomarker_3  &
   location = 110.0, 17.15, -85.25  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_swing_arm.coomarker_3  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_rear_susp.gel_swing_arm  &
   mass = 0.2346599281  &
   center_of_mass_marker = ._modello_rear_susp.gel_swing_arm.cm  &
   inertia_marker = ._modello_rear_susp.gel_swing_arm.inertia_frame  &
   ixx = 405.2945280663  &
   iyy = 602.0236784394  &
   izz = 405.2945280663  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape cylinder  &
   cylinder_name = ._modello_rear_susp.gel_swing_arm.gralin_susp_link  &
   center_marker = ._modello_rear_susp.gel_swing_arm.gralin_3  &
   angle_extent = 360.0  &
   length = 446.8914185795  &
   radius = 15.0  &
   side_count_for_body = 15  &
   segment_count_for_ends = 15
!
geometry attributes  &
   geometry_name = ._modello_rear_susp.gel_swing_arm.gralin_susp_link  &
   color = MAGENTA
!
part attributes  &
   part_name = ._modello_rear_susp.gel_swing_arm  &
   color = BLUE_GRAY  &
   entity_scope = edge_color
!
part attributes  &
   part_name = ._modello_rear_susp.gel_swing_arm  &
   visibility = on
!
!------------------------------- ger_swing_arm --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ger_swing_arm  &
   location = -110.0, 131.95, -37.25  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ger_swing_arm
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.kp3_1  &
   location = 110.0, -11.89, -37.85  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_2  &
   location = -220.0, -11.85, 37.25  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_i_2  &
   location = -220.0, 3.15, 37.25  &
   orientation = 0.0d, 90.0d, 270.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_3  &
   location = 220.0, 11.85, -37.25  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_i_3  &
   location = 220.0, 26.85, -37.25  &
   orientation = 0.0d, 90.0d, 270.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.gralin_4  &
   location = 220.0, 11.85, -37.25  &
   orientation = 273.0831796022d, 80.4035786556d, 89.485529014d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.gralin_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.cm  &
   location = 8.8120104439, -5.8746736292, -8.8120104439  &
   orientation = 90.0d, 45.0d, 242.335548896d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.inertia_frame  &
   location = 8.8120104439, -5.8746736292, -8.8120104439  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushing_j_1  &
   location = 110.0, -17.15, -85.25  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushing_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_j_1  &
   location = 110.0, -2.15, -85.25  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.coomarker_4  &
   location = 110.0, -17.15, -85.25  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.coomarker_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_swing_arm.coomarker_12  &
   location = -220.0, -11.85, 37.25  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_swing_arm.coomarker_12  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_rear_susp.ger_swing_arm  &
   mass = 0.2346599281  &
   center_of_mass_marker = ._modello_rear_susp.ger_swing_arm.cm  &
   inertia_marker = ._modello_rear_susp.ger_swing_arm.inertia_frame  &
   ixx = 405.2945280663  &
   iyy = 602.0236784394  &
   izz = 405.2945280663  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape cylinder  &
   cylinder_name = ._modello_rear_susp.ger_swing_arm.gralin_susp_link  &
   center_marker = ._modello_rear_susp.ger_swing_arm.gralin_4  &
   angle_extent = 360.0  &
   length = 446.8914185795  &
   radius = 15.0  &
   side_count_for_body = 15  &
   segment_count_for_ends = 15
!
geometry attributes  &
   geometry_name = ._modello_rear_susp.ger_swing_arm.gralin_susp_link  &
   color = MAGENTA
!
part attributes  &
   part_name = ._modello_rear_susp.ger_swing_arm  &
   color = BLUE
!
part attributes  &
   part_name = ._modello_rear_susp.ger_swing_arm  &
   color = BLUE  &
   entity_scope = edge_color
!
part attributes  &
   part_name = ._modello_rear_susp.ger_swing_arm  &
   visibility = on
!
!------------------------------ gel_upper_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.gel_upper_strut  &
   location = 0.0, -118.284, 38.367  &
   orientation = 0.0d, 1.2406975577d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.gel_upper_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.coomarker_1  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 180.0d, 1.2406975577d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.coomarker_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.rel_reboundstop_i_1  &
   location = 0.0, 0.0, -160.9047231905  &
   orientation = 265.0535842783d, 13.7160133719d, 95.0908616344d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.rel_reboundstop_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.bxl_bushing_i_4  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.bxl_bushing_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.bxl_bushgeom_i_4  &
   location = 0.0, 0.0, 94.2515800789  &
   orientation = 270.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.bxl_bushgeom_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.jxl_joint_i_1  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 0.0d, 88.7593024423d, 270.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.jxl_joint_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 339.2539197243d, 166.1247448874d, 158.6856096288d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.jxl_joint_j_10  &
   location = 0.0, 0.0, -40.8265715558  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.jxl_joint_j_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.jklhoo_top_mount_kinematic_1  &
   location = 0.0, 1.0826282569, 129.2398578654  &
   orientation = 180.0d, 1.2406975577d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.jklhoo_top_mount_kinematic_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.dal_damper_i_1  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.dal_damper_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.nsl_spring_i_1  &
   location = 0.0, -0.6648836521, 50.3992122431  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.nsl_spring_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.bul_bumpstop_j_1  &
   location = 0.0, -0.2894298382, -13.3638661834  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.bul_bumpstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.dal_ride_damper_axial_ref_i  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.gel_upper_strut.coomarker_5  &
   location = 0.0, -0.6648836521, 50.3992122431  &
   orientation = 180.0d, 1.2406975577d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_upper_strut.coomarker_5  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_rear_susp.gel_upper_strut  &
   mass = 5.0  &
   center_of_mass_marker = ._modello_rear_susp.gel_upper_strut.cm  &
   inertia_marker = ._modello_rear_susp.gel_upper_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_rear_susp.gel_upper_strut  &
   visibility = on
!
!------------------------------ ger_upper_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ger_upper_strut  &
   location = 0.0, 118.284, 38.367  &
   orientation = 180.0d, 1.2406975577d, 180.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ger_upper_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.coomarker_2  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 0.0d, 1.2406975577d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.coomarker_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.rer_reboundstop_i_1  &
   location = 0.0, 0.0, -160.9047231905  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.rer_reboundstop_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.bxr_bushing_i_4  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.bxr_bushing_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.bxr_bushgeom_i_4  &
   location = 0.0, 0.0, 94.2515800789  &
   orientation = 270.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.bxr_bushgeom_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.jxr_joint_i_1  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 180.0d, 88.7593024423d, 270.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.jxr_joint_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 200.7460802757d, 166.1247448874d, 21.3143903712d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.jxr_joint_j_10  &
   location = 0.0, 0.0, -40.8265715558  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.jxr_joint_j_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.jkrhoo_top_mount_kinematic_1  &
   location = 0.0, -1.0826282569, 129.2398578654  &
   orientation = 0.0d, 1.2406975577d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.jkrhoo_top_mount_kinematic_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.dar_damper_i_1  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.dar_damper_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.nsr_spring_i_1  &
   location = 0.0, 0.6648836521, 50.3992122431  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.nsr_spring_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.bur_bumpstop_j_1  &
   location = 0.0, 0.2894298382, -13.3638661834  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.bur_bumpstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.dar_ride_damper_axial_ref_i  &
   location = 0.0, 0.0, 79.2515800789  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ger_upper_strut.coomarker_6  &
   location = 0.0, 0.6648836521, 50.3992122431  &
   orientation = 0.0d, 1.2406975577d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_upper_strut.coomarker_6  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_rear_susp.ger_upper_strut  &
   mass = 5.0  &
   center_of_mass_marker = ._modello_rear_susp.ger_upper_strut.cm  &
   inertia_marker = ._modello_rear_susp.ger_upper_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_rear_susp.ger_upper_strut  &
   visibility = on
!
!---------------------------------- _cv_part ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp._cv_part  &
   comments = "Dummy for communicators"  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp._cv_part
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp._cv_part.marker  &
   comments = "Dummy for communicators"  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp._cv_part.marker  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_rear_susp._cv_part  &
   mass = 0.0  &
   center_of_mass_marker = ._modello_rear_susp._cv_part.marker  &
   ixx = 0.0  &
   iyy = 0.0  &
   izz = 0.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_rear_susp._cv_part  &
   visibility = on  &
   name_visibility = off
!
!------------------------------ ger_lower_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ger_lower_strut  &
   location = 0.0, 116.568, -40.866  &
   orientation = 180.0d, 1.2406975577d, 180.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ger_lower_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.coomarker_8  &
   location = 0.0, 4.2324352356, -34.1503632774  &
   orientation = 0.0d, 1.2406975577d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_lower_strut.coomarker_8  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.rer_reboundstop_j_1  &
   location = 0.0, 0.0, 158.5031601578  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_lower_strut.rer_reboundstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_lower_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.dar_damper_j_1  &
   location = 0.0, 0.0, -81.6531431116  &
   orientation = 201.3143903712d, 13.8752551126d, 159.2539197243d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_lower_strut.dar_damper_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.nsr_spring_j_1  &
   location = 0.0, 4.2324352356, -34.1503632774  &
   orientation = 201.3143903712d, 13.8752551126d, 159.2539197243d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_lower_strut.nsr_spring_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.jxr_joint_i_10  &
   location = 0.0, 0.0, 38.4250085231  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_lower_strut.jxr_joint_i_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.bxr_bushing_i_1  &
   location = 0.0, 0.0, -81.6531431116  &
   orientation = 0.0d, 91.2406975577d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_lower_strut.bxr_bushing_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.bxr_bushgeom_i_1  &
   location = 0.0, 14.9964833359, -81.3283546345  &
   orientation = 0.0d, 91.2406975577d, 270.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.ger_lower_strut.bxr_bushgeom_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.ger_lower_strut.dar_ride_damper_axial_ref_j  &
   location = 0.0, 0.0, 158.5031601578  &
   orientation = 0.0d, 0.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = ._modello_rear_susp.ger_lower_strut  &
   mass = 1.0  &
   center_of_mass_marker = ._modello_rear_susp.ger_lower_strut.cm  &
   inertia_marker = ._modello_rear_susp.ger_lower_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_rear_susp.ger_lower_strut  &
   visibility = on  &
   name_visibility = on
!
!------------------------------ gel_lower_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_rear_susp.gel_lower_strut  &
   location = 0.0, -116.568, -40.866  &
   orientation = 0.0d, 1.2406975577d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.gel_lower_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.coomarker_7  &
   location = 0.0, -4.2324352356, -34.1503632774  &
   orientation = 180.0d, 1.2406975577d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_lower_strut.coomarker_7  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.rel_reboundstop_j_1  &
   location = 0.0, 0.0, 158.5031601578  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_lower_strut.rel_reboundstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_lower_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.dal_damper_j_1  &
   location = 0.0, 0.0, -81.6531431116  &
   orientation = 338.6856096288d, 13.8752551126d, 20.7460802757d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_lower_strut.dal_damper_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.nsl_spring_j_1  &
   location = 0.0, -4.2324352356, -34.1503632774  &
   orientation = 338.6856096288d, 13.8752551126d, 20.7460802757d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_lower_strut.nsl_spring_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.jxl_joint_i_10  &
   location = 0.0, 0.0, 38.4250085231  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_lower_strut.jxl_joint_i_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.bxl_bushing_i_1  &
   location = 0.0, 0.0, -81.6531431116  &
   orientation = 180.0d, 91.2406975577d, 180.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_lower_strut.bxl_bushing_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.bxl_bushgeom_i_1  &
   location = 0.0, -14.9964833359, -81.3283546345  &
   orientation = 180.0d, 91.2406975577d, 90.0d
!
marker attributes  &
   marker_name = ._modello_rear_susp.gel_lower_strut.bxl_bushgeom_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_rear_susp.gel_lower_strut.dal_ride_damper_axial_ref_j  &
   location = 0.0, 0.0, 158.5031601578  &
   orientation = 0.0d, 0.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = ._modello_rear_susp.gel_lower_strut  &
   mass = 1.0  &
   center_of_mass_marker = ._modello_rear_susp.gel_lower_strut.cm  &
   inertia_marker = ._modello_rear_susp.gel_lower_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_rear_susp.gel_lower_strut  &
   visibility = on  &
   name_visibility = on
!
!--------------------------------- Equations ----------------------------------!
!
!
part create equation differential_equation  &
   differential_equation_name = ._modello_rear_susp._cv_diff  &
   comments = "Dummy for communicators"  &
   initial_condition = 0.0  &
   function = ""  &
   implicit = off  &
   static_hold = off
!
part attributes  &
   equation_name = ._modello_rear_susp._cv_diff  &
   visibility = off
!
!----------------------------------- Joints -----------------------------------!
!
!
constraint create joint fixed  &
   joint_name = ._modello_rear_susp.mtl_fixed_1  &
   i_marker_name = ._modello_rear_susp.mtl_strut_to_body.mount_i  &
   j_marker_name = ._modello_rear_susp.ground.mtl_mount_j_1
!
constraint attributes  &
   constraint_name = ._modello_rear_susp.mtl_fixed_1  &
   visibility = off  &
   name_visibility = off
!
constraint create joint fixed  &
   joint_name = ._modello_rear_susp.mtr_fixed_1  &
   i_marker_name = ._modello_rear_susp.mtr_strut_to_body.mount_i  &
   j_marker_name = ._modello_rear_susp.ground.mtr_mount_j_1
!
constraint attributes  &
   constraint_name = ._modello_rear_susp.mtr_fixed_1  &
   visibility = off  &
   name_visibility = off
!
constraint create joint fixed  &
   joint_name = ._modello_rear_susp.mtl_fixed_2  &
   i_marker_name = ._modello_rear_susp.mtl_swing_arm_to_body.mount_i  &
   j_marker_name = ._modello_rear_susp.ground.mtl_mount_j_2
!
constraint attributes  &
   constraint_name = ._modello_rear_susp.mtl_fixed_2  &
   visibility = off  &
   name_visibility = off
!
constraint create joint fixed  &
   joint_name = ._modello_rear_susp.mtr_fixed_2  &
   i_marker_name = ._modello_rear_susp.mtr_swing_arm_to_body.mount_i  &
   j_marker_name = ._modello_rear_susp.ground.mtr_mount_j_2
!
constraint attributes  &
   constraint_name = ._modello_rear_susp.mtr_fixed_2  &
   visibility = off  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = ._modello_rear_susp.josrev_spindle_axle  &
   i_marker_name = ._modello_rear_susp.ges_spindle.jxs_joint_i_2  &
   j_marker_name = ._modello_rear_susp.ges_axle.jxs_joint_j_2
!
constraint attributes  &
   constraint_name = ._modello_rear_susp.josrev_spindle_axle  &
   size_of_icons = 30.0
!
constraint create joint cylindrical  &
   joint_name = ._modello_rear_susp.jolcyl_strut  &
   i_marker_name = ._modello_rear_susp.gel_lower_strut.jxl_joint_i_10  &
   j_marker_name = ._modello_rear_susp.gel_upper_strut.jxl_joint_j_10
!
constraint create joint cylindrical  &
   joint_name = ._modello_rear_susp.jorcyl_strut  &
   i_marker_name = ._modello_rear_susp.ger_lower_strut.jxr_joint_i_10  &
   j_marker_name = ._modello_rear_susp.ger_upper_strut.jxr_joint_j_10
!
constraint create joint cylindrical  &
   joint_name = ._modello_rear_susp._cv_joint_for_motion  &
   comments = "Dummy for communicators"  &
   i_marker_name = ._modello_rear_susp._cv_part.marker  &
   j_marker_name = ._modello_rear_susp.ground._cv_marker
!
constraint attributes  &
   constraint_name = ._modello_rear_susp._cv_joint_for_motion  &
   visibility = off  &
   name_visibility = off
!
!------------------------------ Joint Primitives ------------------------------!
!
!
constraint create primitive_joint perpendicular  &
   jprim_name = ._modello_rear_susp.jolper_top_mount  &
   i_marker_name = ._modello_rear_susp.gel_upper_strut.jxl_joint_i_1  &
   j_marker_name = ._modello_rear_susp.mtl_strut_to_body.jxl_joint_j_1
!
constraint create primitive_joint perpendicular  &
   jprim_name = ._modello_rear_susp.jorper_top_mount  &
   i_marker_name = ._modello_rear_susp.ger_upper_strut.jxr_joint_i_1  &
   j_marker_name = ._modello_rear_susp.mtr_strut_to_body.jxr_joint_j_1
!
constraint create primitive_joint inplane  &
   jprim_name = ._modello_rear_susp._cv_joint  &
   comments = "Dummy for communicators"  &
   i_marker_name = ._modello_rear_susp._cv_part.marker  &
   j_marker_name = ._modello_rear_susp.ground._cv_marker
!
constraint attributes  &
   constraint_name = ._modello_rear_susp._cv_joint  &
   visibility = off  &
   name_visibility = off
!
!----------------------------------- Forces -----------------------------------!
!
!
force create element_like field  &
   field_name = ._modello_rear_susp._cv_bushing  &
   comments = "Dummy for communicators"  &
   i_marker_name = ._modello_rear_susp._cv_part.marker  &
   j_marker_name = ._modello_rear_susp.ground._cv_marker  &
   translation_at_preload = 0.0, 0.0, 0.0  &
   rotation_at_preload = 0.0d, 0.0d, 0.0d  &
   formulation = linear  &
   length_tolerance = 1.0E-05  &
   damping_ratio = 0.0  &
   stiffness_matrix =  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0  &
   force_preload = 0.0, 0.0, 0.0  &
   torque_preload = 0.0, 0.0, 0.0
!
force attributes  &
   force_name = ._modello_rear_susp._cv_bushing  &
   visibility = off  &
   name_visibility = off
!
!---------------------------------- Requests ----------------------------------!
!
!
output_control create request  &
   request_name = ._modello_rear_susp.toe_camber_caster  &
   comment = "Computes the toe and camber of a front or rear suspension"  &
   component_names = "", "toe_single", "caster_single", "camber_single", "",  &
                     "", "", ""  &
   component_units = "no_units", "no_units", "no_units", "no_units",  &
                     "no_units", "no_units", "no_units", "no_units"  &
   results_name = "suspension_kinematics"  &
   user_function = 1101.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0  &
   routine = "acar_solver::reqsub"
!
!------------------------- Groups Owned By This Model -------------------------!
!
!
group create  &
   group_name = ._modello_rear_susp.top_mount_kinematic  &
   expr_active = 0
!
!-------------------------- Adams View UDE Instances --------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
undo begin_block suppress = yes
!
ude create instance  &
   instance_name = ._modello_rear_susp.cnl_top_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.cnr_top_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.cnl_swing_arm_to_body  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.cnr_swing_arm_to_body  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.cnl_bottom_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.cnr_bottom_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.cnl_swing_arm_to_axle  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.cnr_swing_arm_to_axle  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.bgl_top_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 0.0, -120.0, 117.6  &
   orientation = 180.0, 178.7593024423, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.bgr_top_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 0.0, 120.0, 117.6  &
   orientation = 0.0, 178.7593024423, 180.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.bgl_swing_arm_to_body  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = -330.0, -120.1, 0.0  &
   orientation = 180.0, 90.0, 180.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.bgr_swing_arm_to_body  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = -330.0, 120.1, 0.0  &
   orientation = 0.0, 90.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.bgl_swing_arm_to_axle  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 110.0, -143.8, -74.5  &
   orientation = 180.0, 90.0, 180.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.bgr_swing_arm_to_axle  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 110.0, 143.8, -74.5  &
   orientation = 0.0, 90.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.nsl_ride_spring  &
   definition_name = .ACAR.forces.ac_spring  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_rear_susp.nsl_ride_spring  &
   color = WHITE
!
ude create instance  &
   instance_name = ._modello_rear_susp.nsr_ride_spring  &
   definition_name = .ACAR.forces.ac_spring  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_rear_susp.nsr_ride_spring  &
   color = WHITE
!
ude create instance  &
   instance_name = ._modello_rear_susp.rel_rebound_bumper  &
   definition_name = .ACAR.forces.ac_reboundstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_rear_susp.rel_rebound_bumper  &
   color = CYAN
!
ude create instance  &
   instance_name = ._modello_rear_susp.rer_rebound_bumper  &
   definition_name = .ACAR.forces.ac_reboundstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_rear_susp.rer_rebound_bumper  &
   color = CYAN
!
ude create instance  &
   instance_name = ._modello_rear_susp.bgl_bottom_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 0.0, -114.8, -122.5  &
   orientation = 180.0, 90.0, 180.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.bgr_bottom_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 0.0, 114.8, -122.5  &
   orientation = 0.0, 90.0, 0.0
!
ude create instance  &
   instance_name = ._modello_rear_susp.bul_jounce_bumper  &
   definition_name = .ACAR.forces.ac_bumpstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_rear_susp.bul_jounce_bumper  &
   color = MAGENTA
!
ude create instance  &
   instance_name = ._modello_rear_susp.bur_jounce_bumper  &
   definition_name = .ACAR.forces.ac_bumpstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_rear_susp.bur_jounce_bumper  &
   color = MAGENTA
!
ude create instance  &
   instance_name = ._modello_rear_susp.dal_ride_damper  &
   definition_name = .ACAR.forces.ac_damper  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_rear_susp.dal_ride_damper  &
   color = MAIZE
!
ude create instance  &
   instance_name = ._modello_rear_susp.dar_ride_damper  &
   definition_name = .ACAR.forces.ac_damper  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_rear_susp.dar_ride_damper  &
   color = MAIZE
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.group_activity  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.bushing  &
   object_value = ._modello_rear_susp.bgl_top_mount
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.i_marker  &
   object_value = (._modello_rear_susp.cnl_top_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.j_marker  &
   object_value = (._modello_rear_susp.cnl_top_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_top_mount.geo_marker  &
   object_value = (._modello_rear_susp.cnl_top_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.group_activity  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.bushing  &
   object_value = ._modello_rear_susp.bgr_top_mount
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.i_marker  &
   object_value = (._modello_rear_susp.cnr_top_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.j_marker  &
   object_value = (._modello_rear_susp.cnr_top_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_top_mount.geo_marker  &
   object_value = (._modello_rear_susp.cnr_top_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.joint_type  &
   string_value = "revolute"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.group_activity  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.bushing  &
   object_value = ._modello_rear_susp.bgl_swing_arm_to_body
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.i_marker  &
   object_value = (._modello_rear_susp.cnl_swing_arm_to_body.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.j_marker  &
   object_value = (._modello_rear_susp.cnl_swing_arm_to_body.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_body.geo_marker  &
   object_value = (._modello_rear_susp.cnl_swing_arm_to_body.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_swing_arm_to_body
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.joint_type  &
   string_value = "revolute"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.group_activity  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.bushing  &
   object_value = ._modello_rear_susp.bgr_swing_arm_to_body
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.i_marker  &
   object_value = (._modello_rear_susp.cnr_swing_arm_to_body.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.j_marker  &
   object_value = (._modello_rear_susp.cnr_swing_arm_to_body.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_body.geo_marker  &
   object_value = (._modello_rear_susp.cnr_swing_arm_to_body.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_swing_arm_to_body
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.group_activity  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.bushing  &
   object_value = ._modello_rear_susp.bgl_bottom_mount
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.i_marker  &
   object_value = (._modello_rear_susp.cnl_bottom_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.j_marker  &
   object_value = (._modello_rear_susp.cnl_bottom_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_bottom_mount.geo_marker  &
   object_value = (._modello_rear_susp.cnl_bottom_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.group_activity  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.bushing  &
   object_value = ._modello_rear_susp.bgr_bottom_mount
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.i_marker  &
   object_value = (._modello_rear_susp.cnr_bottom_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.j_marker  &
   object_value = (._modello_rear_susp.cnr_bottom_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_bottom_mount.geo_marker  &
   object_value = (._modello_rear_susp.cnr_bottom_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.joint_type  &
   string_value = "revolute"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.group_activity  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.bushing  &
   object_value = ._modello_rear_susp.bgl_swing_arm_to_axle
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.i_marker  &
   object_value = (._modello_rear_susp.cnl_swing_arm_to_axle.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.j_marker  &
   object_value = (._modello_rear_susp.cnl_swing_arm_to_axle.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnl_swing_arm_to_axle.geo_marker  &
   object_value = (._modello_rear_susp.cnl_swing_arm_to_axle.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_swing_arm_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.joint_type  &
   string_value = "revolute"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.group_activity  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.bushing  &
   object_value = ._modello_rear_susp.bgr_swing_arm_to_axle
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.i_marker  &
   object_value = (._modello_rear_susp.cnr_swing_arm_to_axle.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.j_marker  &
   object_value = (._modello_rear_susp.cnr_swing_arm_to_axle.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_rear_susp.cnr_swing_arm_to_axle.geo_marker  &
   object_value = (._modello_rear_susp.cnr_swing_arm_to_axle.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_swing_arm_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.property_file  &
   string_value = (._modello_rear_susp.bgl_top_mount.property_file_list[._modello_rear_susp.bgl_top_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/front_suspension_damper_upper_bus.xml"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.property_file_I  &
   string_value = (._modello_rear_susp.bgl_top_mount.property_file_list_I[._modello_rear_susp.bgl_top_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.property_file_J  &
   string_value = (._modello_rear_susp.bgl_top_mount.property_file_list_J[._modello_rear_susp.bgl_top_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.i_geoMarker  &
   object_value = ._modello_rear_susp.gel_upper_strut.bxl_bushgeom_i_4
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.j_geoMarker  &
   object_value = ._modello_rear_susp.mtl_strut_to_body.bxl_bushgeom_j_4
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.geoRadius  &
   real_value = 25.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.i_compliance_ori  &
   real_value =   &
      180.0,  &
      178.7593024423,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.j_compliance_ori  &
   real_value =   &
      180.0,  &
      178.7593024423,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.i_marker  &
   object_value = ._modello_rear_susp.gel_upper_strut.bxl_bushing_i_4
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_top_mount.j_marker  &
   object_value = ._modello_rear_susp.mtl_strut_to_body.bxl_bushing_j_4
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.property_file  &
   string_value = (._modello_rear_susp.bgr_top_mount.property_file_list[._modello_rear_susp.bgr_top_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/front_suspension_damper_upper_bus.xml"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.property_file_I  &
   string_value = (._modello_rear_susp.bgr_top_mount.property_file_list_I[._modello_rear_susp.bgr_top_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.property_file_J  &
   string_value = (._modello_rear_susp.bgr_top_mount.property_file_list_J[._modello_rear_susp.bgr_top_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.i_geoMarker  &
   object_value = ._modello_rear_susp.ger_upper_strut.bxr_bushgeom_i_4
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.j_geoMarker  &
   object_value = ._modello_rear_susp.mtr_strut_to_body.bxr_bushgeom_j_4
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.geoRadius  &
   real_value = 25.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.i_compliance_ori  &
   real_value =   &
      0.0,  &
      178.7593024423,  &
      180.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.j_compliance_ori  &
   real_value =   &
      0.0,  &
      178.7593024423,  &
      180.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.i_marker  &
   object_value = ._modello_rear_susp.ger_upper_strut.bxr_bushing_i_4
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_top_mount.j_marker  &
   object_value = ._modello_rear_susp.mtr_strut_to_body.bxr_bushing_j_4
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.property_file  &
   string_value = (._modello_rear_susp.bgl_swing_arm_to_body.property_file_list[._modello_rear_susp.bgl_swing_arm_to_body.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/revolute_bush.xml"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.property_file_I  &
   string_value = (._modello_rear_susp.bgl_swing_arm_to_body.property_file_list_I[._modello_rear_susp.bgl_swing_arm_to_body.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.property_file_J  &
   string_value = (._modello_rear_susp.bgl_swing_arm_to_body.property_file_list_J[._modello_rear_susp.bgl_swing_arm_to_body.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.i_geoMarker  &
   object_value = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_i_2
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.j_geoMarker  &
   object_value = ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushgeom_j_2
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.i_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.j_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.i_marker  &
   object_value = ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_2
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_body.j_marker  &
   object_value = ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushing_j_2
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_swing_arm_to_body
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.property_file  &
   string_value = (._modello_rear_susp.bgr_swing_arm_to_body.property_file_list[._modello_rear_susp.bgr_swing_arm_to_body.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/revolute_bush.xml"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.property_file_I  &
   string_value = (._modello_rear_susp.bgr_swing_arm_to_body.property_file_list_I[._modello_rear_susp.bgr_swing_arm_to_body.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.property_file_J  &
   string_value = (._modello_rear_susp.bgr_swing_arm_to_body.property_file_list_J[._modello_rear_susp.bgr_swing_arm_to_body.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.i_geoMarker  &
   object_value = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_i_2
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.j_geoMarker  &
   object_value = ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushgeom_j_2
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.i_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.j_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.i_marker  &
   object_value = ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_2
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_body.j_marker  &
   object_value = ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushing_j_2
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_swing_arm_to_body
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.property_file  &
   string_value = (._modello_rear_susp.bgl_swing_arm_to_axle.property_file_list[._modello_rear_susp.bgl_swing_arm_to_axle.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/fixed_bush.xml"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.property_file_I  &
   string_value = (._modello_rear_susp.bgl_swing_arm_to_axle.property_file_list_I[._modello_rear_susp.bgl_swing_arm_to_axle.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.property_file_J  &
   string_value = (._modello_rear_susp.bgl_swing_arm_to_axle.property_file_list_J[._modello_rear_susp.bgl_swing_arm_to_axle.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.i_geoMarker  &
   object_value = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_i_3
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.j_geoMarker  &
   object_value = ._modello_rear_susp.ges_axle.bxl_bushgeom_j_3
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.i_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.j_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.i_marker  &
   object_value = ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_3
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_swing_arm_to_axle.j_marker  &
   object_value = ._modello_rear_susp.ges_axle.bxl_bushing_j_3
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_swing_arm_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.property_file  &
   string_value = (._modello_rear_susp.bgr_swing_arm_to_axle.property_file_list[._modello_rear_susp.bgr_swing_arm_to_axle.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/fixed_bush.xml"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.property_file_I  &
   string_value = (._modello_rear_susp.bgr_swing_arm_to_axle.property_file_list_I[._modello_rear_susp.bgr_swing_arm_to_axle.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.property_file_J  &
   string_value = (._modello_rear_susp.bgr_swing_arm_to_axle.property_file_list_J[._modello_rear_susp.bgr_swing_arm_to_axle.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.i_geoMarker  &
   object_value = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_i_3
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.j_geoMarker  &
   object_value = ._modello_rear_susp.ges_axle.bxr_bushgeom_j_3
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.i_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.j_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.i_marker  &
   object_value = ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_3
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_swing_arm_to_axle.j_marker  &
   object_value = ._modello_rear_susp.ges_axle.bxr_bushing_j_3
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_swing_arm_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.property_file  &
   string_value = (._modello_rear_susp.nsl_ride_spring.property_file_list[._modello_rear_susp.nsl_ride_spring.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.property_file_list  &
   string_value = "mdids://acar_shared/springs.tbl/mdi_0001.spr"
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.user_value  &
   real_value = 206.0113831806
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.value_type  &
   string_value = "installed_length"
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.diameter  &
   real_value = (._modello_rear_susp.nsl_ride_spring.dmCalc * ._modello_rear_susp.nsl_ride_spring.geoScale)
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.geoScale  &
   real_value = 0.3
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.numCoils  &
   integer_value = 5
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.independentAxis  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.i_marker  &
   object_value = ._modello_rear_susp.gel_upper_strut.nsl_spring_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.nsl_ride_spring.j_marker  &
   object_value = ._modello_rear_susp.gel_lower_strut.nsl_spring_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.nsl_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.property_file  &
   string_value = (._modello_rear_susp.nsr_ride_spring.property_file_list[._modello_rear_susp.nsr_ride_spring.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.property_file_list  &
   string_value = "mdids://acar_shared/springs.tbl/mdi_0001.spr"
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.user_value  &
   real_value = 206.0113831806
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.value_type  &
   string_value = "installed_length"
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.diameter  &
   real_value = (._modello_rear_susp.nsr_ride_spring.dmCalc * ._modello_rear_susp.nsr_ride_spring.geoScale)
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.geoScale  &
   real_value = 0.3
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.numCoils  &
   integer_value = 5
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.independentAxis  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.i_marker  &
   object_value = ._modello_rear_susp.ger_upper_strut.nsr_spring_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.nsr_ride_spring.j_marker  &
   object_value = ._modello_rear_susp.ger_lower_strut.nsr_spring_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.nsr_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.property_file  &
   string_value = (._modello_rear_susp.rel_rebound_bumper.property_file_list[._modello_rear_susp.rel_rebound_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.property_file_list  &
   string_value = "mdids://acar_shared/reboundstops.tbl/mdi_0001.reb"
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.user_distance  &
   real_value = 100.0
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.diameter  &
   real_value = 150.0
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.i_marker  &
   object_value = ._modello_rear_susp.gel_upper_strut.rel_reboundstop_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.rel_rebound_bumper.j_marker  &
   object_value = ._modello_rear_susp.gel_lower_strut.rel_reboundstop_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.rel_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.property_file  &
   string_value = (._modello_rear_susp.rer_rebound_bumper.property_file_list[._modello_rear_susp.rer_rebound_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.property_file_list  &
   string_value = "mdids://acar_shared/reboundstops.tbl/mdi_0001.reb"
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.user_distance  &
   real_value = 100.0
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.diameter  &
   real_value = 150.0
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.i_marker  &
   object_value = ._modello_rear_susp.ger_upper_strut.rer_reboundstop_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.rer_rebound_bumper.j_marker  &
   object_value = ._modello_rear_susp.ger_lower_strut.rer_reboundstop_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.rer_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.property_file  &
   string_value = (._modello_rear_susp.bgl_bottom_mount.property_file_list[._modello_rear_susp.bgl_bottom_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/front_suspension_damper_lower_bus.xml"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.property_file_I  &
   string_value = (._modello_rear_susp.bgl_bottom_mount.property_file_list_I[._modello_rear_susp.bgl_bottom_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.property_file_J  &
   string_value = (._modello_rear_susp.bgl_bottom_mount.property_file_list_J[._modello_rear_susp.bgl_bottom_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.i_geoMarker  &
   object_value = ._modello_rear_susp.gel_lower_strut.bxl_bushgeom_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.j_geoMarker  &
   object_value = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_j_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.i_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.j_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.i_marker  &
   object_value = ._modello_rear_susp.gel_lower_strut.bxl_bushing_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgl_bottom_mount.j_marker  &
   object_value = ._modello_rear_susp.gel_swing_arm.bxl_bushing_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.property_file  &
   string_value = (._modello_rear_susp.bgr_bottom_mount.property_file_list[._modello_rear_susp.bgr_bottom_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/front_suspension_damper_lower_bus.xml"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.property_file_I  &
   string_value = (._modello_rear_susp.bgr_bottom_mount.property_file_list_I[._modello_rear_susp.bgr_bottom_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.property_file_J  &
   string_value = (._modello_rear_susp.bgr_bottom_mount.property_file_list_J[._modello_rear_susp.bgr_bottom_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.i_geoMarker  &
   object_value = ._modello_rear_susp.ger_lower_strut.bxr_bushgeom_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.j_geoMarker  &
   object_value = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_j_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.i_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.j_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.i_marker  &
   object_value = ._modello_rear_susp.ger_lower_strut.bxr_bushing_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bgr_bottom_mount.j_marker  &
   object_value = ._modello_rear_susp.ger_swing_arm.bxr_bushing_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.property_file  &
   string_value = (._modello_rear_susp.bul_jounce_bumper.property_file_list[._modello_rear_susp.bul_jounce_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.property_file_list  &
   string_value = "mdids://acar_shared/bumpstops.tbl/mdi_0001.bum"
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.user_distance  &
   real_value = 75.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.reference_marker  &
   object_value = ._modello_rear_susp.mtl_strut_to_body.bul_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.diameter  &
   real_value = 25.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.force_type  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.i_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.j_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.j_fmarker  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.j_fmarker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.i_marker  &
   object_value = ._modello_rear_susp.mtl_strut_to_body.bul_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bul_jounce_bumper.j_marker  &
   object_value = ._modello_rear_susp.gel_upper_strut.bul_bumpstop_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bul_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.property_file  &
   string_value = (._modello_rear_susp.bur_jounce_bumper.property_file_list[._modello_rear_susp.bur_jounce_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.property_file_list  &
   string_value = "mdids://acar_shared/bumpstops.tbl/mdi_0001.bum"
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.user_distance  &
   real_value = 75.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.reference_marker  &
   object_value = ._modello_rear_susp.mtr_strut_to_body.bur_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.diameter  &
   real_value = 25.0
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.force_type  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.i_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.j_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.j_fmarker  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.j_fmarker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.i_marker  &
   object_value = ._modello_rear_susp.mtr_strut_to_body.bur_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.bur_jounce_bumper.j_marker  &
   object_value = ._modello_rear_susp.ger_upper_strut.bur_bumpstop_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bur_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.property_file  &
   string_value = (._modello_rear_susp.dal_ride_damper.property_file_list[._modello_rear_susp.dal_ride_damper.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.property_file_list  &
   string_value = "mdids://acar_shared/dampers.tbl/mdi_0001.dpr"
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.scale_factor_compression  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.scale_factor_rebound  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.hysteretic_damper  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.gas_preload_method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.geoScale  &
   real_value = 0.15
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.r_marker_i_axial  &
   object_value = ._modello_rear_susp.gel_upper_strut.dal_ride_damper_axial_ref_i
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.r_marker_j_axial  &
   object_value = ._modello_rear_susp.gel_lower_strut.dal_ride_damper_axial_ref_j
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.i_marker  &
   object_value = ._modello_rear_susp.gel_upper_strut.dal_damper_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.dal_ride_damper.j_marker  &
   object_value = ._modello_rear_susp.gel_lower_strut.dal_damper_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.dal_ride_damper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.property_file  &
   string_value = (._modello_rear_susp.dar_ride_damper.property_file_list[._modello_rear_susp.dar_ride_damper.property_file_index])
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.property_file_list  &
   string_value = "mdids://acar_shared/dampers.tbl/mdi_0001.dpr"
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.scale_factor_compression  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.scale_factor_rebound  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.hysteretic_damper  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.gas_preload_method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.geoScale  &
   real_value = 0.15
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.r_marker_i_axial  &
   object_value = ._modello_rear_susp.ger_upper_strut.dar_ride_damper_axial_ref_i
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.r_marker_j_axial  &
   object_value = ._modello_rear_susp.ger_lower_strut.dar_ride_damper_axial_ref_j
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.i_marker  &
   object_value = ._modello_rear_susp.ger_upper_strut.dar_damper_i_1
!
variable modify  &
   variable_name = ._modello_rear_susp.dar_ride_damper.j_marker  &
   object_value = ._modello_rear_susp.ger_lower_strut.dar_damper_j_1
!
ude modify instance  &
   instance_name = ._modello_rear_susp.dar_ride_damper
!
undo end_block
!
!---------------------------------- Motions -----------------------------------!
!
!
constraint create motion_generator  &
   motion_name = ._modello_rear_susp._cv_motion  &
   comments = "Dummy for communicators"  &
   type_of_freedom = rotational  &
   joint_name = ._modello_rear_susp._cv_joint_for_motion  &
   function = ""
!
constraint attributes  &
   constraint_name = ._modello_rear_susp._cv_motion  &
   visibility = off  &
   name_visibility = off
!
!---------------------------------- Accgrav -----------------------------------!
!
!
force create body gravitational  &
   gravity_field_name = gravity  &
   x_component_gravity = 0.0  &
   y_component_gravity = 0.0  &
   z_component_gravity = -9810.0
!
!----------------------------- Analysis settings ------------------------------!
!
!
output_control set results  &
   model_name = _modello_rear_susp  &
   formatted = on
!
!---------------------------- Adams View Variables ----------------------------!
!
!
variable create  &
   variable_name = ._modello_rear_susp.suspension_parameters_ARRAY.type_flag  &
   integer_value = 1  &
   comments = "1=Independent, 0=Dependent"
!
variable create  &
   variable_name = ._modello_rear_susp.suspension_parameters_ARRAY.steer_axis_calc_method  &
   integer_value = 1  &
   comments = "0=Geometric, 1=Instant Axis"
!
variable create  &
   variable_name = ._modello_rear_susp.suspension_parameters_ARRAY.kp1  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.suspension_parameters_ARRAY.kp3  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.mtl_strut_to_body.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.mtl_strut_to_body.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.mtl_strut_to_body.dependents  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.mtr_strut_to_body.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.mtr_strut_to_body.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.mtr_strut_to_body.dependents  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.mtl_swing_arm_to_body.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.mtl_swing_arm_to_body.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.mtl_swing_arm_to_body.dependents  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.mtr_swing_arm_to_body.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.mtr_swing_arm_to_body.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.mtr_swing_arm_to_body.dependents  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.ges_spindle.sms_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = ._modello_rear_susp.ges_axle.sms_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_rear_susp.ges_axle.current_mass_properties  &
   string_value = ".materials.steel", "7.801E-06"
!
variable create  &
   variable_name = ._modello_rear_susp.gel_swing_arm.sml_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_rear_susp.ger_swing_arm.smr_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_rear_susp.gel_upper_strut.sml_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_rear_susp.ger_upper_strut.smr_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_rear_susp.ger_lower_strut.smr_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_rear_susp.gel_lower_strut.sml_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_rear_susp.speed  &
   units = "velocity"  &
   real_value = 0.0
!
variable create  &
   variable_name = ._modello_rear_susp.role  &
   string_value = "suspension"  &
   comments = "Memory for Adams Car major role"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center  &
   units = "length"  &
   real_value = 110.0, 0.0, -74.5
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center.matching_name  &
   string_value = "wheel_center"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center.entity  &
   string_value = "location"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.template_creation_date  &
   string_value = "1995/08/19,15:34:45  - converted to file_version 4"  &
   comments = "Do not remove"
!
variable create  &
   variable_name = ._modello_rear_susp.pvs_toe_angle  &
   units = "angle"  &
   real_value = 0.0  &
   comments =   &
              "A Positive toe angle yields toe_in (front of the wheel rotates towards the chassis)."
!
variable create  &
   variable_name = ._modello_rear_susp.pvs_camber_angle  &
   units = "angle"  &
   real_value = 0.0  &
   comments =   &
              "A Positive camber angle rotates the top of the wheel outward away from the chassis."
!
variable create  &
   variable_name = ._modello_rear_susp.cos_toe_angle  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_toe_angle.matching_name  &
   string_value = "toe_angle"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_toe_angle.entity  &
   string_value = "parameter_real"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_toe_angle.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_camber_angle  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_camber_angle.matching_name  &
   string_value = "camber_angle"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_camber_angle.entity  &
   string_value = "parameter_real"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_camber_angle.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.minor_role  &
   string_value = "unassigned"  &
   comments = "Memory for Adams/Car minor role"
!
variable create  &
   variable_name = ._modello_rear_susp.phs_kinematic_flag  &
   integer_value = 0  &
   comments =   &
              "Flag that determines if kinematic joints or bushings are active"
!
variable create  &
   variable_name = ._modello_rear_susp.model_class  &
   string_value = "template"  &
   comments = "Memory for Adams/Car model class"
!
variable create  &
   variable_name = ._modello_rear_susp.pvr_drive_shaft_offset  &
   units = "length"  &
   real_value = 50.0  &
   comments =   &
              "Location of outer CV joint measured inboard from wheel center along the wheel's spin axis"
!
variable create  &
   variable_name = ._modello_rear_susp.pvl_drive_shaft_offset  &
   units = "length"  &
   real_value = 50.0  &
   comments =   &
              "Location of outer CV joint measured inboard from wheel center along the wheel's spin axis"
!
variable create  &
   variable_name = ._modello_rear_susp.phs_driveline_active  &
   integer_value = 0  &
   comments = "( 1 = active driveline, 0 = inactive driveline)"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_driveline_active  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_driveline_active.matching_name  &
   string_value = "driveline_active"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_driveline_active.entity  &
   string_value = "parameter_integer"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_driveline_active.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_mount  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_mount.matching_name  &
   string_value = "suspension_mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_mount.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_mount.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_mount.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY.matching_name  &
   string_value = "characteristics_input_ARRAY"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY.entity  &
   string_value = "array"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY_adams_id  &
   integer_value = 0  &
   comments =   &
              "Passes the adams_id of the array (used in function expressions)"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY_adams_id.matching_name  &
   string_value = "characteristics_input_ARRAY_adams_id"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY_adams_id.entity  &
   string_value = "array"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY_adams_id.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY_adams_id.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_upright  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_upright.matching_name  &
   string_value = "suspension_upright"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_upright.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_upright.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_upright.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_upright_left  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_upright_left.matching_name  &
   string_value = "upright_left"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_upright_left.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_upright_left.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_upright_left.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_lower_bearing  &
   units = "length"  &
   real_value = 231.9, 0.0, -139.4
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_lower_bearing.matching_name  &
   string_value = "str_fork_loc_lower_bearing"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_lower_bearing.entity  &
   string_value = "location"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_lower_bearing.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_lower_bearing.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_parameters_ARRAY  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_parameters_ARRAY.matching_name  &
   string_value = "suspension_parameters_ARRAY"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_parameters_ARRAY.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_parameters_ARRAY.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_suspension_parameters_ARRAY.entity  &
   string_value = "array"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_chassis_reference  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cis_chassis_reference.matching_name  &
   string_value = "chassis_path_reference"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_chassis_reference.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_chassis_reference.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_chassis_reference_adams_id  &
   integer_value = 0  &
   comments =   &
              "Passes the adams_id of the marker (used in function expressions)"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_chassis_reference_adams_id.matching_name  &
   string_value = "chassis_path_reference_adams_id"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_chassis_reference_adams_id.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_chassis_reference_adams_id.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_upper_bearing  &
   units = "length"  &
   real_value = 0.0, 0.0, 0.0
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_upper_bearing.matching_name  &
   string_value = "str_fork_loc_upper_bearing"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_upper_bearing.entity  &
   string_value = "location"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_upper_bearing.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cis_str_fork_loc_upper_bearing.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_upper_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_upper_marker.matching_name  &
   string_value = "damper_upper_marker"
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_upper_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_upper_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_upper_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_upper_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_upper_marker.matching_name  &
   string_value = "damper_upper_marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_upper_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_upper_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_upper_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_lower_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_lower_marker.matching_name  &
   string_value = "damper_lower_marker"
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_lower_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_lower_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.col_damper_lower_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_lower_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_lower_marker.matching_name  &
   string_value = "damper_lower_marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_lower_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_lower_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_damper_lower_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_upper_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_upper_marker.matching_name  &
   string_value = "spring_upper_marker"
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_upper_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_upper_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_upper_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_upper_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_upper_marker.matching_name  &
   string_value = "spring_upper_marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_upper_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_upper_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_upper_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_lower_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_lower_marker.matching_name  &
   string_value = "spring_lower_marker"
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_lower_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_lower_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.col_spring_lower_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_lower_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_lower_marker.matching_name  &
   string_value = "spring_lower_marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_lower_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_lower_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cor_spring_lower_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_spindle_rise  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_spindle_rise.matching_name  &
   string_value = "spindle_rise"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_spindle_rise.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_spindle_rise.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_spindle_rise.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker_ori  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker_ori.matching_name  &
   string_value = "wheel_center_marker_ori"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker_ori.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker_ori.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker_ori.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_left  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_left.matching_name  &
   string_value = "lower_control_arm_left"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_left.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_left.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_left.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_right  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_right.matching_name  &
   string_value = "lower_control_arm_right"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_right.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_right.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_right.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker.matching_name  &
   string_value = "wheel_center_marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_svs_ride_height  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_svs_ride_height.matching_name  &
   string_value = "svs_ride_height"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_svs_ride_height.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_svs_ride_height.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_svs_ride_height.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm.matching_name  &
   string_value = "lower_control_arm"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_strut_to_body  &
   object_value = (NONE)  &
   comments = "Autocreated for mount part: mtl_strut_to_body"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_strut_to_body.matching_name  &
   string_value = "strut_to_body"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_strut_to_body.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_strut_to_body.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_strut_to_body.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_strut_to_body  &
   object_value = (NONE)  &
   comments = "Autocreated for mount part: mtr_strut_to_body"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_strut_to_body.matching_name  &
   string_value = "strut_to_body"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_strut_to_body.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_strut_to_body.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_strut_to_body.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_swing_arm_to_body  &
   object_value = (NONE)  &
   comments = "Autocreated for mount part: mtl_swing_arm_to_body"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_swing_arm_to_body.matching_name  &
   string_value = "swing_arm_to_body", "strut_to_body"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_swing_arm_to_body.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_swing_arm_to_body.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cil_swing_arm_to_body.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_swing_arm_to_body  &
   object_value = (NONE)  &
   comments = "Autocreated for mount part: mtr_swing_arm_to_body"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_swing_arm_to_body.matching_name  &
   string_value = "swing_arm_to_body", "strut_to_body"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_swing_arm_to_body.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_swing_arm_to_body.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_rear_susp.cir_swing_arm_to_body.subsystem_index  &
   string_value = "inherit"
!
!---------------------------- Adams View Functions ----------------------------!
!
!
function create  &
   function_name = .SYMMETRY  &
   text_of_expression = "LOC_MIRROR(location, .__ACAR.ground.origo, .ACAR.variables.symmetry_plane)"  &
   argument_names = "location"  &
   type = location_orientation  &
   comments =   &
              "Compute mirrored location over the symmetry plane given 3x1 location vector"
!
!---------------------- Set Adams View Object Variables -----------------------!
!
!
variable modify  &
   variable_name = ._modello_rear_susp.suspension_parameters_ARRAY.kp1  &
   object_value = ._modello_rear_susp.ges_axle.kp1_1,  &
                  ._modello_rear_susp.ges_axle.kp1_2
!
variable modify  &
   variable_name = ._modello_rear_susp.suspension_parameters_ARRAY.kp3  &
   object_value = ._modello_rear_susp.gel_swing_arm.kp3_1,  &
                  ._modello_rear_susp.ger_swing_arm.kp3_1
!
variable modify  &
   variable_name = ._modello_rear_susp.mtl_strut_to_body.dependents  &
   object_value = ._modello_rear_susp.mtl_fixed_1,  &
                  ._modello_rear_susp.cil_strut_to_body
!
variable modify  &
   variable_name = ._modello_rear_susp.mtr_strut_to_body.dependents  &
   object_value = ._modello_rear_susp.mtr_fixed_1,  &
                  ._modello_rear_susp.cir_strut_to_body
!
variable modify  &
   variable_name = ._modello_rear_susp.mtl_swing_arm_to_body.dependents  &
   object_value = ._modello_rear_susp.mtl_fixed_2,  &
                  ._modello_rear_susp.cil_swing_arm_to_body
!
variable modify  &
   variable_name = ._modello_rear_susp.mtr_swing_arm_to_body.dependents  &
   object_value = ._modello_rear_susp.mtr_fixed_2,  &
                  ._modello_rear_susp.cir_swing_arm_to_body
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_toe_angle  &
   object_value = ._modello_rear_susp.pvs_toe_angle
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_camber_angle  &
   object_value = ._modello_rear_susp.pvs_camber_angle
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_driveline_active  &
   object_value = ._modello_rear_susp.phs_driveline_active
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_suspension_mount  &
   object_value = ._modello_rear_susp.ges_spindle
!
variable modify  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY  &
   object_value = ._modello_rear_susp._cv_array
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_suspension_upright  &
   object_value = ._modello_rear_susp.ges_axle
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_upright_left  &
   object_value = ._modello_rear_susp.ges_axle
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_suspension_parameters_ARRAY  &
   object_value = ._modello_rear_susp.suspension_parameters_ARRAY
!
variable modify  &
   variable_name = ._modello_rear_susp.cis_chassis_reference  &
   object_value = ._modello_rear_susp.ground._cv_marker
!
variable modify  &
   variable_name = ._modello_rear_susp.col_damper_upper_marker  &
   object_value = ._modello_rear_susp.gel_upper_strut.coomarker_1
!
variable modify  &
   variable_name = ._modello_rear_susp.cor_damper_upper_marker  &
   object_value = ._modello_rear_susp.ger_upper_strut.coomarker_2
!
variable modify  &
   variable_name = ._modello_rear_susp.col_damper_lower_marker  &
   object_value = ._modello_rear_susp.gel_swing_arm.coomarker_3
!
variable modify  &
   variable_name = ._modello_rear_susp.cor_damper_lower_marker  &
   object_value = ._modello_rear_susp.ger_swing_arm.coomarker_4
!
variable modify  &
   variable_name = ._modello_rear_susp.col_spring_upper_marker  &
   object_value = ._modello_rear_susp.gel_upper_strut.coomarker_5
!
variable modify  &
   variable_name = ._modello_rear_susp.cor_spring_upper_marker  &
   object_value = ._modello_rear_susp.ger_upper_strut.coomarker_6
!
variable modify  &
   variable_name = ._modello_rear_susp.col_spring_lower_marker  &
   object_value = ._modello_rear_susp.gel_lower_strut.coomarker_7
!
variable modify  &
   variable_name = ._modello_rear_susp.cor_spring_lower_marker  &
   object_value = ._modello_rear_susp.ger_lower_strut.coomarker_8
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_spindle_rise  &
   object_value = ._modello_rear_susp.ges_axle.coomarker_9
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker_ori  &
   object_value = ._modello_rear_susp.ges_axle.coomarker_10
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_left  &
   object_value = ._modello_rear_susp.gel_swing_arm
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm_right  &
   object_value = ._modello_rear_susp.ger_swing_arm
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_wheel_center_marker  &
   object_value = ._modello_rear_susp.ges_axle.coomarker_11
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_svs_ride_height  &
   object_value = ._modello_rear_susp.ger_swing_arm.coomarker_12
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_lower_control_arm  &
   object_value = ._modello_rear_susp.ges_axle
!
variable modify  &
   variable_name = ._modello_rear_susp.cil_strut_to_body  &
   object_value = ._modello_rear_susp.ground.mtl_mount_j_1,  &
                  ._modello_rear_susp.mtl_strut_to_body,  &
                  ._modello_rear_susp.mtl_fixed_1
!
variable modify  &
   variable_name = ._modello_rear_susp.cir_strut_to_body  &
   object_value = ._modello_rear_susp.ground.mtr_mount_j_1,  &
                  ._modello_rear_susp.mtr_strut_to_body,  &
                  ._modello_rear_susp.mtr_fixed_1
!
variable modify  &
   variable_name = ._modello_rear_susp.cil_swing_arm_to_body  &
   object_value = ._modello_rear_susp.ground.mtl_mount_j_2,  &
                  ._modello_rear_susp.mtl_swing_arm_to_body,  &
                  ._modello_rear_susp.mtl_fixed_2
!
variable modify  &
   variable_name = ._modello_rear_susp.cir_swing_arm_to_body  &
   object_value = ._modello_rear_susp.ground.mtr_mount_j_2,  &
                  ._modello_rear_susp.mtr_swing_arm_to_body,  &
                  ._modello_rear_susp.mtr_fixed_2
!
!--------------------------- Add Objects To Groups ----------------------------!
!
!
group modify  &
   group_name = ._modello_rear_susp.top_mount_kinematic  &
   objects_in_group = ._modello_rear_susp.jolper_top_mount,  &
      ._modello_rear_susp.jorper_top_mount
!
!---------------------------- Function definitions ----------------------------!
!
!
constraint modify motion_generator  &
   motion_name = ._modello_rear_susp._cv_motion  &
   function = "0"
!
data_element modify variable  &
   variable_name = ._modello_rear_susp._cv_solver_variable  &
   function = "0"
!
part modify equation differential_equation  &
   differential_equation_name = ._modello_rear_susp._cv_diff  &
   function = "0"
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_swing_arm_to_body
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_swing_arm_to_body
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_swing_arm_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_swing_arm_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_swing_arm_to_body
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_swing_arm_to_body
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_swing_arm_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_swing_arm_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.nsl_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.nsr_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.rel_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.rer_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bul_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bur_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.dal_ride_damper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_rear_susp.dar_ride_damper
!
!--------------------------- Expression definitions ---------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.mtl_mount_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtl_strut_to_body))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtl_strut_to_body))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.mtr_mount_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtr_strut_to_body))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtr_strut_to_body))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.mtl_mount_j_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtl_swing_arm_to_body))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtl_swing_arm_to_body))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.mtr_mount_j_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtr_swing_arm_to_body))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtr_swing_arm_to_body))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfl_spring_lwr_seat  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpl_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfr_spring_lwr_seat  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfl_spring_upr_seat  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpl_spring_upr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfr_spring_upr_seat  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_spring_upr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfl_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpl_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfr_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfl_top_mount_jprim_ref1  &
   location =   &
      (LOC_RELATIVE_TO({0.0, -50.0, 0.0}mm + LOC_LOCAL(._modello_rear_susp.ground.hpl_top_mount.loc, ._modello_rear_susp.ground.origo), ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfr_top_mount_jprim_ref1  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 50.0, 0.0}mm + LOC_LOCAL(._modello_rear_susp.ground.hpr_top_mount.loc, ._modello_rear_susp.ground.origo), ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfs_str_fork_upper_bearing  &
   location =   &
      (._modello_rear_susp.cis_str_fork_loc_upper_bearing)  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfl_dummy_susp_par_upper_bearing  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.cfs_str_fork_upper_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfr_dummy_susp_par_upper_bearing  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.cfs_str_fork_upper_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfs_strut_to_body  &
   location =   &
      (._modello_rear_susp.cis_str_fork_loc_lower_bearing)  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfs_wheel_center  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({180d - ._modello_rear_susp.pvs_toe_angle, -90d - ._modello_rear_susp.pvs_camber_angle, 180d}, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfl_top_mount_ext  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 50.0}mm + LOC_LOCAL(._modello_rear_susp.ground.hpl_top_mount.loc, ._modello_rear_susp.ground.origo), ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfr_top_mount_ext  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 50.0}mm + LOC_LOCAL(._modello_rear_susp.ground.hpr_top_mount.loc, ._modello_rear_susp.ground.origo), ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfl_dummy_susp_parameter  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.cfs_strut_to_body))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfr_dummy_susp_parameter  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.cfs_strut_to_body))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfl_lwr_strut_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpl_strut_lwr_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfr_lwr_strut_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_strut_lwr_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfs_wheel_center_marker_ori  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({180.0, 90.0, 180.0}degrees, ._modello_rear_susp.ground.cfs_wheel_center))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfs_spindle_rise  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({180.0, 90.0, 0.0}degrees, ._modello_rear_susp.ground.cfs_wheel_center_marker_ori))
!
marker modify  &
   marker_name = ._modello_rear_susp.ground.cfs_ride_height_ref  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_swing_arm_pivot))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
variable modify  &
   variable_name = ._modello_rear_susp.suspension_parameters_ARRAY.type_flag  &
   integer_value = ("Independent" == "Independent")
!
data_element modify array ic_array  &
   array_name = ._modello_rear_susp.suspension_parameters_ARRAY  &
   numbers =   &
      (._modello_rear_susp.suspension_parameters_ARRAY.type_flag),  &
      0.0,  &
      (._modello_rear_susp.gel_swing_arm.kp3_1.adams_id),  &
      0.0,  &
      (._modello_rear_susp.ger_swing_arm.kp3_1.adams_id),  &
      (ANYM(._modello_rear_susp.minor_role == {"front", "any"}))
!
data_element modify string  &
   string_name = ._modello_rear_susp.minor_role_string  &
   string = (._modello_rear_susp.minor_role)
!
material modify  &
   material_name = ._modello_rear_susp.steel  &
   density = (7801.0(kg/meter**3))  &
   youngs_modulus = (2.07E+11(Newton/meter**2))
!
marker modify  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.bxl_bushing_j_4  &
   location =   &
      (._modello_rear_susp.bgl_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgl_top_mount.j_tolerance}, ._modello_rear_susp.bgl_top_mount) : LOC_RELATIVE_TO({._modello_rear_susp.bgl_top_mount.j_tolerance[1], ._modello_rear_susp.bgl_top_mount.j_tolerance[2], ._modello_rear_susp.bgl_top_mount.j_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgl_top_mount.loc, ._modello_rear_susp.bgl_top_mount.parent.ground.origo), ._modello_rear_susp.bgl_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgl_top_mount))  &
   relative_to = ._modello_rear_susp.mtl_strut_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.bxl_bushgeom_j_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgl_top_mount.geoLength / 2}, ._modello_rear_susp.mtl_strut_to_body.bxl_bushing_j_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtl_strut_to_body.bxl_bushing_j_4))  &
   relative_to = ._modello_rear_susp.mtl_strut_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.jxl_joint_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpl_top_mount))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_rear_susp.mtl_strut_to_body.jxl_joint_j_1, ._modello_rear_susp.ground.hpl_strut_lwr_mount, ._modello_rear_susp.ground.cfl_top_mount_jprim_ref1, "Z_ZX"))  &
   relative_to = ._modello_rear_susp.mtl_strut_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.mtl_strut_to_body.bul_bumpstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_bumper_upper))  &
   relative_to = ._modello_rear_susp.mtl_strut_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.mtl_strut_to_body  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.bxr_bushing_j_4  &
   location =   &
      (._modello_rear_susp.bgr_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgr_top_mount.j_tolerance}, ._modello_rear_susp.bgr_top_mount) : LOC_RELATIVE_TO({._modello_rear_susp.bgr_top_mount.j_tolerance[1], ._modello_rear_susp.bgr_top_mount.j_tolerance[2], ._modello_rear_susp.bgr_top_mount.j_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgr_top_mount.loc, ._modello_rear_susp.bgr_top_mount.parent.ground.origo), ._modello_rear_susp.bgr_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgr_top_mount))  &
   relative_to = ._modello_rear_susp.mtr_strut_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.bxr_bushgeom_j_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgr_top_mount.geoLength / 2}, ._modello_rear_susp.mtr_strut_to_body.bxr_bushing_j_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtr_strut_to_body.bxr_bushing_j_4))  &
   relative_to = ._modello_rear_susp.mtr_strut_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.jxr_joint_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_top_mount))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_rear_susp.mtr_strut_to_body.jxr_joint_j_1, ._modello_rear_susp.ground.hpr_strut_lwr_mount, ._modello_rear_susp.ground.cfr_top_mount_jprim_ref1, "Z_ZX"))  &
   relative_to = ._modello_rear_susp.mtr_strut_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.mtr_strut_to_body.bur_bumpstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_bumper_upper))  &
   relative_to = ._modello_rear_susp.mtr_strut_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.mtr_strut_to_body  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushing_j_2  &
   location =   &
      (._modello_rear_susp.bgl_swing_arm_to_body.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgl_swing_arm_to_body.j_tolerance}, ._modello_rear_susp.bgl_swing_arm_to_body) : LOC_RELATIVE_TO({._modello_rear_susp.bgl_swing_arm_to_body.j_tolerance[1], ._modello_rear_susp.bgl_swing_arm_to_body.j_tolerance[2], ._modello_rear_susp.bgl_swing_arm_to_body.j_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgl_swing_arm_to_body.loc, ._modello_rear_susp.bgl_swing_arm_to_body.parent.ground.origo), ._modello_rear_susp.bgl_swing_arm_to_body.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgl_swing_arm_to_body))  &
   relative_to = ._modello_rear_susp.mtl_swing_arm_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushgeom_j_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgl_swing_arm_to_body.geoLength / 2}, ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushing_j_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtl_swing_arm_to_body.bxl_bushing_j_2))  &
   relative_to = ._modello_rear_susp.mtl_swing_arm_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.mtl_swing_arm_to_body  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_swing_arm_pivot))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushing_j_2  &
   location =   &
      (._modello_rear_susp.bgr_swing_arm_to_body.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgr_swing_arm_to_body.j_tolerance}, ._modello_rear_susp.bgr_swing_arm_to_body) : LOC_RELATIVE_TO({._modello_rear_susp.bgr_swing_arm_to_body.j_tolerance[1], ._modello_rear_susp.bgr_swing_arm_to_body.j_tolerance[2], ._modello_rear_susp.bgr_swing_arm_to_body.j_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgr_swing_arm_to_body.loc, ._modello_rear_susp.bgr_swing_arm_to_body.parent.ground.origo), ._modello_rear_susp.bgr_swing_arm_to_body.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgr_swing_arm_to_body))  &
   relative_to = ._modello_rear_susp.mtr_swing_arm_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushgeom_j_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgr_swing_arm_to_body.geoLength / 2}, ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushing_j_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtr_swing_arm_to_body.bxr_bushing_j_2))  &
   relative_to = ._modello_rear_susp.mtr_swing_arm_to_body
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.mtr_swing_arm_to_body  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_swing_arm_pivot))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_spindle.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ges_spindle.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ges_spindle))  &
   relative_to = ._modello_rear_susp.ges_spindle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_spindle.jxs_joint_i_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ges_axle.jxs_joint_j_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ges_axle.jxs_joint_j_2))  &
   relative_to = ._modello_rear_susp.ges_spindle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ges_spindle  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hps_wheel_center))
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.mas_kingpin_axis  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.origo))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.mas_wheel_center  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.cfs_wheel_center))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.kp1_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_dummy_susp_parameter))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.kp1_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_dummy_susp_parameter))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.bxl_bushing_j_3  &
   location =   &
      (._modello_rear_susp.bgl_swing_arm_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgl_swing_arm_to_axle.j_tolerance}, ._modello_rear_susp.bgl_swing_arm_to_axle) : LOC_RELATIVE_TO({._modello_rear_susp.bgl_swing_arm_to_axle.j_tolerance[1], ._modello_rear_susp.bgl_swing_arm_to_axle.j_tolerance[2], ._modello_rear_susp.bgl_swing_arm_to_axle.j_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgl_swing_arm_to_axle.loc, ._modello_rear_susp.bgl_swing_arm_to_axle.parent.ground.origo), ._modello_rear_susp.bgl_swing_arm_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgl_swing_arm_to_axle))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.bxl_bushgeom_j_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgl_swing_arm_to_axle.geoLength / 2}, ._modello_rear_susp.ges_axle.bxl_bushing_j_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ges_axle.bxl_bushing_j_3))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.bxr_bushing_j_3  &
   location =   &
      (._modello_rear_susp.bgr_swing_arm_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgr_swing_arm_to_axle.j_tolerance}, ._modello_rear_susp.bgr_swing_arm_to_axle) : LOC_RELATIVE_TO({._modello_rear_susp.bgr_swing_arm_to_axle.j_tolerance[1], ._modello_rear_susp.bgr_swing_arm_to_axle.j_tolerance[2], ._modello_rear_susp.bgr_swing_arm_to_axle.j_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgr_swing_arm_to_axle.loc, ._modello_rear_susp.bgr_swing_arm_to_axle.parent.ground.origo), ._modello_rear_susp.bgr_swing_arm_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgr_swing_arm_to_axle))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.bxr_bushgeom_j_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgr_swing_arm_to_axle.geoLength / 2}, ._modello_rear_susp.ges_axle.bxr_bushing_j_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ges_axle.bxr_bushing_j_3))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.jxs_joint_j_2  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.cfs_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_rear_susp.ground.cfs_wheel_center))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ges_axle.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ges_axle))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.gralin_5  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_swing_arm_to_axle))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.ground.hpl_swing_arm_to_axle, ._modello_rear_susp.ground.hpr_swing_arm_to_axle, "Z"))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.coomarker_9  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfs_spindle_rise))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfs_spindle_rise))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.coomarker_10  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfs_wheel_center_marker_ori))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfs_wheel_center_marker_ori))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ges_axle.coomarker_11  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfs_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfs_wheel_center))  &
   relative_to = ._modello_rear_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
geometry modify shape cylinder  &
   cylinder_name = ._modello_rear_susp.ges_axle.gralin_axle  &
   length = (DM(._modello_rear_susp.ground.hpl_swing_arm_to_axle, ._modello_rear_susp.ground.hpr_swing_arm_to_axle))
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ges_axle  &
   location =   &
      (LOC_CENTERED({._modello_rear_susp.ground.hpl_swing_arm_to_axle.loc, ._modello_rear_susp.ground.hpr_swing_arm_to_axle.loc}, 2))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.ground.hpl_swing_arm_to_axle, ._modello_rear_susp.ground.hpr_swing_arm_to_axle, "Z"))
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.kp3_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_2  &
   location =   &
      (._modello_rear_susp.bgl_swing_arm_to_body.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgl_swing_arm_to_body.i_tolerance}, ._modello_rear_susp.bgl_swing_arm_to_body) : LOC_RELATIVE_TO({._modello_rear_susp.bgl_swing_arm_to_body.i_tolerance[1], ._modello_rear_susp.bgl_swing_arm_to_body.i_tolerance[2], ._modello_rear_susp.bgl_swing_arm_to_body.i_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgl_swing_arm_to_body.loc, ._modello_rear_susp.bgl_swing_arm_to_body.parent.ground.origo), ._modello_rear_susp.bgl_swing_arm_to_body.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgl_swing_arm_to_body))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_i_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgl_swing_arm_to_body.geoLength / 2}, ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_2))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_3  &
   location =   &
      (._modello_rear_susp.bgl_swing_arm_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgl_swing_arm_to_axle.i_tolerance}, ._modello_rear_susp.bgl_swing_arm_to_axle) : LOC_RELATIVE_TO({._modello_rear_susp.bgl_swing_arm_to_axle.i_tolerance[1], ._modello_rear_susp.bgl_swing_arm_to_axle.i_tolerance[2], ._modello_rear_susp.bgl_swing_arm_to_axle.i_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgl_swing_arm_to_axle.loc, ._modello_rear_susp.bgl_swing_arm_to_axle.parent.ground.origo), ._modello_rear_susp.bgl_swing_arm_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgl_swing_arm_to_axle))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_i_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgl_swing_arm_to_axle.geoLength / 2}, ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_rear_susp.gel_swing_arm.bxl_bushing_i_3))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.gralin_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_swing_arm_to_axle))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.ground.hpl_swing_arm_to_axle, ._modello_rear_susp.ground.hpl_swing_arm_pivot, "Z"))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.gel_swing_arm.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.gel_swing_arm))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushing_j_1  &
   location =   &
      (._modello_rear_susp.bgl_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgl_bottom_mount.j_tolerance}, ._modello_rear_susp.bgl_bottom_mount) : LOC_RELATIVE_TO({._modello_rear_susp.bgl_bottom_mount.j_tolerance[1], ._modello_rear_susp.bgl_bottom_mount.j_tolerance[2], ._modello_rear_susp.bgl_bottom_mount.j_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgl_bottom_mount.loc, ._modello_rear_susp.bgl_bottom_mount.parent.ground.origo), ._modello_rear_susp.bgl_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgl_bottom_mount))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.bxl_bushgeom_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgl_bottom_mount.geoLength / 2}, ._modello_rear_susp.gel_swing_arm.bxl_bushing_j_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.gel_swing_arm.bxl_bushing_j_1))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_swing_arm.coomarker_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_lwr_strut_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_lwr_strut_mount))  &
   relative_to = ._modello_rear_susp.gel_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
geometry modify shape cylinder  &
   cylinder_name = ._modello_rear_susp.gel_swing_arm.gralin_susp_link  &
   length = (DM(._modello_rear_susp.ground.hpl_swing_arm_to_axle, ._modello_rear_susp.ground.hpl_swing_arm_pivot))
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.gel_swing_arm  &
   location =   &
      (LOC_CENTERED({._modello_rear_susp.ground.hpl_swing_arm_pivot.loc, ._modello_rear_susp.ground.hpl_swing_arm_to_axle.loc}, 2))
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.kp3_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_2  &
   location =   &
      (._modello_rear_susp.bgr_swing_arm_to_body.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgr_swing_arm_to_body.i_tolerance}, ._modello_rear_susp.bgr_swing_arm_to_body) : LOC_RELATIVE_TO({._modello_rear_susp.bgr_swing_arm_to_body.i_tolerance[1], ._modello_rear_susp.bgr_swing_arm_to_body.i_tolerance[2], ._modello_rear_susp.bgr_swing_arm_to_body.i_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgr_swing_arm_to_body.loc, ._modello_rear_susp.bgr_swing_arm_to_body.parent.ground.origo), ._modello_rear_susp.bgr_swing_arm_to_body.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgr_swing_arm_to_body))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_i_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgr_swing_arm_to_body.geoLength / 2}, ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_2))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_3  &
   location =   &
      (._modello_rear_susp.bgr_swing_arm_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgr_swing_arm_to_axle.i_tolerance}, ._modello_rear_susp.bgr_swing_arm_to_axle) : LOC_RELATIVE_TO({._modello_rear_susp.bgr_swing_arm_to_axle.i_tolerance[1], ._modello_rear_susp.bgr_swing_arm_to_axle.i_tolerance[2], ._modello_rear_susp.bgr_swing_arm_to_axle.i_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgr_swing_arm_to_axle.loc, ._modello_rear_susp.bgr_swing_arm_to_axle.parent.ground.origo), ._modello_rear_susp.bgr_swing_arm_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgr_swing_arm_to_axle))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_i_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgr_swing_arm_to_axle.geoLength / 2}, ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_rear_susp.ger_swing_arm.bxr_bushing_i_3))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.gralin_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_swing_arm_to_axle))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.ground.hpr_swing_arm_to_axle, ._modello_rear_susp.ground.hpr_swing_arm_pivot, "Z"))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ger_swing_arm.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ger_swing_arm))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushing_j_1  &
   location =   &
      (._modello_rear_susp.bgr_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgr_bottom_mount.j_tolerance}, ._modello_rear_susp.bgr_bottom_mount) : LOC_RELATIVE_TO({._modello_rear_susp.bgr_bottom_mount.j_tolerance[1], ._modello_rear_susp.bgr_bottom_mount.j_tolerance[2], ._modello_rear_susp.bgr_bottom_mount.j_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgr_bottom_mount.loc, ._modello_rear_susp.bgr_bottom_mount.parent.ground.origo), ._modello_rear_susp.bgr_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgr_bottom_mount))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.bxr_bushgeom_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgr_bottom_mount.geoLength / 2}, ._modello_rear_susp.ger_swing_arm.bxr_bushing_j_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ger_swing_arm.bxr_bushing_j_1))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.coomarker_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_lwr_strut_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_lwr_strut_mount))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_swing_arm.coomarker_12  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfs_ride_height_ref))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfs_ride_height_ref))  &
   relative_to = ._modello_rear_susp.ger_swing_arm
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
geometry modify shape cylinder  &
   cylinder_name = ._modello_rear_susp.ger_swing_arm.gralin_susp_link  &
   length = (DM(._modello_rear_susp.ground.hpr_swing_arm_to_axle, ._modello_rear_susp.ground.hpr_swing_arm_pivot))
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ger_swing_arm  &
   location =   &
      (LOC_CENTERED({._modello_rear_susp.ground.hpr_swing_arm_pivot.loc, ._modello_rear_susp.ground.hpr_swing_arm_to_axle.loc}, 2))
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.coomarker_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_top_mount))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.rel_reboundstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_strut_lwr_mount))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.bxl_bushing_i_4  &
   location =   &
      (._modello_rear_susp.bgl_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgl_top_mount.i_tolerance}, ._modello_rear_susp.bgl_top_mount) : LOC_RELATIVE_TO({._modello_rear_susp.bgl_top_mount.i_tolerance[1], ._modello_rear_susp.bgl_top_mount.i_tolerance[2], ._modello_rear_susp.bgl_top_mount.i_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgl_top_mount.loc, ._modello_rear_susp.bgl_top_mount.parent.ground.origo), ._modello_rear_susp.bgl_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgl_top_mount))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.bxl_bushgeom_i_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgl_top_mount.geoLength / 2}, ._modello_rear_susp.gel_upper_strut.bxl_bushing_i_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_rear_susp.gel_upper_strut.bxl_bushing_i_4))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.jxl_joint_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtl_strut_to_body.jxl_joint_j_1))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_rear_susp.gel_upper_strut.jxl_joint_i_1, ._modello_rear_susp.ground.cfl_top_mount_jprim_ref1, ._modello_rear_susp.ground.hpl_strut_lwr_mount, "Z_ZX"))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.jxl_joint_j_10  &
   location =   &
      (LOC_RELATIVE_TO(LOC_CENTERED({._modello_rear_susp.ground.hpl_top_mount.loc, ._modello_rear_susp.ground.hpl_strut_lwr_mount.loc}, 2), ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.gel_upper_strut.jxl_joint_j_10, ._modello_rear_susp.ground.hpl_top_mount, "Z"))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.jklhoo_top_mount_kinematic_1  &
   location =   &
      (LOC_RELATIVE_TO(._modello_rear_susp.ground.cfl_top_mount_ext.location, ._modello_rear_susp.ground.cfl_top_mount_ext.parent))  &
   orientation =   &
      (ORI_RELATIVE_TO(._modello_rear_susp.ground.cfl_top_mount_ext.orientation, ._modello_rear_susp.ground.cfl_top_mount_ext.parent))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.dal_damper_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_top_mount))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.gel_upper_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.gel_upper_strut))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.nsl_spring_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_spring_upr_seat))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.bul_bumpstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_bumper_lower))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.dal_ride_damper_axial_ref_i  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_rear_susp.dal_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.dal_ride_damper.i_marker, ._modello_rear_susp.dal_ride_damper.j_marker, "z"))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_upper_strut.coomarker_5  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_spring_upr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_spring_upr_seat))  &
   relative_to = ._modello_rear_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.gel_upper_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_rear_susp.ground.hpl_top_mount, ._modello_rear_susp.ground.hpl_strut_lwr_mount, 0.33 * DM(._modello_rear_susp.ground.hpl_top_mount, ._modello_rear_susp.ground.hpl_strut_lwr_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.gel_upper_strut, ._modello_rear_susp.ground.hpl_top_mount, "Z"))
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.coomarker_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_top_mount))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.rer_reboundstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_strut_lwr_mount))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.bxr_bushing_i_4  &
   location =   &
      (._modello_rear_susp.bgr_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgr_top_mount.i_tolerance}, ._modello_rear_susp.bgr_top_mount) : LOC_RELATIVE_TO({._modello_rear_susp.bgr_top_mount.i_tolerance[1], ._modello_rear_susp.bgr_top_mount.i_tolerance[2], ._modello_rear_susp.bgr_top_mount.i_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgr_top_mount.loc, ._modello_rear_susp.bgr_top_mount.parent.ground.origo), ._modello_rear_susp.bgr_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgr_top_mount))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.bxr_bushgeom_i_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgr_top_mount.geoLength / 2}, ._modello_rear_susp.ger_upper_strut.bxr_bushing_i_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_rear_susp.ger_upper_strut.bxr_bushing_i_4))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.jxr_joint_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.mtr_strut_to_body.jxr_joint_j_1))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_rear_susp.ger_upper_strut.jxr_joint_i_1, ._modello_rear_susp.ground.cfr_top_mount_jprim_ref1, ._modello_rear_susp.ground.hpr_strut_lwr_mount, "Z_ZX"))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.jxr_joint_j_10  &
   location =   &
      (LOC_RELATIVE_TO(LOC_CENTERED({._modello_rear_susp.ground.hpr_top_mount.loc, ._modello_rear_susp.ground.hpr_strut_lwr_mount.loc}, 2), ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.ger_upper_strut.jxr_joint_j_10, ._modello_rear_susp.ground.hpr_top_mount, "Z"))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.jkrhoo_top_mount_kinematic_1  &
   location =   &
      (LOC_RELATIVE_TO(._modello_rear_susp.ground.cfr_top_mount_ext.location, ._modello_rear_susp.ground.cfr_top_mount_ext.parent))  &
   orientation =   &
      (ORI_RELATIVE_TO(._modello_rear_susp.ground.cfr_top_mount_ext.orientation, ._modello_rear_susp.ground.cfr_top_mount_ext.parent))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.dar_damper_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_top_mount))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ger_upper_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ger_upper_strut))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.nsr_spring_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_spring_upr_seat))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.bur_bumpstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_bumper_lower))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.dar_ride_damper_axial_ref_i  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_rear_susp.dar_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.dar_ride_damper.i_marker, ._modello_rear_susp.dar_ride_damper.j_marker, "z"))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_upper_strut.coomarker_6  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_spring_upr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_spring_upr_seat))  &
   relative_to = ._modello_rear_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ger_upper_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_rear_susp.ground.hpr_top_mount, ._modello_rear_susp.ground.hpr_strut_lwr_mount, 0.33 * DM(._modello_rear_susp.ground.hpr_top_mount, ._modello_rear_susp.ground.hpr_strut_lwr_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.ger_upper_strut, ._modello_rear_susp.ground.hpr_top_mount, "Z"))
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_lower_strut.coomarker_8  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfr_spring_lwr_seat))  &
   relative_to = ._modello_rear_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_lower_strut.rer_reboundstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_top_mount))  &
   relative_to = ._modello_rear_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_lower_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ger_lower_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ger_lower_strut))  &
   relative_to = ._modello_rear_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_lower_strut.dar_damper_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_strut_lwr_mount))  &
   relative_to = ._modello_rear_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_lower_strut.nsr_spring_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpr_spring_lwr_seat))  &
   relative_to = ._modello_rear_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_lower_strut.jxr_joint_i_10  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ger_upper_strut.jxr_joint_j_10))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ger_upper_strut.jxr_joint_j_10))  &
   relative_to = ._modello_rear_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_lower_strut.bxr_bushing_i_1  &
   location =   &
      (._modello_rear_susp.bgr_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgr_bottom_mount.i_tolerance}, ._modello_rear_susp.bgr_bottom_mount) : LOC_RELATIVE_TO({._modello_rear_susp.bgr_bottom_mount.i_tolerance[1], ._modello_rear_susp.bgr_bottom_mount.i_tolerance[2], ._modello_rear_susp.bgr_bottom_mount.i_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgr_bottom_mount.loc, ._modello_rear_susp.bgr_bottom_mount.parent.ground.origo), ._modello_rear_susp.bgr_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgr_bottom_mount))  &
   relative_to = ._modello_rear_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_lower_strut.bxr_bushgeom_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgr_bottom_mount.geoLength / 2}, ._modello_rear_susp.ger_lower_strut.bxr_bushing_i_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_rear_susp.ger_lower_strut.bxr_bushing_i_1))  &
   relative_to = ._modello_rear_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.ger_lower_strut.dar_ride_damper_axial_ref_j  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_rear_susp.dar_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.dar_ride_damper.j_marker, ._modello_rear_susp.dar_ride_damper.i_marker, "z"))  &
   relative_to = ._modello_rear_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.ger_lower_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_rear_susp.ground.hpr_top_mount, ._modello_rear_susp.ground.hpr_strut_lwr_mount, 0.66 * DM(._modello_rear_susp.ground.hpr_top_mount, ._modello_rear_susp.ground.hpr_strut_lwr_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.ger_lower_strut, ._modello_rear_susp.ground.hpr_top_mount, "Z"))
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_lower_strut.coomarker_7  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.cfl_spring_lwr_seat))  &
   relative_to = ._modello_rear_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_lower_strut.rel_reboundstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_top_mount))  &
   relative_to = ._modello_rear_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_lower_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.gel_lower_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.gel_lower_strut))  &
   relative_to = ._modello_rear_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_lower_strut.dal_damper_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_strut_lwr_mount))  &
   relative_to = ._modello_rear_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_lower_strut.nsl_spring_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.hpl_spring_lwr_seat))  &
   relative_to = ._modello_rear_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_lower_strut.jxl_joint_i_10  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.gel_upper_strut.jxl_joint_j_10))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.gel_upper_strut.jxl_joint_j_10))  &
   relative_to = ._modello_rear_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_lower_strut.bxl_bushing_i_1  &
   location =   &
      (._modello_rear_susp.bgl_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_rear_susp.bgl_bottom_mount.i_tolerance}, ._modello_rear_susp.bgl_bottom_mount) : LOC_RELATIVE_TO({._modello_rear_susp.bgl_bottom_mount.i_tolerance[1], ._modello_rear_susp.bgl_bottom_mount.i_tolerance[2], ._modello_rear_susp.bgl_bottom_mount.i_tolerance[3]} + LOC_LOCAL(._modello_rear_susp.bgl_bottom_mount.loc, ._modello_rear_susp.bgl_bottom_mount.parent.ground.origo), ._modello_rear_susp.bgl_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.bgl_bottom_mount))  &
   relative_to = ._modello_rear_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_lower_strut.bxl_bushgeom_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_rear_susp.bgl_bottom_mount.geoLength / 2}, ._modello_rear_susp.gel_lower_strut.bxl_bushing_i_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_rear_susp.gel_lower_strut.bxl_bushing_i_1))  &
   relative_to = ._modello_rear_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
marker modify  &
   marker_name = ._modello_rear_susp.gel_lower_strut.dal_ride_damper_axial_ref_j  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_rear_susp.dal_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.dal_ride_damper.j_marker, ._modello_rear_susp.dal_ride_damper.i_marker, "z"))  &
   relative_to = ._modello_rear_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_rear_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_rear_susp.gel_lower_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_rear_susp.ground.hpl_top_mount, ._modello_rear_susp.ground.hpl_strut_lwr_mount, 0.66 * DM(._modello_rear_susp.ground.hpl_top_mount, ._modello_rear_susp.ground.hpl_strut_lwr_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.gel_lower_strut, ._modello_rear_susp.ground.hpl_top_mount, "Z"))
!
output_control modify request  &
   request_name = ._modello_rear_susp.toe_camber_caster  &
   user_function =   &
      1101.0,  &
      0.0,  &
      (._modello_rear_susp.ges_axle.mas_kingpin_axis.adams_id),  &
      (._modello_rear_susp.ges_axle.mas_wheel_center.adams_id),  &
      0.0,  &
      (._modello_rear_susp.ges_axle.mas_kingpin_axis.adams_id),  &
      (._modello_rear_susp.ges_axle.mas_wheel_center.adams_id),  &
      (._modello_rear_susp.cis_chassis_reference_adams_id),  &
      0.0,  &
      (._modello_rear_susp.ground.origo.adams_id)  &
   routine = "acar_solver::reqsub"
!
group modify  &
   group_name = ._modello_rear_susp.top_mount_kinematic  &
   expr_active = (._modello_rear_susp.cnl_top_mount.method == "joint" && ._modello_rear_susp.cnl_top_mount.joint_type == "spherical" && DB_ACTIVE(._modello_rear_susp))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_swing_arm_to_body  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_swing_arm_to_body  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnl_swing_arm_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.cnr_swing_arm_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpl_top_mount))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.bgl_top_mount, ._modello_rear_susp.ground.hpl_strut_lwr_mount, "Z"))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_top_mount))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.bgr_top_mount, ._modello_rear_susp.ground.hpr_strut_lwr_mount, "Z"))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_swing_arm_to_body  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpl_swing_arm_pivot))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.ground.hpl_swing_arm_pivot, ._modello_rear_susp.ground.hpr_swing_arm_pivot, "Z"))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_swing_arm_to_body  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_swing_arm_pivot))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.ground.hpr_swing_arm_pivot, ._modello_rear_susp.ground.hpl_swing_arm_pivot, "Z"))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_swing_arm_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpl_swing_arm_to_axle))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, -90.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_swing_arm_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_swing_arm_to_axle))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 90.0, 0.0}degrees, ._modello_rear_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.nsl_ride_spring  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.nsr_ride_spring  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.rel_rebound_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.rer_rebound_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgl_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpl_strut_lwr_mount))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.bgl_bottom_mount, ._modello_rear_susp.ground.hpr_strut_lwr_mount, "Z"))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bgr_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_rear_susp.ground.hpr_strut_lwr_mount))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_rear_susp.bgr_bottom_mount, ._modello_rear_susp.ground.hpl_strut_lwr_mount, "Z"))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bul_jounce_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.bur_jounce_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.dal_ride_damper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_rear_susp.dar_ride_damper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_rear_susp.ground))
!
variable modify  &
   variable_name = ._modello_rear_susp.cos_wheel_center  &
   real_value = (._modello_rear_susp.ground.hps_wheel_center.location)
!
variable modify  &
   variable_name = ._modello_rear_susp.cis_characteristics_input_ARRAY_adams_id  &
   integer_value = (._modello_rear_susp.cis_characteristics_input_ARRAY.object_value.adams_id)
!
variable modify  &
   variable_name = ._modello_rear_susp.cis_chassis_reference_adams_id  &
   integer_value = (._modello_rear_susp.cis_chassis_reference.object_value.adams_id)
!
variable modify  &
   variable_name = ._modello_rear_susp.cil_strut_to_body.minor_role  &
   string_value = (._modello_rear_susp.mtl_strut_to_body.minor_role)
!
variable modify  &
   variable_name = ._modello_rear_susp.cil_strut_to_body.subsystem_index  &
   string_value = (._modello_rear_susp.mtl_strut_to_body.subsystem_index)
!
variable modify  &
   variable_name = ._modello_rear_susp.cil_strut_to_body  &
   comments = ("Autocreated for mount part: " // ._modello_rear_susp.cil_strut_to_body[2].name)
!
variable modify  &
   variable_name = ._modello_rear_susp.cir_strut_to_body.minor_role  &
   string_value = (._modello_rear_susp.mtr_strut_to_body.minor_role)
!
variable modify  &
   variable_name = ._modello_rear_susp.cir_strut_to_body.subsystem_index  &
   string_value = (._modello_rear_susp.mtr_strut_to_body.subsystem_index)
!
variable modify  &
   variable_name = ._modello_rear_susp.cir_strut_to_body  &
   comments = ("Autocreated for mount part: " // ._modello_rear_susp.cir_strut_to_body[2].name)
!
variable modify  &
   variable_name = ._modello_rear_susp.cil_swing_arm_to_body.minor_role  &
   string_value = (._modello_rear_susp.mtl_swing_arm_to_body.minor_role)
!
variable modify  &
   variable_name = ._modello_rear_susp.cil_swing_arm_to_body.subsystem_index  &
   string_value = (._modello_rear_susp.mtl_swing_arm_to_body.subsystem_index)
!
variable modify  &
   variable_name = ._modello_rear_susp.cil_swing_arm_to_body  &
   comments = ("Autocreated for mount part: " // ._modello_rear_susp.cil_swing_arm_to_body[2].name)
!
variable modify  &
   variable_name = ._modello_rear_susp.cir_swing_arm_to_body.minor_role  &
   string_value = (._modello_rear_susp.mtr_swing_arm_to_body.minor_role)
!
variable modify  &
   variable_name = ._modello_rear_susp.cir_swing_arm_to_body.subsystem_index  &
   string_value = (._modello_rear_susp.mtr_swing_arm_to_body.subsystem_index)
!
variable modify  &
   variable_name = ._modello_rear_susp.cir_swing_arm_to_body  &
   comments = ("Autocreated for mount part: " // ._modello_rear_susp.cir_swing_arm_to_body[2].name)
!
model display  &
   model_name = _modello_rear_susp
