$---------------------------------------------------------------------MDI_HEADER
[MDI_HEADER]
 FILE_TYPE     =  'tpl'
 FILE_VERSION  =  2022.1
 FILE_FORMAT   =  'ASCII'
 HEADER_SIZE   =  9
(COMMENTS)
{comment_string}
'macpherson strut'
$----------------------------------------------------------------TEMPLATE_HEADER
[TEMPLATE_HEADER]
 TEMPLATE_NAME  =  '_modello_front_susp'
 MAJOR_ROLE     =  'suspension'
 TIMESTAMP      =  '2022/06/25,11:09:48'
 HEADER_SIZE    =  6
$------------------------------------------------------------------------PLUGINS
[PLUGINS]
 PLUGIN_LIST  =  'acar'
 HEADER_SIZE  =  4
!
!-------------------------- Default Units for Model ---------------------------!
!
!
defaults units  &
   length = mm  &
   angle = deg  &
   force = newton  &
   mass = kg  &
   time = sec
!
defaults units  &
   coordinate_system_type = cartesian  &
   orientation_type = body313
!
!------------------------ Default Attributes for Model ------------------------!
!
!
defaults attributes  &
   inheritance = bottom_up  &
   icon_visibility = off  &
   grid_visibility = off  &
   size_of_icons = 50.0  &
   spacing_for_grid = 1000.0
!
!------------------------------ Adams View Model ------------------------------!
!
!
model create  &
   model_name = _modello_front_susp  &
   comments = "macpherson strut"  &
   title = "Adams/Car template"
!
view erase
!
!-------------------------------- Data storage --------------------------------!
!
!
data_element create variable  &
   variable_name = ._modello_front_susp._cv_solver_variable  &
   comments = "Dummy for communicators"  &
   function = ""
!
data_element attributes  &
   data_element_name = ._modello_front_susp._cv_solver_variable  &
   visibility = off
!
data_element create array ic_array  &
   array_name = ._modello_front_susp.suspension_parameters_ARRAY  &
   comments = "STEER AXIS CALCULATION METHOD=: geometric"  &
   size = 6  &
   numbers = 1.0, 0.0, 0.0, 0.0, 0.0, 0.0
!
data_element create array ic_array  &
   array_name = ._modello_front_susp._cv_array  &
   comments = "Dummy for communicators"  &
   size = 1  &
   numbers = 0.0
!
data_element attributes  &
   data_element_name = ._modello_front_susp._cv_array  &
   visibility = off
!
data_element create spline  &
   spline_name = ._modello_front_susp._cv_spline  &
   comments = "Dummy for communicators"  &
   x = 1.0, 2.0, 3.0, 4.0  &
   y = 1.0, 2.0, 3.0, 4.0, 1.0, 2.0, 3.0, 4.0  &
   z = 1.0, 2.0  &
   linear_extrapolate = no
!
data_element attributes  &
   data_element_name = ._modello_front_susp._cv_spline  &
   visibility = off
!
data_element create string  &
   string_name = ._modello_front_susp.minor_role_string  &
   string = "unassigned"
!
data_element attributes  &
   data_element_name = ._modello_front_susp.minor_role_string  &
   visibility = off
!
!--------------------------------- Materials ----------------------------------!
!
!
material create  &
   material_name = ._modello_front_susp.steel  &
   density = 7.801E-06  &
   youngs_modulus = 2.07E+05  &
   poissons_ratio = 0.29
!
!-------------------------------- Rigid Parts ---------------------------------!
!
! Create parts and their dependent markers and graphics
!
!----------------------------------- ground -----------------------------------!
!
!
! ****** Ground Part ******
!
part modify rigid_body name_and_position  &
   part_name = ground
!
defaults model  &
   part_name = ground
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_lwr_strut_mount_loc  &
   location = 192.33, 114.8, -122.5  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_lwr_strut_mount_loc  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_upr_strut_mount_loc  &
   location = 250.7, 120.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_upr_strut_mount_loc  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_spring_lwr_seat_loc  &
   location = 210.0, 120.06, -75.1  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_spring_lwr_seat_loc  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_spring_upr_seat_loc  &
   location = 248.6, 120.04, 88.74  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_spring_upr_seat_loc  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfl_spring_lwr_seat  &
   location = 210.0, -120.06, -75.1  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfl_spring_lwr_seat  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfr_spring_lwr_seat  &
   location = 210.0, 120.06, -75.1  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfr_spring_lwr_seat  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfl_spring_upr_seat  &
   location = 248.6, -120.04, 88.74  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfl_spring_upr_seat  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfr_spring_upr_seat  &
   location = 248.6, 120.04, 88.74  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfr_spring_upr_seat  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfl_top_mount  &
   location = 250.7, -120.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfl_top_mount  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfr_top_mount  &
   location = 250.7, 120.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfr_top_mount  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfl_top_mount_jprim_ref1  &
   location = 250.7, -170.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfl_top_mount_jprim_ref1  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfr_top_mount_jprim_ref1  &
   location = 250.7, 170.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfr_top_mount_jprim_ref1  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_top_mount_jprim_ref  &
   location = 250.7, 170.0, 117.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_top_mount_jprim_ref  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_str_fork_upper_bearing  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_str_fork_upper_bearing  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfl_dummy_susp_par_upper_bearing  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfl_dummy_susp_par_upper_bearing  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfr_dummy_susp_par_upper_bearing  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfr_dummy_susp_par_upper_bearing  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_str_fork_lower_bearing  &
   location = 231.9, 0.0, -139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_str_fork_lower_bearing  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.mts_mount_j_1  &
   location = 231.9, 0.0, -139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.mts_mount_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ground.origo  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_wheel_center  &
   location = 110.0, 0.0, -74.5  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_wheel_center  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfl_top_mount_ext  &
   location = 250.7, -120.0, 167.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfl_top_mount_ext  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfr_top_mount_ext  &
   location = 250.7, 120.0, 167.6  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfr_top_mount_ext  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground._cv_marker  &
   comments = "Dummy for communicators"  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground._cv_marker  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfl_dummy_susp_par_lower_bearing  &
   location = 231.9, 0.0, -139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfl_dummy_susp_par_lower_bearing  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfr_dummy_susp_par_lower_bearing  &
   location = 231.9, 0.0, -139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfr_dummy_susp_par_lower_bearing  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfl_lwr_strut_mount  &
   location = 192.33, -114.8, -122.5  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfl_lwr_strut_mount  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfr_lwr_strut_mount  &
   location = 192.33, 114.8, -122.5  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfr_lwr_strut_mount  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_wheel_center_marker_ori  &
   location = 110.0, 0.0, -74.5  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_wheel_center_marker_ori  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_spindle_rise  &
   location = 110.0, 0.0, -74.5  &
   orientation = 180.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_spindle_rise  &
   color = MAIZE
!
marker create  &
   marker_name = ._modello_front_susp.ground.cfs_ride_height_ref  &
   location = 231.9, 120.1, -139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ground.cfs_ride_height_ref  &
   color = MAIZE
!
! ****** Points for current part ******
!
point create  &
   point_name = ._modello_front_susp.ground.hps_strut_lwr_mount  &
   location = 192.33, 114.8, -122.5
!
point create  &
   point_name = ._modello_front_susp.ground.hps_top_mount  &
   location = 250.7, 120.0, 117.6
!
point create  &
   point_name = ._modello_front_susp.ground.hps_spring_lwr_seat  &
   comments = "(none)"  &
   location = 210.0, 120.06, -75.1
!
point create  &
   point_name = ._modello_front_susp.ground.hps_spring_upr_seat  &
   location = 248.6, 120.04, 88.74
!
point create  &
   point_name = ._modello_front_susp.ground.hpl_susp_link_to_fork  &
   location = 231.9, -120.1, -139.4
!
point create  &
   point_name = ._modello_front_susp.ground.hpr_susp_link_to_fork  &
   location = 231.9, 120.1, -139.4
!
point create  &
   point_name = ._modello_front_susp.ground.hpl_susp_link_to_axle  &
   location = 110.0, -143.8, -74.5
!
point create  &
   point_name = ._modello_front_susp.ground.hpr_susp_link_to_axle  &
   location = 110.0, 143.8, -74.5
!
point create  &
   point_name = ._modello_front_susp.ground.hps_wheel_center  &
   location = 110.0, 0.0, -74.5
!
point create  &
   point_name = ._modello_front_susp.ground.hpl_strut_lwr_mount  &
   location = 192.33, -114.8, -122.5
!
point create  &
   point_name = ._modello_front_susp.ground.hpr_strut_lwr_mount  &
   location = 192.33, 114.8, -122.5
!
point create  &
   point_name = ._modello_front_susp.ground.hpl_top_mount  &
   location = 250.7, -120.0, 117.6
!
point create  &
   point_name = ._modello_front_susp.ground.hpr_top_mount  &
   location = 250.7, 120.0, 117.6
!
point create  &
   point_name = ._modello_front_susp.ground.hpl_spring_lwr_seat  &
   location = 210.0, -120.06, -75.1
!
point create  &
   point_name = ._modello_front_susp.ground.hpr_spring_lwr_seat  &
   location = 210.0, 120.06, -75.1
!
point create  &
   point_name = ._modello_front_susp.ground.hpr_spring_upr_seat  &
   location = 248.6, 120.04, 88.74
!
point create  &
   point_name = ._modello_front_susp.ground.hpl_spring_upr_seat  &
   location = 248.6, -120.04, 88.74
!
point create  &
   point_name = ._modello_front_susp.ground.hps_susp_link_to_axle  &
   location = 110.0, 143.8, -74.5
!
point create  &
   point_name = ._modello_front_susp.ground.hps_susp_link_to_fork  &
   location = 231.9, 120.1, -139.4
!
point create  &
   point_name = ._modello_front_susp.ground.hpl_bumper_upper  &
   location = 250.7, -120.0, 117.6
!
point create  &
   point_name = ._modello_front_susp.ground.hpr_bumper_upper  &
   location = 250.7, 120.0, 117.6
!
point create  &
   point_name = ._modello_front_susp.ground.hpl_bumper_lower  &
   location = 231.4379, -118.284, 25.0
!
point create  &
   point_name = ._modello_front_susp.ground.hpr_bumper_lower  &
   location = 231.4379, 118.284, 25.0
!
point create  &
   point_name = ._modello_front_susp.ground.hps_bumper_upper  &
   location = 250.7, 120.0, 117.6
!
point create  &
   point_name = ._modello_front_susp.ground.hps_bumper_lower  &
   location = 230.8542, 118.232, 25.0
!
! ****** Graphics for current part ******
!
geometry create shape ellipsoid  &
   ellipsoid_name = ._modello_front_susp.ground._cv_csolid  &
   center_marker = ._modello_front_susp.ground._cv_marker  &
   x_scale_factor = 100.0  &
   y_scale_factor = 100.0  &
   z_scale_factor = 100.0
!
geometry attributes  &
   geometry_name = ._modello_front_susp.ground._cv_csolid  &
   active = off
!
part attributes  &
   part_name = ._modello_front_susp.ground  &
   visibility = on
!
!------------------------------ ges_lower_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_lower_strut  &
   location = 211.5921, 116.516, -43.267  &
   orientation = 95.0908616344d, 13.7160133719d, 265.0535842783d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ges_lower_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.coomarker_13  &
   location = 5.9727616524, 4.2019400502, -31.226662093  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_lower_strut.coomarker_13  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.coomarker_16  &
   location = 5.9727616524, 4.2019400502, -31.226662093  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_lower_strut.coomarker_16  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.res_reboundstop_j_1  &
   location = 0.0, 0.0, 165.5891233971  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_lower_strut.res_reboundstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_lower_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.das_damper_j_1  &
   location = 0.0, 0.0, -81.5588219717  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_lower_strut.das_damper_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.das_ride_damper_axial_ref_i  &
   location = 0.0, 0.0, 165.5891233971  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.jxs_joint_j_1  &
   location = 0.0, 0.0, 42.0151507127  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_lower_strut.jxs_joint_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.bxs_bushing_i_4  &
   location = 0.0, 0.0, -81.5588219717  &
   orientation = 0.0d, 91.2055938374d, 13.6639389027d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_lower_strut.bxs_bushing_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.bxs_bushgeom_i_4  &
   location = 0.0, 14.9966795112, -81.2432215329  &
   orientation = 0.0d, 91.2055938374d, 283.6639389027d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_lower_strut.bxs_bushgeom_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_lower_strut.nss_spring_j_1  &
   location = 5.9727616524, 4.2019400502, -31.226662093  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_lower_strut.nss_spring_j_1  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.ges_lower_strut  &
   mass = 1.0  &
   center_of_mass_marker = ._modello_front_susp.ges_lower_strut.cm  &
   inertia_marker = ._modello_front_susp.ges_lower_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
!------------------------------ ges_upper_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_upper_strut  &
   location = 230.8542, 118.232, 35.966  &
   orientation = 95.0908616344d, 13.7160133719d, 265.0535842783d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ges_upper_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.coomarker_14  &
   location = 4.7769344995, 0.6404584291, 55.4981807578  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.coomarker_14  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.coomarker_15  &
   location = 0.0, 0.0, 84.0303014254  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.coomarker_15  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.bus_bumpstop_j_1  &
   location = 2.5904611245, 0.2241949806, -10.6532813618  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.bus_bumpstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.res_reboundstop_i_1  &
   location = 0.0, 0.0, -163.1176439434  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.res_reboundstop_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.das_damper_i_1  &
   location = 0.0, 0.0, 84.0303014254  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.das_damper_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.das_ride_damper_axial_ref_j  &
   location = 0.0, 0.0, 84.0303014254  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.jxs_joint_i_1  &
   location = 0.0, 0.0, -39.543671259  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.jxs_joint_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.bxs_bushing_i_3  &
   location = 0.0, 0.0, 84.0303014254  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.bxs_bushing_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.bxs_bushgeom_i_3  &
   location = 0.0, 0.0, 99.0303014254  &
   orientation = 270.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.bxs_bushgeom_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.jxs_joint_i_3  &
   location = 0.0, 0.0, 84.0303014254  &
   orientation = 180.0d, 88.7944061626d, 270.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.jxs_joint_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_upper_strut.nss_spring_i_1  &
   location = 4.7769344995, 0.6404584291, 55.4981807578  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_upper_strut.nss_spring_i_1  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.ges_upper_strut  &
   mass = 1.0  &
   center_of_mass_marker = ._modello_front_susp.ges_upper_strut.cm  &
   inertia_marker = ._modello_front_susp.ges_upper_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
!------------------------------- ges_link_susp --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_link_susp  &
   location = 170.95, 131.95, -106.95  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ges_link_susp
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushing_j_4  &
   location = 21.38, -17.15, -15.55  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushing_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushgeom_j_4  &
   location = 21.38, -2.15, -15.55  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushgeom_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_link_susp.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.gralin_1  &
   location = -60.95, 11.85, 32.45  &
   orientation = 78.9977172072d, 117.5923697412d, 264.8542892944d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_link_susp.gralin_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushing_i_1  &
   location = -60.95, 11.85, 32.45  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushing_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushgeom_i_1  &
   location = -60.95, 51.85, 32.45  &
   orientation = 0.0d, 90.0d, 270.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushgeom_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushing_i_2  &
   location = 60.95, -11.85, -32.45  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushing_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushgeom_i_2  &
   location = 60.95, 28.15, -32.45  &
   orientation = 0.0d, 90.0d, 270.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushgeom_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_link_susp.coomarker_12  &
   location = 60.95, -11.85, -32.45  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_link_susp.coomarker_12  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.ges_link_susp  &
   mass = 0.25  &
   center_of_mass_marker = ._modello_front_susp.ges_link_susp.cm  &
   inertia_marker = ._modello_front_susp.ges_link_susp.inertia_frame  &
   ixx = 400.0  &
   iyy = 600.0  &
   izz = 400.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape cylinder  &
   cylinder_name = ._modello_front_susp.ges_link_susp.gralin_susp_link  &
   center_marker = ._modello_front_susp.ges_link_susp.gralin_1  &
   angle_extent = 360.0  &
   length = 140.118913784  &
   radius = 15.0  &
   side_count_for_body = 15  &
   segment_count_for_ends = 15
!
geometry attributes  &
   geometry_name = ._modello_front_susp.ges_link_susp.gralin_susp_link  &
   color = MAGENTA
!
!-------------------------------- mts_str_fork --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.mts_str_fork  &
   location = 231.9, 0.0, -139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.mts_str_fork
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bus_bumpstop_i_1  &
   location = 18.8, 120.0, 257.0  &
   orientation = 95.0908616344d, 13.7160133719d, 265.0535842783d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bus_bumpstop_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushing_j_4  &
   location = 18.8, -120.0, 257.0  &
   orientation = 264.9091383656d, 166.2839866281d, 85.0535842783d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushing_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushgeom_j_4  &
   location = 22.3426149252, -120.3156004388, 271.5722433364  &
   orientation = 264.9091383656d, 166.2839866281d, 85.0535842783d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushgeom_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushing_j_4  &
   location = 18.8, 120.0, 257.0  &
   orientation = 275.0908616344d, 166.2839866281d, 94.9464157217d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushing_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushgeom_j_4  &
   location = 22.3426149252, 120.3156004388, 271.5722433364  &
   orientation = 275.0908616344d, 166.2839866281d, 94.9464157217d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushgeom_j_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.jxl_joint_j_1  &
   location = 18.8, -120.0, 257.0  &
   orientation = 264.9091383656d, 166.2839866281d, 355.0535842783d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.jxl_joint_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.jxr_joint_j_1  &
   location = 18.8, 120.0, 257.0  &
   orientation = 275.0908616344d, 166.2839866281d, 184.9464157217d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.jxr_joint_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushing_j_3  &
   location = 18.8, 120.0, 257.0  &
   orientation = 275.0908616344d, 166.2839866281d, 94.9464157217d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushing_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushgeom_j_3  &
   location = 22.3426149252, 120.3156004388, 271.5722433364  &
   orientation = 275.0908616344d, 166.2839866281d, 94.9464157217d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushgeom_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.jxs_joint_j_3  &
   location = 18.8, 120.0, 257.0  &
   orientation = 275.0908616344d, 166.2839866281d, 184.9464157217d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.jxs_joint_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushing_j_2  &
   location = 0.0, 120.1, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushing_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushgeom_j_2  &
   location = 0.0, 160.1, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushgeom_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.kp2_1  &
   location = -231.9, 0.0, 139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.kp2_2  &
   location = -231.9, 0.0, 139.4  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushing_j_2  &
   location = 0.0, -120.1, 0.0  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushing_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushgeom_j_2  &
   location = 0.0, -135.1, 0.0  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushgeom_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushing_j_2  &
   location = 0.0, 120.1, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushing_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushgeom_j_2  &
   location = 0.0, 135.1, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushgeom_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.mount_i  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.mount_i  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bur_bumpstop_i_1  &
   location = 18.8, 120.0, 257.0  &
   orientation = 149.5220583251d, 16.4314449517d, 212.7929962908d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bur_bumpstop_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.mts_str_fork.bul_bumpstop_i_1  &
   location = 18.8, -120.0, 257.0  &
   orientation = 30.4779416749d, 16.4314449517d, 327.2070037092d
!
marker attributes  &
   marker_name = ._modello_front_susp.mts_str_fork.bul_bumpstop_i_1  &
   visibility = off  &
   name_visibility = off
!
!-------------------------------- ges_spindle ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_spindle  &
   location = 110.0, 0.0, -74.5  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ges_spindle
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.ges_spindle.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_spindle.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_spindle.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_spindle.jxs_joint_i_2  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_spindle.jxs_joint_i_2  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.ges_spindle  &
   mass = 0.1  &
   center_of_mass_marker = ._modello_front_susp.ges_spindle.cm  &
   inertia_marker = ._modello_front_susp.ges_spindle.inertia_frame  &
   ixx = 100.0  &
   iyy = 100.0  &
   izz = 100.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
!---------------------------------- ges_axle ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_axle  &
   location = 110.0, 0.0, -74.5  &
   orientation = 180.0d, 90.0d, 180.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ges_axle
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.mas_kingpin_axis  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.mas_wheel_center  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.gralin_2  &
   location = 0.0, 0.0, 143.8  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.gralin_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.bxs_bushing_j_1  &
   location = 0.0, 0.0, 143.8  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.bxs_bushing_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.bxs_bushgeom_j_1  &
   location = 0.0, 0.0, 183.8  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.bxs_bushgeom_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.kp1_1  &
   location = 121.9, 64.9, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.kp1_2  &
   location = 121.9, 64.9, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.bxl_bushing_j_3  &
   location = 0.0, 0.0, -143.8  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.bxl_bushing_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.bxl_bushgeom_j_3  &
   location = 0.0, 0.0, -158.8  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.bxl_bushgeom_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.bxr_bushing_j_3  &
   location = 0.0, 0.0, 143.8  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.bxr_bushing_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.bxr_bushgeom_j_3  &
   location = 0.0, 0.0, 158.8  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.bxr_bushgeom_j_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.jxs_joint_j_2  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.jxs_joint_j_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.gralin_5  &
   location = 0.0, 0.0, -143.8  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.gralin_5  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.coomarker_9  &
   location = 0.0, 0.0, 0.0  &
   orientation = 180.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.coomarker_9  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.coomarker_10  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.coomarker_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ges_axle.coomarker_11  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ges_axle.coomarker_11  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.ges_axle  &
   mass = 1.2293604665  &
   center_of_mass_marker = ._modello_front_susp.ges_axle.cm  &
   inertia_marker = ._modello_front_susp.ges_axle.inertia_frame  &
   ixx = 5467.755625944  &
   iyy = 5467.755625944  &
   izz = 134.3174101136  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape cylinder  &
   cylinder_name = ._modello_front_susp.ges_axle.gralin_axle  &
   center_marker = ._modello_front_susp.ges_axle.gralin_5  &
   angle_extent = 360.0  &
   length = 287.6  &
   radius = 15.0  &
   side_count_for_body = 15  &
   segment_count_for_ends = 15
!
geometry attributes  &
   geometry_name = ._modello_front_susp.ges_axle.gralin_axle  &
   color = RED
!
geometry create shape cylinder  &
   cylinder_name = ._modello_front_susp.ges_axle.gralin_axle_1  &
   center_marker = ._modello_front_susp.ges_axle.gralin_2  &
   angle_extent = 360.0  &
   length = 143.8  &
   radius = 15.0  &
   side_count_for_body = 15  &
   segment_count_for_ends = 15
!
geometry attributes  &
   geometry_name = ._modello_front_susp.ges_axle.gralin_axle_1  &
   color = RED
!
!------------------------------- gel_susp_link --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.gel_susp_link  &
   location = 170.95, -131.95, -106.95  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.gel_susp_link
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushing_i_2  &
   location = 60.95, 11.85, -32.45  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushing_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushgeom_i_2  &
   location = 60.95, -3.15, -32.45  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushgeom_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushing_i_3  &
   location = -60.95, -11.85, 32.45  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushing_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushgeom_i_3  &
   location = -60.95, -26.85, 32.45  &
   orientation = 180.0d, 90.0d, 90.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushgeom_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.gralin_3  &
   location = -60.95, -11.85, 32.45  &
   orientation = 101.0022827928d, 117.5923697412d, 275.1457107056d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_susp_link.gralin_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.cm  &
   location = 8.8120104439, 5.8746736292, -8.8120104439  &
   orientation = 90.0d, 45.0d, 297.664451104d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_susp_link.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.inertia_frame  &
   location = 8.8120104439, 5.8746736292, -8.8120104439  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushing_j_1  &
   location = 21.38, 17.15, -15.55  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushing_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushgeom_j_1  &
   location = 21.38, 2.15, -15.55  &
   orientation = 180.0d, 90.0d, 180.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushgeom_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_susp_link.coomarker_3  &
   location = 21.38, 17.15, -15.55  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_susp_link.coomarker_3  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.gel_susp_link  &
   mass = 0.2346599281  &
   center_of_mass_marker = ._modello_front_susp.gel_susp_link.cm  &
   inertia_marker = ._modello_front_susp.gel_susp_link.inertia_frame  &
   ixx = 405.2945280663  &
   iyy = 602.0236784394  &
   izz = 405.2945280663  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape cylinder  &
   cylinder_name = ._modello_front_susp.gel_susp_link.gralin_susp_link  &
   center_marker = ._modello_front_susp.gel_susp_link.gralin_3  &
   angle_extent = 360.0  &
   length = 140.118913784  &
   radius = 15.0  &
   side_count_for_body = 15  &
   segment_count_for_ends = 15
!
geometry attributes  &
   geometry_name = ._modello_front_susp.gel_susp_link.gralin_susp_link  &
   color = MAGENTA
!
part attributes  &
   part_name = ._modello_front_susp.gel_susp_link  &
   color = BLUE_GRAY  &
   entity_scope = edge_color
!
part attributes  &
   part_name = ._modello_front_susp.gel_susp_link  &
   visibility = on
!
!------------------------------- ger_susp_link --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.ger_susp_link  &
   location = 170.95, 131.95, -106.95  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ger_susp_link
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushing_i_2  &
   location = 60.95, -11.85, -32.45  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushing_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushgeom_i_2  &
   location = 60.95, 3.15, -32.45  &
   orientation = 0.0d, 90.0d, 270.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushgeom_i_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushing_i_3  &
   location = -60.95, 11.85, 32.45  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushing_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushgeom_i_3  &
   location = -60.95, 26.85, 32.45  &
   orientation = 0.0d, 90.0d, 270.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushgeom_i_3  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.gralin_4  &
   location = -60.95, 11.85, 32.45  &
   orientation = 78.9977172072d, 117.5923697412d, 264.8542892944d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.gralin_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.cm  &
   location = 8.8120104439, -5.8746736292, -8.8120104439  &
   orientation = 90.0d, 45.0d, 242.335548896d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.inertia_frame  &
   location = 8.8120104439, -5.8746736292, -8.8120104439  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushing_j_1  &
   location = 21.38, -17.15, -15.55  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushing_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushgeom_j_1  &
   location = 21.38, -2.15, -15.55  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushgeom_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.coomarker_4  &
   location = 21.38, -17.15, -15.55  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.coomarker_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_susp_link.coomarker_12  &
   location = 60.95, -11.85, -32.45  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_susp_link.coomarker_12  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.ger_susp_link  &
   mass = 0.2346599281  &
   center_of_mass_marker = ._modello_front_susp.ger_susp_link.cm  &
   inertia_marker = ._modello_front_susp.ger_susp_link.inertia_frame  &
   ixx = 405.2945280663  &
   iyy = 602.0236784394  &
   izz = 405.2945280663  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape cylinder  &
   cylinder_name = ._modello_front_susp.ger_susp_link.gralin_susp_link  &
   center_marker = ._modello_front_susp.ger_susp_link.gralin_4  &
   angle_extent = 360.0  &
   length = 140.118913784  &
   radius = 15.0  &
   side_count_for_body = 15  &
   segment_count_for_ends = 15
!
geometry attributes  &
   geometry_name = ._modello_front_susp.ger_susp_link.gralin_susp_link  &
   color = MAGENTA
!
part attributes  &
   part_name = ._modello_front_susp.ger_susp_link  &
   color = BLUE
!
part attributes  &
   part_name = ._modello_front_susp.ger_susp_link  &
   color = BLUE  &
   entity_scope = edge_color
!
part attributes  &
   part_name = ._modello_front_susp.ger_susp_link  &
   visibility = on
!
!------------------------------ gel_upper_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.gel_upper_strut  &
   location = 231.4379, -118.284, 38.367  &
   orientation = 84.9091383656d, 13.7160133719d, 274.9464157217d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.gel_upper_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.coomarker_1  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 265.0535842783d, 13.7160133719d, 95.0908616344d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.coomarker_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.rel_reboundstop_i_1  &
   location = 0.0, 0.0, -165.5891233971  &
   orientation = 265.0535842783d, 13.7160133719d, 95.0908616344d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.rel_reboundstop_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.bxl_bushing_i_4  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.bxl_bushing_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.bxl_bushgeom_i_4  &
   location = 0.0, 0.0, 96.5588219717  &
   orientation = 270.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.bxl_bushgeom_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.jxl_joint_i_1  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 0.0d, 88.7944061626d, 270.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.jxl_joint_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 339.2539197243d, 166.1247448874d, 158.6856096288d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.jxl_joint_j_10  &
   location = 0.0, 0.0, -42.0151507127  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.jxl_joint_j_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.jklhoo_top_mount_kinematic_1  &
   location = -11.8113310435, 1.0222277066, 130.1329664263  &
   orientation = 265.0535842783d, 13.7160133719d, 95.0908616344d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.jklhoo_top_mount_kinematic_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.dal_damper_i_1  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.dal_damper_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.nsl_spring_i_1  &
   location = 4.7769344995, -0.6404584291, 53.0267013041  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.nsl_spring_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.bul_bumpstop_j_1  &
   location = 3.1576412412, -0.2732823551, -12.9858117785  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.bul_bumpstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.dal_ride_damper_axial_ref_i  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.gel_upper_strut.coomarker_5  &
   location = 4.7769344995, -0.6404584291, 53.0267013041  &
   orientation = 265.0535842783d, 13.7160133719d, 95.0908616344d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_upper_strut.coomarker_5  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.gel_upper_strut  &
   mass = 5.0  &
   center_of_mass_marker = ._modello_front_susp.gel_upper_strut.cm  &
   inertia_marker = ._modello_front_susp.gel_upper_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_front_susp.gel_upper_strut  &
   visibility = on
!
!------------------------------ ger_upper_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.ger_upper_strut  &
   location = 231.4379, 118.284, 38.367  &
   orientation = 95.0908616344d, 13.7160133719d, 265.0535842783d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ger_upper_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.coomarker_2  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.coomarker_2  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.rer_reboundstop_i_1  &
   location = 0.0, 0.0, -165.5891233971  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.rer_reboundstop_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.bxr_bushing_i_4  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.bxr_bushing_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.bxr_bushgeom_i_4  &
   location = 0.0, 0.0, 96.5588219717  &
   orientation = 270.0d, 180.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.bxr_bushgeom_i_4  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.jxr_joint_i_1  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 180.0d, 88.7944061626d, 270.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.jxr_joint_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 200.7460802757d, 166.1247448874d, 21.3143903712d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.jxr_joint_j_10  &
   location = 0.0, 0.0, -42.0151507127  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.jxr_joint_j_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.jkrhoo_top_mount_kinematic_1  &
   location = -11.8113310435, -1.0222277066, 130.1329664263  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.jkrhoo_top_mount_kinematic_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.dar_damper_i_1  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.dar_damper_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.nsr_spring_i_1  &
   location = 4.7769344995, 0.6404584291, 53.0267013041  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.nsr_spring_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.bur_bumpstop_j_1  &
   location = 3.1576412412, 0.2732823551, -12.9858117785  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.bur_bumpstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.dar_ride_damper_axial_ref_i  &
   location = 0.0, 0.0, 81.5588219717  &
   orientation = 180.0d, 180.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ger_upper_strut.coomarker_6  &
   location = 4.7769344995, 0.6404584291, 53.0267013041  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_upper_strut.coomarker_6  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.ger_upper_strut  &
   mass = 5.0  &
   center_of_mass_marker = ._modello_front_susp.ger_upper_strut.cm  &
   inertia_marker = ._modello_front_susp.ger_upper_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_front_susp.ger_upper_strut  &
   visibility = on
!
!---------------------------------- _cv_part ----------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp._cv_part  &
   comments = "Dummy for communicators"  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp._cv_part
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp._cv_part.marker  &
   comments = "Dummy for communicators"  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp._cv_part.marker  &
   visibility = off  &
   name_visibility = off
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp._cv_part  &
   mass = 0.0  &
   center_of_mass_marker = ._modello_front_susp._cv_part.marker  &
   ixx = 0.0  &
   iyy = 0.0  &
   izz = 0.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_front_susp._cv_part  &
   visibility = on  &
   name_visibility = off
!
!------------------------------ ger_lower_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.ger_lower_strut  &
   location = 212.1758, 116.568, -40.866  &
   orientation = 95.0908616344d, 13.7160133719d, 265.0535842783d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ger_lower_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.coomarker_8  &
   location = 5.9727616524, 4.2019400502, -33.6981415466  &
   orientation = 274.9464157217d, 13.7160133719d, 84.9091383656d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_lower_strut.coomarker_8  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.rer_reboundstop_j_1  &
   location = 0.0, 0.0, 163.1176439434  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_lower_strut.rer_reboundstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_lower_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.dar_damper_j_1  &
   location = 0.0, 0.0, -84.0303014254  &
   orientation = 201.3143903712d, 13.8752551126d, 159.2539197243d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_lower_strut.dar_damper_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.nsr_spring_j_1  &
   location = 5.9727616524, 4.2019400502, -33.6981415466  &
   orientation = 201.3143903712d, 13.8752551126d, 159.2539197243d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_lower_strut.nsr_spring_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.jxr_joint_i_10  &
   location = 0.0, 0.0, 39.543671259  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_lower_strut.jxr_joint_i_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.bxr_bushing_i_1  &
   location = 0.0, 0.0, -84.0303014254  &
   orientation = 0.0d, 91.2055938374d, 13.6639389027d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_lower_strut.bxr_bushing_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.bxr_bushgeom_i_1  &
   location = 0.0, 14.9966795112, -83.7147009866  &
   orientation = 0.0d, 91.2055938374d, 283.6639389027d
!
marker attributes  &
   marker_name = ._modello_front_susp.ger_lower_strut.bxr_bushgeom_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.ger_lower_strut.dar_ride_damper_axial_ref_j  &
   location = 0.0, 0.0, 163.1176439434  &
   orientation = 0.0d, 0.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.ger_lower_strut  &
   mass = 1.0  &
   center_of_mass_marker = ._modello_front_susp.ger_lower_strut.cm  &
   inertia_marker = ._modello_front_susp.ger_lower_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_front_susp.ger_lower_strut  &
   visibility = on  &
   name_visibility = on
!
!------------------------------ gel_lower_strut -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part create rigid_body name_and_position  &
   part_name = ._modello_front_susp.gel_lower_strut  &
   location = 212.1758, -116.568, -40.866  &
   orientation = 84.9091383656d, 13.7160133719d, 274.9464157217d
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.gel_lower_strut
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.coomarker_7  &
   location = 5.9727616524, -4.2019400502, -33.6981415466  &
   orientation = 265.0535842783d, 13.7160133719d, 95.0908616344d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_lower_strut.coomarker_7  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.rel_reboundstop_j_1  &
   location = 0.0, 0.0, 163.1176439434  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_lower_strut.rel_reboundstop_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.cm  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_lower_strut.cm  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.inertia_frame  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.dal_damper_j_1  &
   location = 0.0, 0.0, -84.0303014254  &
   orientation = 338.6856096288d, 13.8752551126d, 20.7460802757d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_lower_strut.dal_damper_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.nsl_spring_j_1  &
   location = 5.9727616524, -4.2019400502, -33.6981415466  &
   orientation = 338.6856096288d, 13.8752551126d, 20.7460802757d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_lower_strut.nsl_spring_j_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.jxl_joint_i_10  &
   location = 0.0, 0.0, 39.543671259  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_lower_strut.jxl_joint_i_10  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.bxl_bushing_i_1  &
   location = 0.0, 0.0, -84.0303014254  &
   orientation = 180.0d, 91.2055938374d, 166.3360610973d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_lower_strut.bxl_bushing_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.bxl_bushgeom_i_1  &
   location = 0.0, -14.9966795112, -83.7147009866  &
   orientation = 180.0d, 91.2055938374d, 76.3360610973d
!
marker attributes  &
   marker_name = ._modello_front_susp.gel_lower_strut.bxl_bushgeom_i_1  &
   visibility = off  &
   name_visibility = off
!
marker create  &
   marker_name = ._modello_front_susp.gel_lower_strut.dal_ride_damper_axial_ref_j  &
   location = 0.0, 0.0, 163.1176439434  &
   orientation = 0.0d, 0.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = ._modello_front_susp.gel_lower_strut  &
   mass = 1.0  &
   center_of_mass_marker = ._modello_front_susp.gel_lower_strut.cm  &
   inertia_marker = ._modello_front_susp.gel_lower_strut.inertia_frame  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
part attributes  &
   part_name = ._modello_front_susp.gel_lower_strut  &
   visibility = on  &
   name_visibility = on
!
!--------------------------------- Equations ----------------------------------!
!
!
part create equation differential_equation  &
   differential_equation_name = ._modello_front_susp._cv_diff  &
   comments = "Dummy for communicators"  &
   initial_condition = 0.0  &
   function = ""  &
   implicit = off  &
   static_hold = off
!
part attributes  &
   equation_name = ._modello_front_susp._cv_diff  &
   visibility = off
!
!----------------------------------- Joints -----------------------------------!
!
!
constraint create joint cylindrical  &
   joint_name = ._modello_front_susp.joscyl_strut  &
   i_marker_name = ._modello_front_susp.ges_upper_strut.jxs_joint_i_1  &
   j_marker_name = ._modello_front_susp.ges_lower_strut.jxs_joint_j_1
!
constraint create joint fixed  &
   joint_name = ._modello_front_susp.mts_fixed_1  &
   i_marker_name = ._modello_front_susp.mts_str_fork.mount_i  &
   j_marker_name = ._modello_front_susp.ground.mts_mount_j_1
!
constraint attributes  &
   constraint_name = ._modello_front_susp.mts_fixed_1  &
   visibility = off  &
   name_visibility = off
!
constraint create joint revolute  &
   joint_name = ._modello_front_susp.josrev_spindle_axle  &
   i_marker_name = ._modello_front_susp.ges_spindle.jxs_joint_i_2  &
   j_marker_name = ._modello_front_susp.ges_axle.jxs_joint_j_2
!
constraint attributes  &
   constraint_name = ._modello_front_susp.josrev_spindle_axle  &
   size_of_icons = 30.0
!
constraint create joint cylindrical  &
   joint_name = ._modello_front_susp.jolcyl_strut  &
   i_marker_name = ._modello_front_susp.gel_lower_strut.jxl_joint_i_10  &
   j_marker_name = ._modello_front_susp.gel_upper_strut.jxl_joint_j_10
!
constraint create joint cylindrical  &
   joint_name = ._modello_front_susp.jorcyl_strut  &
   i_marker_name = ._modello_front_susp.ger_lower_strut.jxr_joint_i_10  &
   j_marker_name = ._modello_front_susp.ger_upper_strut.jxr_joint_j_10
!
constraint create joint cylindrical  &
   joint_name = ._modello_front_susp._cv_joint_for_motion  &
   comments = "Dummy for communicators"  &
   i_marker_name = ._modello_front_susp._cv_part.marker  &
   j_marker_name = ._modello_front_susp.ground._cv_marker
!
constraint attributes  &
   constraint_name = ._modello_front_susp._cv_joint_for_motion  &
   visibility = off  &
   name_visibility = off
!
!------------------------------ Joint Primitives ------------------------------!
!
!
constraint create primitive_joint perpendicular  &
   jprim_name = ._modello_front_susp.jolper_top_mount  &
   i_marker_name = ._modello_front_susp.gel_upper_strut.jxl_joint_i_1  &
   j_marker_name = ._modello_front_susp.mts_str_fork.jxl_joint_j_1
!
constraint create primitive_joint perpendicular  &
   jprim_name = ._modello_front_susp.jorper_top_mount  &
   i_marker_name = ._modello_front_susp.ger_upper_strut.jxr_joint_i_1  &
   j_marker_name = ._modello_front_susp.mts_str_fork.jxr_joint_j_1
!
constraint create primitive_joint perpendicular  &
   jprim_name = ._modello_front_susp.josper_top_mount  &
   i_marker_name = ._modello_front_susp.ges_upper_strut.jxs_joint_i_3  &
   j_marker_name = ._modello_front_susp.mts_str_fork.jxs_joint_j_3
!
constraint create primitive_joint inplane  &
   jprim_name = ._modello_front_susp._cv_joint  &
   comments = "Dummy for communicators"  &
   i_marker_name = ._modello_front_susp._cv_part.marker  &
   j_marker_name = ._modello_front_susp.ground._cv_marker
!
constraint attributes  &
   constraint_name = ._modello_front_susp._cv_joint  &
   visibility = off  &
   name_visibility = off
!
!----------------------------------- Forces -----------------------------------!
!
!
force create element_like field  &
   field_name = ._modello_front_susp._cv_bushing  &
   comments = "Dummy for communicators"  &
   i_marker_name = ._modello_front_susp._cv_part.marker  &
   j_marker_name = ._modello_front_susp.ground._cv_marker  &
   translation_at_preload = 0.0, 0.0, 0.0  &
   rotation_at_preload = 0.0d, 0.0d, 0.0d  &
   formulation = linear  &
   length_tolerance = 1.0E-05  &
   damping_ratio = 0.0  &
   stiffness_matrix =  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0,  &
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0  &
   force_preload = 0.0, 0.0, 0.0  &
   torque_preload = 0.0, 0.0, 0.0
!
force attributes  &
   force_name = ._modello_front_susp._cv_bushing  &
   visibility = off  &
   name_visibility = off
!
!---------------------------------- Requests ----------------------------------!
!
!
output_control create request  &
   request_name = ._modello_front_susp.toe_camber_caster  &
   comment = "Computes the toe and camber of a front or rear suspension"  &
   component_names = "", "toe_single", "caster_single", "camber_single", "",  &
                     "", "", ""  &
   component_units = "no_units", "no_units", "no_units", "no_units",  &
                     "no_units", "no_units", "no_units", "no_units"  &
   results_name = "suspension_kinematics"  &
   user_function = 1101.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0  &
   routine = "acar_solver::reqsub"
!
!------------------------- Groups Owned By This Model -------------------------!
!
!
group create  &
   group_name = ._modello_front_susp.top_mount_kinematic  &
   expr_active = 0
!
group create  &
   group_name = ._modello_front_susp.suspension_link_type_dual  &
   expr_active = 1
!
group create  &
   group_name = ._modello_front_susp.single_top_mount_kinematic  &
   expr_active = 0
!
group create  &
   group_name = ._modello_front_susp.kinematic_mode_active  &
   expr_active = 1
!
group create  &
   group_name = ._modello_front_susp.kinematic_mode_inactive  &
   expr_active = 1
!
group create  &
   group_name = ._modello_front_susp.driveline_active  &
   expr_active = 1
!
group create  &
   group_name = ._modello_front_susp.driveline_inactive  &
   expr_active = 1
!
group create  &
   group_name = ._modello_front_susp.suspension_link_type_single  &
   expr_active = 0
!
!-------------------------- Adams View UDE Instances --------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
undo begin_block suppress = yes
!
ude create instance  &
   instance_name = ._modello_front_susp.bus_jounce_bumper  &
   definition_name = .ACAR.forces.ac_bumpstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.bus_jounce_bumper  &
   color = MAGENTA
!
ude create instance  &
   instance_name = ._modello_front_susp.res_rebound_bumper  &
   definition_name = .ACAR.forces.ac_reboundstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.res_rebound_bumper  &
   color = CYAN
!
ude create instance  &
   instance_name = ._modello_front_susp.das_ride_damper  &
   definition_name = .ACAR.forces.ac_damper  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.das_ride_damper  &
   color = MAIZE
!
ude create instance  &
   instance_name = ._modello_front_susp.bgl_top_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 250.7, -120.0, 117.6  &
   orientation = 264.9091383656, 166.2839866281, 85.0535842783
!
ude create instance  &
   instance_name = ._modello_front_susp.bgr_top_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 250.7, 120.0, 117.6  &
   orientation = 275.0908616344, 166.2839866281, 94.9464157217
!
ude create instance  &
   instance_name = ._modello_front_susp.cnl_top_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.cnr_top_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.bgs_top_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 250.7, 120.0, 117.6  &
   orientation = 275.0908616344, 166.2839866281, 94.9464157217
!
ude attributes  &
   instance_name = ._modello_front_susp.bgs_top_mount  &
   active = off
!
ude create instance  &
   instance_name = ._modello_front_susp.bgs_bottom_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 192.33, 114.8, -122.5  &
   orientation = 0.0, 90.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.bgs_bottom_mount  &
   active = off
!
ude create instance  &
   instance_name = ._modello_front_susp.cns_top_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.cns_bottom_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.nss_ride_spring  &
   definition_name = .ACAR.forces.ac_spring  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.nss_ride_spring  &
   color = WHITE
!
ude create instance  &
   instance_name = ._modello_front_susp.bgl_fork_to_link  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 231.9, -120.1, -139.4  &
   orientation = 180.0, 90.0, 180.0
!
ude create instance  &
   instance_name = ._modello_front_susp.bgr_fork_to_link  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 231.9, 120.1, -139.4  &
   orientation = 0.0, 90.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.cnl_fork_to_link  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.cnr_fork_to_link  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.bgl_susp_link_to_axle  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 110.0, -143.8, -74.5  &
   orientation = 180.0, 90.0, 180.0
!
ude create instance  &
   instance_name = ._modello_front_susp.bgr_susp_link_to_axle  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 110.0, 143.8, -74.5  &
   orientation = 0.0, 90.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.cnl_susp_link_to_axle  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.cnr_susp_link_to_axle  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.cnl_bottom_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.cnr_bottom_mount  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.nsl_ride_spring  &
   definition_name = .ACAR.forces.ac_spring  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.nsl_ride_spring  &
   color = WHITE
!
ude create instance  &
   instance_name = ._modello_front_susp.nsr_ride_spring  &
   definition_name = .ACAR.forces.ac_spring  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.nsr_ride_spring  &
   color = WHITE
!
ude create instance  &
   instance_name = ._modello_front_susp.rel_rebound_bumper  &
   definition_name = .ACAR.forces.ac_reboundstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.rel_rebound_bumper  &
   color = CYAN
!
ude create instance  &
   instance_name = ._modello_front_susp.rer_rebound_bumper  &
   definition_name = .ACAR.forces.ac_reboundstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.rer_rebound_bumper  &
   color = CYAN
!
ude create instance  &
   instance_name = ._modello_front_susp.bgl_bottom_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 192.33, -114.8, -122.5  &
   orientation = 180.0, 90.0, 180.0
!
ude create instance  &
   instance_name = ._modello_front_susp.bgr_bottom_mount  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 192.33, 114.8, -122.5  &
   orientation = 0.0, 90.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.bul_jounce_bumper  &
   definition_name = .ACAR.forces.ac_bumpstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.bul_jounce_bumper  &
   color = MAGENTA
!
ude create instance  &
   instance_name = ._modello_front_susp.bur_jounce_bumper  &
   definition_name = .ACAR.forces.ac_bumpstop  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.bur_jounce_bumper  &
   color = MAGENTA
!
ude create instance  &
   instance_name = ._modello_front_susp.dal_ride_damper  &
   definition_name = .ACAR.forces.ac_damper  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.dal_ride_damper  &
   color = MAIZE
!
ude create instance  &
   instance_name = ._modello_front_susp.dar_ride_damper  &
   definition_name = .ACAR.forces.ac_damper  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.dar_ride_damper  &
   color = MAIZE
!
ude create instance  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_axle  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 110.0, 143.8, -74.5  &
   orientation = 0.0, 90.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_axle  &
   active = off
!
ude create instance  &
   instance_name = ._modello_front_susp.cns_link_susp_to_axle  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_fork  &
   definition_name = .ACAR.attachments.ac_bushing  &
   location = 231.9, 120.1, -139.4  &
   orientation = 0.0, 90.0, 0.0
!
ude attributes  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_fork  &
   active = off
!
ude create instance  &
   instance_name = ._modello_front_susp.cns_link_susp_to_fork  &
   definition_name = .ACAR.attachments.ac_connector  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.property_file  &
   string_value = (._modello_front_susp.bus_jounce_bumper.property_file_list[._modello_front_susp.bus_jounce_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.property_file_list  &
   string_value = "mdids://acar_shared/bumpstops.tbl/mdi_0001.bum"
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.user_distance  &
   real_value = 75.0
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.reference_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bus_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.diameter  &
   real_value = 25.0
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.force_type  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.i_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.j_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.j_fmarker  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.j_fmarker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.i_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bus_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bus_jounce_bumper.j_marker  &
   object_value = ._modello_front_susp.ges_upper_strut.bus_bumpstop_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.bus_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.property_file  &
   string_value = (._modello_front_susp.res_rebound_bumper.property_file_list[._modello_front_susp.res_rebound_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.property_file_list  &
   string_value = "mdids://acar_shared/reboundstops.tbl/mdi_0001.reb"
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.user_distance  &
   real_value = 100.0
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.diameter  &
   real_value = 150.0
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.i_marker  &
   object_value = ._modello_front_susp.ges_upper_strut.res_reboundstop_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.res_rebound_bumper.j_marker  &
   object_value = ._modello_front_susp.ges_lower_strut.res_reboundstop_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.res_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.property_file  &
   string_value = (._modello_front_susp.das_ride_damper.property_file_list[._modello_front_susp.das_ride_damper.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.property_file_list  &
   string_value = "mdids://acar_shared/dampers.tbl/mdi_0001.dpr"
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.scale_factor_compression  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.scale_factor_rebound  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.hysteretic_damper  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.gas_preload_method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.geoScale  &
   real_value = 0.15
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.r_marker_i_axial  &
   object_value = ._modello_front_susp.ges_lower_strut.das_ride_damper_axial_ref_i
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.r_marker_j_axial  &
   object_value = ._modello_front_susp.ges_upper_strut.das_ride_damper_axial_ref_j
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.i_marker  &
   object_value = ._modello_front_susp.ges_upper_strut.das_damper_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.das_ride_damper.j_marker  &
   object_value = ._modello_front_susp.ges_lower_strut.das_damper_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.das_ride_damper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.property_file  &
   string_value = (._modello_front_susp.bgl_top_mount.property_file_list[._modello_front_susp.bgl_top_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/front_suspension_damper_upper_bus.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.property_file_I  &
   string_value = (._modello_front_susp.bgl_top_mount.property_file_list_I[._modello_front_susp.bgl_top_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.property_file_J  &
   string_value = (._modello_front_susp.bgl_top_mount.property_file_list_J[._modello_front_susp.bgl_top_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.i_geoMarker  &
   object_value = ._modello_front_susp.gel_upper_strut.bxl_bushgeom_i_4
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.j_geoMarker  &
   object_value = ._modello_front_susp.mts_str_fork.bxl_bushgeom_j_4
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.i_compliance_ori  &
   real_value =   &
      264.9091383656,  &
      166.2839866281,  &
      85.0535842783
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.j_compliance_ori  &
   real_value =   &
      264.9091383656,  &
      166.2839866281,  &
      85.0535842783
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.i_marker  &
   object_value = ._modello_front_susp.gel_upper_strut.bxl_bushing_i_4
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_top_mount.j_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bxl_bushing_j_4
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.property_file  &
   string_value = (._modello_front_susp.bgr_top_mount.property_file_list[._modello_front_susp.bgr_top_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/front_suspension_damper_upper_bus.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.property_file_I  &
   string_value = (._modello_front_susp.bgr_top_mount.property_file_list_I[._modello_front_susp.bgr_top_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.property_file_J  &
   string_value = (._modello_front_susp.bgr_top_mount.property_file_list_J[._modello_front_susp.bgr_top_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.i_geoMarker  &
   object_value = ._modello_front_susp.ger_upper_strut.bxr_bushgeom_i_4
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.j_geoMarker  &
   object_value = ._modello_front_susp.mts_str_fork.bxr_bushgeom_j_4
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.i_compliance_ori  &
   real_value =   &
      275.0908616344,  &
      166.2839866281,  &
      94.9464157217
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.j_compliance_ori  &
   real_value =   &
      275.0908616344,  &
      166.2839866281,  &
      94.9464157217
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.i_marker  &
   object_value = ._modello_front_susp.ger_upper_strut.bxr_bushing_i_4
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_top_mount.j_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bxr_bushing_j_4
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_dual
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.bushing  &
   object_value = ._modello_front_susp.bgl_top_mount
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.i_marker  &
   object_value = (._modello_front_susp.cnl_top_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.j_marker  &
   object_value = (._modello_front_susp.cnl_top_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_top_mount.geo_marker  &
   object_value = (._modello_front_susp.cnl_top_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_dual
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.bushing  &
   object_value = ._modello_front_susp.bgr_top_mount
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.i_marker  &
   object_value = (._modello_front_susp.cnr_top_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.j_marker  &
   object_value = (._modello_front_susp.cnr_top_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_top_mount.geo_marker  &
   object_value = (._modello_front_susp.cnr_top_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.property_file  &
   string_value = (._modello_front_susp.bgs_top_mount.property_file_list[._modello_front_susp.bgs_top_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.property_file_list  &
   string_value = "mdids://acar_shared/bushings.tbl/mdi_0001.bus"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.property_file_I  &
   string_value = (._modello_front_susp.bgs_top_mount.property_file_list_I[._modello_front_susp.bgs_top_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.property_file_J  &
   string_value = (._modello_front_susp.bgs_top_mount.property_file_list_J[._modello_front_susp.bgs_top_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.i_geoMarker  &
   object_value = ._modello_front_susp.ges_upper_strut.bxs_bushgeom_i_3
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.j_geoMarker  &
   object_value = ._modello_front_susp.mts_str_fork.bxs_bushgeom_j_3
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.i_compliance_ori  &
   real_value =   &
      275.0908616344,  &
      166.2839866281,  &
      94.9464157217
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.j_compliance_ori  &
   real_value =   &
      275.0908616344,  &
      166.2839866281,  &
      94.9464157217
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.i_marker  &
   object_value = ._modello_front_susp.ges_upper_strut.bxs_bushing_i_3
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_top_mount.j_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bxs_bushing_j_3
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.property_file  &
   string_value = (._modello_front_susp.bgs_bottom_mount.property_file_list[._modello_front_susp.bgs_bottom_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/front_suspension_damper_lower_bus.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.property_file_I  &
   string_value = (._modello_front_susp.bgs_bottom_mount.property_file_list_I[._modello_front_susp.bgs_bottom_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.property_file_J  &
   string_value = (._modello_front_susp.bgs_bottom_mount.property_file_list_J[._modello_front_susp.bgs_bottom_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.i_geoMarker  &
   object_value = ._modello_front_susp.ges_lower_strut.bxs_bushgeom_i_4
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.j_geoMarker  &
   object_value = ._modello_front_susp.ges_link_susp.bxs_bushgeom_j_4
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.i_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.j_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.i_marker  &
   object_value = ._modello_front_susp.ges_lower_strut.bxs_bushing_i_4
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_bottom_mount.j_marker  &
   object_value = ._modello_front_susp.ges_link_susp.bxs_bushing_j_4
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_single
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.bushing  &
   object_value = ._modello_front_susp.bgs_top_mount
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.i_marker  &
   object_value = (._modello_front_susp.cns_top_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.j_marker  &
   object_value = (._modello_front_susp.cns_top_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_top_mount.geo_marker  &
   object_value = (._modello_front_susp.cns_top_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_single
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.bushing  &
   object_value = ._modello_front_susp.bgs_bottom_mount
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.i_marker  &
   object_value = (._modello_front_susp.cns_bottom_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.j_marker  &
   object_value = (._modello_front_susp.cns_bottom_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_bottom_mount.geo_marker  &
   object_value = (._modello_front_susp.cns_bottom_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.property_file  &
   string_value = (._modello_front_susp.nss_ride_spring.property_file_list[._modello_front_susp.nss_ride_spring.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.property_file_list  &
   string_value = "mdids://acar_shared/springs.tbl/mdi_0001.spr"
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.user_value  &
   real_value = (DM(._modello_front_susp.ground.hps_spring_upr_seat, ._modello_front_susp.ground.hps_spring_lwr_seat))
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.value_type  &
   string_value = "use_hardpoints"
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.diameter  &
   real_value = (._modello_front_susp.nss_ride_spring.dmCalc * ._modello_front_susp.nss_ride_spring.geoScale)
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.geoScale  &
   real_value = 0.3
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.numCoils  &
   integer_value = 5
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.independentAxis  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.i_marker  &
   object_value = ._modello_front_susp.ges_upper_strut.nss_spring_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.nss_ride_spring.j_marker  &
   object_value = ._modello_front_susp.ges_lower_strut.nss_spring_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.nss_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.property_file  &
   string_value = (._modello_front_susp.bgl_fork_to_link.property_file_list[._modello_front_susp.bgl_fork_to_link.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/revolute_bush.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.property_file_I  &
   string_value = (._modello_front_susp.bgl_fork_to_link.property_file_list_I[._modello_front_susp.bgl_fork_to_link.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.property_file_J  &
   string_value = (._modello_front_susp.bgl_fork_to_link.property_file_list_J[._modello_front_susp.bgl_fork_to_link.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.i_geoMarker  &
   object_value = ._modello_front_susp.gel_susp_link.bxl_bushgeom_i_2
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.j_geoMarker  &
   object_value = ._modello_front_susp.mts_str_fork.bxl_bushgeom_j_2
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.i_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.j_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.i_marker  &
   object_value = ._modello_front_susp.gel_susp_link.bxl_bushing_i_2
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_fork_to_link.j_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bxl_bushing_j_2
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_fork_to_link
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.property_file  &
   string_value = (._modello_front_susp.bgr_fork_to_link.property_file_list[._modello_front_susp.bgr_fork_to_link.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/revolute_bush.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.property_file_I  &
   string_value = (._modello_front_susp.bgr_fork_to_link.property_file_list_I[._modello_front_susp.bgr_fork_to_link.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.property_file_J  &
   string_value = (._modello_front_susp.bgr_fork_to_link.property_file_list_J[._modello_front_susp.bgr_fork_to_link.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.i_geoMarker  &
   object_value = ._modello_front_susp.ger_susp_link.bxr_bushgeom_i_2
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.j_geoMarker  &
   object_value = ._modello_front_susp.mts_str_fork.bxr_bushgeom_j_2
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.i_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.j_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.i_marker  &
   object_value = ._modello_front_susp.ger_susp_link.bxr_bushing_i_2
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_fork_to_link.j_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bxr_bushing_j_2
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_fork_to_link
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.joint_type  &
   string_value = "revolute"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_dual
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.bushing  &
   object_value = ._modello_front_susp.bgl_fork_to_link
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.i_marker  &
   object_value = (._modello_front_susp.cnl_fork_to_link.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.j_marker  &
   object_value = (._modello_front_susp.cnl_fork_to_link.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_fork_to_link.geo_marker  &
   object_value = (._modello_front_susp.cnl_fork_to_link.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_fork_to_link
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.joint_type  &
   string_value = "revolute"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_dual
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.bushing  &
   object_value = ._modello_front_susp.bgr_fork_to_link
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.i_marker  &
   object_value = (._modello_front_susp.cnr_fork_to_link.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.j_marker  &
   object_value = (._modello_front_susp.cnr_fork_to_link.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_fork_to_link.geo_marker  &
   object_value = (._modello_front_susp.cnr_fork_to_link.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_fork_to_link
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.property_file  &
   string_value = (._modello_front_susp.bgl_susp_link_to_axle.property_file_list[._modello_front_susp.bgl_susp_link_to_axle.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/fixed_bush.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.property_file_I  &
   string_value = (._modello_front_susp.bgl_susp_link_to_axle.property_file_list_I[._modello_front_susp.bgl_susp_link_to_axle.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.property_file_J  &
   string_value = (._modello_front_susp.bgl_susp_link_to_axle.property_file_list_J[._modello_front_susp.bgl_susp_link_to_axle.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.i_geoMarker  &
   object_value = ._modello_front_susp.gel_susp_link.bxl_bushgeom_i_3
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.j_geoMarker  &
   object_value = ._modello_front_susp.ges_axle.bxl_bushgeom_j_3
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.i_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.j_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.i_marker  &
   object_value = ._modello_front_susp.gel_susp_link.bxl_bushing_i_3
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_susp_link_to_axle.j_marker  &
   object_value = ._modello_front_susp.ges_axle.bxl_bushing_j_3
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_susp_link_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.property_file  &
   string_value = (._modello_front_susp.bgr_susp_link_to_axle.property_file_list[._modello_front_susp.bgr_susp_link_to_axle.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/fixed_bush.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.property_file_I  &
   string_value = (._modello_front_susp.bgr_susp_link_to_axle.property_file_list_I[._modello_front_susp.bgr_susp_link_to_axle.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.property_file_J  &
   string_value = (._modello_front_susp.bgr_susp_link_to_axle.property_file_list_J[._modello_front_susp.bgr_susp_link_to_axle.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.i_geoMarker  &
   object_value = ._modello_front_susp.ger_susp_link.bxr_bushgeom_i_3
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.j_geoMarker  &
   object_value = ._modello_front_susp.ges_axle.bxr_bushgeom_j_3
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.i_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.j_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.i_marker  &
   object_value = ._modello_front_susp.ger_susp_link.bxr_bushing_i_3
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_susp_link_to_axle.j_marker  &
   object_value = ._modello_front_susp.ges_axle.bxr_bushing_j_3
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_susp_link_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.joint_type  &
   string_value = "fixed"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_dual
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.bushing  &
   object_value = ._modello_front_susp.bgl_susp_link_to_axle
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.i_marker  &
   object_value = (._modello_front_susp.cnl_susp_link_to_axle.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.j_marker  &
   object_value = (._modello_front_susp.cnl_susp_link_to_axle.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_susp_link_to_axle.geo_marker  &
   object_value = (._modello_front_susp.cnl_susp_link_to_axle.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_susp_link_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.joint_type  &
   string_value = "fixed"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_dual
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.bushing  &
   object_value = ._modello_front_susp.bgr_susp_link_to_axle
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.i_marker  &
   object_value = (._modello_front_susp.cnr_susp_link_to_axle.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.j_marker  &
   object_value = (._modello_front_susp.cnr_susp_link_to_axle.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_susp_link_to_axle.geo_marker  &
   object_value = (._modello_front_susp.cnr_susp_link_to_axle.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_susp_link_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_dual
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.bushing  &
   object_value = ._modello_front_susp.bgl_bottom_mount
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.i_marker  &
   object_value = (._modello_front_susp.cnl_bottom_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.j_marker  &
   object_value = (._modello_front_susp.cnl_bottom_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnl_bottom_mount.geo_marker  &
   object_value = (._modello_front_susp.cnl_bottom_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.joint_type  &
   string_value = "spherical"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_dual
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.bushing  &
   object_value = ._modello_front_susp.bgr_bottom_mount
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.i_marker  &
   object_value = (._modello_front_susp.cnr_bottom_mount.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.j_marker  &
   object_value = (._modello_front_susp.cnr_bottom_mount.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cnr_bottom_mount.geo_marker  &
   object_value = (._modello_front_susp.cnr_bottom_mount.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.property_file  &
   string_value = (._modello_front_susp.nsl_ride_spring.property_file_list[._modello_front_susp.nsl_ride_spring.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.property_file_list  &
   string_value = "mdids://acar_shared/springs.tbl/mdi_0001.spr"
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.user_value  &
   real_value = 206.0113831806
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.value_type  &
   string_value = "installed_length"
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.diameter  &
   real_value = (._modello_front_susp.nsl_ride_spring.dmCalc * ._modello_front_susp.nsl_ride_spring.geoScale)
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.geoScale  &
   real_value = 0.3
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.numCoils  &
   integer_value = 5
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.independentAxis  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.i_marker  &
   object_value = ._modello_front_susp.gel_upper_strut.nsl_spring_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.nsl_ride_spring.j_marker  &
   object_value = ._modello_front_susp.gel_lower_strut.nsl_spring_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.nsl_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.property_file  &
   string_value = (._modello_front_susp.nsr_ride_spring.property_file_list[._modello_front_susp.nsr_ride_spring.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.property_file_list  &
   string_value = "mdids://acar_shared/springs.tbl/mdi_0001.spr"
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.user_value  &
   real_value = 206.0113831806
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.value_type  &
   string_value = "installed_length"
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.diameter  &
   real_value = (._modello_front_susp.nsr_ride_spring.dmCalc * ._modello_front_susp.nsr_ride_spring.geoScale)
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.geoScale  &
   real_value = 0.3
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.numCoils  &
   integer_value = 5
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.independentAxis  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.i_marker  &
   object_value = ._modello_front_susp.ger_upper_strut.nsr_spring_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.nsr_ride_spring.j_marker  &
   object_value = ._modello_front_susp.ger_lower_strut.nsr_spring_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.nsr_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.property_file  &
   string_value = (._modello_front_susp.rel_rebound_bumper.property_file_list[._modello_front_susp.rel_rebound_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.property_file_list  &
   string_value = "mdids://acar_shared/reboundstops.tbl/mdi_0001.reb"
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.user_distance  &
   real_value = 100.0
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.diameter  &
   real_value = 150.0
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.i_marker  &
   object_value = ._modello_front_susp.gel_upper_strut.rel_reboundstop_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.rel_rebound_bumper.j_marker  &
   object_value = ._modello_front_susp.gel_lower_strut.rel_reboundstop_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.rel_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.property_file  &
   string_value = (._modello_front_susp.rer_rebound_bumper.property_file_list[._modello_front_susp.rer_rebound_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.property_file_list  &
   string_value = "mdids://acar_shared/reboundstops.tbl/mdi_0001.reb"
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.user_distance  &
   real_value = 100.0
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.diameter  &
   real_value = 150.0
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.i_marker  &
   object_value = ._modello_front_susp.ger_upper_strut.rer_reboundstop_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.rer_rebound_bumper.j_marker  &
   object_value = ._modello_front_susp.ger_lower_strut.rer_reboundstop_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.rer_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.property_file  &
   string_value = (._modello_front_susp.bgl_bottom_mount.property_file_list[._modello_front_susp.bgl_bottom_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/front_suspension_damper_lower_bus.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.property_file_I  &
   string_value = (._modello_front_susp.bgl_bottom_mount.property_file_list_I[._modello_front_susp.bgl_bottom_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.property_file_J  &
   string_value = (._modello_front_susp.bgl_bottom_mount.property_file_list_J[._modello_front_susp.bgl_bottom_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.i_geoMarker  &
   object_value = ._modello_front_susp.gel_lower_strut.bxl_bushgeom_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.j_geoMarker  &
   object_value = ._modello_front_susp.gel_susp_link.bxl_bushgeom_j_1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.i_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.j_compliance_ori  &
   real_value =   &
      180.0,  &
      90.0,  &
      180.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.i_marker  &
   object_value = ._modello_front_susp.gel_lower_strut.bxl_bushing_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bgl_bottom_mount.j_marker  &
   object_value = ._modello_front_susp.gel_susp_link.bxl_bushing_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.property_file  &
   string_value = (._modello_front_susp.bgr_bottom_mount.property_file_list[._modello_front_susp.bgr_bottom_mount.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/front_suspension_damper_lower_bus.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.property_file_I  &
   string_value = (._modello_front_susp.bgr_bottom_mount.property_file_list_I[._modello_front_susp.bgr_bottom_mount.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.property_file_J  &
   string_value = (._modello_front_susp.bgr_bottom_mount.property_file_list_J[._modello_front_susp.bgr_bottom_mount.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.i_geoMarker  &
   object_value = ._modello_front_susp.ger_lower_strut.bxr_bushgeom_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.j_geoMarker  &
   object_value = ._modello_front_susp.ger_susp_link.bxr_bushgeom_j_1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.geoRadius  &
   real_value = 20.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.geoLength  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.i_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.j_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.i_marker  &
   object_value = ._modello_front_susp.ger_lower_strut.bxr_bushing_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bgr_bottom_mount.j_marker  &
   object_value = ._modello_front_susp.ger_susp_link.bxr_bushing_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.property_file  &
   string_value = (._modello_front_susp.bul_jounce_bumper.property_file_list[._modello_front_susp.bul_jounce_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.property_file_list  &
   string_value = "mdids://acar_shared/bumpstops.tbl/mdi_0001.bum"
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.user_distance  &
   real_value = 75.0
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.reference_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bul_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.diameter  &
   real_value = 25.0
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.force_type  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.i_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.j_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.j_fmarker  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.j_fmarker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.i_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bul_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bul_jounce_bumper.j_marker  &
   object_value = ._modello_front_susp.gel_upper_strut.bul_bumpstop_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.bul_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.property_file  &
   string_value = (._modello_front_susp.bur_jounce_bumper.property_file_list[._modello_front_susp.bur_jounce_bumper.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.property_file_list  &
   string_value = "mdids://acar_shared/bumpstops.tbl/mdi_0001.bum"
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.user_distance  &
   real_value = 75.0
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.reference_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bur_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.distance_type  &
   string_value = "clearance"
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.scale_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.diameter  &
   real_value = 25.0
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.method  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.force_type  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.dampingMethod  &
   integer_value = -1
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.geoScale  &
   real_value = 0.2
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.i_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.j_marker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.j_fmarker  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.j_fmarker2  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.i_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bur_bumpstop_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bur_jounce_bumper.j_marker  &
   object_value = ._modello_front_susp.ger_upper_strut.bur_bumpstop_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.bur_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.property_file  &
   string_value = (._modello_front_susp.dal_ride_damper.property_file_list[._modello_front_susp.dal_ride_damper.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.property_file_list  &
   string_value = "mdids://acar_shared/dampers.tbl/mdi_0001.dpr"
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.scale_factor_compression  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.scale_factor_rebound  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.hysteretic_damper  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.gas_preload_method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.geoScale  &
   real_value = 0.15
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.r_marker_i_axial  &
   object_value = ._modello_front_susp.gel_upper_strut.dal_ride_damper_axial_ref_i
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.r_marker_j_axial  &
   object_value = ._modello_front_susp.gel_lower_strut.dal_ride_damper_axial_ref_j
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.i_marker  &
   object_value = ._modello_front_susp.gel_upper_strut.dal_damper_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.dal_ride_damper.j_marker  &
   object_value = ._modello_front_susp.gel_lower_strut.dal_damper_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.dal_ride_damper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.property_file  &
   string_value = (._modello_front_susp.dar_ride_damper.property_file_list[._modello_front_susp.dar_ride_damper.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.property_file_list  &
   string_value = "mdids://acar_shared/dampers.tbl/mdi_0001.dpr"
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.scale_factor_compression  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.scale_factor_rebound  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.hysteretic_damper  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.gas_preload_method  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.geoScale  &
   real_value = 0.15
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.r_marker_i_axial  &
   object_value = ._modello_front_susp.ger_upper_strut.dar_ride_damper_axial_ref_i
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.r_marker_j_axial  &
   object_value = ._modello_front_susp.ger_lower_strut.dar_ride_damper_axial_ref_j
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.i_marker  &
   object_value = ._modello_front_susp.ger_upper_strut.dar_damper_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.dar_ride_damper.j_marker  &
   object_value = ._modello_front_susp.ger_lower_strut.dar_damper_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.dar_ride_damper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.property_file  &
   string_value = (._modello_front_susp.bgs_link_susp_to_axle.property_file_list[._modello_front_susp.bgs_link_susp_to_axle.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/fixed_bush.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.property_file_I  &
   string_value = (._modello_front_susp.bgs_link_susp_to_axle.property_file_list_I[._modello_front_susp.bgs_link_susp_to_axle.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.property_file_J  &
   string_value = (._modello_front_susp.bgs_link_susp_to_axle.property_file_list_J[._modello_front_susp.bgs_link_susp_to_axle.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.i_geoMarker  &
   object_value = ._modello_front_susp.ges_link_susp.bxs_bushgeom_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.j_geoMarker  &
   object_value = ._modello_front_susp.ges_axle.bxs_bushgeom_j_1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.geoRadius  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.geoLength  &
   real_value = 80.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.i_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.j_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.i_marker  &
   object_value = ._modello_front_susp.ges_link_susp.bxs_bushing_i_1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_axle.j_marker  &
   object_value = ._modello_front_susp.ges_axle.bxs_bushing_j_1
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.joint_type  &
   string_value = "fixed"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_single
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.bushing  &
   object_value = ._modello_front_susp.bgs_link_susp_to_axle
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.i_marker  &
   object_value = (._modello_front_susp.cns_link_susp_to_axle.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.j_marker  &
   object_value = (._modello_front_susp.cns_link_susp_to_axle.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_axle.geo_marker  &
   object_value = (._modello_front_susp.cns_link_susp_to_axle.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_link_susp_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.property_file  &
   string_value = (._modello_front_susp.bgs_link_susp_to_fork.property_file_list[._modello_front_susp.bgs_link_susp_to_fork.property_file_index])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.property_file_list  &
   string_value = "mdids://atrike_shared/bushings.tbl/revolute_bush.xml"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.property_file_index  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.property_file_I  &
   string_value = (._modello_front_susp.bgs_link_susp_to_fork.property_file_list_I[._modello_front_susp.bgs_link_susp_to_fork.property_file_index_I])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.property_file_list_I  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.property_file_index_I  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.property_file_J  &
   string_value = (._modello_front_susp.bgs_link_susp_to_fork.property_file_list_J[._modello_front_susp.bgs_link_susp_to_fork.property_file_index_J])
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.property_file_list_J  &
   string_value = ""
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.property_file_index_J  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_preload_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_preload_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_preload_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_offset_z_bus_ins  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_displ_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_displ_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_displ_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_velo_offset_x  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_velo_offset_y  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_velo_offset_z  &
   real_value = 0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_velo_scale_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_velo_scale_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_velo_scale_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_velo_threshold_x  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_velo_threshold_y  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.t_velo_threshold_z  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_velo_threshold_x  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_velo_threshold_y  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_velo_threshold_z  &
   real_value = 1.745329252E-02
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.i_geoMarker  &
   object_value = ._modello_front_susp.ges_link_susp.bxs_bushgeom_i_2
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.j_geoMarker  &
   object_value = ._modello_front_susp.mts_str_fork.bxs_bushgeom_j_2
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.bushing_shape  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.stiffness_curve  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.fx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.fy_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.fz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.tx_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.ty_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.tz_scaling_factor  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.tx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.ty_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.tz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.rx_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.ry_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.rz_damping_force_scale  &
   real_value = 1.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.geoRadius  &
   real_value = 30.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.geoLength  &
   real_value = 80.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.i_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.j_tolerance  &
   real_value =   &
      0.0,  &
      0.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.tolerance_coordinate  &
   string_value = "local"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.i_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.j_ori_type  &
   string_value = "default"
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.i_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.j_compliance_ori  &
   real_value =   &
      0.0,  &
      90.0,  &
      0.0
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.i_marker  &
   object_value = ._modello_front_susp.ges_link_susp.bxs_bushing_i_2
!
variable modify  &
   variable_name = ._modello_front_susp.bgs_link_susp_to_fork.j_marker  &
   object_value = ._modello_front_susp.mts_str_fork.bxs_bushing_j_2
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_fork
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.method  &
   string_value = "bushing"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.joint_type  &
   string_value = "revolute"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.design_option  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.r_marker_i_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.r_marker_j_part  &
   object_value = (NONE)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.friction_active  &
   integer_value = 0
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.request_activity  &
   string_value = "inherit"
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.displacement_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.velocity_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.acceleration_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.force_request_active  &
   integer_value = 1
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.request_coordinates  &
   integer_value =   &
      1,  &
      0,  &
      0,  &
      0
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.group_activity  &
   object_value = ._modello_front_susp.suspension_link_type_single
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.bushing  &
   object_value = ._modello_front_susp.bgs_link_susp_to_fork
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.i_marker  &
   object_value = (._modello_front_susp.cns_link_susp_to_fork.bushing.object_value.i_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.j_marker  &
   object_value = (._modello_front_susp.cns_link_susp_to_fork.bushing.object_value.j_marker)
!
variable modify  &
   variable_name = ._modello_front_susp.cns_link_susp_to_fork.geo_marker  &
   object_value = (._modello_front_susp.cns_link_susp_to_fork.bushing.object_value.j_geoMarker.object_value)
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_link_susp_to_fork
!
undo end_block
!
!---------------------------------- Motions -----------------------------------!
!
!
constraint create motion_generator  &
   motion_name = ._modello_front_susp._cv_motion  &
   comments = "Dummy for communicators"  &
   type_of_freedom = rotational  &
   joint_name = ._modello_front_susp._cv_joint_for_motion  &
   function = ""
!
constraint attributes  &
   constraint_name = ._modello_front_susp._cv_motion  &
   visibility = off  &
   name_visibility = off
!
!---------------------------------- Accgrav -----------------------------------!
!
!
force create body gravitational  &
   gravity_field_name = gravity  &
   x_component_gravity = 0.0  &
   y_component_gravity = 0.0  &
   z_component_gravity = -9810.0
!
!----------------------------- Analysis settings ------------------------------!
!
!
output_control set results  &
   model_name = _modello_front_susp  &
   formatted = on
!
!---------------------------- Adams View Variables ----------------------------!
!
!
variable create  &
   variable_name = ._modello_front_susp.suspension_parameters_ARRAY.type_flag  &
   integer_value = 1  &
   comments = "1=Independent, 0=Dependent"
!
variable create  &
   variable_name = ._modello_front_susp.suspension_parameters_ARRAY.steer_axis_calc_method  &
   integer_value = 0  &
   comments = "0=Geometric, 1=Instant Axis"
!
variable create  &
   variable_name = ._modello_front_susp.suspension_parameters_ARRAY.kp1  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.suspension_parameters_ARRAY.kp2  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.ges_lower_strut.sms_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.ges_upper_strut.sms_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.ges_link_susp.sms_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.mts_str_fork.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.mts_str_fork.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.mts_str_fork.dependents  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.ges_spindle.sms_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 0.0
!
variable create  &
   variable_name = ._modello_front_susp.ges_axle.sms_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.ges_axle.current_mass_properties  &
   string_value = ".materials.steel", "7.801E-06"
!
variable create  &
   variable_name = ._modello_front_susp.gel_susp_link.sml_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.ger_susp_link.smr_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.gel_upper_strut.sml_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.ger_upper_strut.smr_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.ger_lower_strut.smr_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.gel_lower_strut.sml_sprung_mass_percent  &
   range = 0.0, 100.0  &
   delta_type = relative  &
   real_value = 100.0
!
variable create  &
   variable_name = ._modello_front_susp.speed  &
   units = "velocity"  &
   real_value = 0.0
!
variable create  &
   variable_name = ._modello_front_susp.role  &
   string_value = "suspension"  &
   comments = "Memory for Adams Car major role"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center  &
   units = "length"  &
   real_value = 110.0, 0.0, -74.5
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center.matching_name  &
   string_value = "wheel_center"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center.entity  &
   string_value = "location"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.template_creation_date  &
   string_value = "1995/08/19,15:34:45  - converted to file_version 4"  &
   comments = "Do not remove"
!
variable create  &
   variable_name = ._modello_front_susp.pvs_toe_angle  &
   units = "angle"  &
   real_value = 0.0  &
   comments =   &
              "A Positive toe angle yields toe_in (front of the wheel rotates towards the chassis)."
!
variable create  &
   variable_name = ._modello_front_susp.pvs_camber_angle  &
   units = "angle"  &
   real_value = 0.0  &
   comments =   &
              "A Positive camber angle rotates the top of the wheel outward away from the chassis."
!
variable create  &
   variable_name = ._modello_front_susp.cos_toe_angle  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_toe_angle.matching_name  &
   string_value = "toe_angle"
!
variable create  &
   variable_name = ._modello_front_susp.cos_toe_angle.entity  &
   string_value = "parameter_real"
!
variable create  &
   variable_name = ._modello_front_susp.cos_toe_angle.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_camber_angle  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_camber_angle.matching_name  &
   string_value = "camber_angle"
!
variable create  &
   variable_name = ._modello_front_susp.cos_camber_angle.entity  &
   string_value = "parameter_real"
!
variable create  &
   variable_name = ._modello_front_susp.cos_camber_angle.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.minor_role  &
   string_value = "unassigned"  &
   comments = "Memory for Adams/Car minor role"
!
variable create  &
   variable_name = ._modello_front_susp.phs_kinematic_flag  &
   integer_value = 0  &
   comments =   &
              "Flag that determines if kinematic joints or bushings are active"
!
variable create  &
   variable_name = ._modello_front_susp.model_class  &
   string_value = "template"  &
   comments = "Memory for Adams/Car model class"
!
variable create  &
   variable_name = ._modello_front_susp.pvr_drive_shaft_offset  &
   units = "length"  &
   real_value = 50.0  &
   comments =   &
              "Location of outer CV joint measured inboard from wheel center along the wheel's spin axis"
!
variable create  &
   variable_name = ._modello_front_susp.pvl_drive_shaft_offset  &
   units = "length"  &
   real_value = 50.0  &
   comments =   &
              "Location of outer CV joint measured inboard from wheel center along the wheel's spin axis"
!
variable create  &
   variable_name = ._modello_front_susp.phs_driveline_active  &
   integer_value = 0  &
   comments = "( 1 = active driveline, 0 = inactive driveline)"
!
variable create  &
   variable_name = ._modello_front_susp.cos_driveline_active  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_driveline_active.matching_name  &
   string_value = "driveline_active"
!
variable create  &
   variable_name = ._modello_front_susp.cos_driveline_active.entity  &
   string_value = "parameter_integer"
!
variable create  &
   variable_name = ._modello_front_susp.cos_driveline_active.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_mount  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_mount.matching_name  &
   string_value = "suspension_mount"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_mount.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_mount.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_mount.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY.matching_name  &
   string_value = "characteristics_input_ARRAY"
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY.entity  &
   string_value = "array"
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY_adams_id  &
   integer_value = 0  &
   comments =   &
              "Passes the adams_id of the array (used in function expressions)"
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY_adams_id.matching_name  &
   string_value = "characteristics_input_ARRAY_adams_id"
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY_adams_id.entity  &
   string_value = "array"
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY_adams_id.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY_adams_id.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_upright  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_upright.matching_name  &
   string_value = "suspension_upright"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_upright.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_upright.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_upright.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_front_susp.cos_upright_left  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_upright_left.matching_name  &
   string_value = "upright_left"
!
variable create  &
   variable_name = ._modello_front_susp.cos_upright_left.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_upright_left.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_upright_left.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_lower_bearing  &
   units = "length"  &
   real_value = 231.9, 0.0, -139.4
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_lower_bearing.matching_name  &
   string_value = "str_fork_loc_lower_bearing"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_lower_bearing.entity  &
   string_value = "location"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_lower_bearing.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_lower_bearing.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork  &
   object_value = (NONE)  &
   comments = "Autocreated for mount part: mts_str_fork"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork.matching_name  &
   string_value = "str_fork"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_parameters_ARRAY  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_parameters_ARRAY.matching_name  &
   string_value = "suspension_parameters_ARRAY"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_parameters_ARRAY.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_parameters_ARRAY.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_parameters_ARRAY.entity  &
   string_value = "array"
!
variable create  &
   variable_name = ._modello_front_susp.cis_chassis_reference  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cis_chassis_reference.matching_name  &
   string_value = "chassis_path_reference"
!
variable create  &
   variable_name = ._modello_front_susp.cis_chassis_reference.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cis_chassis_reference.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cis_chassis_reference_adams_id  &
   integer_value = 0  &
   comments =   &
              "Passes the adams_id of the marker (used in function expressions)"
!
variable create  &
   variable_name = ._modello_front_susp.cis_chassis_reference_adams_id.matching_name  &
   string_value = "chassis_path_reference_adams_id"
!
variable create  &
   variable_name = ._modello_front_susp.cis_chassis_reference_adams_id.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cis_chassis_reference_adams_id.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_upper_bearing  &
   units = "length"  &
   real_value = 0.0, 0.0, 0.0
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_upper_bearing.matching_name  &
   string_value = "str_fork_loc_upper_bearing"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_upper_bearing.entity  &
   string_value = "location"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_upper_bearing.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cis_str_fork_loc_upper_bearing.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.pvs_suspension_link_type  &
   integer_value = 2  &
   comments = "(1 = Single Link, 2 = Dual Link)", "",  &
              "Flag that determines suspension link configuration.", "",  &
              "Single link used for asymmetric fork steering",  &
              "Dual link used for symmetric fork steering"
!
variable create  &
   variable_name = ._modello_front_susp.pvs_suspension_link_type.choices  &
   string_value = "Single Link", "Dual Link"
!
variable create  &
   variable_name = ._modello_front_susp.pvs_suspension_link_type.values  &
   integer_value = 1, 2
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_upper_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_upper_marker.matching_name  &
   string_value = "damper_upper_marker"
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_upper_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_upper_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_upper_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_upper_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_upper_marker.matching_name  &
   string_value = "damper_upper_marker"
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_upper_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_upper_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_upper_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_lower_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_lower_marker.matching_name  &
   string_value = "damper_lower_marker"
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_lower_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_lower_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.col_damper_lower_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_lower_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_lower_marker.matching_name  &
   string_value = "damper_lower_marker"
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_lower_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_lower_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cor_damper_lower_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_upper_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_upper_marker.matching_name  &
   string_value = "spring_upper_marker"
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_upper_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_upper_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_upper_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_upper_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_upper_marker.matching_name  &
   string_value = "spring_upper_marker"
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_upper_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_upper_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_upper_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_lower_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_lower_marker.matching_name  &
   string_value = "spring_lower_marker"
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_lower_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_lower_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.col_spring_lower_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_lower_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_lower_marker.matching_name  &
   string_value = "spring_lower_marker"
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_lower_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_lower_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cor_spring_lower_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spindle_rise  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_spindle_rise.matching_name  &
   string_value = "spindle_rise"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spindle_rise.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spindle_rise.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spindle_rise.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker_ori  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker_ori.matching_name  &
   string_value = "wheel_center_marker_ori"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker_ori.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker_ori.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker_ori.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_left  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_left.matching_name  &
   string_value = "lower_control_arm_left"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_left.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_left.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_left.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_right  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_right.matching_name  &
   string_value = "lower_control_arm_right"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_right.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_right.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_right.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker.matching_name  &
   string_value = "wheel_center_marker"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cos_svs_ride_height  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_svs_ride_height.matching_name  &
   string_value = "svs_ride_height"
!
variable create  &
   variable_name = ._modello_front_susp.cos_svs_ride_height.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_svs_ride_height.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_svs_ride_height.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm.matching_name  &
   string_value = "lower_control_arm"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_lower_control_arm.entity  &
   string_value = "mount"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_link_type  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_link_type.matching_name  &
   string_value = "suspension_link_type"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_link_type.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_link_type.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_suspension_link_type.entity  &
   string_value = "parameter_integer"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_lower_marker_loc  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_lower_marker_loc.matching_name  &
   string_value = "spring_lower_marker_loc"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_lower_marker_loc.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_lower_marker_loc.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_lower_marker_loc.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_upper_marker_loc  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_upper_marker_loc.matching_name  &
   string_value = "spring_upper_marker_loc"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_upper_marker_loc.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_upper_marker_loc.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_spring_upper_marker_loc.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_upper_marker_loc  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_upper_marker_loc.matching_name  &
   string_value = "damper_upper_marker_loc"
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_upper_marker_loc.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_upper_marker_loc.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_upper_marker_loc.entity  &
   string_value = "marker"
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_lower_marker_loc  &
   object_value = (NONE)
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_lower_marker_loc.matching_name  &
   string_value = "damper_lower_marker_loc"
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_lower_marker_loc.minor_role  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_lower_marker_loc.subsystem_index  &
   string_value = "inherit"
!
variable create  &
   variable_name = ._modello_front_susp.cos_damper_lower_marker_loc.entity  &
   string_value = "marker"
!
!---------------------------- Adams View Functions ----------------------------!
!
!
function create  &
   function_name = .SYMMETRY  &
   text_of_expression = "LOC_MIRROR(location, .__ACAR.ground.origo, .ACAR.variables.symmetry_plane)"  &
   argument_names = "location"  &
   type = location_orientation  &
   comments =   &
              "Compute mirrored location over the symmetry plane given 3x1 location vector"
!
!---------------------- Set Adams View Object Variables -----------------------!
!
!
variable modify  &
   variable_name = ._modello_front_susp.suspension_parameters_ARRAY.kp1  &
   object_value = ._modello_front_susp.ges_axle.kp1_1,  &
                  ._modello_front_susp.ges_axle.kp1_2
!
variable modify  &
   variable_name = ._modello_front_susp.suspension_parameters_ARRAY.kp2  &
   object_value = ._modello_front_susp.mts_str_fork.kp2_1,  &
                  ._modello_front_susp.mts_str_fork.kp2_2
!
variable modify  &
   variable_name = ._modello_front_susp.mts_str_fork.dependents  &
   object_value = ._modello_front_susp.mts_fixed_1,  &
                  ._modello_front_susp.cis_str_fork
!
variable modify  &
   variable_name = ._modello_front_susp.cos_toe_angle  &
   object_value = ._modello_front_susp.pvs_toe_angle
!
variable modify  &
   variable_name = ._modello_front_susp.cos_camber_angle  &
   object_value = ._modello_front_susp.pvs_camber_angle
!
variable modify  &
   variable_name = ._modello_front_susp.cos_driveline_active  &
   object_value = ._modello_front_susp.phs_driveline_active
!
variable modify  &
   variable_name = ._modello_front_susp.cos_suspension_mount  &
   object_value = ._modello_front_susp.ges_spindle
!
variable modify  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY  &
   object_value = ._modello_front_susp._cv_array
!
variable modify  &
   variable_name = ._modello_front_susp.cos_suspension_upright  &
   object_value = ._modello_front_susp.ges_axle
!
variable modify  &
   variable_name = ._modello_front_susp.cos_upright_left  &
   object_value = ._modello_front_susp.ges_axle
!
variable modify  &
   variable_name = ._modello_front_susp.cis_str_fork  &
   object_value = ._modello_front_susp.ground.mts_mount_j_1,  &
                  ._modello_front_susp.mts_str_fork,  &
                  ._modello_front_susp.mts_fixed_1
!
variable modify  &
   variable_name = ._modello_front_susp.cos_suspension_parameters_ARRAY  &
   object_value = ._modello_front_susp.suspension_parameters_ARRAY
!
variable modify  &
   variable_name = ._modello_front_susp.cis_chassis_reference  &
   object_value = ._modello_front_susp.ground._cv_marker
!
variable modify  &
   variable_name = ._modello_front_susp.col_damper_upper_marker  &
   object_value = ._modello_front_susp.gel_upper_strut.coomarker_1
!
variable modify  &
   variable_name = ._modello_front_susp.cor_damper_upper_marker  &
   object_value = ._modello_front_susp.ger_upper_strut.coomarker_2
!
variable modify  &
   variable_name = ._modello_front_susp.col_damper_lower_marker  &
   object_value = ._modello_front_susp.gel_susp_link.coomarker_3
!
variable modify  &
   variable_name = ._modello_front_susp.cor_damper_lower_marker  &
   object_value = ._modello_front_susp.ger_susp_link.coomarker_4
!
variable modify  &
   variable_name = ._modello_front_susp.col_spring_upper_marker  &
   object_value = ._modello_front_susp.gel_upper_strut.coomarker_5
!
variable modify  &
   variable_name = ._modello_front_susp.cor_spring_upper_marker  &
   object_value = ._modello_front_susp.ger_upper_strut.coomarker_6
!
variable modify  &
   variable_name = ._modello_front_susp.col_spring_lower_marker  &
   object_value = ._modello_front_susp.gel_lower_strut.coomarker_7
!
variable modify  &
   variable_name = ._modello_front_susp.cor_spring_lower_marker  &
   object_value = ._modello_front_susp.ger_lower_strut.coomarker_8
!
variable modify  &
   variable_name = ._modello_front_susp.cos_spindle_rise  &
   object_value = ._modello_front_susp.ges_axle.coomarker_9
!
variable modify  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker_ori  &
   object_value = ._modello_front_susp.ges_axle.coomarker_10
!
variable modify  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_left  &
   object_value = ._modello_front_susp.gel_susp_link
!
variable modify  &
   variable_name = ._modello_front_susp.cos_lower_control_arm_right  &
   object_value = ._modello_front_susp.ger_susp_link
!
variable modify  &
   variable_name = ._modello_front_susp.cos_wheel_center_marker  &
   object_value = ._modello_front_susp.ges_axle.coomarker_11
!
variable modify  &
   variable_name = ._modello_front_susp.cos_svs_ride_height  &
   object_value = ._modello_front_susp.ger_susp_link.coomarker_12
!
variable modify  &
   variable_name = ._modello_front_susp.cos_lower_control_arm  &
   object_value = ._modello_front_susp.ges_axle
!
variable modify  &
   variable_name = ._modello_front_susp.cos_suspension_link_type  &
   object_value = ._modello_front_susp.pvs_suspension_link_type
!
variable modify  &
   variable_name = ._modello_front_susp.cos_spring_lower_marker_loc  &
   object_value = ._modello_front_susp.ges_lower_strut.coomarker_13
!
variable modify  &
   variable_name = ._modello_front_susp.cos_spring_upper_marker_loc  &
   object_value = ._modello_front_susp.ges_upper_strut.coomarker_14
!
variable modify  &
   variable_name = ._modello_front_susp.cos_damper_upper_marker_loc  &
   object_value = ._modello_front_susp.ges_upper_strut.coomarker_15
!
variable modify  &
   variable_name = ._modello_front_susp.cos_damper_lower_marker_loc  &
   object_value = ._modello_front_susp.ges_lower_strut.coomarker_16
!
!--------------------------- Add Objects To Groups ----------------------------!
!
!
group modify  &
   group_name = ._modello_front_susp.top_mount_kinematic  &
   objects_in_group = ._modello_front_susp.jolper_top_mount,  &
      ._modello_front_susp.jorper_top_mount
!
group modify  &
   group_name = ._modello_front_susp.suspension_link_type_dual  &
   objects_in_group = ._modello_front_susp.gel_susp_link,  &
      ._modello_front_susp.ger_susp_link,  &
      ._modello_front_susp.ground.hpl_susp_link_to_axle,  &
      ._modello_front_susp.ground.hpr_susp_link_to_axle,  &
      ._modello_front_susp.ground.hpl_susp_link_to_fork,  &
      ._modello_front_susp.ground.hpr_susp_link_to_fork,  &
      ._modello_front_susp.ground.hpl_strut_lwr_mount,  &
      ._modello_front_susp.ground.hpr_strut_lwr_mount,  &
      ._modello_front_susp.nsl_ride_spring,  &
      ._modello_front_susp.nsr_ride_spring,  &
      ._modello_front_susp.dal_ride_damper,  &
      ._modello_front_susp.dar_ride_damper,  &
      ._modello_front_susp.jolcyl_strut,  &
      ._modello_front_susp.jorcyl_strut,  &
      ._modello_front_susp.bul_jounce_bumper,  &
      ._modello_front_susp.bur_jounce_bumper,  &
      ._modello_front_susp.gel_lower_strut,  &
      ._modello_front_susp.gel_upper_strut,  &
      ._modello_front_susp.ger_lower_strut,  &
      ._modello_front_susp.ger_upper_strut,  &
      ._modello_front_susp.ground.hpl_spring_lwr_seat,  &
      ._modello_front_susp.ground.hpr_spring_lwr_seat,  &
      ._modello_front_susp.ground.hpl_spring_upr_seat,  &
      ._modello_front_susp.ground.hpr_spring_upr_seat,  &
      ._modello_front_susp.ground.hpl_top_mount,  &
      ._modello_front_susp.ground.hpr_top_mount,  &
      ._modello_front_susp.rel_rebound_bumper,  &
      ._modello_front_susp.rer_rebound_bumper,  &
      ._modello_front_susp.ground.cfl_top_mount_ext,  &
      ._modello_front_susp.ground.cfl_top_mount_jprim_ref1,  &
      ._modello_front_susp.ground.cfr_top_mount_ext,  &
      ._modello_front_susp.ground.cfr_top_mount_jprim_ref1,  &
      ._modello_front_susp.ground.hpl_bumper_lower,  &
      ._modello_front_susp.ground.hpl_bumper_upper,  &
      ._modello_front_susp.ground.hpr_bumper_lower,  &
      ._modello_front_susp.ground.hpr_bumper_upper,  &
      ._modello_front_susp.ges_axle.gralin_axle,  &
      ._modello_front_susp.ground.cfl_top_mount,  &
      ._modello_front_susp.ground.cfl_lwr_strut_mount,  &
      ._modello_front_susp.ground.cfr_top_mount,  &
      ._modello_front_susp.ground.cfr_lwr_strut_mount,  &
      ._modello_front_susp.cos_lower_control_arm_left,  &
      ._modello_front_susp.cos_lower_control_arm_right,  &
      ._modello_front_susp.cor_spring_lower_marker,  &
      ._modello_front_susp.col_spring_lower_marker,  &
      ._modello_front_susp.cor_spring_upper_marker,  &
      ._modello_front_susp.col_spring_upper_marker,  &
      ._modello_front_susp.col_damper_lower_marker,  &
      ._modello_front_susp.cor_damper_lower_marker,  &
      ._modello_front_susp.col_damper_upper_marker,  &
      ._modello_front_susp.cor_damper_upper_marker
!
group modify  &
   group_name = ._modello_front_susp.single_top_mount_kinematic  &
   objects_in_group = ._modello_front_susp.josper_top_mount
!
group modify  &
   group_name = ._modello_front_susp.kinematic_mode_active
!
group modify  &
   group_name = ._modello_front_susp.kinematic_mode_inactive
!
group modify  &
   group_name = ._modello_front_susp.driveline_active
!
group modify  &
   group_name = ._modello_front_susp.driveline_inactive
!
group modify  &
   group_name = ._modello_front_susp.suspension_link_type_single  &
   objects_in_group = ._modello_front_susp.ground.hps_susp_link_to_axle,  &
      ._modello_front_susp.ges_link_susp,  &
      ._modello_front_susp.ground.hps_susp_link_to_fork,  &
      ._modello_front_susp.ges_link_susp.gralin_susp_link,  &
      ._modello_front_susp.ground.hps_strut_lwr_mount,  &
      ._modello_front_susp.joscyl_strut,  &
      ._modello_front_susp.ground.hps_spring_lwr_seat,  &
      ._modello_front_susp.das_ride_damper,  &
      ._modello_front_susp.ges_lower_strut,  &
      ._modello_front_susp.ges_upper_strut,  &
      ._modello_front_susp.ground.hps_top_mount,  &
      ._modello_front_susp.ground.hps_spring_upr_seat,  &
      ._modello_front_susp.nss_ride_spring,  &
      ._modello_front_susp.bus_jounce_bumper,  &
      ._modello_front_susp.res_rebound_bumper,  &
      ._modello_front_susp.ground.hps_bumper_upper,  &
      ._modello_front_susp.ground.hps_bumper_lower,  &
      ._modello_front_susp.ges_axle.gralin_axle_1,  &
      ._modello_front_susp.cos_spring_lower_marker_loc,  &
      ._modello_front_susp.cos_spring_upper_marker_loc,  &
      ._modello_front_susp.cos_damper_upper_marker_loc,  &
      ._modello_front_susp.cos_damper_lower_marker_loc,  &
      ._modello_front_susp.ground.cfs_lwr_strut_mount_loc,  &
      ._modello_front_susp.ground.cfs_upr_strut_mount_loc,  &
      ._modello_front_susp.ground.cfs_spring_lwr_seat_loc,  &
      ._modello_front_susp.ground.cfs_spring_upr_seat_loc
!
!---------------------------- Function definitions ----------------------------!
!
!
constraint modify motion_generator  &
   motion_name = ._modello_front_susp._cv_motion  &
   function = "0"
!
data_element modify variable  &
   variable_name = ._modello_front_susp._cv_solver_variable  &
   function = "0"
!
part modify equation differential_equation  &
   differential_equation_name = ._modello_front_susp._cv_diff  &
   function = "0"
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bus_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.res_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.das_ride_damper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_top_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.nss_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_fork_to_link
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_fork_to_link
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_fork_to_link
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_fork_to_link
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_susp_link_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_susp_link_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_susp_link_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_susp_link_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.nsl_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.nsr_ride_spring
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.rel_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.rer_rebound_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_bottom_mount
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bul_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bur_jounce_bumper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.dal_ride_damper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.dar_ride_damper
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_link_susp_to_axle
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_fork
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_link_susp_to_fork
!
!--------------------------- Expression definitions ---------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = ground
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_lwr_strut_mount_loc  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_strut_lwr_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_upr_strut_mount_loc  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_spring_lwr_seat_loc  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_spring_upr_seat_loc  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_spring_upr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfl_spring_lwr_seat  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpl_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfr_spring_lwr_seat  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfl_spring_upr_seat  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpl_spring_upr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfr_spring_upr_seat  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_spring_upr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfl_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpl_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfr_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfl_top_mount_jprim_ref1  &
   location =   &
      (LOC_RELATIVE_TO({0.0, -50.0, 0.0}mm + LOC_LOCAL(._modello_front_susp.ground.hpl_top_mount.loc, ._modello_front_susp.ground.origo), ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfr_top_mount_jprim_ref1  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 50.0, 0.0}mm + LOC_LOCAL(._modello_front_susp.ground.hpr_top_mount.loc, ._modello_front_susp.ground.origo), ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_top_mount_jprim_ref  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 50.0, 0.0}mm + LOC_LOCAL(._modello_front_susp.ground.hps_top_mount.loc, ._modello_front_susp.ground.origo), ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_str_fork_upper_bearing  &
   location =   &
      (._modello_front_susp.cis_str_fork_loc_upper_bearing)  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfl_dummy_susp_par_upper_bearing  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.cfs_str_fork_upper_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfr_dummy_susp_par_upper_bearing  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.cfs_str_fork_upper_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_str_fork_lower_bearing  &
   location =   &
      (._modello_front_susp.cis_str_fork_loc_lower_bearing)  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.mts_mount_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_wheel_center  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({180d - ._modello_front_susp.pvs_toe_angle, -90d - ._modello_front_susp.pvs_camber_angle, 180d}, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfl_top_mount_ext  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 50.0}mm + LOC_LOCAL(._modello_front_susp.ground.hpl_top_mount.loc, ._modello_front_susp.ground.origo), ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfr_top_mount_ext  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 50.0}mm + LOC_LOCAL(._modello_front_susp.ground.hpr_top_mount.loc, ._modello_front_susp.ground.origo), ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfl_dummy_susp_par_lower_bearing  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.cfs_str_fork_lower_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfr_dummy_susp_par_lower_bearing  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.cfs_str_fork_lower_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfl_lwr_strut_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpl_strut_lwr_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfr_lwr_strut_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_strut_lwr_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_wheel_center_marker_ori  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({180.0, 90.0, 180.0}degrees, ._modello_front_susp.ground.cfs_wheel_center))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_spindle_rise  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({180.0, 90.0, 0.0}degrees, ._modello_front_susp.ground.cfs_wheel_center_marker_ori))
!
marker modify  &
   marker_name = ._modello_front_susp.ground.cfs_ride_height_ref  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_susp_link_to_fork))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
variable modify  &
   variable_name = ._modello_front_susp.suspension_parameters_ARRAY.type_flag  &
   integer_value = ("Independent" == "Independent")
!
data_element modify array ic_array  &
   array_name = ._modello_front_susp.suspension_parameters_ARRAY  &
   numbers =   &
      (._modello_front_susp.suspension_parameters_ARRAY.type_flag),  &
      (._modello_front_susp.ges_axle.kp1_1.adams_id),  &
      (._modello_front_susp.mts_str_fork.kp2_1.adams_id),  &
      (._modello_front_susp.ges_axle.kp1_2.adams_id),  &
      (._modello_front_susp.mts_str_fork.kp2_2.adams_id),  &
      (ANYM(._modello_front_susp.minor_role == {"front", "any"}))
!
data_element modify string  &
   string_name = ._modello_front_susp.minor_role_string  &
   string = (._modello_front_susp.minor_role)
!
material modify  &
   material_name = ._modello_front_susp.steel  &
   density = (7801.0(kg/meter**3))  &
   youngs_modulus = (2.07E+11(Newton/meter**2))
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.coomarker_13  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_spring_lwr_seat_loc))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_spring_lwr_seat_loc))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.coomarker_16  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_spring_lwr_seat_loc))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_spring_lwr_seat_loc))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.res_reboundstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_top_mount))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_lower_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_lower_strut))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.das_damper_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_strut_lwr_mount))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.das_ride_damper_axial_ref_i  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_front_susp.das_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.das_ride_damper.i_marker, ._modello_front_susp.das_ride_damper.j_marker, "z"))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.jxs_joint_j_1  &
   location =   &
      (LOC_RELATIVE_TO(LOC_CENTERED({._modello_front_susp.ground.hps_top_mount.loc, ._modello_front_susp.ground.hps_strut_lwr_mount.loc}, 2), ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ges_lower_strut.jxs_joint_j_1, ._modello_front_susp.ground.hps_top_mount, "Z"))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.bxs_bushing_i_4  &
   location =   &
      (._modello_front_susp.bgs_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgs_bottom_mount.i_tolerance}, ._modello_front_susp.bgs_bottom_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgs_bottom_mount.i_tolerance[1], ._modello_front_susp.bgs_bottom_mount.i_tolerance[2], ._modello_front_susp.bgs_bottom_mount.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgs_bottom_mount.loc, ._modello_front_susp.bgs_bottom_mount.parent.ground.origo), ._modello_front_susp.bgs_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgs_bottom_mount))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.bxs_bushgeom_i_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgs_bottom_mount.geoLength / 2}, ._modello_front_susp.ges_lower_strut.bxs_bushing_i_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.ges_lower_strut.bxs_bushing_i_4))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_lower_strut.nss_spring_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_spring_lwr_seat))  &
   relative_to = ._modello_front_susp.ges_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_lower_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_front_susp.ground.hps_strut_lwr_mount, ._modello_front_susp.ground.hps_top_mount, 0.33 * DM(._modello_front_susp.ground.hps_strut_lwr_mount, ._modello_front_susp.ground.hps_top_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ges_lower_strut, ._modello_front_susp.ground.hps_top_mount, "Z"))
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.coomarker_14  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_spring_upr_seat_loc))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_spring_upr_seat_loc))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.coomarker_15  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_upr_strut_mount_loc))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_upr_strut_mount_loc))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.bus_bumpstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_bumper_lower))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.res_reboundstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_strut_lwr_mount))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_upper_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_upper_strut))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.das_damper_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_top_mount))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.das_ride_damper_axial_ref_j  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_front_susp.das_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.das_ride_damper.j_marker, ._modello_front_susp.das_ride_damper.i_marker, "z"))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.jxs_joint_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_lower_strut.jxs_joint_j_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_lower_strut.jxs_joint_j_1))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.bxs_bushing_i_3  &
   location =   &
      (._modello_front_susp.bgs_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgs_top_mount.i_tolerance}, ._modello_front_susp.bgs_top_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgs_top_mount.i_tolerance[1], ._modello_front_susp.bgs_top_mount.i_tolerance[2], ._modello_front_susp.bgs_top_mount.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgs_top_mount.loc, ._modello_front_susp.bgs_top_mount.parent.ground.origo), ._modello_front_susp.bgs_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgs_top_mount))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.bxs_bushgeom_i_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgs_top_mount.geoLength / 2}, ._modello_front_susp.ges_upper_strut.bxs_bushing_i_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.ges_upper_strut.bxs_bushing_i_3))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.jxs_joint_i_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork.jxs_joint_j_3))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_front_susp.ges_upper_strut.jxs_joint_i_3, ._modello_front_susp.ground.cfs_top_mount_jprim_ref, ._modello_front_susp.ground.hps_strut_lwr_mount, "Z_ZX"))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_upper_strut.nss_spring_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_spring_upr_seat))  &
   relative_to = ._modello_front_susp.ges_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_upper_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_front_susp.ground.hps_strut_lwr_mount, ._modello_front_susp.ground.hps_top_mount, 0.66 * DM(._modello_front_susp.ground.hps_strut_lwr_mount, ._modello_front_susp.ground.hps_top_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ges_upper_strut, ._modello_front_susp.ground.hps_top_mount, "Z"))
!
marker modify  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushing_j_4  &
   location =   &
      (._modello_front_susp.bgs_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgs_bottom_mount.j_tolerance}, ._modello_front_susp.bgs_bottom_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgs_bottom_mount.j_tolerance[1], ._modello_front_susp.bgs_bottom_mount.j_tolerance[2], ._modello_front_susp.bgs_bottom_mount.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgs_bottom_mount.loc, ._modello_front_susp.bgs_bottom_mount.parent.ground.origo), ._modello_front_susp.bgs_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgs_bottom_mount))  &
   relative_to = ._modello_front_susp.ges_link_susp
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushgeom_j_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgs_bottom_mount.geoLength / 2}, ._modello_front_susp.ges_link_susp.bxs_bushing_j_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_link_susp.bxs_bushing_j_4))  &
   relative_to = ._modello_front_susp.ges_link_susp
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_link_susp.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_link_susp.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_link_susp))  &
   relative_to = ._modello_front_susp.ges_link_susp
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_link_susp.gralin_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_susp_link_to_axle))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ground.hps_susp_link_to_axle, ._modello_front_susp.ground.hps_susp_link_to_fork, "Z"))  &
   relative_to = ._modello_front_susp.ges_link_susp
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushing_i_1  &
   location =   &
      (._modello_front_susp.bgs_link_susp_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgs_link_susp_to_axle.i_tolerance}, ._modello_front_susp.bgs_link_susp_to_axle) : LOC_RELATIVE_TO({._modello_front_susp.bgs_link_susp_to_axle.i_tolerance[1], ._modello_front_susp.bgs_link_susp_to_axle.i_tolerance[2], ._modello_front_susp.bgs_link_susp_to_axle.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgs_link_susp_to_axle.loc, ._modello_front_susp.bgs_link_susp_to_axle.parent.ground.origo), ._modello_front_susp.bgs_link_susp_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgs_link_susp_to_axle))  &
   relative_to = ._modello_front_susp.ges_link_susp
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushgeom_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgs_link_susp_to_axle.geoLength / 2}, ._modello_front_susp.ges_link_susp.bxs_bushing_i_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.ges_link_susp.bxs_bushing_i_1))  &
   relative_to = ._modello_front_susp.ges_link_susp
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushing_i_2  &
   location =   &
      (._modello_front_susp.bgs_link_susp_to_fork.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgs_link_susp_to_fork.i_tolerance}, ._modello_front_susp.bgs_link_susp_to_fork) : LOC_RELATIVE_TO({._modello_front_susp.bgs_link_susp_to_fork.i_tolerance[1], ._modello_front_susp.bgs_link_susp_to_fork.i_tolerance[2], ._modello_front_susp.bgs_link_susp_to_fork.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgs_link_susp_to_fork.loc, ._modello_front_susp.bgs_link_susp_to_fork.parent.ground.origo), ._modello_front_susp.bgs_link_susp_to_fork.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgs_link_susp_to_fork))  &
   relative_to = ._modello_front_susp.ges_link_susp
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_link_susp.bxs_bushgeom_i_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgs_link_susp_to_fork.geoLength / 2}, ._modello_front_susp.ges_link_susp.bxs_bushing_i_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.ges_link_susp.bxs_bushing_i_2))  &
   relative_to = ._modello_front_susp.ges_link_susp
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_link_susp.coomarker_12  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_ride_height_ref))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_ride_height_ref))  &
   relative_to = ._modello_front_susp.ges_link_susp
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
geometry modify shape cylinder  &
   cylinder_name = ._modello_front_susp.ges_link_susp.gralin_susp_link  &
   length = (DM(._modello_front_susp.ground.hps_susp_link_to_axle, ._modello_front_susp.ground.hps_susp_link_to_fork))
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_link_susp  &
   location =   &
      (LOC_CENTERED({._modello_front_susp.ground.hps_susp_link_to_axle.loc, ._modello_front_susp.ground.hps_susp_link_to_fork.loc}, 2))
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bus_bumpstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_bumper_upper))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushing_j_4  &
   location =   &
      (._modello_front_susp.bgl_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgl_top_mount.j_tolerance}, ._modello_front_susp.bgl_top_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgl_top_mount.j_tolerance[1], ._modello_front_susp.bgl_top_mount.j_tolerance[2], ._modello_front_susp.bgl_top_mount.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgl_top_mount.loc, ._modello_front_susp.bgl_top_mount.parent.ground.origo), ._modello_front_susp.bgl_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgl_top_mount))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushgeom_j_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgl_top_mount.geoLength / 2}, ._modello_front_susp.mts_str_fork.bxl_bushing_j_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork.bxl_bushing_j_4))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushing_j_4  &
   location =   &
      (._modello_front_susp.bgr_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgr_top_mount.j_tolerance}, ._modello_front_susp.bgr_top_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgr_top_mount.j_tolerance[1], ._modello_front_susp.bgr_top_mount.j_tolerance[2], ._modello_front_susp.bgr_top_mount.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgr_top_mount.loc, ._modello_front_susp.bgr_top_mount.parent.ground.origo), ._modello_front_susp.bgr_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgr_top_mount))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushgeom_j_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgr_top_mount.geoLength / 2}, ._modello_front_susp.mts_str_fork.bxr_bushing_j_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork.bxr_bushing_j_4))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.jxl_joint_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpl_top_mount))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_front_susp.mts_str_fork.jxl_joint_j_1, ._modello_front_susp.ground.hpl_strut_lwr_mount, ._modello_front_susp.ground.cfl_top_mount_jprim_ref1, "Z_ZX"))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.jxr_joint_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_top_mount))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_front_susp.mts_str_fork.jxr_joint_j_1, ._modello_front_susp.ground.hpr_strut_lwr_mount, ._modello_front_susp.ground.cfr_top_mount_jprim_ref1, "Z_ZX"))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushing_j_3  &
   location =   &
      (._modello_front_susp.bgs_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgs_top_mount.j_tolerance}, ._modello_front_susp.bgs_top_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgs_top_mount.j_tolerance[1], ._modello_front_susp.bgs_top_mount.j_tolerance[2], ._modello_front_susp.bgs_top_mount.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgs_top_mount.loc, ._modello_front_susp.bgs_top_mount.parent.ground.origo), ._modello_front_susp.bgs_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgs_top_mount))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushgeom_j_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgs_top_mount.geoLength / 2}, ._modello_front_susp.mts_str_fork.bxs_bushing_j_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork.bxs_bushing_j_3))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.jxs_joint_j_3  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_top_mount))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_front_susp.mts_str_fork.jxs_joint_j_3, ._modello_front_susp.ground.hps_strut_lwr_mount, ._modello_front_susp.ground.cfs_top_mount_jprim_ref, "Z_ZX"))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushing_j_2  &
   location =   &
      (._modello_front_susp.bgs_link_susp_to_fork.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgs_link_susp_to_fork.j_tolerance}, ._modello_front_susp.bgs_link_susp_to_fork) : LOC_RELATIVE_TO({._modello_front_susp.bgs_link_susp_to_fork.j_tolerance[1], ._modello_front_susp.bgs_link_susp_to_fork.j_tolerance[2], ._modello_front_susp.bgs_link_susp_to_fork.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgs_link_susp_to_fork.loc, ._modello_front_susp.bgs_link_susp_to_fork.parent.ground.origo), ._modello_front_susp.bgs_link_susp_to_fork.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgs_link_susp_to_fork))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxs_bushgeom_j_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgs_link_susp_to_fork.geoLength / 2}, ._modello_front_susp.mts_str_fork.bxs_bushing_j_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork.bxs_bushing_j_2))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.kp2_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_dummy_susp_par_upper_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.kp2_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_dummy_susp_par_upper_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushing_j_2  &
   location =   &
      (._modello_front_susp.bgl_fork_to_link.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgl_fork_to_link.j_tolerance}, ._modello_front_susp.bgl_fork_to_link) : LOC_RELATIVE_TO({._modello_front_susp.bgl_fork_to_link.j_tolerance[1], ._modello_front_susp.bgl_fork_to_link.j_tolerance[2], ._modello_front_susp.bgl_fork_to_link.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgl_fork_to_link.loc, ._modello_front_susp.bgl_fork_to_link.parent.ground.origo), ._modello_front_susp.bgl_fork_to_link.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgl_fork_to_link))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxl_bushgeom_j_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgl_fork_to_link.geoLength / 2}, ._modello_front_susp.mts_str_fork.bxl_bushing_j_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork.bxl_bushing_j_2))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushing_j_2  &
   location =   &
      (._modello_front_susp.bgr_fork_to_link.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgr_fork_to_link.j_tolerance}, ._modello_front_susp.bgr_fork_to_link) : LOC_RELATIVE_TO({._modello_front_susp.bgr_fork_to_link.j_tolerance[1], ._modello_front_susp.bgr_fork_to_link.j_tolerance[2], ._modello_front_susp.bgr_fork_to_link.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgr_fork_to_link.loc, ._modello_front_susp.bgr_fork_to_link.parent.ground.origo), ._modello_front_susp.bgr_fork_to_link.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgr_fork_to_link))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bxr_bushgeom_j_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgr_fork_to_link.geoLength / 2}, ._modello_front_susp.mts_str_fork.bxr_bushing_j_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork.bxr_bushing_j_2))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bur_bumpstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpr_bumper_upper))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.mts_str_fork.bul_bumpstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_bumper_upper))  &
   relative_to = ._modello_front_susp.mts_str_fork
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.mts_str_fork  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_str_fork_lower_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
marker modify  &
   marker_name = ._modello_front_susp.ges_spindle.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_spindle.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_spindle))  &
   relative_to = ._modello_front_susp.ges_spindle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_spindle.jxs_joint_i_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_axle.jxs_joint_j_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_axle.jxs_joint_j_2))  &
   relative_to = ._modello_front_susp.ges_spindle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_spindle  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_wheel_center))
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.mas_kingpin_axis  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.origo))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.mas_wheel_center  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.cfs_wheel_center))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.gralin_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hps_susp_link_to_axle))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ground.hps_susp_link_to_axle, ._modello_front_susp.ground.hps_wheel_center, "Z"))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.bxs_bushing_j_1  &
   location =   &
      (._modello_front_susp.bgs_link_susp_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgs_link_susp_to_axle.j_tolerance}, ._modello_front_susp.bgs_link_susp_to_axle) : LOC_RELATIVE_TO({._modello_front_susp.bgs_link_susp_to_axle.j_tolerance[1], ._modello_front_susp.bgs_link_susp_to_axle.j_tolerance[2], ._modello_front_susp.bgs_link_susp_to_axle.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgs_link_susp_to_axle.loc, ._modello_front_susp.bgs_link_susp_to_axle.parent.ground.origo), ._modello_front_susp.bgs_link_susp_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgs_link_susp_to_axle))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.bxs_bushgeom_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgs_link_susp_to_axle.geoLength / 2}, ._modello_front_susp.ges_axle.bxs_bushing_j_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_axle.bxs_bushing_j_1))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.kp1_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_dummy_susp_par_lower_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.kp1_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_dummy_susp_par_lower_bearing))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.bxl_bushing_j_3  &
   location =   &
      (._modello_front_susp.bgl_susp_link_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgl_susp_link_to_axle.j_tolerance}, ._modello_front_susp.bgl_susp_link_to_axle) : LOC_RELATIVE_TO({._modello_front_susp.bgl_susp_link_to_axle.j_tolerance[1], ._modello_front_susp.bgl_susp_link_to_axle.j_tolerance[2], ._modello_front_susp.bgl_susp_link_to_axle.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgl_susp_link_to_axle.loc, ._modello_front_susp.bgl_susp_link_to_axle.parent.ground.origo), ._modello_front_susp.bgl_susp_link_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgl_susp_link_to_axle))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.bxl_bushgeom_j_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgl_susp_link_to_axle.geoLength / 2}, ._modello_front_susp.ges_axle.bxl_bushing_j_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_axle.bxl_bushing_j_3))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.bxr_bushing_j_3  &
   location =   &
      (._modello_front_susp.bgr_susp_link_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgr_susp_link_to_axle.j_tolerance}, ._modello_front_susp.bgr_susp_link_to_axle) : LOC_RELATIVE_TO({._modello_front_susp.bgr_susp_link_to_axle.j_tolerance[1], ._modello_front_susp.bgr_susp_link_to_axle.j_tolerance[2], ._modello_front_susp.bgr_susp_link_to_axle.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgr_susp_link_to_axle.loc, ._modello_front_susp.bgr_susp_link_to_axle.parent.ground.origo), ._modello_front_susp.bgr_susp_link_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgr_susp_link_to_axle))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.bxr_bushgeom_j_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgr_susp_link_to_axle.geoLength / 2}, ._modello_front_susp.ges_axle.bxr_bushing_j_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_axle.bxr_bushing_j_3))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.jxs_joint_j_2  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.cfs_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 0.0, 0.0}degrees, ._modello_front_susp.ground.cfs_wheel_center))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_axle.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ges_axle))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.gralin_5  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_susp_link_to_axle))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ground.hpl_susp_link_to_axle, ._modello_front_susp.ground.hpr_susp_link_to_axle, "Z"))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.coomarker_9  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_spindle_rise))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_spindle_rise))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.coomarker_10  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_wheel_center_marker_ori))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_wheel_center_marker_ori))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ges_axle.coomarker_11  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_wheel_center))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_wheel_center))  &
   relative_to = ._modello_front_susp.ges_axle
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
geometry modify shape cylinder  &
   cylinder_name = ._modello_front_susp.ges_axle.gralin_axle  &
   length = (DM(._modello_front_susp.ground.hpl_susp_link_to_axle, ._modello_front_susp.ground.hpr_susp_link_to_axle))
!
geometry modify shape cylinder  &
   cylinder_name = ._modello_front_susp.ges_axle.gralin_axle_1  &
   length = (DM(._modello_front_susp.ground.hps_susp_link_to_axle, ._modello_front_susp.ground.hps_wheel_center))
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.ges_axle  &
   location =   &
      (LOC_CENTERED({._modello_front_susp.ground.hpl_susp_link_to_axle.loc, ._modello_front_susp.ground.hpr_susp_link_to_axle.loc}, 2))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ground.hpl_susp_link_to_axle, ._modello_front_susp.ground.hpr_susp_link_to_axle, "Z"))
!
marker modify  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushing_i_2  &
   location =   &
      (._modello_front_susp.bgl_fork_to_link.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgl_fork_to_link.i_tolerance}, ._modello_front_susp.bgl_fork_to_link) : LOC_RELATIVE_TO({._modello_front_susp.bgl_fork_to_link.i_tolerance[1], ._modello_front_susp.bgl_fork_to_link.i_tolerance[2], ._modello_front_susp.bgl_fork_to_link.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgl_fork_to_link.loc, ._modello_front_susp.bgl_fork_to_link.parent.ground.origo), ._modello_front_susp.bgl_fork_to_link.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgl_fork_to_link))  &
   relative_to = ._modello_front_susp.gel_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushgeom_i_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgl_fork_to_link.geoLength / 2}, ._modello_front_susp.gel_susp_link.bxl_bushing_i_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.gel_susp_link.bxl_bushing_i_2))  &
   relative_to = ._modello_front_susp.gel_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushing_i_3  &
   location =   &
      (._modello_front_susp.bgl_susp_link_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgl_susp_link_to_axle.i_tolerance}, ._modello_front_susp.bgl_susp_link_to_axle) : LOC_RELATIVE_TO({._modello_front_susp.bgl_susp_link_to_axle.i_tolerance[1], ._modello_front_susp.bgl_susp_link_to_axle.i_tolerance[2], ._modello_front_susp.bgl_susp_link_to_axle.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgl_susp_link_to_axle.loc, ._modello_front_susp.bgl_susp_link_to_axle.parent.ground.origo), ._modello_front_susp.bgl_susp_link_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgl_susp_link_to_axle))  &
   relative_to = ._modello_front_susp.gel_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushgeom_i_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgl_susp_link_to_axle.geoLength / 2}, ._modello_front_susp.gel_susp_link.bxl_bushing_i_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.gel_susp_link.bxl_bushing_i_3))  &
   relative_to = ._modello_front_susp.gel_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_susp_link.gralin_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_susp_link_to_axle))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ground.hpl_susp_link_to_axle, ._modello_front_susp.ground.hpl_susp_link_to_fork, "Z"))  &
   relative_to = ._modello_front_susp.gel_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_susp_link.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.gel_susp_link.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.gel_susp_link))  &
   relative_to = ._modello_front_susp.gel_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushing_j_1  &
   location =   &
      (._modello_front_susp.bgl_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgl_bottom_mount.j_tolerance}, ._modello_front_susp.bgl_bottom_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgl_bottom_mount.j_tolerance[1], ._modello_front_susp.bgl_bottom_mount.j_tolerance[2], ._modello_front_susp.bgl_bottom_mount.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgl_bottom_mount.loc, ._modello_front_susp.bgl_bottom_mount.parent.ground.origo), ._modello_front_susp.bgl_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgl_bottom_mount))  &
   relative_to = ._modello_front_susp.gel_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_susp_link.bxl_bushgeom_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgl_bottom_mount.geoLength / 2}, ._modello_front_susp.gel_susp_link.bxl_bushing_j_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.gel_susp_link.bxl_bushing_j_1))  &
   relative_to = ._modello_front_susp.gel_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_susp_link.coomarker_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_lwr_strut_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_lwr_strut_mount))  &
   relative_to = ._modello_front_susp.gel_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
geometry modify shape cylinder  &
   cylinder_name = ._modello_front_susp.gel_susp_link.gralin_susp_link  &
   length = (DM(._modello_front_susp.ground.hpl_susp_link_to_axle, ._modello_front_susp.ground.hpl_susp_link_to_fork))
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.gel_susp_link  &
   location =   &
      (LOC_CENTERED({._modello_front_susp.ground.hpl_susp_link_to_fork.loc, ._modello_front_susp.ground.hpl_susp_link_to_axle.loc}, 2))
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushing_i_2  &
   location =   &
      (._modello_front_susp.bgr_fork_to_link.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgr_fork_to_link.i_tolerance}, ._modello_front_susp.bgr_fork_to_link) : LOC_RELATIVE_TO({._modello_front_susp.bgr_fork_to_link.i_tolerance[1], ._modello_front_susp.bgr_fork_to_link.i_tolerance[2], ._modello_front_susp.bgr_fork_to_link.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgr_fork_to_link.loc, ._modello_front_susp.bgr_fork_to_link.parent.ground.origo), ._modello_front_susp.bgr_fork_to_link.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgr_fork_to_link))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushgeom_i_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgr_fork_to_link.geoLength / 2}, ._modello_front_susp.ger_susp_link.bxr_bushing_i_2))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.ger_susp_link.bxr_bushing_i_2))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushing_i_3  &
   location =   &
      (._modello_front_susp.bgr_susp_link_to_axle.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgr_susp_link_to_axle.i_tolerance}, ._modello_front_susp.bgr_susp_link_to_axle) : LOC_RELATIVE_TO({._modello_front_susp.bgr_susp_link_to_axle.i_tolerance[1], ._modello_front_susp.bgr_susp_link_to_axle.i_tolerance[2], ._modello_front_susp.bgr_susp_link_to_axle.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgr_susp_link_to_axle.loc, ._modello_front_susp.bgr_susp_link_to_axle.parent.ground.origo), ._modello_front_susp.bgr_susp_link_to_axle.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgr_susp_link_to_axle))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushgeom_i_3  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgr_susp_link_to_axle.geoLength / 2}, ._modello_front_susp.ger_susp_link.bxr_bushing_i_3))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.ger_susp_link.bxr_bushing_i_3))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.gralin_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpr_susp_link_to_axle))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ground.hpr_susp_link_to_axle, ._modello_front_susp.ground.hpr_susp_link_to_fork, "Z"))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ger_susp_link.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ger_susp_link))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushing_j_1  &
   location =   &
      (._modello_front_susp.bgr_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgr_bottom_mount.j_tolerance}, ._modello_front_susp.bgr_bottom_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgr_bottom_mount.j_tolerance[1], ._modello_front_susp.bgr_bottom_mount.j_tolerance[2], ._modello_front_susp.bgr_bottom_mount.j_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgr_bottom_mount.loc, ._modello_front_susp.bgr_bottom_mount.parent.ground.origo), ._modello_front_susp.bgr_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgr_bottom_mount))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.bxr_bushgeom_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgr_bottom_mount.geoLength / 2}, ._modello_front_susp.ger_susp_link.bxr_bushing_j_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ger_susp_link.bxr_bushing_j_1))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.coomarker_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_lwr_strut_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_lwr_strut_mount))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_susp_link.coomarker_12  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_ride_height_ref))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfs_ride_height_ref))  &
   relative_to = ._modello_front_susp.ger_susp_link
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
geometry modify shape cylinder  &
   cylinder_name = ._modello_front_susp.ger_susp_link.gralin_susp_link  &
   length = (DM(._modello_front_susp.ground.hpr_susp_link_to_axle, ._modello_front_susp.ground.hpr_susp_link_to_fork))
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.ger_susp_link  &
   location =   &
      (LOC_CENTERED({._modello_front_susp.ground.hpr_susp_link_to_fork.loc, ._modello_front_susp.ground.hpr_susp_link_to_axle.loc}, 2))
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.coomarker_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_top_mount))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.rel_reboundstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_strut_lwr_mount))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.bxl_bushing_i_4  &
   location =   &
      (._modello_front_susp.bgl_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgl_top_mount.i_tolerance}, ._modello_front_susp.bgl_top_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgl_top_mount.i_tolerance[1], ._modello_front_susp.bgl_top_mount.i_tolerance[2], ._modello_front_susp.bgl_top_mount.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgl_top_mount.loc, ._modello_front_susp.bgl_top_mount.parent.ground.origo), ._modello_front_susp.bgl_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgl_top_mount))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.bxl_bushgeom_i_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgl_top_mount.geoLength / 2}, ._modello_front_susp.gel_upper_strut.bxl_bushing_i_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.gel_upper_strut.bxl_bushing_i_4))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.jxl_joint_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork.jxl_joint_j_1))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_front_susp.gel_upper_strut.jxl_joint_i_1, ._modello_front_susp.ground.cfl_top_mount_jprim_ref1, ._modello_front_susp.ground.hpl_strut_lwr_mount, "Z_ZX"))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.jxl_joint_j_10  &
   location =   &
      (LOC_RELATIVE_TO(LOC_CENTERED({._modello_front_susp.ground.hpl_top_mount.loc, ._modello_front_susp.ground.hpl_strut_lwr_mount.loc}, 2), ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.gel_upper_strut.jxl_joint_j_10, ._modello_front_susp.ground.hpl_top_mount, "Z"))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.jklhoo_top_mount_kinematic_1  &
   location =   &
      (LOC_RELATIVE_TO(._modello_front_susp.ground.cfl_top_mount_ext.location, ._modello_front_susp.ground.cfl_top_mount_ext.parent))  &
   orientation =   &
      (ORI_RELATIVE_TO(._modello_front_susp.ground.cfl_top_mount_ext.orientation, ._modello_front_susp.ground.cfl_top_mount_ext.parent))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.dal_damper_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_top_mount))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.gel_upper_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.gel_upper_strut))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.nsl_spring_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_spring_upr_seat))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.bul_bumpstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_bumper_lower))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.dal_ride_damper_axial_ref_i  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_front_susp.dal_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.dal_ride_damper.i_marker, ._modello_front_susp.dal_ride_damper.j_marker, "z"))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_upper_strut.coomarker_5  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_spring_upr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_spring_upr_seat))  &
   relative_to = ._modello_front_susp.gel_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.gel_upper_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_front_susp.ground.hpl_top_mount, ._modello_front_susp.ground.hpl_strut_lwr_mount, 0.33 * DM(._modello_front_susp.ground.hpl_top_mount, ._modello_front_susp.ground.hpl_strut_lwr_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.gel_upper_strut, ._modello_front_susp.ground.hpl_top_mount, "Z"))
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.coomarker_2  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_top_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_top_mount))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.rer_reboundstop_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpr_strut_lwr_mount))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.bxr_bushing_i_4  &
   location =   &
      (._modello_front_susp.bgr_top_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgr_top_mount.i_tolerance}, ._modello_front_susp.bgr_top_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgr_top_mount.i_tolerance[1], ._modello_front_susp.bgr_top_mount.i_tolerance[2], ._modello_front_susp.bgr_top_mount.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgr_top_mount.loc, ._modello_front_susp.bgr_top_mount.parent.ground.origo), ._modello_front_susp.bgr_top_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgr_top_mount))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.bxr_bushgeom_i_4  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgr_top_mount.geoLength / 2}, ._modello_front_susp.ger_upper_strut.bxr_bushing_i_4))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.ger_upper_strut.bxr_bushing_i_4))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.jxr_joint_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.mts_str_fork.jxr_joint_j_1))  &
   orientation =   &
      (ORI_IN_PLANE(._modello_front_susp.ger_upper_strut.jxr_joint_i_1, ._modello_front_susp.ground.cfr_top_mount_jprim_ref1, ._modello_front_susp.ground.hpr_strut_lwr_mount, "Z_ZX"))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.jxr_joint_j_10  &
   location =   &
      (LOC_RELATIVE_TO(LOC_CENTERED({._modello_front_susp.ground.hpr_top_mount.loc, ._modello_front_susp.ground.hpr_strut_lwr_mount.loc}, 2), ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ger_upper_strut.jxr_joint_j_10, ._modello_front_susp.ground.hpr_top_mount, "Z"))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.jkrhoo_top_mount_kinematic_1  &
   location =   &
      (LOC_RELATIVE_TO(._modello_front_susp.ground.cfr_top_mount_ext.location, ._modello_front_susp.ground.cfr_top_mount_ext.parent))  &
   orientation =   &
      (ORI_RELATIVE_TO(._modello_front_susp.ground.cfr_top_mount_ext.orientation, ._modello_front_susp.ground.cfr_top_mount_ext.parent))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.dar_damper_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpr_top_mount))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ger_upper_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ger_upper_strut))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.nsr_spring_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpr_spring_upr_seat))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.bur_bumpstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpr_bumper_lower))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.dar_ride_damper_axial_ref_i  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_front_susp.dar_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.dar_ride_damper.i_marker, ._modello_front_susp.dar_ride_damper.j_marker, "z"))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_upper_strut.coomarker_6  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_spring_upr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_spring_upr_seat))  &
   relative_to = ._modello_front_susp.ger_upper_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.ger_upper_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_front_susp.ground.hpr_top_mount, ._modello_front_susp.ground.hpr_strut_lwr_mount, 0.33 * DM(._modello_front_susp.ground.hpr_top_mount, ._modello_front_susp.ground.hpr_strut_lwr_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ger_upper_strut, ._modello_front_susp.ground.hpr_top_mount, "Z"))
!
marker modify  &
   marker_name = ._modello_front_susp.ger_lower_strut.coomarker_8  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfr_spring_lwr_seat))  &
   relative_to = ._modello_front_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_lower_strut.rer_reboundstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpr_top_mount))  &
   relative_to = ._modello_front_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_lower_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ger_lower_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ger_lower_strut))  &
   relative_to = ._modello_front_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_lower_strut.dar_damper_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpr_strut_lwr_mount))  &
   relative_to = ._modello_front_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_lower_strut.nsr_spring_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpr_spring_lwr_seat))  &
   relative_to = ._modello_front_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_lower_strut.jxr_joint_i_10  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ger_upper_strut.jxr_joint_j_10))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ger_upper_strut.jxr_joint_j_10))  &
   relative_to = ._modello_front_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_lower_strut.bxr_bushing_i_1  &
   location =   &
      (._modello_front_susp.bgr_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgr_bottom_mount.i_tolerance}, ._modello_front_susp.bgr_bottom_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgr_bottom_mount.i_tolerance[1], ._modello_front_susp.bgr_bottom_mount.i_tolerance[2], ._modello_front_susp.bgr_bottom_mount.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgr_bottom_mount.loc, ._modello_front_susp.bgr_bottom_mount.parent.ground.origo), ._modello_front_susp.bgr_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgr_bottom_mount))  &
   relative_to = ._modello_front_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_lower_strut.bxr_bushgeom_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgr_bottom_mount.geoLength / 2}, ._modello_front_susp.ger_lower_strut.bxr_bushing_i_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.ger_lower_strut.bxr_bushing_i_1))  &
   relative_to = ._modello_front_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.ger_lower_strut.dar_ride_damper_axial_ref_j  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_front_susp.dar_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.dar_ride_damper.j_marker, ._modello_front_susp.dar_ride_damper.i_marker, "z"))  &
   relative_to = ._modello_front_susp.ger_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.ger_lower_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_front_susp.ground.hpr_top_mount, ._modello_front_susp.ground.hpr_strut_lwr_mount, 0.66 * DM(._modello_front_susp.ground.hpr_top_mount, ._modello_front_susp.ground.hpr_strut_lwr_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ger_lower_strut, ._modello_front_susp.ground.hpr_top_mount, "Z"))
!
marker modify  &
   marker_name = ._modello_front_susp.gel_lower_strut.coomarker_7  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_spring_lwr_seat))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.cfl_spring_lwr_seat))  &
   relative_to = ._modello_front_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_lower_strut.rel_reboundstop_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_top_mount))  &
   relative_to = ._modello_front_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_lower_strut.inertia_frame  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.gel_lower_strut.cm))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.gel_lower_strut))  &
   relative_to = ._modello_front_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_lower_strut.dal_damper_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_strut_lwr_mount))  &
   relative_to = ._modello_front_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_lower_strut.nsl_spring_j_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.hpl_spring_lwr_seat))  &
   relative_to = ._modello_front_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_lower_strut.jxl_joint_i_10  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.gel_upper_strut.jxl_joint_j_10))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.gel_upper_strut.jxl_joint_j_10))  &
   relative_to = ._modello_front_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_lower_strut.bxl_bushing_i_1  &
   location =   &
      (._modello_front_susp.bgl_bottom_mount.tolerance_coordinate == "local" ? LOC_RELATIVE_TO({._modello_front_susp.bgl_bottom_mount.i_tolerance}, ._modello_front_susp.bgl_bottom_mount) : LOC_RELATIVE_TO({._modello_front_susp.bgl_bottom_mount.i_tolerance[1], ._modello_front_susp.bgl_bottom_mount.i_tolerance[2], ._modello_front_susp.bgl_bottom_mount.i_tolerance[3]} + LOC_LOCAL(._modello_front_susp.bgl_bottom_mount.loc, ._modello_front_susp.bgl_bottom_mount.parent.ground.origo), ._modello_front_susp.bgl_bottom_mount.parent.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.bgl_bottom_mount))  &
   relative_to = ._modello_front_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_lower_strut.bxl_bushgeom_i_1  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, -._modello_front_susp.bgl_bottom_mount.geoLength / 2}, ._modello_front_susp.gel_lower_strut.bxl_bushing_i_1))  &
   orientation =   &
      (ORI_RELATIVE_TO({270deg, 0, 0}, ._modello_front_susp.gel_lower_strut.bxl_bushing_i_1))  &
   relative_to = ._modello_front_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
marker modify  &
   marker_name = ._modello_front_susp.gel_lower_strut.dal_ride_damper_axial_ref_j  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}, ._modello_front_susp.dal_ride_damper.i_marker.object_value))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.dal_ride_damper.j_marker, ._modello_front_susp.dal_ride_damper.i_marker, "z"))  &
   relative_to = ._modello_front_susp.gel_lower_strut
!
defaults coordinate_system  &
   default_coordinate_system = ._modello_front_susp.ground
!
part modify rigid_body name_and_position  &
   part_name = ._modello_front_susp.gel_lower_strut  &
   location =   &
      (LOC_ALONG_LINE(._modello_front_susp.ground.hpl_top_mount, ._modello_front_susp.ground.hpl_strut_lwr_mount, 0.66 * DM(._modello_front_susp.ground.hpl_top_mount, ._modello_front_susp.ground.hpl_strut_lwr_mount)))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.gel_lower_strut, ._modello_front_susp.ground.hpl_top_mount, "Z"))
!
output_control modify request  &
   request_name = ._modello_front_susp.toe_camber_caster  &
   user_function =   &
      1101.0,  &
      0.0,  &
      (._modello_front_susp.ges_axle.mas_kingpin_axis.adams_id),  &
      (._modello_front_susp.ges_axle.mas_wheel_center.adams_id),  &
      0.0,  &
      (._modello_front_susp.ges_axle.mas_kingpin_axis.adams_id),  &
      (._modello_front_susp.ges_axle.mas_wheel_center.adams_id),  &
      (._modello_front_susp.cis_chassis_reference_adams_id),  &
      0.0,  &
      (._modello_front_susp.ground.origo.adams_id)  &
   routine = "acar_solver::reqsub"
!
group modify  &
   group_name = ._modello_front_susp.top_mount_kinematic  &
   expr_active = (._modello_front_susp.cnl_top_mount.method == "joint" && ._modello_front_susp.cnl_top_mount.joint_type == "spherical" && DB_ACTIVE(._modello_front_susp))
!
group modify  &
   group_name = ._modello_front_susp.suspension_link_type_dual  &
   expr_active = ((._modello_front_susp.pvs_suspension_link_type == 2 ? 1 : 0) && DB_ACTIVE(._modello_front_susp))
!
group modify  &
   group_name = ._modello_front_susp.single_top_mount_kinematic  &
   expr_active = (._modello_front_susp.cns_top_mount.method == "joint" && ._modello_front_susp.cns_top_mount.joint_type == "spherical" && DB_ACTIVE(._modello_front_susp))
!
group modify  &
   group_name = ._modello_front_susp.kinematic_mode_active  &
   expr_active = ((._modello_front_susp.phs_kinematic_flag || ._modello_front_susp.model_class == "template" ? 1 : 0) && DB_ACTIVE(._modello_front_susp))
!
group modify  &
   group_name = ._modello_front_susp.kinematic_mode_inactive  &
   expr_active = (( ! ._modello_front_susp.phs_kinematic_flag || ._modello_front_susp.model_class == "template" ? 1 : 0) && DB_ACTIVE(._modello_front_susp))
!
group modify  &
   group_name = ._modello_front_susp.driveline_active  &
   expr_active = ((._modello_front_susp.phs_driveline_active || ._modello_front_susp.model_class == "template" ? 1 : 0) && DB_ACTIVE(._modello_front_susp))
!
group modify  &
   group_name = ._modello_front_susp.driveline_inactive  &
   expr_active = (( ! ._modello_front_susp.phs_driveline_active || ._modello_front_susp.model_class == "template" ? 1 : 0) && DB_ACTIVE(._modello_front_susp))
!
group modify  &
   group_name = ._modello_front_susp.suspension_link_type_single  &
   expr_active = ((._modello_front_susp.pvs_suspension_link_type == 1 ? 1 : 0) && DB_ACTIVE(._modello_front_susp))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bus_jounce_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.res_rebound_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.das_ride_damper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpl_top_mount))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.bgl_top_mount, ._modello_front_susp.ground.hpl_strut_lwr_mount, "Z"))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_top_mount))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.bgr_top_mount, ._modello_front_susp.ground.hpr_strut_lwr_mount, "Z"))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_top_mount))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.bgs_top_mount, ._modello_front_susp.ground.hps_strut_lwr_mount, "Z"))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_strut_lwr_mount))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 90.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_top_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.nss_ride_spring  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_fork_to_link  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpl_susp_link_to_fork))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ground.hpl_susp_link_to_fork, ._modello_front_susp.ground.hpr_susp_link_to_fork, "Z"))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_fork_to_link  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_susp_link_to_fork))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.ground.hpr_susp_link_to_fork, ._modello_front_susp.ground.hpl_susp_link_to_fork, "Z"))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_fork_to_link  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_fork_to_link  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_susp_link_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpl_susp_link_to_axle))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, -90.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_susp_link_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_susp_link_to_axle))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 90.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_susp_link_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_susp_link_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnl_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cnr_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.nsl_ride_spring  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_front_susp.nsr_ride_spring  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_front_susp.rel_rebound_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_front_susp.rer_rebound_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgl_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpl_strut_lwr_mount))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.bgl_bottom_mount, ._modello_front_susp.ground.hpr_strut_lwr_mount, "Z"))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgr_bottom_mount  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hpr_strut_lwr_mount))  &
   orientation =   &
      (ORI_ALONG_AXIS(._modello_front_susp.bgr_bottom_mount, ._modello_front_susp.ground.hpl_strut_lwr_mount, "Z"))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bul_jounce_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bur_jounce_bumper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_front_susp.dal_ride_damper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_front_susp.dar_ride_damper  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_susp_link_to_axle))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 90.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_link_susp_to_axle  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.bgs_link_susp_to_fork  &
   location =   &
      (LOC_RELATIVE_TO({0.0, 0.0, 0.0}mm, ._modello_front_susp.ground.hps_susp_link_to_fork))  &
   orientation =   &
      (ORI_RELATIVE_TO({0.0, 90.0, 0.0}degrees, ._modello_front_susp.ground.origo))
!
ude modify instance  &
   instance_name = ._modello_front_susp.cns_link_susp_to_fork  &
   location =   &
      (LOC_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))  &
   orientation =   &
      (ORI_RELATIVE_TO({0, 0, 0}, ._modello_front_susp.ground.origo))
!
variable modify  &
   variable_name = ._modello_front_susp.cos_wheel_center  &
   real_value = (._modello_front_susp.ground.hps_wheel_center.location)
!
variable modify  &
   variable_name = ._modello_front_susp.cis_characteristics_input_ARRAY_adams_id  &
   integer_value = (._modello_front_susp.cis_characteristics_input_ARRAY.object_value.adams_id)
!
variable modify  &
   variable_name = ._modello_front_susp.cis_str_fork.minor_role  &
   string_value = (._modello_front_susp.mts_str_fork.minor_role)
!
variable modify  &
   variable_name = ._modello_front_susp.cis_str_fork.subsystem_index  &
   string_value = (._modello_front_susp.mts_str_fork.subsystem_index)
!
variable modify  &
   variable_name = ._modello_front_susp.cis_str_fork  &
   comments = ("Autocreated for mount part: " // ._modello_front_susp.cis_str_fork[2].name)
!
variable modify  &
   variable_name = ._modello_front_susp.cis_chassis_reference_adams_id  &
   integer_value = (._modello_front_susp.cis_chassis_reference.object_value.adams_id)
!
variable modify  &
   variable_name = ._modello_front_susp.cos_svs_ride_height  &
   object_value = (._modello_front_susp.pvs_suspension_link_type == 2 ? ._modello_front_susp.ger_susp_link.coomarker_12 : ._modello_front_susp.ges_link_susp.coomarker_12)
!
model display  &
   model_name = _modello_front_susp
