close all
clear
clc

%% PRW
load("SonyMurata_US18650VTC6_phase_37.mat");
load("PRW_SOC.mat")
load("SOH_predict.mat")
%% PRW
for i=1:52
    Current_37{i, 1}=meas37{i, 1}.Current;
    Voltage_37{i, 1}=meas37{i, 1}.Voltage(:,3)  ;
    Temperature_37{i, 1}=meas37{i, 1}.Temperature(:,3);
    simtime_37{i, 1}=length(meas37{i, 1}.Current);
end

for i=1:52
    Current37(i) =timeseries(Current_37{i, 1}');
    Voltage37(i)=timeseries(Voltage_37{i, 1}');
    Temperature37(i)=timeseries(Temperature_37{i, 1}');
    SOC_37_GT(i)=timeseries(SOC37{i, 1});
    simtime(i)=simtime_37{i, 1};
    GT(i)=SOH_predict(i);
end

model = 'PRW_Cycle_5Class';

for i = 1:52
   
   in(i) = Simulink.SimulationInput(model);
   in(i) = in(i).setVariable('Current37', Current37(i));
   in(i) = in(i).setVariable('Voltage37', Voltage37(i));
   in(i) = in(i).setVariable('Temperature37',Temperature37(i));
   in(i) = in(i).setVariable('SOC_37_GT',SOC_37_GT(i));
   in(i) = in(i).setVariable('simtime',simtime(i));
   in(i) = in(i).setVariable('GT',GT(i));
end
%% Run batch simulation
simOut = sim(in, 'ShowSimulationManager', 'on');
%% 
%% SOC RMSE
for i=1:52
    SOC37RMSE(i,1)=mean(simOut(1, i).SOC_37_abserror)
end
SOC37RMSE_mean=mean(SOC37RMSE);
figure
plot(SOC37RMSE*100,'b', 'Linewidth', 2, 'MarkerSize', 2)
hold on
yline(SOC37RMSE_mean*100,'-','LineWidth',2);

xlabel("Number of cycle");
ylabel("RMSE% of SOC");
legend("PRW RMSE% of SOC","mean PRW RMSE%");

subplot(2,1,1)
plot(SOC37{29, 1},'b', 'Linewidth', 2, 'MarkerSize', 2)
hold on
plot(simOut(1, 29).SOC_37_pred,'r', 'Linewidth', 2, 'MarkerSize', 2)
xlabel("Number of data");
ylabel("SOC");
legend("SOC ground truth","SOC predict");
title('PRW dicharging Cycle29-SOC prediction of 5-Class option')

