close all
clear
clc
%% Charging 
load("SOH_p01.mat");
load("SonyMurata_US18650VTC6_phase_1_Charging.mat");
load("SonyMurata_US18650VTC6_phase_1_capacity.mat");
load("SOH_all_params.mat");
load("SOC.mat");

%% Charging

GT=1
for i=1:length(meas)
    Current_og{i, 1}=meas{i, 1}.Current;
    Voltage_og{i, 1}=meas{i, 1}.Voltage(:,3)  ;
    Temperature_og{i, 1}=meas{i, 1}.Temperature(:,3);
    simtime_og{i, 1}=length(meas{i, 1}.Current);
    SOC_GT_og{i,1}=SOC{i, 1};
end


%% One charging cycle each time
SOH_predict=1;
i = 1
tic
for j=1:52
  
   Current=timeseries(Current_og{i, 1});
   Voltage=timeseries(Voltage_og{i, 1});
   Temperature=timeseries(Temperature_og{i, 1});
   SOC_GT=timeseries(SOC_GT_og{i, 1});
   simtime=cell2mat(simtime_og(i));
   sim('Combined_net_3Class')   % modify the model name:1,3,5Class
   SOH_predict=double(ans.SOHout(simtime));
   SOH_saveresult(i,1)=SOH_predict;
   error(i,1)=SOH_predict-SOH_p01(i,1);
   SOC_abserror{i, 1}=ans.SOC_abserror;

   i=i+1
end
toc
%                       
                          
%% SOH RMSE
for i=1:52
error(i,1)=SOH_saveresult(i,1)-SOH_p01(i,1);
end
SOHRMSE= sqrt(sum(error.^2)/length(meas))*100
%% SOC RMSE
for i=1:52
    SOCRMSE(i,1)=mean(SOC_abserror{i, 1});
end
SOCRMSE_mean=mean(SOCRMSE);
figure
plot(SOCRMSE*100,'b', 'Linewidth', 2, 'MarkerSize', 2)
hold on
yline(SOCRMSE_mean*100,'-','LineWidth',2);

xlabel("Number of cycle");
ylabel("RMSE% of SOC");
legend("RMSE% of SOC","mean RMSE");



%% SOHRMSE
figure
plot(SOH_saveresult,'b', 'Linewidth', 2, 'MarkerSize', 2);
hold on 
plot(SOH_p01,'r-', 'Linewidth', 2, 'MarkerSize', 2);
xlabel("Number of data");
ylabel("SOH");
legend("SOH predict","SOH ground truth");
% figure
% plot(SOC{1, 1},'b', 'Linewidth', 2, 'MarkerSize', 2)
% hold on
% plot(simOut(1, 1).SOCout,'r', 'Linewidth', 2, 'MarkerSize', 2)
% xlabel("Number of data");
% ylabel("SOC");
% legend("SOC ground truth","SOC predict");