/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.worker;

import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.wizard.worker.Worker;
import com.mathworks.wizard.worker.WorkerListener;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

final class WorkerImpl<T>
extends SwingWorker<T, Object>
implements Worker<T> {
    private final Callable<T> task;
    private final WorkerListener<T> workerListener;
    private final ExceptionHandler exceptionHandler;

    WorkerImpl(Callable<T> callable, WorkerListener<T> workerListener, ExceptionHandler exceptionHandler) {
        this.task = callable;
        this.workerListener = workerListener;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    protected T doInBackground() throws Exception {
        return this.task.call();
    }

    @Override
    protected void done() {
        if (this.isCancelled()) {
            this.workerListener.cancelled();
        } else {
            try {
                Object t = this.get();
                this.workerListener.done(t);
            }
            catch (InterruptedException interruptedException) {
                this.workerListener.cancelled();
            }
            catch (ExecutionException executionException) {
                this.exceptionHandler.uncaughtException(Thread.currentThread(), (Throwable)executionException);
            }
        }
    }
}

