/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.silent;

import com.google.inject.Inject;
import com.mathworks.install_task.BackgroundTask;
import com.mathworks.instutil.AvailablePlatform;
import com.mathworks.instutil.LicenseNumberProvider;
import com.mathworks.instutil.MinimalProducts;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ExitStatus;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.StepCallback;
import com.mathworks.wizard.model.AccessibleTableFormat;
import com.mathworks.wizard.model.ConnectionMode;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.model.FileSystem;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.OptionSelectedState;
import com.mathworks.wizard.model.PlatformModel;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.ui.CheckBoxConfiguration;
import com.mathworks.wizard.ui.panels.AbstractLoggingStep;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import com.mathworks.wizard.ui.silent.SilentResourceKeys;
import java.io.File;
import java.util.Collection;
import javax.swing.ImageIcon;

final class SilentPanelStepBuilder
implements PanelStepBuilder {
    private final ExitHandler exitHandler;
    private AppLogger appLogger;

    @Inject
    SilentPanelStepBuilder(ExitHandler exitHandler, AppLogger appLogger) {
        this.exitHandler = exitHandler;
        this.appLogger = appLogger;
    }

    @Override
    public Step buildWelcomeStep(Model<ConnectionMode> model, Step step) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildInstallAgentWelcomeStep(Step step, String string, String string2) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildLicenseAgreementStep(Model<Boolean> model, String string) {
        if (!model.get().booleanValue()) {
            return new ExitImmediatelyStep(SilentResourceKeys.LICENSE_AGREEMENT_ERROR);
        }
        return new SilentPanelStep();
    }

    @Override
    public Step buildFikStep(Model<Boolean> model, Model<String> model2) {
        if (model2.get().length() == 0) {
            return new ExitImmediatelyStep(SilentResourceKeys.FIK_ERROR);
        }
        return new SilentPanelStep();
    }

    @Override
    public Step buildLicenseNumberStep(LicenseNumberProvider licenseNumberProvider) {
        if (licenseNumberProvider.getLicenseNumber().trim().isEmpty() || licenseNumberProvider.getLicenseNumber().trim().equalsIgnoreCase("true")) {
            return new ExitImmediatelyStep(SilentResourceKeys.LICENSE_NUMBER_ERROR);
        }
        return new SilentPanelStep();
    }

    @Override
    public Step buildNextStepsStep(String string) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildTypicalCustomStep(Model<Boolean> model, String string) {
        return new SilentPanelStep();
    }

    @Override
    public <T> Step buildProductSelectionStep(ProductModel<T> productModel, ProductTableFormat<T> productTableFormat, Model<MinimalProducts> model) {
        if (!productModel.anySelected()) {
            return new ExitImmediatelyStep(SilentResourceKeys.PRODUCT_SELECTION_ERROR);
        }
        return new SilentPanelStep();
    }

    @Override
    public Step createMCRAlreadyInstalledPanelStep(ImageIcon imageIcon, Model<String> model, Model<Boolean> model2) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildWindowsInstallationOptionsStep(InstallOptionModel installOptionModel, InstallOptionModel installOptionModel2) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildLinuxInstallationOptionsStep(InstallOptionModel installOptionModel) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildConfirmationStep(String string) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildConfirmationStep(String string, boolean bl) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildDownloadConfirmationStep(String string) {
        return new SilentPanelStep();
    }

    @Override
    public <T> Step buildDownloadProductSelectionStep(ProductModel<T> productModel, ProductTableFormat<T> productTableFormat) {
        if (!productModel.anySelected()) {
            return new ExitImmediatelyStep(SilentResourceKeys.PRODUCT_SELECTION_ERROR);
        }
        return new SilentPanelStep();
    }

    @Override
    public Step createMCRFolderSelectionPanelStep(DefaultedModel<String> defaultedModel, ImageIcon imageIcon) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildInstallAgentFinalPanel(String string, Model<File> model) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildTrialsWelcomePanelStep(Collection<String> collection) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildTrialsFinalPanelStep(Model<CheckBoxConfiguration> model) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildAddOnsUninstallerWelcomePanelStep(Collection<String> collection) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildAddOnsUninstallStatusStep(BackgroundTask backgroundTask) {
        return new Step(){

            @Override
            public void reverseVisitStep(StepCallback stepCallback) {
            }

            @Override
            public void forwardVisitStep(StepCallback stepCallback) {
            }
        };
    }

    @Override
    public Step buildMacInstallationOptionsStep() {
        return new SilentPanelStep();
    }

    @Override
    public Step build2SVStep(String string, Platform platform, Model<String> model, Model<String> model2, Model<String> model3) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildFinalPanelStep(Model<CheckBoxConfiguration> model, Model<CheckBoxConfiguration> model2, boolean bl, int n, String string, Model<Boolean> model3) {
        return new SilentPanelStep();
    }

    @Override
    public Step createCompatibilityErrorPanelStep(String string) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildFolderSelectionStep(DefaultedModel<String> defaultedModel) {
        if (((String)defaultedModel.get()).length() == 0) {
            return new ExitImmediatelyStep(SilentResourceKeys.FOLDER_SELECTION_ERROR);
        }
        return new SilentPanelStep();
    }

    @Override
    public Step buildUserAppFolderSelectionStep(DefaultedModel<String> defaultedModel, FileSystem fileSystem, InstallOptionModel installOptionModel, boolean bl) {
        if (((String)defaultedModel.get()).length() == 0) {
            return new ExitImmediatelyStep(SilentResourceKeys.FOLDER_SELECTION_ERROR);
        }
        return new SilentPanelStep();
    }

    @Override
    public Step buildStatusStep(BackgroundTask backgroundTask, boolean bl) {
        return new Step(){

            @Override
            public void reverseVisitStep(StepCallback stepCallback) {
            }

            @Override
            public void forwardVisitStep(StepCallback stepCallback) {
            }
        };
    }

    @Override
    public Step buildStatusStep(BackgroundTask backgroundTask, boolean bl, boolean bl2) {
        return this.buildStatusStep(backgroundTask, bl);
    }

    @Override
    public Step buildFinalPanelStep(Model<CheckBoxConfiguration> model, Model<CheckBoxConfiguration> model2, boolean bl, int n, String string) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildNotesStep(String string) {
        return new SilentPanelStep("Notes: " + System.getProperty("line.separator") + string);
    }

    @Override
    public <T> Step buildUninstallerProductSelectionStep(ProductModel<T> productModel, ProductTableFormat<T> productTableFormat, Model<Boolean> model, InstallOptionModel ... installOptionModelArray) {
        if (!productModel.anySelected()) {
            return new ExitImmediatelyStep(SilentResourceKeys.PRODUCT_SELECTION_ERROR);
        }
        return new SilentPanelStep();
    }

    @Override
    public Step buildUninstallerFinishStep(Model<Boolean> model) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildLoginPanelStep(Model<String> model, Model<String> model2, Model<OptionSelectedState> model3) {
        if (model.get().length() == 0 || model2.get().length() == 0) {
            return new ExitImmediatelyStep(SilentResourceKeys.USERACCOUNT_ERROR);
        }
        model3.set(OptionSelectedState.LOGIN);
        return new SilentPanelStep();
    }

    private Step createOnlineNotSupportedStep() {
        return new ExitImmediatelyStep(SilentResourceKeys.WELCOME_ERROR);
    }

    @Override
    public <T> Step buildEntitlementSelectionPanelStep(Model<T[]> model, Model<T> model2, AccessibleTableFormat<T> accessibleTableFormat, Model<Boolean> model3, Model<String> model4) {
        if (model4.get().length() == 0) {
            return new ExitImmediatelyStep(SilentResourceKeys.ACTIVATION_KEY_ERROR);
        }
        model3.set(Boolean.FALSE);
        return new SilentPanelStep();
    }

    @Override
    public Step buildActivationKeyPanelStep(Model<String> model) {
        return this.createOnlineNotSupportedStep();
    }

    @Override
    public Step buildCreateAccountPanelStep(Model<String> model, Model<String> model2, Model<String> model3, Model<String> model4, Model<String> model5, Model<String> model6, Model<String> model7) {
        return this.createOnlineNotSupportedStep();
    }

    @Override
    public Step buildLicenseFilePanelStep(Model<String> model) {
        if (model.get().length() == 0) {
            return new ExitImmediatelyStep(SilentResourceKeys.LICENSE_FILE_ERROR);
        }
        return new SilentPanelStep();
    }

    @Override
    public Step buildLicenseServicePanelStep(InstallOptionModel installOptionModel, String string, File file, File file2) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildVerifyEmailAddressPanelStep(Model<String> model, Model<String> model2) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildDownloadInstallPanelStep(Model<Boolean> model) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildDownloadFolderSelectionStep(DefaultedModel<File> defaultedModel, PlatformModel<AvailablePlatform> platformModel) {
        return new SilentPanelStep();
    }

    @Override
    public Step buildDownloadFinalPanelStep(int n, String string, Model<CheckBoxConfiguration> model) {
        return new SilentPanelStep();
    }

    private class ExitImmediatelyStep
    extends AbstractLoggingStep {
        ExitImmediatelyStep(SilentResourceKeys silentResourceKeys) {
            super(SilentPanelStepBuilder.this.appLogger, silentResourceKeys.getString(new Object[0]));
        }

        @Override
        public void reverseVisitStep(StepCallback stepCallback) {
        }

        @Override
        public void forwardVisitStep(StepCallback stepCallback) {
            super.forwardVisitStep(stepCallback);
            SilentPanelStepBuilder.this.exitHandler.exit(ExitStatus.FAILED);
        }
    }

    private class SilentPanelStep
    extends AbstractLoggingStep {
        SilentPanelStep(String string) {
            super(SilentPanelStepBuilder.this.appLogger, string);
        }

        SilentPanelStep() {
        }

        @Override
        public void reverseVisitStep(StepCallback stepCallback) {
            SilentPanelStepBuilder.this.exitHandler.exit(ExitStatus.FAILED);
        }

        @Override
        public void forwardVisitStep(StepCallback stepCallback) {
            super.forwardVisitStep(stepCallback);
            stepCallback.stepForward();
        }
    }
}

