/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.google.inject.Inject;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.net.transport.MWTransportClientProperties;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.StepCallback;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.components.ProxyContainer;
import com.mathworks.wizard.ui.panels.ProxyConfigurator;

final class ProxyConfiguratorImpl
implements ProxyConfigurator {
    private final MWTransportClientProperties tcp;
    private final WizardUI ui;
    private UsageDataCollector usageDataCollector;

    @Inject
    ProxyConfiguratorImpl(MWTransportClientProperties mWTransportClientProperties, WizardUI wizardUI, UsageDataCollector usageDataCollector) {
        this.tcp = mWTransportClientProperties;
        this.ui = wizardUI;
        this.usageDataCollector = usageDataCollector;
    }

    @Override
    public void configure(ProxyContainer proxyContainer, Step step) {
        String string = this.tcp.getProxyHost();
        String string2 = this.tcp.getProxyPort();
        String string3 = this.tcp.getProxyUser();
        String string4 = this.tcp.getProxyPassword();
        this.showProxyPanel(string, string2, string3, string4, proxyContainer, step);
    }

    private void showProxyPanel(String string, String string2, String string3, String string4, ProxyContainer proxyContainer, Step step) {
        if (this.ui.showPlainMessage(WizardResourceKeys.PROXY_TITLE.getString(new Object[0]), proxyContainer.getComponent())) {
            String string5;
            String string6;
            String string7;
            String string8 = proxyContainer.getServerData();
            if (ProxyConfiguratorImpl.anyDataProvided(string8, string7 = proxyContainer.getPortData(), string6 = proxyContainer.getUserData(), string5 = proxyContainer.getPassword())) {
                this.tryToBind(string, string2, string3, string4, proxyContainer, string8, string7, string6, string5, step);
            } else {
                this.setProxySettings(string8, string7, string6, string5);
            }
        } else {
            this.resetProxySettings(proxyContainer, string, string2, string3, string4);
        }
    }

    private void tryToBind(String string, String string2, String string3, String string4, ProxyContainer proxyContainer, String string5, String string6, String string7, String string8, Step step) {
        if (ProxyConfiguratorImpl.userAndValidPortProvided(string5, string6)) {
            this.setProxySettings(string5, string6, string7, string8);
            this.bind(string, string2, string3, string4, proxyContainer, string7, step);
        } else {
            this.ui.showErrorMessage(WizardResourceKeys.PROXY_ERROR_TITLE.getString(new Object[0]), WizardResourceKeys.PROXY_ERROR_MESSAGE.getString(new Object[0]));
            this.showProxyPanel(string, string2, string3, string4, proxyContainer, step);
        }
    }

    private void setProxySettings(String string, String string2, String string3, String string4) {
        if (string != null) {
            this.tcp.setProxyHost(string);
        }
        if (string2 != null) {
            this.tcp.setProxyPort(string2);
        }
        if (string3 != null) {
            this.tcp.setProxyUser(string3);
        }
        if (string4 != null) {
            this.tcp.setProxyPassword(string4);
        }
    }

    private void bind(final String string, final String string2, final String string3, final String string4, final ProxyContainer proxyContainer, String string5, final Step step) {
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_CONNECTION_SETTINGS_CHANGED, (Object)true);
        step.forwardVisitStep(new StepCallback(){

            @Override
            public void stepBack() {
                ProxyConfiguratorImpl.this.showProxyPanel(string, string2, string3, string4, proxyContainer, step);
            }

            @Override
            public void stepForward() {
            }

            @Override
            public boolean canStepBack() {
                return true;
            }

            @Override
            public boolean canStepForward() {
                return true;
            }
        });
    }

    private static boolean userAndValidPortProvided(String string, String string2) {
        boolean bl = false;
        try {
            if (Integer.parseInt(string2) >= 0 && Integer.parseInt(string2) <= 65535) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return !"".equalsIgnoreCase(string) && bl;
    }

    private static boolean anyDataProvided(String string, String string2, String string3, String string4) {
        return !"".equalsIgnoreCase(string) || !"".equalsIgnoreCase(string2) || !"".equalsIgnoreCase(string3) || !"".equalsIgnoreCase(string4);
    }

    private void resetProxySettings(ProxyContainer proxyContainer, String string, String string2, String string3, String string4) {
        if (string == null) {
            this.tcp.setProxyHost("");
        } else {
            this.tcp.setProxyHost(string);
        }
        if (string2 == null) {
            this.tcp.setProxyPort("");
        } else {
            this.tcp.setProxyPort(string2);
        }
        if (string3 == null) {
            this.tcp.setProxyUser("");
        } else {
            this.tcp.setProxyUser(string3);
        }
        if (string4 == null) {
            this.tcp.setProxyPassword("");
        } else {
            this.tcp.setProxyPassword(string4);
        }
        proxyContainer.resetProxyContainer(string, string2, string3, string4);
    }
}

