/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.install_task.BackgroundTask;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ExitStatus;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.StepCallback;
import com.mathworks.wizard.command.Command;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.navigation.NavigationButtonFactory;
import com.mathworks.wizard.ui.navigation.NavigationPanelBuilder;
import com.mathworks.wizard.ui.panels.AbstractLoggingStep;
import com.mathworks.wizard.ui.panels.PanelUI;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class PanelStep
extends AbstractLoggingStep {
    protected PanelUI pnlUI;
    protected final NavigationButtonFactory navButtonFactory;
    private final NavigationPanelBuilder navPanelBuilder;
    protected final WizardUI container;
    private final String name;
    private final boolean showFooterImage;
    private BackgroundTask[] tasks;
    private ExitHandler exitHandler;
    private String hlpKey = null;
    private ResourceRetriever resourceRetriever;
    private WizardResourceKeys cancelText = WizardResourceKeys.CANCEL_TEXT;

    private PanelStep(PanelUI panelUI, NavigationButtonFactory navigationButtonFactory, NavigationPanelBuilder navigationPanelBuilder, WizardUI wizardUI, String string, ExitHandler exitHandler, ResourceRetriever resourceRetriever, AppLogger appLogger, boolean bl, String string2, WizardResourceKeys wizardResourceKeys, BackgroundTask ... backgroundTaskArray) {
        super(appLogger, panelUI.getLoggerData());
        this.pnlUI = panelUI;
        this.container = wizardUI;
        this.navButtonFactory = navigationButtonFactory;
        this.navPanelBuilder = navigationPanelBuilder;
        this.name = string;
        this.exitHandler = exitHandler;
        this.resourceRetriever = resourceRetriever;
        this.cancelText = wizardResourceKeys;
        this.tasks = (BackgroundTask[])backgroundTaskArray.clone();
        this.showFooterImage = bl;
        this.hlpKey = string2;
    }

    PanelStep(PanelUI panelUI, NavigationButtonFactory navigationButtonFactory, NavigationPanelBuilder navigationPanelBuilder, WizardUI wizardUI, String string, ExitHandler exitHandler, ResourceRetriever resourceRetriever, AppLogger appLogger, boolean bl, BackgroundTask ... backgroundTaskArray) {
        this(panelUI, navigationButtonFactory, navigationPanelBuilder, wizardUI, string, exitHandler, resourceRetriever, appLogger, bl, null, WizardResourceKeys.CANCEL_TEXT, backgroundTaskArray);
    }

    PanelStep(PanelUI panelUI, NavigationButtonFactory navigationButtonFactory, NavigationPanelBuilder navigationPanelBuilder, WizardUI wizardUI, String string, ExitHandler exitHandler, String string2, ResourceRetriever resourceRetriever, AppLogger appLogger, boolean bl, BackgroundTask ... backgroundTaskArray) {
        this(panelUI, navigationButtonFactory, navigationPanelBuilder, wizardUI, string, exitHandler, resourceRetriever, appLogger, bl, string2, WizardResourceKeys.CANCEL_TEXT, backgroundTaskArray);
    }

    public PanelStep(PanelUI panelUI, NavigationButtonFactory navigationButtonFactory, NavigationPanelBuilder navigationPanelBuilder, WizardUI wizardUI, String string, ExitHandler exitHandler, ResourceRetriever resourceRetriever, AppLogger appLogger, boolean bl, BackgroundTask backgroundTask, WizardResourceKeys wizardResourceKeys) {
        this(panelUI, navigationButtonFactory, navigationPanelBuilder, wizardUI, string, exitHandler, resourceRetriever, appLogger, bl, null, wizardResourceKeys, backgroundTask);
    }

    @Override
    public void reverseVisitStep(StepCallback stepCallback) {
        this.visit(stepCallback);
    }

    @Override
    public void forwardVisitStep(StepCallback stepCallback) {
        this.visit(stepCallback);
        super.forwardVisitStep(stepCallback);
    }

    private void visit(StepCallback stepCallback) {
        this.setupBackButton(stepCallback);
        this.setupCustomButtons();
        JButton jButton = this.setupNextButton(stepCallback);
        Command command = this.createCancelCommand();
        this.setupCancelButton(command);
        this.setupHelpButton();
        this.setupContainer(jButton, command);
        this.requestInitialFocus(jButton);
    }

    private Command createCancelCommand() {
        return new Command(){

            @Override
            public void execute() {
                String string = PanelStep.this.resourceRetriever.getResource(WizardResourceKeys.CANCEL_TITLE, new Object[0]);
                String string2 = PanelStep.this.resourceRetriever.getResource(PanelStep.this.cancelText, new Object[0]);
                ArrayList<BackgroundTask> arrayList = new ArrayList<BackgroundTask>();
                for (Object object : PanelStep.this.tasks) {
                    if (!object.pause()) continue;
                    arrayList.add((BackgroundTask)object);
                }
                if (PanelStep.this.container.getResponseToYesNoQuestion(string, string2, MessageType.QUESTION)) {
                    for (Object object : PanelStep.this.tasks) {
                        object.cancel();
                    }
                    PanelStep.this.exitHandler.exit(ExitStatus.CANCELLED);
                } else {
                    for (BackgroundTask backgroundTask : arrayList) {
                        backgroundTask.resume();
                    }
                }
            }
        };
    }

    private void requestInitialFocus(JButton jButton) {
        final JComponent jComponent = this.pnlUI.getInitialFocus(jButton);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jComponent.isEnabled()) {
                    jComponent.requestFocusInWindow();
                }
            }
        });
    }

    private void setupContainer(JButton jButton, Command command) {
        this.container.showPanel(this.pnlUI.getPanel(), this.name, this.navPanelBuilder.buildNavigationPanel(this.showFooterImage), jButton, command, this.pnlUI.getTitle(), this.pnlUI.getAccessibleName());
    }

    private void setupHelpButton() {
        if (this.hlpKey != null && !"".equals(this.resourceRetriever.getResource(this.hlpKey, new Object[0]))) {
            JButton jButton = this.navButtonFactory.createHelpButton(this.hlpKey);
            this.pnlUI.configureHelpButton(jButton);
            this.navPanelBuilder.addRightAnchoredButtons(new AbstractButton[]{jButton});
        }
    }

    private void setupCancelButton(Command command) {
        JButton jButton = this.navButtonFactory.createCancelButton(command);
        this.pnlUI.configureCancelButton(jButton);
        this.navPanelBuilder.addRightAnchoredButtons(new AbstractButton[]{jButton});
    }

    private JButton setupNextButton(StepCallback stepCallback) {
        JButton jButton = this.createNextButton(stepCallback);
        this.pnlUI.configureNextButton(jButton);
        this.navPanelBuilder.addLeftAnchoredButtons(new AbstractButton[]{jButton});
        return jButton;
    }

    private JButton createNextButton(StepCallback stepCallback) {
        return this.navButtonFactory.createNextButton(new StepForwardCommand(stepCallback));
    }

    private void setupCustomButtons() {
        ArrayList<AbstractButton> arrayList = new ArrayList<AbstractButton>();
        this.pnlUI.addCustomButtonsInBetweenBackAndNext(this.navButtonFactory, arrayList);
        this.navPanelBuilder.addLeftAnchoredButtons(arrayList.toArray(new AbstractButton[arrayList.size()]));
    }

    private void setupBackButton(final StepCallback stepCallback) {
        JButton jButton = this.navButtonFactory.createBackButton(new Command(){

            @Override
            public void execute() {
                if (PanelStep.this.pnlUI.apply()) {
                    stepCallback.stepBack();
                }
            }
        });
        jButton.setEnabled(stepCallback.canStepBack());
        this.pnlUI.configureBackButton(jButton);
        this.navPanelBuilder.addLeftAnchoredButtons(new AbstractButton[]{jButton});
    }

    private class StepForwardCommand
    implements Command {
        private final StepCallback stepCallback;

        StepForwardCommand(StepCallback stepCallback) {
            this.stepCallback = stepCallback;
        }

        @Override
        public void execute() {
            if (PanelStep.this.pnlUI.apply()) {
                this.stepCallback.stepForward();
            }
        }
    }
}

