/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.instutil.FolderUtils;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractMCRFolderSelectionPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

final class MCRNotInstalledFolderSelectionPanelUI
extends AbstractMCRFolderSelectionPanelUI {
    private final DefaultedModel<String> myFolder;
    private final JTextComponent folderTextField;
    private final FolderUtils folderUtils;
    private ResourceRetriever resourceRetriever;
    private final JComponent fieldLabel;

    MCRNotInstalledFolderSelectionPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, FolderUtils folderUtils, DefaultedModel<String> defaultedModel, String string, ResourceRetriever resourceRetriever, String string2, ImageIcon imageIcon) {
        super(resourceBundle, swingComponentFactory, string);
        this.myFolder = defaultedModel;
        this.folderUtils = folderUtils;
        this.resourceRetriever = resourceRetriever;
        JComponent jComponent = swingComponentFactory.createLabel(WizardResourceKeys.MCR_FOLDER_LABEL.getString(new Object[0]), WizardComponentName.MCR_DIRECTORY_LABEL);
        this.fieldLabel = swingComponentFactory.createLabel(string2, WizardComponentName.MCR_FOLDER_FIELD_LABEL);
        JButton jButton = swingComponentFactory.createButton(AllButtonProperties.RESET, new ResetAction(), WizardComponentName.MCR_DIRECTORY_RESET_BUTTON);
        this.folderTextField = swingComponentFactory.createTextField(WizardComponentName.MCR_DIRECTORY_TEXTFIELD, WizardResourceKeys.INSTALL_FOLDER_FIELD_LABEL.getString(new Object[0]));
        String string3 = (String)this.myFolder.get();
        this.folderTextField.setText(string3);
        JComponent jComponent2 = swingComponentFactory.createBrowseableFolderTextField(this.folderTextField, WizardComponentName.MCR_DIRECTORY_BROWSE_BUTTON, string3);
        this.panel = ((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent})).addRow(new JComponent[0])).addRow(new JComponent[]{this.fieldLabel})).addRow(new JComponent[]{jComponent2})).addRightAnchoredRow(new JComponent[]{jButton})).addVerticalFillRow(new JComponent[0])).addRow(new JComponent[]{swingComponentFactory.createWrappingLabel(this.getFooterText(), WizardComponentName.WELCOME_FOOTER)})).buildPanel(imageIcon);
    }

    private String getFooterText() {
        String string = System.getProperty("line.separator");
        return WizardResourceKeys.TRADEMARK.getString(new Object[0]) + string + string + WizardResourceKeys.WELCOME_FOOTER.getString(this.resourceRetriever, new Object[0]);
    }

    private void updateFolderTextField(String string) {
        this.folderTextField.setText(string);
    }

    private void updateFolderModelAndSpaceLabels() {
        this.updateFolderModel();
    }

    private void updateFolderModel() {
        this.myFolder.set(this.getPath());
    }

    private String getPath() {
        return this.folderUtils.scrub(this.folderTextField.getText());
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.folderTextField;
    }

    @Override
    public void configureNextButton(AbstractButton abstractButton) {
        abstractButton.setEnabled(this.getPath().length() > 0);
        this.factory.addDocumentObserver(this.folderTextField.getDocument(), new FolderTextFieldObserver(abstractButton));
    }

    @Override
    public boolean apply() {
        this.updateFolderModel();
        return true;
    }

    @Override
    public String getLoggerData() {
        return "Default Installation Folder: " + this.folderTextField.getText();
    }

    private class SpaceLabelUpdaterWizardObserver
    implements WizardObserver {
        private SpaceLabelUpdaterWizardObserver() {
        }

        @Override
        public void update() {
            MCRNotInstalledFolderSelectionPanelUI.this.updateFolderModelAndSpaceLabels();
        }
    }

    private class FolderTextFieldObserver
    implements WizardObserver {
        private AbstractButton nextButton;

        FolderTextFieldObserver(AbstractButton abstractButton) {
            this.nextButton = abstractButton;
        }

        @Override
        public void update() {
            this.nextButton.setEnabled(MCRNotInstalledFolderSelectionPanelUI.this.getPath().length() > 0);
        }
    }

    private class ResetAction
    extends AbstractAction {
        private ResetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MCRNotInstalledFolderSelectionPanelUI.this.updateFolderTextField((String)MCRNotInstalledFolderSelectionPanelUI.this.myFolder.getDefault());
        }
    }
}

