/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.net.hyperlink.HyperlinkProvider;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.OptionSelectedState;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

final class LoginPanelUI
extends AbstractPanelUI {
    private final JPanel panel;
    private final Model<String> uname;
    private final Model<String> pword;
    private final Model<OptionSelectedState> option;
    private final JTextComponent emailField;
    private final JTextComponent passwordField;
    private AbstractButton createAccountButton;
    private AbstractButton loginButton;

    LoginPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, Model<String> model, Model<String> model2, Model<OptionSelectedState> model3, HyperlinkProvider hyperlinkProvider) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.LOGIN_TITLE.getString(new Object[0]));
        this.uname = model;
        this.pword = model2;
        this.option = model3;
        this.loginButton = swingComponentFactory.createRadioButton(WizardResourceKeys.LOGIN_CAN.getString(new Object[0]), WizardComponentName.LOGIN_HAS_MW_ACCOUNT);
        this.loginButton.setSelected(true);
        JComponent jComponent = swingComponentFactory.createNonWrappingLabel(WizardResourceKeys.LOGIN_EMAIL_LABEL.getString(new Object[0]), WizardComponentName.LOGIN_EMAIL_LABEL);
        this.emailField = swingComponentFactory.createTextField(WizardComponentName.LOGIN_EMAIL_TEXTFIELD, WizardResourceKeys.LOGIN_EMAIL_LABEL.getString(new Object[0]));
        this.emailField.setText(model.get());
        JComponent jComponent2 = swingComponentFactory.createNonWrappingLabel(resourceBundle.getString("login.password.label"), WizardComponentName.LOGIN_PASSWORD_LABEL);
        this.passwordField = swingComponentFactory.createPasswordField(WizardComponentName.LOGIN_PASSWORD_FIELD);
        swingComponentFactory.createRelationship(this.loginButton, this.emailField, this.passwordField);
        this.passwordField.setText(model2.get());
        JLabel jLabel = new JLabel();
        JComponent jComponent3 = swingComponentFactory.createLabel(MessageFormat.format(resourceBundle.getString("login.forgotpassword.link"), hyperlinkProvider.getForgotPasswordLink()), WizardComponentName.LOGIN_FORGOT_PASSWORD);
        this.createAccountButton = swingComponentFactory.createRadioButton(resourceBundle.getString("login.create"), WizardComponentName.LOGIN_CREATE_ACCOUNT);
        swingComponentFactory.createButtonGroup(this.loginButton, this.createAccountButton);
        ((PanelBuilder)((PanelBuilder)((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{this.loginButton})).addSubRow(new JComponent[]{jComponent, this.emailField})).addSubRow(new JComponent[]{jComponent2, this.passwordField})).addSubRow(new JComponent[]{jLabel, jComponent3})).addRow(new JComponent[]{this.createAccountButton});
        this.panel = panelBuilder.buildPanel();
    }

    @Override
    public boolean apply() {
        if (this.loginButton.isSelected()) {
            this.uname.set(this.emailField.getText());
            this.pword.set(this.passwordField.getText());
            this.option.set(OptionSelectedState.LOGIN);
        } else {
            this.option.set(OptionSelectedState.CREATE_ACCOUNT);
        }
        return true;
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.emailField;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.LOGIN_TITLE.getString(new Object[0]);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        abstractButton.setEnabled(this.LoginButtonSelectedAndDataProvided() || this.createAccountButton.isSelected());
        this.createAccountButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                abstractButton.setEnabled(itemEvent.getStateChange() == 1);
            }
        });
        this.loginButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                abstractButton.setEnabled(itemEvent.getStateChange() == 1 && LoginPanelUI.this.userNameAndPasswordExists());
            }
        });
        this.factory.addDocumentObserver(this.emailField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                abstractButton.setEnabled(LoginPanelUI.this.LoginButtonSelectedAndDataProvided());
            }
        });
        this.factory.addDocumentObserver(this.passwordField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                abstractButton.setEnabled(LoginPanelUI.this.LoginButtonSelectedAndDataProvided());
            }
        });
    }

    private boolean LoginButtonSelectedAndDataProvided() {
        return this.loginButton.isSelected() && this.userNameAndPasswordExists();
    }

    private boolean userNameAndPasswordExists() {
        boolean bl = this.passwordField.getDocument().getLength() > 0;
        return this.emailField.getText().length() > 0 && bl;
    }
}

