/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.Platform;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractOptionsPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

final class LinuxOptionsPanelUI
extends AbstractOptionsPanelUI {
    private static final String SYM_LINK_ACCESSIBLE_NAME = "";
    private JTextComponent symLinkTextField;
    private AbstractButton symLinkCheckBox;
    private final FolderUtils folderUtils;
    private final UsageDataCollector usageDataCollector;

    LinuxOptionsPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, FolderUtils folderUtils, InstallOptionModel installOptionModel, UsageDataCollector usageDataCollector, Platform platform) {
        super(resourceBundle, swingComponentFactory, platform);
        this.folderUtils = folderUtils;
        this.usageDataCollector = usageDataCollector;
        JComponent jComponent = swingComponentFactory.createLabel(resourceBundle.getString("options.text"), WizardComponentName.OPTIONS_LABEL_TOP);
        JPanel jPanel = this.createSymlinkPanel(swingComponentFactory, installOptionModel);
        JPanel jPanel2 = this.createOptInOptionsPanel(swingComponentFactory);
        this.panel = ((PanelBuilder)((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent})).addRow(new JComponent[]{jPanel})).addRow(new JComponent[]{jPanel2})).buildPanel();
    }

    private JPanel createSymlinkPanel(SwingComponentFactory swingComponentFactory, final InstallOptionModel installOptionModel) {
        String string = WizardResourceKeys.OPTIONS_SYMLINKS_BORDER.getString(new Object[0]);
        JPanel jPanel = swingComponentFactory.createTitledBorderPanel(string, WizardComponentName.SYMBOLIC_LINK_BORDER);
        this.symLinkCheckBox = swingComponentFactory.createCheckBox(WizardResourceKeys.OPTIONS_SYMLINKS_CHECKBOX.getString(new Object[0]), WizardComponentName.SYMBOLIC_LINK_CHECKBOX);
        swingComponentFactory.createAssociation(this.symLinkCheckBox, installOptionModel);
        this.symLinkTextField = swingComponentFactory.createTextField(WizardComponentName.SYMBOLIC_LINK_TEXTFIELD, SYM_LINK_ACCESSIBLE_NAME);
        swingComponentFactory.addDocumentObserver(this.symLinkTextField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                installOptionModel.setContext(LinuxOptionsPanelUI.this.getValidPath());
            }
        });
        String string2 = installOptionModel.getContext();
        this.symLinkTextField.setText(string2);
        JComponent jComponent = swingComponentFactory.createBrowseableFolderTextField(this.symLinkTextField, WizardComponentName.SYMBOLIC_LINK_BROWSE_BUTTON, string2);
        swingComponentFactory.createRelationship(this.symLinkCheckBox, jComponent.getComponents());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.symLinkCheckBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 9, 2, 5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        return jPanel;
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        abstractButton.setEnabled(this.checkBoxNotSelectedOrSymbolicLinkTextIsNotEmpty());
        this.symLinkCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                abstractButton.setEnabled(LinuxOptionsPanelUI.this.checkBoxNotSelectedOrSymbolicLinkTextIsNotEmpty());
            }
        });
        this.factory.addDocumentObserver(this.symLinkTextField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                abstractButton.setEnabled(LinuxOptionsPanelUI.this.checkBoxNotSelectedOrSymbolicLinkTextIsNotEmpty());
            }
        });
    }

    private boolean checkBoxNotSelectedOrSymbolicLinkTextIsNotEmpty() {
        return !this.symLinkCheckBox.isSelected() || this.getValidPath().length() > 0;
    }

    private String getValidPath() {
        return this.folderUtils.scrub(this.symLinkTextField.getText());
    }

    @Override
    public boolean apply() {
        this.applyOptInSelection();
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_SYMBOLIC_LINKS_SELECTED, (Object)this.symLinkCheckBox.isSelected());
        return true;
    }
}

