/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.instutil.LicenseNumberProvider;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class LicenseNumberPanelUI
extends AbstractPanelUI {
    static final int MIN_LICENSE_LENGTH = 1;
    private final JPanel panel;
    private JTextComponent licenseNumberField;
    LicenseNumberProvider licenseNumberProvider;

    LicenseNumberPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, LicenseNumberProvider licenseNumberProvider) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.LICENSENUMBER_TITLE.getString(new Object[0]));
        this.licenseNumberProvider = licenseNumberProvider;
        JComponent jComponent = swingComponentFactory.createLabel(WizardResourceKeys.LICENSE_NUMBER_FIELD_LABEL.getString(new Object[0]), WizardComponentName.LICENSE_NUMBER_LABEL);
        this.licenseNumberField = swingComponentFactory.createTextField(WizardComponentName.LICENSE_TEXTFIELD, WizardResourceKeys.LICENSE_NUMBER_FIELD_LABEL.getString(new Object[0]));
        this.licenseNumberField.setText(licenseNumberProvider.getLicenseNumber());
        ((PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent})).addLeftWeightedRow(new JComponent[]{this.licenseNumberField});
        this.panel = panelBuilder.buildPanel();
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.licenseNumberField;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.LICENSENUMBER_TITLE.getString(new Object[0]);
    }

    @Override
    public boolean apply() {
        this.licenseNumberProvider.setLicenseNumber(this.licenseNumberField.getText().trim());
        return true;
    }

    @Override
    public void configureNextButton(final AbstractButton abstractButton) {
        abstractButton.setEnabled(this.licenseNumberExists());
        this.factory.addDocumentObserver(this.licenseNumberField.getDocument(), new WizardObserver(){

            @Override
            public void update() {
                abstractButton.setEnabled(LicenseNumberPanelUI.this.licenseNumberExists());
            }
        });
    }

    private boolean licenseNumberExists() {
        return this.licenseNumberField.getText().trim().length() >= 1;
    }
}

