/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

final class LicenseAgreementPanelUI
extends AbstractPanelUI {
    private final JPanel panel;
    private final AbstractButton yesRadioButton;
    private final Model<Boolean> agreeToLicense;

    LicenseAgreementPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, String string, Model<Boolean> model, ResourceRetriever resourceRetriever) {
        super(resourceBundle, swingComponentFactory, resourceRetriever.getResource(WizardResourceKeys.LICENSE_TITLE, new Object[0]));
        this.agreeToLicense = model;
        JComponent jComponent = LicenseAgreementPanelUI.createScrollPane(swingComponentFactory, string);
        JComponent jComponent2 = this.createQuestionLabel(swingComponentFactory);
        this.yesRadioButton = this.createYesRadioButton(swingComponentFactory);
        this.yesRadioButton.setSelected(this.agreeToLicense.get());
        AbstractButton abstractButton = this.createNoRadioButton(swingComponentFactory);
        swingComponentFactory.createButtonGroup(this.yesRadioButton, abstractButton);
        this.panel = ((PanelBuilder)((PanelBuilder)panelBuilder.addVerticalFillRow(new JComponent[]{jComponent})).addRow(new JComponent[]{jComponent2, this.yesRadioButton, abstractButton})).buildImagelessPanel();
    }

    private static JComponent createScrollPane(SwingComponentFactory swingComponentFactory, String string) {
        return swingComponentFactory.createScrollPane(swingComponentFactory.createPrintableEditorPane(string, WizardComponentName.LICENSE_AGREEMENT_TEXT_AREA));
    }

    private JComponent createQuestionLabel(SwingComponentFactory swingComponentFactory) {
        return swingComponentFactory.createLabel(this.getQuestionText(), WizardComponentName.LICENSE_AGREEMENT_LABEL);
    }

    private String getQuestionText() {
        return this.bundle.getString("license.text.question");
    }

    private AbstractButton createYesRadioButton(SwingComponentFactory swingComponentFactory) {
        AbstractButton abstractButton = swingComponentFactory.createRadioButton(this.bundle.getString("button.yes"), WizardComponentName.LICENSE_AGREEMENT_YES_RADIOBUTTON);
        abstractButton.setMnemonic(this.bundle.getString("button.yes.mnemonic").hashCode());
        this.setYesRBAccessibleContext(abstractButton);
        return abstractButton;
    }

    private void setYesRBAccessibleContext(AbstractButton abstractButton) {
        AccessibleContext accessibleContext = abstractButton.getAccessibleContext();
        accessibleContext.setAccessibleName(this.getQuestionText().replaceAll("<.*?>", "") + ' ' + this.bundle.getString("yes.accessible") + ' ' + accessibleContext.getAccessibleName());
    }

    private AbstractButton createNoRadioButton(SwingComponentFactory swingComponentFactory) {
        AbstractButton abstractButton = swingComponentFactory.createRadioButton(this.bundle.getString("button.no"), WizardComponentName.LICENSE_AGREEMENT_NO_RADIOBUTTON);
        abstractButton.setMnemonic(this.bundle.getString("button.no.mnemonic").hashCode());
        return abstractButton;
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.yesRadioButton;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.LICENSE_ACCESSIBLE.getString(new Object[0]);
    }

    @Override
    public void configureNextButton(AbstractButton abstractButton) {
        this.factory.createRelationship(this.yesRadioButton, abstractButton);
    }

    @Override
    public boolean apply() {
        this.agreeToLicense.set(this.yesRadioButton.isSelected());
        return true;
    }
}

