/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InstallAgentFinalPanelUI
extends AbstractPanelUI {
    private final JPanel fPanel;
    private final Model<File> fInstallationLocation;

    public InstallAgentFinalPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, String string, Model<File> model) {
        super(resourceBundle, swingComponentFactory, WizardResourceKeys.FINAL_TITLE.getString(new Object[0]));
        this.fInstallationLocation = model;
        JComponent jComponent = swingComponentFactory.createLabel(WizardResourceKeys.INSTALLAGENT_FINAL_COMPLETE_LABEL.getString(new Object[0]), WizardComponentName.INSTALLAGENT_FINAL_COMPLETE_TITLE);
        PanelBuilder panelBuilder2 = (PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent});
        if (!string.trim().isEmpty()) {
            JComponent jComponent2 = swingComponentFactory.createPrintableEditorPane(InstallAgentFinalPanelUI.getTextToDisplay(string), WizardComponentName.SETUP_TEXT_PANE);
            JScrollPane jScrollPane = swingComponentFactory.createScrollPane(jComponent2);
            panelBuilder2 = (PanelBuilder)panelBuilder2.addVerticalFillRow(new JComponent[]{jScrollPane});
        }
        this.fPanel = panelBuilder2.buildPanel();
    }

    private static String getTextToDisplay(String string) {
        String string2 = System.lineSeparator();
        return WizardResourceKeys.PRODUCT_CONFIGURATION_NOTES_LABEL.getString(new Object[0]) + string2 + string2 + string;
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return jComponent;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.FINAL_ACCESSIBLE.getString(new Object[0]);
    }

    @Override
    public JPanel getPanel() {
        return this.fPanel;
    }

    @Override
    public void configureNextButton(AbstractButton abstractButton) {
        this.factory.setButtonProperties(abstractButton, AllButtonProperties.FINISH);
    }

    @Override
    public void configureCancelButton(AbstractButton abstractButton) {
        abstractButton.setVisible(false);
    }

    @Override
    public void configureBackButton(AbstractButton abstractButton) {
        abstractButton.setVisible(false);
    }

    @Override
    public boolean apply() {
        if (this.fInstallationLocation != null) {
            this.openGettingStarted();
        }
        return true;
    }

    private void openFileLocation() {
        File file = new File(this.fInstallationLocation.get(), "application");
        if (file.exists()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void openGettingStarted() {
        File file = new File(this.fInstallationLocation.get(), "application");
        File file2 = new File(file, "GettingStarted.html");
        if (file2.exists()) {
            try {
                if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(file2.toURI());
                } else {
                    Runtime runtime = Runtime.getRuntime();
                    runtime.exec("xdg-open " + file2.toURI());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

