/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.panels;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.DefaultedModel;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.panels.AbstractPanelUI;
import com.mathworks.wizard.ui.panels.PanelBuilder;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

final class FolderSelectionPanelUI
extends AbstractPanelUI {
    private final DefaultedModel<String> myFolder;
    private final UsageDataCollector usageDataCollector;
    private final JTextComponent folderTextField;
    private final FolderUtils folderUtils;
    private JPanel panel;
    private File current;
    private File def;

    FolderSelectionPanelUI(ResourceBundle resourceBundle, SwingComponentFactory swingComponentFactory, PanelBuilder panelBuilder, FolderUtils folderUtils, DefaultedModel<String> defaultedModel, String string, UsageDataCollector usageDataCollector, JComponent ... jComponentArray) {
        super(resourceBundle, swingComponentFactory, string);
        this.folderUtils = folderUtils;
        this.myFolder = defaultedModel;
        this.usageDataCollector = usageDataCollector;
        JButton jButton = swingComponentFactory.createButton(AllButtonProperties.RESET, new ResetAction(), WizardComponentName.DIRECTORY_RESET_BUTTON);
        JComponent jComponent = swingComponentFactory.createLabel(WizardResourceKeys.INSTALL_FOLDER_FIELD_LABEL.getString(new Object[0]), WizardComponentName.PRODUCT_LABEL);
        this.folderTextField = swingComponentFactory.createTextField(WizardComponentName.DIRECTORY_TEXTFIELD, this.getString("folder.field.label"));
        String string2 = (String)this.myFolder.get();
        this.folderTextField.setText(string2);
        JComponent jComponent2 = swingComponentFactory.createBrowseableFolderTextField(this.folderTextField, WizardComponentName.DIRECTORY_BROWSE_BUTTON, string2);
        swingComponentFactory.addDocumentObserver(this.folderTextField.getDocument(), new SpaceLabelUpdaterWizardObserver());
        ((PanelBuilder)((PanelBuilder)((PanelBuilder)panelBuilder.addRow(new JComponent[]{jComponent})).addRow(new JComponent[]{jComponent2})).addRightAnchoredRow(new JComponent[]{jButton})).addVerticalFillRow(jComponentArray);
        this.panel = panelBuilder.buildPanel();
    }

    @Override
    public JComponent getInitialFocus(JComponent jComponent) {
        return this.folderTextField;
    }

    @Override
    public String getAccessibleName() {
        return WizardResourceKeys.FOLDER_TITLE.getString(new Object[0]);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void configureNextButton(AbstractButton abstractButton) {
        abstractButton.setEnabled(!this.getPath().isEmpty());
        this.factory.addDocumentObserver(this.folderTextField.getDocument(), new FolderTextFieldObserver(abstractButton));
    }

    @Override
    public boolean apply() {
        this.updateFolderModel();
        this.collectUsageData();
        return true;
    }

    private void collectUsageData() {
        this.current = new File((String)this.myFolder.get());
        this.def = new File(this.myFolder.getDefault());
        boolean bl = false;
        try {
            bl = !this.current.getCanonicalPath().equals(this.def.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_DEFAULT_INSTALLATION_FOLDER_CHANGED, (Object)bl);
        this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_INSTALLATION_FOLDER, (Object)this.folderTextField.getText());
    }

    @Override
    public String getLoggerData() {
        return "Default Installation Folder: " + this.folderTextField.getText();
    }

    private void updateFolderModel() {
        this.myFolder.set(this.getPath());
    }

    private void updateFolderTextField(String string) {
        this.folderTextField.setText(string);
    }

    private String getPath() {
        return this.folderUtils.scrub(this.folderTextField.getText());
    }

    private void updateFolderModelAndSpaceLabels() {
        this.updateFolderModel();
    }

    private class SpaceLabelUpdaterWizardObserver
    implements WizardObserver {
        private SpaceLabelUpdaterWizardObserver() {
        }

        @Override
        public void update() {
            FolderSelectionPanelUI.this.updateFolderModelAndSpaceLabels();
        }
    }

    private class FolderTextFieldObserver
    implements WizardObserver {
        private AbstractButton nextButton;

        FolderTextFieldObserver(AbstractButton abstractButton) {
            this.nextButton = abstractButton;
        }

        @Override
        public void update() {
            this.nextButton.setEnabled(FolderSelectionPanelUI.this.getPath().length() > 0);
        }
    }

    private class ResetAction
    extends AbstractAction {
        private ResetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FolderSelectionPanelUI.this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_RESTORED_DEFAULT_INSTALL_FOLDER, (Object)true);
            FolderSelectionPanelUI.this.updateFolderTextField((String)FolderSelectionPanelUI.this.myFolder.getDefault());
        }
    }
}

