/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.navigation;

import com.google.inject.Inject;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.wizard.Printer;
import com.mathworks.wizard.command.Command;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.ButtonProperties;
import com.mathworks.wizard.ui.components.ButtonFactory;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.help.Help;
import com.mathworks.wizard.ui.navigation.NavigationButtonFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EnumMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;

final class NavigationButtonFactoryImpl
implements NavigationButtonFactory {
    static final ButtonProperties[] NAVIGATION_BUTTON_PROPERTIES = new ButtonProperties[]{AllButtonProperties.BACK, AllButtonProperties.NEXT, AllButtonProperties.CANCEL, AllButtonProperties.HELP, AllButtonProperties.INSTALL, AllButtonProperties.FINISH, AllButtonProperties.PRINT, AllButtonProperties.UNINSTALL, AllButtonProperties.DOWNLOAD};
    private final ButtonFactory factory;
    private final Help h;
    private final Printer p;
    private final UsageDataCollector usageDataCollector;

    @Inject
    NavigationButtonFactoryImpl(SwingComponentFactory swingComponentFactory, Printer printer, Help help, UsageDataCollector usageDataCollector) {
        this.usageDataCollector = usageDataCollector;
        this.factory = swingComponentFactory.createButtonFactory(NAVIGATION_BUTTON_PROPERTIES);
        this.p = printer;
        this.h = help;
    }

    @Override
    public JButton createBackButton(final Command command) {
        return this.factory.createButton(AllButtonProperties.BACK, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                command.execute();
            }
        }, WizardComponentName.BACK_BUTTON);
    }

    @Override
    public JButton createNextButton(Command command) {
        return this.factory.createButton(AllButtonProperties.NEXT, new NextAction(command), WizardComponentName.NEXT_BUTTON);
    }

    @Override
    public JButton createCancelButton(final Command command) {
        return this.factory.createButton(AllButtonProperties.CANCEL, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                command.execute();
            }
        }, WizardComponentName.CANCEL_BUTTON);
    }

    @Override
    public JButton createHelpButton(final String string) {
        return this.factory.createButton(AllButtonProperties.HELP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigationButtonFactoryImpl.this.h.showHelp(string);
                EnumMap<UsageDataCollectorKey, Object> enumMap = new EnumMap<UsageDataCollectorKey, Object>(UsageDataCollectorKey.class);
                enumMap.put(UsageDataCollectorKey.PANEL_DATA_HELP_USED, (Object)true);
                enumMap.put(UsageDataCollectorKey.PANEL_DATA_NAME, (Object)string);
                NavigationButtonFactoryImpl.this.usageDataCollector.addData(UsageDataCollectorKey.PANEL_DATA_ADD_PANEL_DATA, enumMap);
            }
        }, WizardComponentName.HELP_BUTTON);
    }

    @Override
    public JButton createPrintButton(final Component component) {
        return this.factory.createButton(AllButtonProperties.PRINT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NavigationButtonFactoryImpl.this.p.print(component);
            }
        }, WizardComponentName.PRINT_BUTTON);
    }

    private static class NextAction
    extends AbstractAction {
        private final Command nextCommand;
        private boolean acceptingEvents = true;

        NextAction(Command command) {
            this.nextCommand = command;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.acceptingEvents) {
                this.nextCommand.execute();
                this.acceptingEvents = false;
            }
        }
    }
}

