/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.laf;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.mathworks.instutil.DisplayProperties;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.wizard.CJKFontSize;
import com.mathworks.instutil.wizard.FontSizeStrategy;
import com.mathworks.wizard.ui.laf.DefaultFontSize;
import com.mathworks.wizard.ui.laf.DefaultFontStyle;
import com.mathworks.wizard.ui.laf.DefaultUIProperties;
import com.mathworks.wizard.ui.laf.FontProvider;
import com.mathworks.wizard.ui.laf.FontProviderImpl;
import com.mathworks.wizard.ui.laf.FontStyleStrategy;
import com.mathworks.wizard.ui.laf.HighContrastFontStyle;
import com.mathworks.wizard.ui.laf.MacUIProperties;
import com.mathworks.wizard.ui.laf.UIDefaultsTable;
import com.mathworks.wizard.ui.laf.UIDefaultsTableImpl;
import com.mathworks.wizard.ui.laf.UIProperties;
import java.util.ResourceBundle;

public final class LookAndFeelModule
extends AbstractModule {
    protected void configure() {
        this.bind(UIDefaultsTable.class).to(UIDefaultsTableImpl.class);
        this.bind(FontProvider.class).to(FontProviderImpl.class);
    }

    @Provides
    static FontSizeStrategy provideFontSizeStrategy(Platform platform) {
        return platform.isCJK() ? new CJKFontSize() : new DefaultFontSize();
    }

    @Provides
    static FontStyleStrategy provideFontStyleStrategy(DisplayProperties displayProperties) {
        return displayProperties.isHighContrast() ? new HighContrastFontStyle() : new DefaultFontStyle();
    }

    @Provides
    static UIProperties provideUIProperties(Platform platform, UIDefaultsTable uIDefaultsTable, ResourceBundle resourceBundle, FontProvider fontProvider) {
        UIProperties uIProperties = new DefaultUIProperties(uIDefaultsTable, resourceBundle, fontProvider);
        if (platform.isMac()) {
            uIProperties = new MacUIProperties(uIDefaultsTable, uIProperties);
        }
        return uIProperties;
    }
}

