/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.laf;

import com.mathworks.wizard.ui.laf.FontProvider;
import com.mathworks.wizard.ui.laf.UIDefaultsTable;
import com.mathworks.wizard.ui.laf.UIProperties;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ResourceBundle;
import javax.swing.plaf.FontUIResource;

final class DefaultUIProperties
implements UIProperties {
    private final UIDefaultsTable table;
    private final ResourceBundle bundle;
    private FontProvider fontProvider;
    private String[] uiFontArray = new String[]{"EditorPane.font", "OptionPane.font", "OptionPane.messageFont", "OptionPane.buttonFont", "Panel.font", "RadioButton.font", "CheckBox.font", "TextField.font", "TableHeader.font", "Table.font", "ScrollPane.font", "Label.font", "TextArea.font", "Button.font", "TitledBorder.font", "PasswordField.font", "ComboBox.font", "Menu.font", "ListBox.font", "MenuItem.font"};

    DefaultUIProperties(UIDefaultsTable uIDefaultsTable, ResourceBundle resourceBundle, FontProvider fontProvider) {
        this.table = uIDefaultsTable;
        this.bundle = resourceBundle;
        this.fontProvider = fontProvider;
    }

    @Override
    public void initialize() {
        DefaultUIProperties.configureCJKFonts();
        Font font = (Font)this.table.getProperty("OptionPane.font");
        int n = font.getStyle();
        if (n == 1) {
            n = 0;
        }
        FontUIResource fontUIResource = new FontUIResource(this.fontProvider.getFont(n, font));
        for (String string : this.uiFontArray) {
            this.table.setProperty(string, fontUIResource);
        }
        this.table.setProperty("TitledBorder.titleColor", Color.BLACK);
        this.table.setProperty("Table.focusCellHighlightBorder", this.table.getProperty("Table.selectionBackground"));
        this.table.setProperty("FileChooser.cancelButtonText", this.bundle.getString("button.cancel"));
    }

    @Override
    public void undo() {
        this.table.undo();
    }

    private static void configureCJKFonts() {
        GraphicsEnvironment.getLocalGraphicsEnvironment().preferProportionalFonts();
    }
}

