/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.help;

import com.google.inject.Inject;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.instutil.InstUtilPropertyKey;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.wizard.Desktop;
import com.mathworks.wizard.ResourceRetriever;
import com.mathworks.wizard.SourcePathProvider;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.help.Help;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;

final class HelpImpl
implements Help {
    private final SourcePathProvider provider;
    private final ResourceRetriever resources;
    private final ExceptionHandler exHandler;
    private final Desktop desktop;
    private final WizardUI wizardUI;
    private Platform platform;
    private final Properties properties;

    @Inject
    HelpImpl(SourcePathProvider sourcePathProvider, ResourceRetriever resourceRetriever, ExceptionHandler exceptionHandler, Desktop desktop, WizardUI wizardUI, Platform platform, Properties properties) {
        this.provider = sourcePathProvider;
        this.resources = resourceRetriever;
        this.exHandler = exceptionHandler;
        this.desktop = desktop;
        this.wizardUI = wizardUI;
        this.platform = platform;
        this.properties = properties;
    }

    @Override
    public URI getHelpURI(String string) {
        String string2 = this.resources.getResource(string, new Object[0]);
        String string3 = this.properties.getProperty(InstUtilPropertyKey.LIBDIR.get());
        String string4 = string3 == null ? this.provider.getSourcePath() : string3;
        String string5 = this.platform.getLocalizedHelpPath(string2, string4);
        File file = new File(string5);
        return file.toURI();
    }

    @Override
    public void showHelp(String string) {
        this.displayURI(this.getHelpURI(string));
    }

    @Override
    public void displayURI(URI uRI) {
        if (this.desktop.isDesktopSupported()) {
            try {
                this.desktop.browse(uRI);
            }
            catch (IOException iOException) {
                this.exHandler.handleException((Throwable)iOException);
            }
        } else {
            this.wizardUI.showErrorMessage(InstutilResourceKeys.BROWSER_ERROR_TITLE.getString(new Object[0]), InstutilResourceKeys.BROWSER_ERROR_MESSAGE.getString(new Object[]{uRI.toString()}));
        }
    }
}

