/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.components;

import com.google.inject.Inject;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.instutil.wizard.ContextMenu;
import com.mathworks.instutil.wizard.ContextMenuListener;
import com.mathworks.instutil.wizard.HyperlinkHandler;
import com.mathworks.instutil.wizard.InstutilDialog;
import com.mathworks.instutil.wizard.Printer;
import com.mathworks.instutil.wizard.TextComponentConfigurator;
import com.mathworks.instutil.wizard.TextComponentFactory;
import com.mathworks.net.transport.MWTransportClientProperties;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.AccessibleTableFormat;
import com.mathworks.wizard.model.InstallOptionModel;
import com.mathworks.wizard.model.Model;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.resources.WizardComponentName;
import com.mathworks.wizard.ui.AllButtonProperties;
import com.mathworks.wizard.ui.ButtonProperties;
import com.mathworks.wizard.ui.ComponentName;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.OptionType;
import com.mathworks.wizard.ui.WizardUI;
import com.mathworks.wizard.ui.components.ButtonFactory;
import com.mathworks.wizard.ui.components.ButtonStrategy;
import com.mathworks.wizard.ui.components.EditableLabel;
import com.mathworks.wizard.ui.components.EntitlementTableImpl;
import com.mathworks.wizard.ui.components.FileBrowseStrategy;
import com.mathworks.wizard.ui.components.FileInstallationKeyDocument;
import com.mathworks.wizard.ui.components.LinkListener;
import com.mathworks.wizard.ui.components.MinimumSizeButtonFactory;
import com.mathworks.wizard.ui.components.PaintStrategy;
import com.mathworks.wizard.ui.components.PrintableEditorPane;
import com.mathworks.wizard.ui.components.ProductTableImpl;
import com.mathworks.wizard.ui.components.ProxyContainer;
import com.mathworks.wizard.ui.components.ProxyPanel;
import com.mathworks.wizard.ui.components.SwingComponentFactory;
import com.mathworks.wizard.ui.components.TableProvider;
import com.mathworks.wizard.ui.components.TableProviderImpl;
import com.mathworks.wizard.ui.components.TextAreaFocusListener;
import com.mathworks.wizard.ui.help.Help;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

final class SwingComponentFactoryImpl
implements SwingComponentFactory {
    static final int MAX_OPTION_PANE_MESSAGE_WIDTH = 475;
    private final ResourceBundle resourceBundle;
    private final JPopupMenu menu;
    private final ContextMenuListener listener;
    private final ButtonStrategy buttonStrategy;
    private final ExceptionHandler handler;
    private final Help hlp;
    private final PaintStrategy paintStrategy;
    private final HyperlinkHandler hyperlinkHandler;
    private final Printer printer;
    private final MWTransportClientProperties tcp;
    private final FileBrowseStrategy fileBrowseStrategy;
    private final TextComponentFactory textComponentFactory;
    private final TextComponentConfigurator textComponentConfigurator;

    @Inject
    SwingComponentFactoryImpl(ResourceBundle resourceBundle, ButtonStrategy buttonStrategy, ExceptionHandler exceptionHandler, Help help, PaintStrategy paintStrategy, HyperlinkHandler hyperlinkHandler, Printer printer, MWTransportClientProperties mWTransportClientProperties, FileBrowseStrategy fileBrowseStrategy, TextComponentFactory textComponentFactory, TextComponentConfigurator textComponentConfigurator) {
        this.resourceBundle = resourceBundle;
        this.buttonStrategy = buttonStrategy;
        this.handler = exceptionHandler;
        this.hlp = help;
        this.paintStrategy = paintStrategy;
        this.hyperlinkHandler = hyperlinkHandler;
        this.printer = printer;
        this.tcp = mWTransportClientProperties;
        this.fileBrowseStrategy = fileBrowseStrategy;
        this.textComponentFactory = textComponentFactory;
        this.textComponentConfigurator = textComponentConfigurator;
        this.menu = new ContextMenu();
        this.listener = new ContextMenuListener(this.menu);
    }

    @Override
    public JButton createButton(ButtonProperties buttonProperties, Action action, ComponentName componentName) {
        JButton jButton = new JButton(action);
        this.setButtonProperties(jButton, buttonProperties);
        jButton.setName(componentName.toString());
        return jButton;
    }

    @Override
    public void setButtonProperties(AbstractButton abstractButton, ButtonProperties buttonProperties) {
        String string = buttonProperties.getText();
        int n = buttonProperties.getMnemonic().hashCode();
        String string2 = buttonProperties.getAccessibleName();
        abstractButton.setText(string);
        this.buttonStrategy.configureButton(abstractButton, n);
        AccessibleContext accessibleContext = abstractButton.getAccessibleContext();
        accessibleContext.setAccessibleName(string2);
    }

    @Override
    public JPanel createTitledBorderPanel(String string, ComponentName componentName) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName(componentName.toString());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        jPanel.setBorder(titledBorder);
        return SwingComponentFactoryImpl.handleOpacity(jPanel);
    }

    @Override
    public JComponent createBrowseableFileTextField(JTextComponent jTextComponent, ComponentName componentName, String string, FileFilter ... fileFilterArray) {
        return this.createBrowseableComponent(jTextComponent, componentName, this.fileBrowseStrategy.createFileBrowseAction(jTextComponent, string, null, fileFilterArray));
    }

    @Override
    public JComponent createBrowseableFolderTextField(JTextComponent jTextComponent, ComponentName componentName, String string) {
        return this.createBrowseableComponent(jTextComponent, componentName, this.fileBrowseStrategy.createFolderBrowseAction(jTextComponent, this.resourceBundle.getString("folder.browse.title"), string, new FileFilter[0]));
    }

    private JComponent createBrowseableComponent(JTextComponent jTextComponent, ComponentName componentName, Action action) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JButton jButton = this.createButton(AllButtonProperties.BROWSE, action, componentName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jTextComponent, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        return SwingComponentFactoryImpl.handleOpacity(jPanel);
    }

    @Override
    public <T> TableProvider createProductTable(ProductModel<T> productModel, ProductTableFormat<T> productTableFormat, TableModelListener ... tableModelListenerArray) {
        ProductTableImpl<T> productTableImpl = new ProductTableImpl<T>(productModel, productTableFormat, WizardComponentName.PRODUCTS_TABLE.toString());
        for (TableModelListener tableModelListener : tableModelListenerArray) {
            productTableImpl.addTableModelListener(tableModelListener);
        }
        JScrollPane jScrollPane = this.createTableScrollPane((JTable)((Object)productTableImpl));
        return new TableProviderImpl((JTable)((Object)productTableImpl), jScrollPane);
    }

    @Override
    public <T> TableProvider createEntitlementTable(Model<T[]> model, Model<T> model2, AccessibleTableFormat<T> accessibleTableFormat, ListSelectionListener ... listSelectionListenerArray) {
        EntitlementTableImpl<T> entitlementTableImpl = new EntitlementTableImpl<T>(model, model2, accessibleTableFormat, WizardComponentName.ENTITLEMENTS_TABLE.toString());
        for (ListSelectionListener listSelectionListener : listSelectionListenerArray) {
            ((JTable)((Object)entitlementTableImpl)).getSelectionModel().addListSelectionListener(listSelectionListener);
        }
        JScrollPane jScrollPane = this.createTableScrollPane((JTable)((Object)entitlementTableImpl));
        return new TableProviderImpl((JTable)((Object)entitlementTableImpl), jScrollPane);
    }

    private JScrollPane createTableScrollPane(JTable jTable) {
        MouseWheelListener[] mouseWheelListenerArray;
        JScrollPane jScrollPane = this.createScrollPane(jTable);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setPreferredSize(new Dimension(0, 0));
        for (MouseWheelListener mouseWheelListener : mouseWheelListenerArray = jScrollPane.getMouseWheelListeners()) {
            jScrollPane.removeMouseWheelListener(mouseWheelListener);
        }
        ProductTableMouseWheelListener productTableMouseWheelListener = new ProductTableMouseWheelListener();
        jScrollPane.addMouseWheelListener(productTableMouseWheelListener);
        return jScrollPane;
    }

    @Override
    public JDialog createProgressDialog(Frame frame, String string, String string2, ComponentName componentName) {
        InstutilDialog instutilDialog = new InstutilDialog(frame, string);
        JPanel jPanel = this.createBackgroundPanel();
        JButton jButton = new JButton();
        jButton.setVisible(false);
        jPanel.add(jButton);
        JPanel jPanel2 = this.createPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        jPanel2.add((Component)this.createNonWrappingLabel(string2, componentName), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        JProgressBar jProgressBar = this.createProgressBar();
        jProgressBar.setStringPainted(false);
        jProgressBar.setIndeterminate(true);
        jPanel2.add((Component)jProgressBar, gridBagConstraints);
        jPanel.add(jPanel2);
        instutilDialog.add(jPanel);
        instutilDialog.pack();
        return instutilDialog;
    }

    @Override
    public ProxyContainer createProxyPanel(WizardUI wizardUI) {
        return SwingComponentFactoryImpl.handleOpacity(new ProxyPanel(this, this.tcp.getProxyHost(), this.tcp.getProxyPort(), this.tcp.getProxyUser(), this.tcp.getProxyPassword()));
    }

    @Override
    public void createAssociation(AbstractButton abstractButton, final InstallOptionModel installOptionModel) {
        abstractButton.setSelected(installOptionModel.isSelected());
        abstractButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                installOptionModel.setSelected(itemEvent.getStateChange() == 1);
            }
        });
    }

    @Override
    public JTextComponent createFileInstallationKeyField(ComponentName componentName, String string) {
        JTextComponent jTextComponent = this.createTextField(componentName, string);
        jTextComponent.setDocument(new FileInstallationKeyDocument());
        return jTextComponent;
    }

    @Override
    public ButtonFactory createButtonFactory(ButtonProperties ... buttonPropertiesArray) {
        return new MinimumSizeButtonFactory(this, buttonPropertiesArray);
    }

    @Override
    public JComponent createLabelWithoutHyperLink(String string, com.mathworks.instutil.wizard.ComponentName componentName) {
        PrintableEditorPane printableEditorPane = SwingComponentFactoryImpl.handleOpacity(this.createEditorPane(string, componentName));
        printableEditorPane.setBorder(null);
        return SwingComponentFactoryImpl.handleOpacity(printableEditorPane);
    }

    @Override
    public JComponent createLabel(String string, com.mathworks.instutil.wizard.ComponentName componentName) {
        PrintableEditorPane printableEditorPane = (PrintableEditorPane)((Object)this.createLabelWithoutHyperLink(string, componentName));
        this.hyperlinkHandler.start((JEditorPane)((Object)printableEditorPane));
        return printableEditorPane;
    }

    @Override
    public JTextComponent createEditableLabel(ComponentName componentName) {
        return this.createEditableLabel(componentName, true, true);
    }

    @Override
    public JTextComponent createWrappingLabel(String string, ComponentName componentName) {
        JTextComponent jTextComponent = this.createEditableLabel(componentName, true, true);
        jTextComponent.setText(string);
        return jTextComponent;
    }

    @Override
    public JComponent createNonWrappingLabel(String string, ComponentName componentName) {
        JTextComponent jTextComponent = this.createNonWrappingEditableLabel(componentName);
        jTextComponent.setText(string);
        return jTextComponent;
    }

    @Override
    public JTextComponent createNonWrappingEditableLabel(ComponentName componentName) {
        return this.createEditableLabel(componentName, false, true);
    }

    @Override
    public JTextComponent createNonWrappingNonAccessibleEditableLabel(ComponentName componentName) {
        return this.createEditableLabel(componentName, false, false);
    }

    private JTextComponent createEditableLabel(ComponentName componentName, boolean bl, boolean bl2) {
        EditableLabel editableLabel = new EditableLabel(bl, bl2);
        editableLabel.setName(componentName.toString());
        this.textComponentConfigurator.configureTextComponent((JTextComponent)editableLabel, (MouseListener)this.listener, this.menu);
        return SwingComponentFactoryImpl.handleOpacity(editableLabel);
    }

    @Override
    public JComponent createPrintableEditorPane(String string, ComponentName componentName) {
        PrintableEditorPane printableEditorPane = this.createEditorPane(string, componentName);
        printableEditorPane.setCursor(Cursor.getPredefinedCursor(2));
        printableEditorPane.addFocusListener(new TextAreaFocusListener((JTextComponent)((Object)printableEditorPane)));
        return printableEditorPane;
    }

    @Override
    public JComponent createPrintableTransparentEditorPane(String string, ComponentName componentName) {
        return SwingComponentFactoryImpl.handleOpacity(this.createPrintableEditorPane(string, componentName));
    }

    private PrintableEditorPane createEditorPane(String string, com.mathworks.instutil.wizard.ComponentName componentName) {
        PrintableEditorPane printableEditorPane = new PrintableEditorPane(string, this.handler, this.printer);
        printableEditorPane.setMargin(new Insets(5, 5, 5, 5));
        printableEditorPane.setName(componentName.toString());
        this.textComponentConfigurator.configureTextComponent((JTextComponent)((Object)printableEditorPane), (MouseListener)this.listener, this.menu);
        printableEditorPane.addHyperlinkListener(new LinkListener(this.hlp, this.handler));
        return printableEditorPane;
    }

    @Override
    public AbstractButton createRadioButton(String string, ComponentName componentName) {
        JRadioButton jRadioButton = new JRadioButton(string);
        jRadioButton.setName(componentName.toString());
        return SwingComponentFactoryImpl.handleOpacity(jRadioButton);
    }

    @Override
    public JComponent createImageComponent(String string) {
        return this.createImageComponent(this.createImageIcon(string));
    }

    @Override
    public JComponent createImageComponent(ImageIcon imageIcon) {
        JLabel jLabel = new JLabel(imageIcon);
        return SwingComponentFactoryImpl.handleOpacity(jLabel);
    }

    @Override
    public Image createImage(String string) {
        return this.createImageIcon(string).getImage();
    }

    @Override
    public JOptionPane createOptionPane(String string, MessageType messageType, OptionType optionType, ComponentName componentName) {
        return this.createOptionPane(this.createLabel(string, componentName), messageType, optionType, componentName);
    }

    @Override
    public JOptionPane createOptionPane(Component component, MessageType messageType, OptionType optionType, ComponentName componentName) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("createOptionPane must be called on the Swing Event Dispatch Thread.");
        }
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 475;
                return dimension;
            }
        };
        jPanel.add(component, "Center");
        JOptionPane jOptionPane = new JOptionPane(jPanel, messageType.getMessageType()){

            @Override
            protected void paintComponent(Graphics graphics) {
                SwingComponentFactoryImpl.this.paintStrategy.paintBackground(graphics, this);
                super.paintComponent(graphics);
            }
        };
        optionType.configure(this, jOptionPane);
        jOptionPane.setUI(new BasicOptionPaneUI(){

            @Override
            protected Container createButtonArea() {
                Container container = super.createButtonArea();
                if (container instanceof JComponent) {
                    SwingComponentFactoryImpl.handleOpacity((JComponent)container);
                }
                return container;
            }

            @Override
            protected Container createMessageArea() {
                Container container = super.createMessageArea();
                SwingComponentFactoryImpl.handleChildrenOpacity(container);
                if (container instanceof JComponent) {
                    SwingComponentFactoryImpl.handleOpacity((JComponent)container);
                }
                return container;
            }
        });
        return SwingComponentFactoryImpl.handleOpacity(jOptionPane);
    }

    @Override
    public JPanel createPanel() {
        return this.createPanel(new BorderLayout());
    }

    @Override
    public JPanel createPanel(LayoutManager layoutManager) {
        return SwingComponentFactoryImpl.handleOpacity(new JPanel(layoutManager));
    }

    @Override
    public JPanel createNavigationBackgroundPanel() {
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics graphics) {
                SwingComponentFactoryImpl.this.paintStrategy.paintNavigationBackground(graphics, this);
                super.paintComponent(graphics);
            }
        };
        return SwingComponentFactoryImpl.handleOpacity(jPanel);
    }

    @Override
    public JPanel createBackgroundPanel() {
        JPanel jPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics graphics) {
                SwingComponentFactoryImpl.this.paintStrategy.paintBackground(graphics, this);
                super.paintComponent(graphics);
            }
        };
        return SwingComponentFactoryImpl.handleOpacity(jPanel);
    }

    @Override
    public JProgressBar createProgressBar() {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setStringPainted(true);
        return jProgressBar;
    }

    @Override
    public void createButtonGroup(AbstractButton ... abstractButtonArray) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (AbstractButton abstractButton : abstractButtonArray) {
            buttonGroup.add(abstractButton);
        }
    }

    @Override
    public void createRelationship(ItemSelectable itemSelectable, final Component ... componentArray) {
        boolean bl = itemSelectable.getSelectedObjects() != null;
        SwingComponentFactoryImpl.setComponentsEnabled(bl, componentArray);
        itemSelectable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SwingComponentFactoryImpl.setComponentsEnabled(itemEvent.getStateChange() == 1, componentArray);
            }
        });
    }

    @Override
    public void addDocumentObserver(Document document, final WizardObserver wizardObserver) {
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                wizardObserver.update();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                wizardObserver.update();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                wizardObserver.update();
            }
        });
    }

    @Override
    public AbstractButton createCheckBox(String string, ComponentName componentName) {
        JCheckBox jCheckBox = new JCheckBox(string);
        jCheckBox.setName(componentName.toString());
        return SwingComponentFactoryImpl.handleOpacity(jCheckBox);
    }

    @Override
    public AbstractButton createCheckBoxWithoutLabel(ComponentName componentName) {
        JCheckBox jCheckBox = new JCheckBox();
        return SwingComponentFactoryImpl.handleOpacity(jCheckBox);
    }

    @Override
    public JScrollPane createScrollPane(final JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent){

            @Override
            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                jComponent.setEnabled(bl);
            }
        };
        jScrollPane.getViewport().setPreferredSize(new Dimension(0, 0));
        return jScrollPane;
    }

    @Override
    public JScrollPane createTransparentScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = this.createScrollPane(jComponent);
        SwingComponentFactoryImpl.handleOpacity(jScrollPane.getViewport());
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        return SwingComponentFactoryImpl.handleOpacity(jScrollPane);
    }

    private static void setComponentsEnabled(boolean bl, Component ... componentArray) {
        for (Component component : componentArray) {
            component.setEnabled(bl);
        }
    }

    private static <T extends JComponent> T handleOpacity(T t) {
        t.setOpaque(false);
        return t;
    }

    private static void handleChildrenOpacity(Container container) {
        Component[] componentArray;
        for (Component component : componentArray = container.getComponents()) {
            if (component instanceof Container) {
                SwingComponentFactoryImpl.handleChildrenOpacity((Container)component);
            }
            if (!(component instanceof JComponent) || component instanceof JTextField) continue;
            SwingComponentFactoryImpl.handleOpacity((JComponent)component);
        }
    }

    private ImageIcon createImageIcon(String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return new ImageIcon();
        }
        return new ImageIcon(uRL);
    }

    public JTextComponent createActivationKeyField(com.mathworks.instutil.wizard.ComponentName componentName, String string) {
        return this.textComponentFactory.createActivationKeyField(componentName, string);
    }

    public JTextComponent createPortNumberField(com.mathworks.instutil.wizard.ComponentName componentName, String string) {
        return this.textComponentFactory.createPortNumberField(componentName, string);
    }

    public JTextComponent createSerialNumberField(com.mathworks.instutil.wizard.ComponentName componentName, String string) {
        return this.textComponentFactory.createSerialNumberField(componentName, string);
    }

    public JTextComponent createTextField(com.mathworks.instutil.wizard.ComponentName componentName, String string) {
        return this.textComponentFactory.createTextField(componentName, string);
    }

    public JTextComponent createPasswordField(com.mathworks.instutil.wizard.ComponentName componentName) {
        return this.textComponentFactory.createPasswordField(componentName);
    }

    public void configureTextComponent(JTextComponent jTextComponent, MouseListener mouseListener, JPopupMenu jPopupMenu) {
        this.textComponentConfigurator.configureTextComponent(jTextComponent, mouseListener, jPopupMenu);
    }

    public void setupSelectAllOnFocusListener(JTextComponent jTextComponent) {
        this.textComponentConfigurator.setupSelectAllOnFocusListener(jTextComponent);
    }

    public void enableDragAndDrop(JComponent jComponent, JTextComponent jTextComponent) {
        this.textComponentConfigurator.enableDragAndDrop(jComponent, jTextComponent);
    }

    private static final class ProductTableMouseWheelListener
    implements MouseWheelListener {
        private ProductTableMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.getScrollType() == 0) {
                int n = mouseWheelEvent.getWheelRotation() * 16;
                JScrollPane jScrollPane = (JScrollPane)mouseWheelEvent.getSource();
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                jScrollBar.setValue(jScrollBar.getValue() + n);
            }
        }
    }
}

