/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.components;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventTableModel;
import com.mathworks.wizard.WizardObserver;
import com.mathworks.wizard.model.ProductModel;
import com.mathworks.wizard.model.ProductTableFormat;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.components.AbstractTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

final class ProductTableImpl<T>
extends AbstractTable<T>
implements WizardObserver {
    private static final int CHECKBOX_COLUMN_INDEX = 0;
    private final ProductModel<T> productModel;
    private final ProductTableFormat<T> productTableFormat;
    private final JCheckBox selectAllCheckBox;

    ProductTableImpl(ProductModel<T> productModel, ProductTableFormat<T> productTableFormat, String string) {
        super(ProductTableImpl.createEventList(productModel), productTableFormat, string, WizardResourceKeys.PRODUCT_TABLE_ACCESSIBLE.getString(new Object[0]));
        this.productModel = productModel;
        this.productTableFormat = productTableFormat;
        this.tableHeader.setReorderingAllowed(false);
        this.selectAllCheckBox = new JCheckBox();
        this.configureCheckBoxColumn(this.selectAllCheckBox);
        this.makeProductNameColumnHeaderLeftJustified();
        this.addMouseListener(new ProductMouseListener());
        productModel.addObserver(this);
        this.setKeyBindings();
    }

    private void makeProductNameColumnHeaderLeftJustified() {
        this.leftAlignColumnAt(1);
    }

    private void configureCheckBoxColumn(JCheckBox jCheckBox) {
        jCheckBox.setHorizontalAlignment(0);
        this.synchronizeCheckBoxStateWithProductModel(jCheckBox);
        this.addCheckBoxToCheckBoxColumnHeader(jCheckBox);
        this.disableCheckBoxColumnExpansion();
    }

    private void addCheckBoxToCheckBoxColumnHeader(JCheckBox jCheckBox) {
        TableColumn tableColumn = this.tableHeader.getColumnModel().getColumn(0);
        tableColumn.setHeaderRenderer(new ComponentHeaderRenderer());
        tableColumn.setHeaderValue(jCheckBox);
        this.tableHeader.addMouseListener(new ColumnHeaderListener());
    }

    private void synchronizeCheckBoxStateWithProductModel(JCheckBox jCheckBox) {
        jCheckBox.setSelected(this.productModel.allLatestSelected());
    }

    private void disableCheckBoxColumnExpansion() {
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(tableColumn.getMinWidth());
    }

    private static <T> EventList<T> createEventList(ProductModel<T> productModel) {
        BasicEventList basicEventList = new BasicEventList();
        basicEventList.addAll(productModel.getAvailable());
        return basicEventList;
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableModel.addTableModelListener(tableModelListener);
    }

    private void setKeyBindings() {
        InputMap inputMap = this.getInputMap();
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "select");
        actionMap.put("select", this.getSelectionAction(this.tableModel));
        inputMap.put(KeyStroke.getKeyStroke(65, 128), "all");
        actionMap.put("all", new SelectAllAction());
    }

    private Action getSelectionAction(final EventTableModel<T> eventTableModel) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ProductTableImpl.this.getSelectedRow();
                Object object = eventTableModel.getElementAt(n);
                ProductTableImpl.this.productModel.toggleSelect(object);
            }
        };
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        Component component = focusEvent.getOppositeComponent();
        if (component != null) {
            Container container = component.getParent();
            if (focusEvent.getID() == 1004 && container != null && !container.equals(this)) {
                int[] nArray = this.getSelectedRows();
                int[] nArray2 = this.getSelectedColumns();
                if (!this.eventList.isEmpty() && nArray.length == 0 && nArray2.length == 0) {
                    this.setColumnSelectionInterval(0, 0);
                    this.setRowSelectionInterval(0, 0);
                }
            }
        }
    }

    public void editingStopped(ChangeEvent changeEvent) {
        super.editingStopped(changeEvent);
        this.requestFocusInWindow();
    }

    @Override
    public void update() {
        for (int i = 0; i < this.eventList.size(); ++i) {
            this.eventList.set(i, this.eventList.get(i));
        }
        this.synchronizeCheckBoxStateWithProductModel(this.selectAllCheckBox);
        this.tableHeader.invalidate();
        this.tableHeader.repaint();
    }

    private static class ComponentHeaderRenderer
    implements TableCellRenderer {
        private ComponentHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return (Component)object;
        }
    }

    private class ColumnHeaderListener
    extends MouseAdapter {
        private ColumnHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = ((JTableHeader)mouseEvent.getSource()).getTable();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            if (n == 0 && mouseEvent.getButton() == 1) {
                ProductTableImpl.this.productModel.toggleSelectAll();
            }
        }
    }

    private final class ProductMouseListener
    extends MouseAdapter {
        private int pressedRow = 0;
        private int pressedColumn = 0;

        private ProductMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                JTable jTable = (JTable)mouseEvent.getSource();
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.pressedRow = jTable.rowAtPoint(point);
                this.pressedColumn = jTable.columnAtPoint(point);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                JTable jTable = (JTable)mouseEvent.getSource();
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n = jTable.rowAtPoint(point);
                int n2 = jTable.columnAtPoint(point);
                if (n == this.pressedRow) {
                    Object object = ProductTableImpl.this.tableModel.getElementAt(n);
                    ProductTableImpl.this.productTableFormat.toggleSelect(object, this.pressedColumn, n2);
                }
            }
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductTableImpl.this.productModel.toggleSelectAll();
        }
    }
}

