/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui.components;

import com.mathworks.wizard.ui.ButtonProperties;
import com.mathworks.wizard.ui.ComponentName;
import com.mathworks.wizard.ui.components.ButtonFactory;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;

final class MinimumSizeButtonFactory
implements ButtonFactory {
    private final List<ButtonProperties> props;
    private final ButtonFactory buttonFactory;

    MinimumSizeButtonFactory(ButtonFactory buttonFactory, ButtonProperties ... buttonPropertiesArray) {
        this.buttonFactory = buttonFactory;
        this.props = Arrays.asList(buttonPropertiesArray);
    }

    @Override
    public JButton createButton(ButtonProperties buttonProperties, Action action, ComponentName componentName) {
        JButton jButton = this.buttonFactory.createButton(buttonProperties, action, componentName);
        Dimension dimension = jButton.getPreferredSize();
        int n = this.getMaxWidth(componentName, dimension.width);
        jButton.setPreferredSize(new Dimension(n, dimension.height));
        return jButton;
    }

    private int getMaxWidth(ComponentName componentName, int n) {
        int n2 = n;
        for (ButtonProperties buttonProperties : this.props) {
            JButton jButton = this.buttonFactory.createButton(buttonProperties, null, componentName);
            int n3 = jButton.getPreferredSize().width;
            n2 = Math.max(n2, n3);
        }
        return n2;
    }
}

