/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.ui;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.command.Command;
import com.mathworks.wizard.ui.MessageType;
import com.mathworks.wizard.ui.OptionType;
import com.mathworks.wizard.ui.Response;
import com.mathworks.wizard.ui.WizardUI;
import java.awt.Component;
import java.awt.Image;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;

final class WizardUIAutomated
implements WizardUI {
    private final WizardUI wizardUI;
    private final AppLogger appLogger;

    @Inject
    WizardUIAutomated(@Named(value="BaseWizardUI") WizardUI wizardUI, AppLogger appLogger) {
        this.wizardUI = wizardUI;
        this.appLogger = appLogger;
    }

    @Override
    public void showErrorMessage(String string, String string2) {
        this.wizardUI.showErrorMessage(string, string2);
    }

    @Override
    public boolean getResponseToYesNoQuestion(String string, String string2, MessageType messageType) {
        return this.getResponseToQuestion(string, string2, messageType, OptionType.YES_NO).equals((Object)Response.YES);
    }

    @Override
    public Response getResponseToQuestion(String string, String string2, MessageType messageType, OptionType optionType) {
        if (MessageType.ERROR.equals((Object)messageType)) {
            return this.wizardUI.getResponseToQuestion(string, string2, messageType, optionType);
        }
        this.appLogger.logMsg(string2);
        return optionType.getDefaultResponse();
    }

    @Override
    public void setTitle(String string) {
        this.wizardUI.setTitle(string);
    }

    @Override
    public boolean showWarningMessage(String string, String string2) {
        this.appLogger.logMsg("Warning: " + string2);
        return true;
    }

    @Override
    public void closeAndDispose() {
        this.wizardUI.closeAndDispose();
    }

    @Override
    public void showProgress(String string, String string2, Command command) {
        this.wizardUI.showProgress(string, string2, command);
    }

    @Override
    public void hideProgress() {
        this.wizardUI.hideProgress();
    }

    @Override
    public void showInfoMessage(String string, Component component) {
        this.wizardUI.showInfoMessage(string, component);
    }

    @Override
    public boolean showPlainMessage(String string, Component component) {
        return this.wizardUI.showPlainMessage(string, component);
    }

    @Override
    public void showPanel(JPanel jPanel, String string, JPanel jPanel2, JButton jButton, Command command, String string2, String string3) {
        this.wizardUI.showPanel(jPanel, string, jPanel2, jButton, command, string2, string3);
    }

    @Override
    public boolean showMessageWithoutHidingProgressDialog(String string, Component component) {
        return this.wizardUI.showMessageWithoutHidingProgressDialog(string, component);
    }

    @Override
    public void setIconImages(List<Image> list) {
        this.wizardUI.setIconImages(list);
    }

    @Override
    public void showBusyCursor(Command command) {
        this.wizardUI.showBusyCursor(command);
    }

    @Override
    public void showInfoMessage(String string, String string2) {
        this.wizardUI.showInfoMessage(string, string2);
    }

    @Override
    public void hideBusyCursor() {
        this.wizardUI.hideBusyCursor();
    }
}

