/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard.command;

import com.mathworks.wizard.Step;
import com.mathworks.wizard.StepCallback;
import com.mathworks.wizard.worker.Worker;
import com.mathworks.wizard.worker.WorkerFactory;
import com.mathworks.wizard.worker.WorkerListener;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

abstract class AbstractTaskStep
implements Step {
    private final Callable<Boolean> task;
    private final WorkerFactory workerFactory;

    AbstractTaskStep(Callable<Boolean> callable, WorkerFactory workerFactory) {
        this.task = callable;
        this.workerFactory = workerFactory;
    }

    @Override
    public final void forwardVisitStep(StepCallback stepCallback) {
        Worker<Boolean> worker = this.workerFactory.createWorker(this.task, new MyWorkerListener(stepCallback));
        this.preSubmitTask(stepCallback, worker);
        worker.execute();
    }

    abstract void postWaitForTaskToFinish();

    abstract void preSubmitTask(StepCallback var1, Future<Boolean> var2);

    private class MyWorkerListener
    implements WorkerListener<Boolean> {
        private final StepCallback callback;

        MyWorkerListener(StepCallback stepCallback) {
            this.callback = stepCallback;
        }

        @Override
        public void done(Boolean bl) {
            AbstractTaskStep.this.postWaitForTaskToFinish();
            if (bl.booleanValue()) {
                this.callback.stepForward();
            } else {
                AbstractTaskStep.this.reverseVisitStep(this.callback);
            }
        }

        @Override
        public void cancelled() {
            this.done(false);
        }
    }
}

