/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.google.inject.Inject;
import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.Step;
import com.mathworks.wizard.StepCallback;
import com.mathworks.wizard.StepSequencer;
import com.mathworks.wizard.StepSequencerImpl;
import com.mathworks.wizard.Wizard;
import com.mathworks.wizard.WizardFactory;
import com.mathworks.wizard.Workflow;
import com.mathworks.wizard.ui.panels.PanelStepBuilder;
import java.util.ArrayList;
import java.util.List;

final class WizardFactoryImpl
implements WizardFactory {
    private final PanelStepBuilder pnlStepBuilder;
    private final ExitHandler exitHandler;

    @Inject
    WizardFactoryImpl(PanelStepBuilder panelStepBuilder, ExitHandler exitHandler) {
        this.pnlStepBuilder = panelStepBuilder;
        this.exitHandler = exitHandler;
    }

    @Override
    public List<Step> createWorkflowSteps(final Workflow workflow) {
        final ArrayList<Step> arrayList = new ArrayList<Step>();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                workflow.construct(new Wizard(){

                    @Override
                    public Wizard addStep(Step step) {
                        arrayList.add(step);
                        return this;
                    }
                }, WizardFactoryImpl.this.pnlStepBuilder);
            }
        };
        InstallerUtilities.doNowOnEDT((Runnable)runnable);
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("Workflow must contain 1 or more steps.");
        }
        if (workflow.hasBranch()) {
            arrayList.add(new CreateAndStartBranchStep(workflow));
        }
        return arrayList;
    }

    @Override
    public StepSequencer createStepSequencer() {
        return new StepSequencerImpl(this.exitHandler);
    }

    private static class GoBackToWorkflowStep
    implements Step {
        private final StepCallback fromCallback;

        GoBackToWorkflowStep(StepCallback stepCallback) {
            this.fromCallback = stepCallback;
        }

        @Override
        public void reverseVisitStep(StepCallback stepCallback) {
            this.fromCallback.stepBack();
        }

        @Override
        public void forwardVisitStep(StepCallback stepCallback) {
            stepCallback.stepForward();
        }
    }

    private class CreateAndStartBranchStep
    implements Step {
        private final Workflow workflow;

        CreateAndStartBranchStep(Workflow workflow) {
            this.workflow = workflow;
        }

        @Override
        public void reverseVisitStep(StepCallback stepCallback) {
        }

        @Override
        public void forwardVisitStep(StepCallback stepCallback) {
            List<Step> list = WizardFactoryImpl.this.createWorkflowSteps(this.workflow.getBranch());
            list.add(0, new GoBackToWorkflowStep(stepCallback));
            StepSequencer stepSequencer = WizardFactoryImpl.this.createStepSequencer();
            stepSequencer.startSequence(list.toArray(new Step[list.size()]));
        }
    }
}

