/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.google.inject.Inject;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.wizard.ExceptionHandlerImplUtility;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ExitStatus;
import com.mathworks.wizard.resources.WizardResourceKeys;
import com.mathworks.wizard.ui.WizardUI;
import java.io.PrintWriter;
import java.io.StringWriter;

final class ExceptionHandlerImpl
implements ExceptionHandler {
    private final WizardUI ui;
    private final AppLogger appLogger;
    private final ExitHandler exitHandler;
    private Thread.UncaughtExceptionHandler originalUncaughtExceptionHandler;

    @Inject
    ExceptionHandlerImpl(WizardUI wizardUI, AppLogger appLogger, ExitHandler exitHandler) {
        this.ui = wizardUI;
        this.appLogger = appLogger;
        this.exitHandler = exitHandler;
    }

    public void handleException(Throwable throwable) {
        this.displayDefaultExceptionMessage(throwable, "");
    }

    public void logException(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        this.appLogger.logMsg(stringWriter.toString());
        ExceptionHandlerImplUtility.setException(throwable);
    }

    public void initialize() {
        this.originalUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)((Object)this));
    }

    public void handleException(Throwable throwable, String string, String string2) {
        this.logException(throwable);
        this.ui.showErrorMessage(string, string2);
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        this.handleExceptionThatRequiresExit(throwable);
        this.exitHandler.exit(ExitStatus.FAILED);
    }

    public void unwindAndExit(Throwable throwable) {
        throw new RuntimeException(throwable);
    }

    public void exit() {
        Thread.setDefaultUncaughtExceptionHandler(this.originalUncaughtExceptionHandler);
    }

    private void displayDefaultExceptionMessage(Throwable throwable, String string) {
        String string2 = WizardResourceKeys.EXCEPTION_TITLE.getString(new Object[0]);
        String string3 = WizardResourceKeys.EXCEPTION_MESSAGE.getString(string, this.appLogger.getPath());
        this.handleException(throwable, string2, string3);
    }

    public void handleExceptionThatRequiresExit(Throwable throwable) {
        this.displayDefaultExceptionMessage(throwable, " ".concat(WizardResourceKeys.EXCEPTION_TEXT_CLOSE.getString(new Object[0])));
    }

    public Exception processException(Throwable throwable) {
        return null;
    }
}

