/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.wizard;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.mathworks.instutil.logging.LoggingFilterStrategy;
import com.mathworks.instutil.logging.SensitiveInformationLoggingFilterStrategyImpl;
import com.mathworks.wizard.ExitHandler;
import com.mathworks.wizard.ExitStatus;
import com.mathworks.wizard.LoggerModule;
import com.mathworks.wizard.PropertyKey;
import com.mathworks.wizard.WizardLauncher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractLauncher {
    private ExitHandler exitHandler;

    public void launchStandalone(String[] stringArray, Module ... moduleArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(stringArray));
        arrayList.add('-' + PropertyKey.STANDALONE.get());
        this.launch(arrayList, moduleArray);
    }

    protected void addAdditionalArguments(Collection<String> collection) {
    }

    public void launch(Collection<String> collection, Module ... moduleArray) {
        this.addAdditionalArguments(collection);
        this.exitHandler = WizardLauncher.start(collection.toArray(new String[collection.size()]), this.getLoggingConfigurationModule(), this.getLoggingStrategyModule(), Modules.override((Module[])this.getModules()).with(moduleArray));
    }

    public int waitForExitCode() {
        if (this.exitHandler == null) {
            throw new IllegalStateException("launch() method must be called before waitFor()");
        }
        ExitStatus exitStatus = this.exitHandler.waitFor();
        return exitStatus.getExitCode();
    }

    protected abstract Module[] getModules();

    protected Module getLoggingStrategyModule() {
        return new AbstractModule(){

            protected void configure() {
                this.bind(LoggingFilterStrategy.class).to(SensitiveInformationLoggingFilterStrategyImpl.class);
            }
        };
    }

    protected Module getLoggingConfigurationModule() {
        return new LoggerModule();
    }
}

