/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.messageservice.test;

import com.mathworks.messageservice.Message;
import com.mathworks.messageservice.MessageService;
import com.mathworks.messageservice.Subscriber;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MessageServiceLoopback
implements MessageService {
    private static final Logger logger = Logger.getLogger(MessageServiceLoopback.class.getName());
    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("message service loopback");
            thread.setDaemon(true);
            return thread;
        }
    });
    private Deque<PendingMessage> pendingMessageTasks = new ArrayDeque<PendingMessage>();
    private MessageService messageService;
    private int delayMs;
    protected final Map<String, List<Subscriber>> subscriptions = new HashMap<String, List<Subscriber>>();
    protected final ReadWriteLock subscriptionLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(String channel, Subscriber subscriber) {
        if (!this.isChannelValid(channel)) {
            throw new IllegalArgumentException("Invalid channel");
        }
        Lock l = this.subscriptionLock.writeLock();
        l.lock();
        try {
            if (!this.subscriptions.containsKey(channel)) {
                ArrayList<Subscriber> subscribers = new ArrayList<Subscriber>();
                subscribers.add(subscriber);
                this.subscriptions.put(channel, subscribers);
            } else {
                this.subscriptions.get(channel).add(subscriber);
            }
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(String channel, Subscriber subscriber) {
        block6: {
            Lock l = this.subscriptionLock.writeLock();
            l.lock();
            try {
                if (this.subscriptions.containsKey(channel)) {
                    if (this.subscriptions.get(channel).contains(subscriber)) {
                        this.subscriptions.get(channel).remove(subscriber);
                        if (this.subscriptions.get(channel).isEmpty()) {
                            this.subscriptions.remove(channel);
                        }
                        break block6;
                    }
                    throw new IllegalArgumentException("Subscriber does not exist");
                }
                throw new IllegalArgumentException("Channel does not exist");
            }
            finally {
                l.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message message) {
        ArrayList subscribers = new ArrayList();
        Lock l = this.subscriptionLock.readLock();
        l.lock();
        try {
            for (String channel : this.subscriptions.keySet()) {
                if (!this.doesSubscriptionChannelMatchMessage(channel, message)) continue;
                subscribers.addAll(this.subscriptions.get(channel));
            }
        }
        finally {
            l.unlock();
        }
        for (Subscriber subscriber : subscribers) {
            try {
                subscriber.handle(message);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error in subscription handler", e);
            }
        }
    }

    @Override
    public void publish(final String channel, final Object data) {
        if (this.delayMs > 0) {
            final PendingMessage message = new PendingMessage();
            message.runnable = new Runnable(){

                @Override
                public void run() {
                    MessageServiceLoopback.this.pendingMessageTasks.remove(message);
                    MessageServiceLoopback.this.doPublish(channel, data);
                }
            };
            message.future = this.service.schedule(message.runnable, (long)this.delayMs, TimeUnit.MILLISECONDS);
            this.pendingMessageTasks.push(message);
        } else {
            this.doPublish(channel, data);
        }
    }

    private void doPublish(final String channel, final Object data) {
        if (this.messageService != null) {
            this.messageService.handleMessage(new Message(){

                @Override
                public String getChannel() {
                    return channel;
                }

                @Override
                public Object getData() {
                    return data;
                }
            });
        }
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setDelay(int ms) {
        this.delayMs = ms;
    }

    public void flush() {
        while (!this.pendingMessageTasks.isEmpty()) {
            PendingMessage message = this.pendingMessageTasks.pop();
            message.future.cancel(false);
            message.runnable.run();
        }
    }

    public void deliverNext() {
        if (!this.pendingMessageTasks.isEmpty()) {
            PendingMessage message = this.pendingMessageTasks.pop();
            message.future.cancel(false);
            message.runnable.run();
        }
    }

    private boolean doesSubscriptionChannelMatchMessage(String channel, Message message) {
        String[] subChannelPath;
        boolean matches = true;
        String[] channelPath = StringUtils.split((String)message.getChannel(), (String)"/");
        if (channelPath.length >= (subChannelPath = StringUtils.split((String)channel, (String)"/")).length) {
            int lastPathIndex = subChannelPath.length - 1;
            for (int i = 0; i < lastPathIndex; ++i) {
                if (subChannelPath[i].equals(channelPath[i])) continue;
                matches = false;
                break;
            }
            boolean isSameLength = channelPath.length == subChannelPath.length;
            boolean isWildCard = subChannelPath[lastPathIndex].equals("*");
            boolean isDoubleWildCard = subChannelPath[lastPathIndex].equals("**");
            boolean isSamePath = subChannelPath[lastPathIndex].equals(channelPath[lastPathIndex]);
            if (!(isDoubleWildCard || isSameLength && (isSamePath || isWildCard))) {
                matches = false;
            }
        } else {
            matches = false;
        }
        return matches;
    }

    private boolean isChannelValid(String channel) {
        if (channel.contains(" ")) {
            return false;
        }
        if ((channel.contains("*") || channel.contains("**")) && channel.lastIndexOf("*") != channel.length() - 1) {
            return false;
        }
        if (channel.charAt(0) != '/') {
            return false;
        }
        return channel.charAt(channel.length() - 1) != '/';
    }

    private class PendingMessage {
        public ScheduledFuture future;
        public Runnable runnable;

        private PendingMessage() {
        }
    }
}

