/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_task.udc;

import com.google.inject.Inject;
import com.mathworks.install.udc.UdcResourceKey;
import com.mathworks.install.udc.UdcResourceRetriever;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.install_impl.udc.UdcClientTask;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.mlwebservices.WSEndPoints;
import com.mathworks.webservices.udc.client.UDCClient;
import com.mathworks.webservices.udc.client.installer.GpuInfo;
import com.mathworks.webservices.udc.client.installer.InstallerUdcData;
import com.mathworks.webservices.udc.client.installer.ObjectFactory;
import com.mathworks.webservices.udc.client.installer.PanelData;
import com.mathworks.webservices.udc.client.installer.ProductData;
import com.mathworks.webservices.udc.client.installer.Utils;
import com.mathworks.webservices.udc.model.Event;
import com.mathworks.webservices.udc.model.Events;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.JAXBException;

public class InstallerUsageDataCollectorImpl
implements UsageDataCollector {
    private static final Class<ProductData> PRODUCT_DATA_CLASS = ProductData.class;
    private static final Class<PanelData> PANEL_DATA_CLASS = PanelData.class;
    private String APPLICATION_NAME = "";
    private String APPLICATION_VERSION = "";
    private static final String INSTALL_XML_DATA = "INSTALL_XML_DATA";
    private static final String CHARACTER_ENCODING = StandardCharsets.UTF_8.name();
    private static final int LOG_EVENTS_TIMEOUT = 15;
    private static final String GPU_REGEX = "%&#";
    private final Map<UsageDataCollectorKey, Object> keyValueMap = new EnumMap<UsageDataCollectorKey, Object>(UsageDataCollectorKey.class);
    private final ObjectFactory xsdObjectFactory;
    private final AppLogger appLogger;
    private final UDCClient udcClient;
    private final InstallerUdcData installerUdcDataType;
    private final List<ProductData> productDataList;
    private final List<PanelData> panelDataList;
    private final Set<String> panelNames = new HashSet<String>();
    private final List<String> gpuList = new ArrayList<String>();
    private final List<Event> eventList = new ArrayList<Event>();
    private final UdcResourceRetriever resourceRetriever;
    private boolean disableEvents;
    private String logFileFullPath;
    private String sessionKey;
    private String token;
    private Properties[] properties;
    private static final String MW_DISABLE_EVENTS = "MW_DISABLE_EVENTS";

    @Inject
    public InstallerUsageDataCollectorImpl(AppLogger appLogger, UDCClient uDCClient, UdcResourceRetriever udcResourceRetriever, String string, String string2, String string3, String string4, Properties ... propertiesArray) {
        boolean bl;
        this.appLogger = appLogger;
        this.udcClient = uDCClient;
        this.resourceRetriever = udcResourceRetriever;
        this.APPLICATION_NAME = string2;
        this.APPLICATION_VERSION = string3;
        this.token = string4;
        this.properties = propertiesArray;
        this.xsdObjectFactory = new ObjectFactory();
        this.installerUdcDataType = this.xsdObjectFactory.createInstallerUdcData();
        this.productDataList = this.installerUdcDataType.getProductData();
        this.panelDataList = this.installerUdcDataType.getPanelData();
        String string5 = System.getenv(MW_DISABLE_EVENTS);
        String string6 = null;
        if (propertiesArray != null && propertiesArray.length != 0) {
            string6 = propertiesArray[0].getProperty("disableEvents");
        }
        if (string6 != null || string5 != null) {
            this.disableEvents = true;
        }
        boolean bl2 = bl = string != null && !string.isEmpty();
        if (bl && !this.disableEvents) {
            this.logFileFullPath = string;
        }
    }

    public void addData(UsageDataCollectorKey usageDataCollectorKey, Object object) {
        if (UsageDataCollectorKey.PRODUCT_DATA_ADD_PRODUCT_DATA == usageDataCollectorKey) {
            this.addProduct((Map)object);
        } else if (UsageDataCollectorKey.PANEL_DATA_ADD_PANEL_DATA == usageDataCollectorKey) {
            this.addPanelData((Map)object);
        } else if (UsageDataCollectorKey.SESSION_DATA_GPU_INFO == usageDataCollectorKey) {
            this.addGpuInfo((List)object);
        } else {
            this.keyValueMap.put(usageDataCollectorKey, object);
        }
    }

    public Object getData(UsageDataCollectorKey usageDataCollectorKey) {
        return this.keyValueMap.get(usageDataCollectorKey);
    }

    private void addPanelData(Map<UsageDataCollectorKey, Object> map) {
        Object object = map.get(UsageDataCollectorKey.PANEL_DATA_NAME);
        if (!this.panelNames.contains(object.toString())) {
            PanelData panelData = this.xsdObjectFactory.createPanelData();
            Set<Map.Entry<UsageDataCollectorKey, Object>> set = map.entrySet();
            for (Map.Entry<UsageDataCollectorKey, Object> entry : set) {
                String string = this.resourceRetriever.getResourceText((UdcResourceKey)entry.getKey());
                Object object2 = entry.getValue();
                try {
                    Method method = PANEL_DATA_CLASS.getMethod(string, object2.getClass());
                    method.invoke((Object)panelData, object2);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    this.logInvokeException(string, object2);
                }
            }
            this.panelDataList.add(panelData);
            this.panelNames.add(object.toString());
        }
    }

    private void addProduct(Map<UsageDataCollectorKey, Object> map) {
        ProductData productData = this.xsdObjectFactory.createProductData();
        Set<Map.Entry<UsageDataCollectorKey, Object>> set = map.entrySet();
        for (Map.Entry<UsageDataCollectorKey, Object> entry : set) {
            String string = this.resourceRetriever.getResourceText((UdcResourceKey)entry.getKey());
            Object object = entry.getValue();
            try {
                Method method = PRODUCT_DATA_CLASS.getMethod(string, object.getClass());
                method.invoke((Object)productData, object);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                this.logInvokeException(string, object);
            }
        }
        this.productDataList.add(productData);
    }

    private void addGpuInfo(List<String> list) {
        int n = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List list2 = this.installerUdcDataType.getGpuInfo();
        for (String string : list) {
            String[] stringArray = string.split(GPU_REGEX);
            GpuInfo gpuInfo = this.xsdObjectFactory.createGpuInfo();
            gpuInfo.setGpuUnit(n++);
            gpuInfo.setGpuVendor(stringArray[0].trim());
            gpuInfo.setGpuModel(stringArray[1].trim());
            gpuInfo.setGpuDriverVer(stringArray[2].trim());
            try {
                Date date = simpleDateFormat.parse(stringArray[3].trim());
                gpuInfo.setGpuDriverDate(date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            list2.add(gpuInfo);
        }
    }

    private void logInvokeException(String string, Object object) {
        this.logUdcMessage("Error: Could not find method '" + string + "(" + object.getClass().getCanonicalName() + ")'");
    }

    public void removeData(UsageDataCollectorKey usageDataCollectorKey) {
        if (UsageDataCollectorKey.PRODUCT_DATA_CLEAR_PRODUCT_DATA == usageDataCollectorKey) {
            this.productDataList.clear();
        } else if (UsageDataCollectorKey.PANEL_DATA_CLEAR_PANEL_DATA == usageDataCollectorKey) {
            this.panelDataList.clear();
        } else {
            this.keyValueMap.remove(usageDataCollectorKey);
        }
    }

    public void prepareDataForTransmission(String string) {
        this.sessionKey = string;
        this.populateXsdObject();
        this.addKeyValueEventsToList();
        this.addXsdEventToList();
    }

    private void populateXsdObject() {
        Set<UsageDataCollectorKey> set = this.keyValueMap.keySet();
        for (UsageDataCollectorKey usageDataCollectorKey : set) {
            String string = usageDataCollectorKey.getKeyText();
            if (!string.startsWith("session.")) continue;
            String string2 = this.resourceRetriever.getResourceText((UdcResourceKey)usageDataCollectorKey);
            Object object = this.keyValueMap.get(usageDataCollectorKey);
            try {
                Method method = InstallerUdcData.class.getMethod(string2, object.getClass());
                method.invoke((Object)this.installerUdcDataType, object);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                this.logInvokeException(string2, object);
            }
        }
    }

    private void addKeyValueEventsToList() {
        String string;
        Set<UsageDataCollectorKey> set = this.keyValueMap.keySet();
        Date date = new Date();
        for (UsageDataCollectorKey object : set) {
            string = object.getKeyText();
            if (string.startsWith("session.") || object == UsageDataCollectorKey.USAGE_DATA_TOKEN) continue;
            String string2 = this.keyValueMap.get(object).toString();
            Event event = this.createEvent(object, string2, this.sessionKey, date);
            this.eventList.add(event);
        }
        for (String string3 : this.gpuList) {
            string = this.createEvent(UsageDataCollectorKey.SESSION_DATA_GPU_INFO, string3, this.sessionKey, date);
            this.eventList.add((Event)string);
        }
    }

    private void addXsdEventToList() {
        try {
            String string = this.marshallXsdObject(false);
            Event event = new Event();
            event.setEventKey(INSTALL_XML_DATA);
            event.setEventData(string);
            event.setSessionKey(this.sessionKey);
            event.setEventDate(new Date());
            event.setApplicationComponent("");
            this.eventList.add(event);
        }
        catch (JAXBException jAXBException) {
            this.logUdcMessage("Error: " + jAXBException.getMessage());
        }
    }

    public void transmitData() {
        String string = "";
        if (this.keyValueMap.containsKey(UsageDataCollectorKey.SESSION_DATA_RELEASE_FAMILY)) {
            string = this.keyValueMap.get(UsageDataCollectorKey.SESSION_DATA_RELEASE_FAMILY).toString();
        }
        this.udcClient.setApplicationVersion(string);
        this.udcClient.setApplicationName(this.APPLICATION_NAME);
        this.udcClient.setClientString(this.APPLICATION_NAME + "_" + this.APPLICATION_VERSION);
        this.udcClient.setLocale(Locale.getDefault().toString());
        this.udcClient.setEndPoint(WSEndPoints.getUDCEndPoint());
        Object object = this.keyValueMap.get(UsageDataCollectorKey.USAGE_DATA_TOKEN);
        String string2 = object == null ? this.token : object.toString();
        this.udcClient.setToken(string2);
        if (this.disableEvents) {
            this.appLogger.safeLogMsg("Events service disabled.");
        } else {
            this.logEvents();
        }
        if (this.logFileFullPath != null) {
            this.writeUdcLogFile();
        }
    }

    public void ping() {
        if (!this.disableEvents) {
            this.udcClient.setClientString(this.APPLICATION_NAME + "_" + this.APPLICATION_VERSION);
            this.udcClient.setEndPoint(WSEndPoints.getUDCPingEndPoint());
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("UDC Ping");
                    InstallerUsageDataCollectorImpl.this.udcClient.ping();
                }
            });
        }
    }

    private String marshallXsdObject(boolean bl) throws JAXBException {
        Utils utils = new Utils();
        String string = utils.convertInstallerUdcObjToString(this.installerUdcDataType, bl);
        return string;
    }

    private void logEvents() {
        Events events = new Events();
        List list = events.getEvent();
        list.addAll(this.eventList);
        UdcClientTask udcClientTask = new UdcClientTask(this.udcClient, events);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        this.logUdcMessage("Submitting event data.");
        try {
            Exception exception = (Exception)executorService.submit(udcClientTask).get(15L, TimeUnit.SECONDS);
            if (exception != null) {
                this.logUdcMessage("Events exception: " + exception);
            } else {
                this.logUdcMessage("Event data submitted.");
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.logUdcMessage("Events exception: " + exception);
        }
        executorService.shutdown();
    }

    private void writeUdcLogFile() {
        FileIO fileIO = new FileIO((FilePermissions)new FilePermissionsUtil());
        File file = new File(this.logFileFullPath);
        fileIO.createParentIfNecessary(file);
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            String string = this.marshallXsdObject(true);
            bufferedOutputStream.write(string.getBytes(CHARACTER_ENCODING));
            this.writeKeyValuePairs(bufferedOutputStream);
            bufferedOutputStream.flush();
        }
        catch (IOException | JAXBException throwable) {
            this.logUdcMessage("Error writing udc log file: " + throwable.getMessage());
        }
    }

    private void writeKeyValuePairs(OutputStream outputStream) throws IOException {
        String string;
        Set<UsageDataCollectorKey> set = this.keyValueMap.keySet();
        for (UsageDataCollectorKey object : set) {
            string = object.getKeyText();
            if (string.startsWith("session.")) continue;
            String string2 = this.resourceRetriever.getResourceText((UdcResourceKey)object) + ":" + this.keyValueMap.get(object) + "\n";
            outputStream.write(string2.getBytes(CHARACTER_ENCODING));
        }
        for (String string3 : this.gpuList) {
            string = this.resourceRetriever.getResourceText((UdcResourceKey)UsageDataCollectorKey.SESSION_DATA_GPU_INFO) + ":" + string3 + "\n";
            outputStream.write(string.getBytes(CHARACTER_ENCODING));
        }
        String string3 = "sessionKey:" + this.sessionKey;
        outputStream.write(string3.getBytes(CHARACTER_ENCODING));
    }

    private void logUdcMessage(String string) {
        if (this.logFileFullPath != null) {
            this.appLogger.logMsg(string);
        }
    }

    private Event createEvent(UsageDataCollectorKey usageDataCollectorKey, String string, String string2, Date date) {
        Event event = new Event();
        event.setEventKey(this.resourceRetriever.getResourceText((UdcResourceKey)usageDataCollectorKey));
        event.setEventData(string);
        event.setSessionKey(string2);
        event.setEventDate(date);
        event.setApplicationComponent("");
        return event;
    }
}

