/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_task;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.Uninstaller;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_task.AbstractDefaultInstallTask;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.instutil.logging.AppLogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class UninstallTask
extends AbstractDefaultInstallTask {
    private Uninstaller uninstaller;
    private AppLogger appLogger;
    public long totalUnits;

    public UninstallTask(ExceptionHandler exceptionHandler, AppLogger appLogger, Uninstaller uninstaller, InstallStatusObserver ... installStatusObserverArray) {
        super(exceptionHandler, appLogger, installStatusObserverArray);
        this.uninstaller = uninstaller;
        this.appLogger = appLogger;
    }

    @Override
    protected long calculateTotalUnits() {
        return this.totalUnits;
    }

    @Override
    protected void execute(InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver[] installStatusObserverArray) throws Exception {
        try {
            this.uninstaller.uninstall(installStatusObserverArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.appLogger.safeLogMsg(classNotFoundException.getMessage());
            this.logException(this.appLogger, classNotFoundException);
        }
        catch (IOException iOException) {
            this.appLogger.safeLogMsg(iOException.getMessage());
            this.logException(this.appLogger, iOException);
        }
        catch (InterruptedException interruptedException) {
            this.appLogger.safeLogMsg(interruptedException.getMessage());
            this.logException(this.appLogger, interruptedException);
        }
        catch (Throwable throwable) {
            this.appLogger.safeLogMsg(throwable.getMessage());
            this.logException(this.appLogger, throwable);
        }
    }

    public void logException(AppLogger appLogger, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        appLogger.safeLogMsg(stringWriter.toString());
    }
}

