/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_task;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.Installer;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_task.AbstractDefaultInstallTask;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.instutil.MatlabInstallerUtil;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public final class InstallTask
extends AbstractDefaultInstallTask {
    private Installer installer;
    private File installFolder;
    private AppLogger appLogger;

    public InstallTask(Installer installer, File file, ExceptionHandler exceptionHandler, AppLogger appLogger, InstallStatusObserver ... installStatusObserverArray) {
        super(exceptionHandler, appLogger, installStatusObserverArray);
        this.installer = installer;
        this.installFolder = file;
        this.appLogger = appLogger;
    }

    @Override
    protected long calculateTotalUnits() {
        return this.calculateTotalUnits(this.installer, this.installFolder);
    }

    private long calculateTotalUnits(Installer installer, File file) {
        return installer.getInstallTotalUnits(file);
    }

    @Override
    protected void execute(InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver[] installStatusObserverArray) throws Exception {
        try {
            File file = new File(MatlabInstallerUtil.getDefaultDownloadFolderForInstallWorkflow());
            this.installer.install(this.installFolder, file, installFlowControlHandler, installStatusObserverArray);
            if (file.exists()) {
                FileUtils.forceDelete((File)file);
            }
        }
        catch (IOException iOException) {
            this.appLogger.safeLogMsg(iOException.getMessage());
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            this.appLogger.safeLogMsg(interruptedException.getMessage());
            throw interruptedException;
        }
        catch (Throwable throwable) {
            this.appLogger.safeLogMsg(throwable.getMessage());
            throw throwable;
        }
    }
}

