/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_task;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.SoftwareManager;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_task.AbstractDefaultInstallTask;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;

public class DownloadTask
extends AbstractDefaultInstallTask {
    private final SoftwareManager softwareManager;
    private final File downloadFolder;
    private AppLogger appLogger;

    public DownloadTask(SoftwareManager softwareManager, File file, ExceptionHandler exceptionHandler, AppLogger appLogger, InstallStatusObserver ... installStatusObserverArray) {
        super(exceptionHandler, appLogger, installStatusObserverArray);
        this.softwareManager = softwareManager;
        this.downloadFolder = file;
        this.appLogger = appLogger;
    }

    @Override
    protected long calculateTotalUnits() {
        return this.softwareManager.getBytesRequired(this.downloadFolder);
    }

    @Override
    protected void execute(InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver[] installStatusObserverArray) throws Exception {
        try {
            this.softwareManager.download(this.downloadFolder, installFlowControlHandler, installStatusObserverArray);
        }
        catch (IOException iOException) {
            this.appLogger.safeLogMsg(iOException.getMessage());
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            this.appLogger.safeLogMsg(interruptedException.getMessage());
            throw interruptedException;
        }
        catch (Throwable throwable) {
            this.appLogger.safeLogMsg(throwable.getMessage());
            throw throwable;
        }
    }
}

