/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_task;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_task.ExceptionHandler;
import com.mathworks.install_task.InstallerStatusObserverImpl;
import com.mathworks.install_task.TaskCommon;
import com.mathworks.install_task.TaskStatusObserver;
import com.mathworks.instutil.logging.AppLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractInstallTask
implements TaskCommon {
    private AppLogger appLogger;
    protected long start;
    protected final List<InstallStatusObserver> observers;
    private final Set<TaskStatusObserver> statusObservers = new LinkedHashSet<TaskStatusObserver>();
    private long idleTime = 0L;
    protected long totalUnits = -1L;
    private long idleStartTime;
    private Lock stateLock = new ReentrantLock();
    private TaskState state = TaskState.NOT_STARTED;
    private Condition condition = this.stateLock.newCondition();
    protected final ExceptionHandler exHandler;

    public AbstractInstallTask(ExceptionHandler exceptionHandler, AppLogger appLogger, InstallStatusObserver ... installStatusObserverArray) {
        this.exHandler = exceptionHandler;
        this.appLogger = appLogger;
        this.observers = new ArrayList<InstallStatusObserver>(Arrays.asList(installStatusObserverArray));
    }

    protected abstract long calculateTotalUnits();

    @Override
    public Boolean call() throws Exception {
        this.totalUnits = this.calculateTotalUnits();
        this.observers.add((InstallStatusObserver)new InstallerStatusObserverImpl(this));
        this.start = System.currentTimeMillis();
        try {
            this.setState(TaskState.RUNNING);
            this.execute(this, this.observers.toArray(new InstallStatusObserver[this.observers.size()]));
            this.setState(TaskState.DONE);
        }
        catch (IOException iOException) {
            this.exception(iOException);
            this.setState(TaskState.CANCELLED);
        }
        catch (InterruptedException interruptedException) {
            this.setState(TaskState.CANCELLED);
        }
        return this.getState() == TaskState.DONE;
    }

    public TaskStatusObserver[] getTaskStatusObservers() {
        return this.statusObservers.toArray(new TaskStatusObserver[this.statusObservers.size()]);
    }

    protected abstract void execute(InstallFlowControlHandler var1, InstallStatusObserver[] var2) throws Exception;

    public long getIdleTime() {
        return this.idleTime;
    }

    public long getTotalUnits() {
        return this.totalUnits;
    }

    protected TaskState getState() {
        this.stateLock.lock();
        try {
            TaskState taskState = this.state;
            return taskState;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    protected void setState(TaskState taskState) {
        this.stateLock.lock();
        try {
            this.state = taskState;
            this.condition.signalAll();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public boolean shouldRetry(String string, String string2, Throwable throwable) {
        return false;
    }

    public boolean checkTaskState() throws InterruptedException {
        this.idle();
        boolean bl = false;
        while (this.getState() == TaskState.PAUSED) {
            bl = true;
            this.stateLock.lock();
            try {
                this.condition.await();
            }
            finally {
                this.stateLock.unlock();
            }
        }
        if (this.getState() == TaskState.CANCELLED) {
            throw new InterruptedException();
        }
        this.active();
        return bl;
    }

    public void alert(String string) {
    }

    public void showInfoMessage(String string, String string2) throws InterruptedException {
    }

    public void exception(Throwable throwable) {
    }

    public void alert(String string, String string2) {
    }

    public void alert(Exception exception) {
    }

    public void logMsg(String string) {
        this.appLogger.logMsg(string);
    }

    public void exitImmediately(Throwable throwable) throws InterruptedException {
        this.exHandler.handleExceptionThatRequiresExit(throwable);
        throw new InterruptedException();
    }

    @Override
    public void addStatusObserver(TaskStatusObserver taskStatusObserver) {
        this.statusObservers.add(taskStatusObserver);
    }

    @Override
    public boolean pause() {
        this.stateLock.lock();
        try {
            if (this.state == TaskState.RUNNING) {
                this.state = TaskState.PAUSED;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public synchronized void resume() {
        this.setState(TaskState.RUNNING);
    }

    @Override
    public synchronized void cancel() {
        this.setState(TaskState.CANCELLED);
    }

    @Override
    public String getAccessibleName() {
        return null;
    }

    protected void idle() {
        this.idleStartTime = System.currentTimeMillis();
    }

    protected void active() {
        this.idleTime += System.currentTimeMillis() - this.idleStartTime;
    }

    protected static enum TaskState {
        NOT_STARTED,
        RUNNING,
        PAUSED,
        DONE,
        CANCELLED;

    }
}

