/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.mcrdws.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksServiceResponse;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.http.EntityEnclosingRequest;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.RequestContent;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.json.JacksonResponseHandler;
import com.mathworks.webservices.client.core.raw.RawByteResponseHandler;
import com.mathworks.webservices.mcrdws.v2.MCRDownloadClient;
import com.mathworks.webservices.mcrdws.v2.model.ComponentsRequest;
import com.mathworks.webservices.mcrdws.v2.model.ComponentsResponse;
import com.mathworks.webservices.mcrdws.v2.model.InstallerRequest;
import com.mathworks.webservices.mcrdws.v2.model.InstallerResponse;
import com.mathworks.webservices.mcrdws.v2.model.ReleaseDataRequest;
import com.mathworks.webservices.mcrdws.v2.model.ReleaseDataResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class MCRDownloadClientImpl
extends MathWorksWebServiceClient
implements MCRDownloadClient {
    private String full_endpoint = null;

    private String getEndpoint() {
        if (this.full_endpoint == null) {
            this.full_endpoint = this.endpoint + "/service/v2";
        }
        return this.full_endpoint;
    }

    private void initializeMarshaller() {
        if (JacksonResponseHandler.objectMapper == null) {
            JacksonResponseHandler.objectMapper = new ObjectMapper();
        }
    }

    public MCRDownloadClientImpl(ClientConfiguration config) {
        super(config, new JacksonResponseHandler());
    }

    @Override
    public MathWorksServiceResponse ping(String locale, String clientString) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest request = new HttpRequest(HttpMethodName.GET, this.getEndpoint(), "/ping");
        request.setLocale(locale);
        request.setClientString(clientString);
        return this.executeRequest(request, (ResponseHandler)new RawByteResponseHandler());
    }

    @Override
    public InstallerResponse getInstaller(String token, String locale, String clientString, InstallerRequest request) throws MathWorksServiceException, MathWorksClientException {
        String release = "empty";
        String status = "";
        String arch = "";
        String targetUpdateLevel = "";
        if (null != request) {
            release = request.getRelease();
            status = request.getStatus();
            arch = request.getArch();
            targetUpdateLevel = request.getTargetUpdateLevel();
            if (null != release && release.trim().isEmpty()) {
                release = "empty";
            }
        }
        String resourcePath = "/releases/" + release + "/installers";
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("status", status);
        requestParameters.put("arch", arch);
        requestParameters.put("targetUpdateLevel", targetUpdateLevel);
        return (InstallerResponse)this.executeRequest(this.createGetRequest(resourcePath, requestParameters, token, locale, clientString), InstallerResponse.class);
    }

    @Override
    public ReleaseDataResponse getReleaseData(String token, String locale, String clientString, ReleaseDataRequest request) throws MathWorksServiceException, MathWorksClientException {
        String release = "empty";
        String status = "";
        String arch = "";
        String targetUpdateLevel = "";
        if (null != request) {
            release = request.getRelease();
            status = request.getStatus();
            arch = request.getArch();
            targetUpdateLevel = request.getTargetUpdateLevel();
            if (null != release && release.trim().isEmpty()) {
                release = "empty";
            }
        }
        String resourcePath = "/releases/" + release + "/releasedata";
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("arch", arch);
        requestParameters.put("status", status);
        requestParameters.put("targetUpdateLevel", targetUpdateLevel);
        return (ReleaseDataResponse)this.executeRequest(this.createGetRequest(resourcePath, requestParameters, token, locale, clientString), ReleaseDataResponse.class);
    }

    @Override
    public ComponentsResponse getComponents(String token, String locale, String clientString, ComponentsRequest request) throws MathWorksServiceException, MathWorksClientException {
        String release = "empty";
        if (null != request && null != (release = request.getRelease()) && release.trim().isEmpty()) {
            release = "empty";
        }
        String resourcePath = "/releases/" + release + "/components";
        return (ComponentsResponse)this.executeRequest((HttpRequest)this.createPostRequest(resourcePath, request, token, locale, clientString), ComponentsResponse.class);
    }

    private HttpRequest createGetRequest(String url, HashMap<String, String> requestParameters, String token, String locale, String clientString) {
        HttpRequest request = new HttpRequest(HttpMethodName.GET, this.getEndpoint(), url);
        request.addHeader("x-mw-authentication", token);
        request.addHeader("Accept-Language", locale);
        request.addHeader("x-mw-clientString", clientString);
        for (Map.Entry<String, String> requestParameter : requestParameters.entrySet()) {
            request.addParameter(requestParameter.getKey(), requestParameter.getValue());
        }
        request.setLocale(locale);
        request.setClientString(clientString);
        return request;
    }

    private EntityEnclosingRequest createPostRequest(String url, Object object, String token, String locale, String clientString) {
        try {
            this.initializeMarshaller();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JacksonResponseHandler.objectMapper.writeValue((OutputStream)byteArrayOutputStream, object);
            EntityEnclosingRequest request = new EntityEnclosingRequest(HttpMethodName.POST, this.getEndpoint(), url);
            RequestContent requestContent = new RequestContent(byteArrayOutputStream.toByteArray(), "application/json");
            request.setRequestContent(requestContent);
            request.addHeader("x-mw-authentication", token);
            request.addHeader("Accept-Language", locale);
            request.addHeader("x-mw-clientstring", clientString);
            request.setLocale(locale);
            request.setClientString(clientString);
            return request;
        }
        catch (IOException exception) {
            throw new MathWorksClientException(exception.getMessage());
        }
    }
}

