/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.service;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.install_impl.service.ServiceFactoryDefault;
import com.mathworks.install_impl.service.ServiceFactoryWindows;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.WinTaskScheduler;
import com.mathworks.instutil.WinTaskSchedulerImpl;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.LicenseLocationFactoryImpl;
import com.mathworks.instutil.logging.AppLogger;

public final class ServiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(LicenseLocationFactory.class).to(LicenseLocationFactoryImpl.class);
        this.bind(WinTaskScheduler.class).to(WinTaskSchedulerImpl.class);
    }

    @Provides
    static ServiceFactory provideServiceFactory(Platform platform, LicenseLocationFactory licenseLocationFactory, WinTaskScheduler winTaskScheduler, AppLogger appLogger) {
        if (platform.isWindows()) {
            return new ServiceFactoryWindows(licenseLocationFactory, winTaskScheduler, platform.getArchString(), appLogger);
        }
        return new ServiceFactoryDefault();
    }
}

