/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.service;

import com.mathworks.install.service.ScheduledTaskParameters;
import com.mathworks.install.service.ServiceException;
import com.mathworks.install_impl.service.AbstractServiceWindows;
import com.mathworks.instutil.WinTaskScheduler;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.text.MessageFormat;

final class ScheduledTaskWindows
extends AbstractServiceWindows {
    private final ScheduledTaskParameters scheduledTaskParameters;
    private final WinTaskScheduler winTaskScheduler;
    private String arch;
    private AppLogger appLogger;

    public ScheduledTaskWindows(ScheduledTaskParameters scheduledTaskParameters, WinTaskScheduler winTaskScheduler, String string, AppLogger appLogger) {
        this.scheduledTaskParameters = scheduledTaskParameters;
        this.winTaskScheduler = winTaskScheduler;
        this.arch = string;
        this.appLogger = appLogger;
    }

    @Override
    public int exists(File file, StringBuffer stringBuffer) {
        String string = this.scheduledTaskParameters.getTaskName();
        int n = this.winTaskScheduler.taskExists(string);
        if (n == 0) {
            Object[] objectArray = new Object[]{string, this.scheduledTaskParameters.getStartInFolder(file, this.arch).getAbsolutePath()};
            String string2 = MessageFormat.format("Task {0} for {1} does not exist", objectArray);
            this.appLogger.logMsg(string2);
            return 0;
        }
        String string3 = this.winTaskScheduler.getTaskApplicationPath(string);
        String string4 = this.scheduledTaskParameters.getProgram(file, this.arch).getAbsolutePath();
        Object[] objectArray = new Object[]{string, string4};
        if (string3.equalsIgnoreCase(string4)) {
            this.appLogger.logMsg(MessageFormat.format("Task {0} for {1} exists", objectArray));
            return 1;
        }
        this.appLogger.logMsg(MessageFormat.format("Task {0} for {1} does not exist", objectArray));
        return 0;
    }

    @Override
    int stop(StringBuffer stringBuffer) {
        String string = this.scheduledTaskParameters.getTaskName();
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format("Stopping task {0}", objectArray);
        this.appLogger.logMsg(string2);
        return this.winTaskScheduler.taskTerminateAndDisable(string);
    }

    @Override
    int remove(File file, StringBuffer stringBuffer) {
        String string = this.scheduledTaskParameters.getTaskName();
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format("Removing task {0}", objectArray);
        this.appLogger.logMsg(string2);
        return this.winTaskScheduler.taskDelete(string);
    }

    public String getDisplayName() {
        return null;
    }

    public File getLocation(File file) {
        return null;
    }

    public void install(File file) throws ServiceException {
        String string = this.scheduledTaskParameters.getTaskName();
        String[] stringArray = this.scheduledTaskParameters.getProgramArguments(file, this.arch);
        String string2 = this.arrayToString(stringArray);
        String string3 = this.scheduledTaskParameters.getProgram(file, this.arch).getAbsolutePath();
        Object[] objectArray = new Object[]{string, string3};
        String string4 = MessageFormat.format("Scheduling task {0} for {1}", objectArray);
        this.appLogger.logMsg(string4);
        int n = this.winTaskScheduler.taskCreate(string, string3, this.scheduledTaskParameters.getStartInFolder(file, this.arch).getAbsolutePath(), string2);
        if (n > 0) {
            Object[] objectArray2 = new Object[]{new Integer(n).toString(), string, string3};
            String string5 = MessageFormat.format("Error {0} scheduling task {1} for {2}", objectArray2);
            this.appLogger.logMsg(string5);
        }
    }

    private String arrayToString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = " ";
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("\"");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("\"");
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString().trim();
    }
}

