/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.service;

import com.mathworks.install.service.ServiceException;
import com.mathworks.install_impl.service.AbstractServiceWindows;
import com.mathworks.install_impl.service.UnableToInstallServiceException;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import java.io.File;

final class LicenseManagerServiceWindows
extends AbstractServiceWindows {
    private final String myArch;
    private final LicenseLocationFactory licLocationFactory;

    LicenseManagerServiceWindows(LicenseLocationFactory licenseLocationFactory, String string) {
        this.myArch = string;
        this.licLocationFactory = licenseLocationFactory;
    }

    @Override
    int exists(File file, StringBuffer stringBuffer) {
        return this.flexServiceExists(this.getPathToLmgrd(file), stringBuffer);
    }

    private String getPathToLmgrd(File file) {
        return new File(this.getLocation(file), "lmgrd.exe").getAbsolutePath();
    }

    public String getDisplayName() {
        return "MATLAB License Server";
    }

    public File getLocation(File file) {
        return new File(file, "etc" + File.separator + this.myArch);
    }

    @Override
    int stop(StringBuffer stringBuffer) {
        return this.stopFlexService(stringBuffer);
    }

    @Override
    int remove(File file, StringBuffer stringBuffer) {
        return this.deleteFlexService(stringBuffer);
    }

    public void install(File file) throws ServiceException {
        StringBuffer stringBuffer;
        String string;
        String string2 = this.getLocation(file).getAbsolutePath().concat(File.separator);
        int n = this.installFlexService(string2, string = this.licLocationFactory.getNetworkServerLicenseLocation(file.getAbsolutePath()).getLicenseLocation().concat(File.separator), stringBuffer = new StringBuffer());
        if (n == 0) {
            throw new UnableToInstallServiceException(stringBuffer);
        }
    }

    private native int flexServiceExists(String var1, StringBuffer var2);

    private native int deleteFlexService(StringBuffer var1);

    private native int stopFlexService(StringBuffer var1);

    private native int installFlexService(String var1, String var2, StringBuffer var3);
}

