/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.google.inject.Inject;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.UpdateComponentContainer;
import com.mathworks.install.UpdateProductContainer;
import com.mathworks.install.input.ComponentData;
import com.mathworks.install.input.MetaData;
import com.mathworks.install.input.ProductData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class UpdateProductContainerImpl
implements UpdateProductContainer {
    private static final String UNDERSCORE = "_";
    private static final String SPACE = "\\s";
    private final UpdateComponentContainer updateComponentContainer;
    private ProductData productData;
    private Map<String, ProductData.Product> modifiedProductData;
    private ComponentData componentData;

    @Inject
    public UpdateProductContainerImpl(UpdateComponentContainer updateComponentContainer) {
        this.updateComponentContainer = updateComponentContainer;
    }

    public List<String> getUpdatedProductNames() {
        Set<String> set = this.modifiedProductData.keySet();
        return new ArrayList<String>(set);
    }

    public String getTargetUpdateLevel() {
        MetaData metaData = this.productData.getMetadata();
        MetaData.ReleaseMetaData releaseMetaData = metaData.getTarget();
        String string = releaseMetaData.getRelease();
        String string2 = releaseMetaData.getDescription();
        String string3 = string2.replaceAll(SPACE, UNDERSCORE);
        return string + UNDERSCORE + string3;
    }

    public String getBaseVersion() {
        MetaData metaData = this.productData.getMetadata();
        MetaData.ReleaseMetaData releaseMetaData = metaData.getBase();
        return releaseMetaData.getVersion();
    }

    public ProductData getProductData() {
        return this.productData;
    }

    public void setUpdateProductData(ProductData productData) {
        this.productData = productData;
    }

    public void setUpdateComponentData(ComponentData componentData) {
        this.componentData = componentData;
    }

    public List<String> getUpdateComponentNames(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(this.getComponentsToUpdate(string));
        linkedHashSet.addAll(this.getComponentsToDelete(string));
        linkedHashSet.addAll(this.getComponentsToAdd(string));
        return new ArrayList<String>(linkedHashSet);
    }

    public List<String> getComponentsToUpdate(String string) {
        ProductData.Product product = this.modifiedProductData.get(string);
        return product.getAllComponents();
    }

    public List<String> getComponentsToDelete(String string) {
        ProductData.Product product = this.modifiedProductData.get(string);
        return product.getComponentsToDelete();
    }

    public List<String> getComponentsToAdd(String string) {
        ProductData.Product product = this.modifiedProductData.get(string);
        return product.getComponentsToAdd();
    }

    public void computeUpdatedProducts() {
        this.modifiedProductData = new HashMap<String, ProductData.Product>();
        Map map = this.productData.getProducts();
        for (String string : map.keySet()) {
            ProductData.Product product = (ProductData.Product)map.get(string);
            List list = product.getComponentsToAdd();
            product.setComponentsToAdd(this.getCompleteComponentNames(list));
            List list2 = product.getComponentsToDelete();
            product.setComponentsToDelete(this.getCompleteComponentNamesForDeletedComponents(list2));
            List list3 = product.getAllComponents();
            List<String> list4 = this.getCompleteComponentNames(list3);
            list4.retainAll(this.updateComponentContainer.getUpdatedCompleteComponentNames());
            product.setComponentsToUpdate(list4);
            if (list.isEmpty() && list2.isEmpty() && list4.isEmpty()) continue;
            this.modifiedProductData.put(string, product);
        }
    }

    public long getUpdateSize(InstallableProduct[] installableProductArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (InstallableProduct object : installableProductArray) {
            arrayList.add(object.getProductData().getName());
        }
        arrayList.retainAll(this.modifiedProductData.keySet());
        long l = 0L;
        for (String string : arrayList) {
            List<String> list = this.getUpdateComponentNames(string);
            for (String string2 : list) {
                l += this.updateComponentContainer.getUpdateSize(string2);
            }
        }
        return l;
    }

    public long getDownloadSize(InstallableProduct[] installableProductArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (InstallableProduct object : installableProductArray) {
            arrayList.add(object.getProductData().getName());
        }
        arrayList.retainAll(this.modifiedProductData.keySet());
        long l = 0L;
        for (String string : arrayList) {
            List<String> list = this.getUpdateComponentNames(string);
            for (String string2 : list) {
                l += this.updateComponentContainer.getDownloadSize(string2);
            }
        }
        return 3L * l / 4L;
    }

    private List<String> getCompleteComponentNames(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.componentData.getComponents();
        for (String string : list) {
            ComponentData.Component component = (ComponentData.Component)map.get(string);
            ArrayList<String> arrayList2 = new ArrayList<String>(component.getPkgs());
            for (String string2 : component.getGain()) {
                if (arrayList2.contains(string2)) continue;
                arrayList2.add(string2);
            }
            for (String string2 : arrayList2) {
                arrayList.add(string + UNDERSCORE + string2);
            }
        }
        return arrayList;
    }

    private List<String> getCompleteComponentNamesForDeletedComponents(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map = this.componentData.getComponents();
        for (String string : list) {
            ComponentData.Component component = (ComponentData.Component)map.get(string);
            ArrayList arrayList2 = new ArrayList(component.getPkgs());
            arrayList2.addAll(component.getLoss());
            for (String string2 : arrayList2) {
                arrayList.add(string + UNDERSCORE + string2);
            }
        }
        return arrayList;
    }
}

