/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.InputStreamProvider;
import com.mathworks.install.JSONInstallationFileParser;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.archive.Archive;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.ComponentData;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.DeltaData;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.ProductData;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install_impl.input.ArchiveInputStreamProvider;
import com.mathworks.install_impl.input.CompressedXMLAndJSONComponentSourceProvider;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public final class UpdateCompressedInstallationInputFile
implements InstallationInputFile {
    private final File file;
    private XMLInstallationFileParser xmlInstallationFileParser;
    private final ComponentSourceFactory componentSourceFactory;
    private final ArchiveFactory archiveFactory;
    private final ContentOptimizer contentOptimizer;
    private final JSONInstallationFileParser jsonInstallationFileParser;

    UpdateCompressedInstallationInputFile(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory, ContentOptimizer contentOptimizer, JSONInstallationFileParser jSONInstallationFileParser) {
        this.file = file;
        this.archiveFactory = archiveFactory;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.componentSourceFactory = componentSourceFactory;
        this.contentOptimizer = contentOptimizer;
        this.jsonInstallationFileParser = jSONInstallationFileParser;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException, XMLParseException {
        Archive archive = null;
        try {
            archive = this.archiveFactory.createArchive(this.getFile());
            for (String string : archive.getEntries()) {
                if (!this.contentOptimizer.accept(string)) continue;
                ArchiveInputStreamProvider archiveInputStreamProvider = new ArchiveInputStreamProvider(archive, string);
                if (FilenameUtils.isExtension((String)string, (String)"xml")) {
                    this.xmlInstallationFileParser.readInDefinition((InputStreamProvider)archiveInputStreamProvider, (ComponentSourceProvider)new CompressedXMLAndJSONComponentSourceProvider(this.componentSourceFactory, this.file));
                    continue;
                }
                if (string.contains("product_data.json")) {
                    this.jsonInstallationFileParser.parseProductJSON(archiveInputStreamProvider.getInputStream(), ProductData.class);
                    continue;
                }
                if (string.contains("delta_data.json")) {
                    this.jsonInstallationFileParser.parseDeltaJSON(archiveInputStreamProvider.getInputStream(), DeltaData.class);
                    continue;
                }
                if (!string.contains("component_data.json")) continue;
                this.jsonInstallationFileParser.parseComponentJSON(archiveInputStreamProvider.getInputStream(), ComponentData.class);
            }
        }
        finally {
            if (archive != null) {
                archive.closeQuietly();
            }
        }
    }
}

