/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.mathworks.install.UpdateComponentContainer;
import com.mathworks.install.input.DeltaData;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

class UpdateComponentContainerImpl
implements UpdateComponentContainer {
    private static final String UNDERSCORE = "_";
    private static final String LINUX_PATH_SEPARATOR = "/";
    private DeltaData deltaData;
    private Map<String, Map<String, DeltaData.FileProperties>> modifiedComponentsData;
    private Map<String, Map<String, DeltaData.FileProperties>> componentsDeletedFiles;
    private Map<String, Map<String, DeltaData.FileProperties>> componentsTouchedFiles;
    private Map<String, Map<String, DeltaData.FileProperties>> allUpdatedComponentsData = new HashMap<String, Map<String, DeltaData.FileProperties>>();

    UpdateComponentContainerImpl() {
    }

    public List<String> getUpdatedCompleteComponentNames() {
        Set<String> set = this.modifiedComponentsData.keySet();
        return new ArrayList<String>(set);
    }

    public void setUpdateDeltaData(DeltaData deltaData) {
        this.deltaData = deltaData;
    }

    public List<String> getFilesToDelete(String string) {
        ArrayList<Object> arrayList = new ArrayList();
        Map<String, DeltaData.FileProperties> map = this.componentsDeletedFiles.get(string);
        if (map != null) {
            arrayList = new ArrayList<String>(map.keySet());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : arrayList) {
            arrayList2.add(string2.replaceAll(LINUX_PATH_SEPARATOR, Matcher.quoteReplacement(File.separator)));
        }
        return arrayList2;
    }

    public List<String> getFilesToUpdate(String string) {
        ArrayList<Object> arrayList = new ArrayList();
        Map<String, DeltaData.FileProperties> map = this.modifiedComponentsData.get(string);
        if (map != null) {
            arrayList = new ArrayList<String>(map.keySet());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : arrayList) {
            arrayList2.add(string2.replaceAll(LINUX_PATH_SEPARATOR, Matcher.quoteReplacement(File.separator)));
        }
        return arrayList2;
    }

    public List<String> getComponentsWithFileDeletions() {
        Set<String> set = this.componentsDeletedFiles.keySet();
        return new ArrayList<String>(set);
    }

    public List<String> getComponentsWithFilesTouchedButNotUpdated() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.componentsTouchedFiles.keySet()) {
            if (this.modifiedComponentsData.containsKey(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getPackageNames(String string) {
        Map map;
        ArrayList<String> arrayList = new ArrayList<String>();
        Map map2 = this.deltaData.getComponents();
        if (map2 != null && (map = (Map)map2.get(string)) != null) {
            Set set = map.keySet();
            for (String string2 : set) {
                arrayList.add(string + UNDERSCORE + string2);
            }
        }
        return arrayList;
    }

    public void computeUpdatedComponents() {
        this.modifiedComponentsData = new HashMap<String, Map<String, DeltaData.FileProperties>>();
        this.componentsDeletedFiles = new HashMap<String, Map<String, DeltaData.FileProperties>>();
        this.componentsTouchedFiles = new HashMap<String, Map<String, DeltaData.FileProperties>>();
        Map map = this.deltaData.getComponents();
        if (map != null) {
            for (String string : map.keySet()) {
                Map map2 = (Map)map.get(string);
                if (map2 == null) continue;
                for (String string2 : map2.keySet()) {
                    Map map3 = (Map)map2.get(string2);
                    HashMap hashMap = new HashMap();
                    HashMap hashMap2 = new HashMap();
                    HashMap hashMap3 = new HashMap();
                    for (String string3 : map3.keySet()) {
                        boolean bl;
                        DeltaData.FileProperties fileProperties = (DeltaData.FileProperties)map3.get(string3);
                        long l = fileProperties.getNew_size();
                        long l2 = fileProperties.getOld_size();
                        String string4 = fileProperties.getNew_csum();
                        String string5 = fileProperties.getOld_csum();
                        int n = fileProperties.getNew_time();
                        int n2 = fileProperties.getOld_time();
                        boolean bl2 = l == 0L && n2 != 0 && n == 0;
                        boolean bl3 = this.hasSizeChanged(l, l2) && this.hasTimestampChanged(n, n2) || this.hasChecksumChanged(l, string4, string5) && this.hasTimestampChanged(n, n2) || n2 == 0 && n > 0;
                        boolean bl4 = bl = this.hasTimestampChanged(n, n2) && l == l2 && string4.equals(string5);
                        if (bl2) {
                            hashMap.put(string3, map3.get(string3));
                        }
                        if (bl3) {
                            hashMap2.put(string3, map3.get(string3));
                        }
                        if (!bl) continue;
                        hashMap3.put(string3, map3.get(string3));
                    }
                    if (!hashMap.isEmpty()) {
                        this.componentsDeletedFiles.put(string + UNDERSCORE + string2, hashMap);
                    }
                    if (!hashMap2.isEmpty()) {
                        this.modifiedComponentsData.put(string + UNDERSCORE + string2, hashMap2);
                    }
                    if (hashMap3.isEmpty()) continue;
                    this.componentsTouchedFiles.put(string + UNDERSCORE + string2, hashMap3);
                }
            }
        }
    }

    public long getUpdateSize(String string) {
        long l = 0L;
        Map<String, DeltaData.FileProperties> map = this.getAllUpdatedComponentsData().get(string);
        if (map != null) {
            for (String string2 : map.keySet()) {
                DeltaData.FileProperties fileProperties = map.get(string2);
                l += fileProperties.getNew_size() - fileProperties.getOld_size();
            }
        }
        return l;
    }

    public long getDownloadSize(String string) {
        long l = 0L;
        Map<String, DeltaData.FileProperties> map = this.getAllUpdatedComponentsData().get(string);
        if (map != null) {
            for (String string2 : map.keySet()) {
                DeltaData.FileProperties fileProperties = map.get(string2);
                l += fileProperties.getNew_size();
            }
        }
        return l;
    }

    private boolean hasChecksumChanged(long l, String string, String string2) {
        return !string.equals(string2) && l != 0L;
    }

    private boolean hasSizeChanged(long l, long l2) {
        return l != l2 && l != 0L;
    }

    private boolean hasTimestampChanged(int n, int n2) {
        return n != n2 && n != 0;
    }

    private Map<String, Map<String, DeltaData.FileProperties>> getAllUpdatedComponentsData() {
        if (this.allUpdatedComponentsData.isEmpty()) {
            this.allUpdatedComponentsData.putAll(this.componentsDeletedFiles);
            this.allUpdatedComponentsData.putAll(this.modifiedComponentsData);
        }
        return this.allUpdatedComponentsData;
    }
}

