/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.google.inject.Inject;
import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.JSONInstallationFileParser;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.InstallationInputFileStrategy;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install_impl.input.CompressedXMLInstallationInputFile;
import com.mathworks.install_impl.input.ProductOrComponentJSONFile;
import com.mathworks.install_impl.input.ProductOrComponentXMLFileForZip;
import com.mathworks.install_impl.input.UnifiedProductArchive;
import com.mathworks.instutil.Platform;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

class UnifiedInstallationInputFileStrategy
implements InstallationInputFileStrategy {
    private final Platform platform;

    @Inject
    public UnifiedInstallationInputFileStrategy(Platform platform) {
        this.platform = platform;
    }

    public InstallationInputFile createProductArchive(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory) {
        return new UnifiedProductArchive(file, archiveFactory, xMLInstallationFileParser, componentSourceFactory, this.platform);
    }

    public InstallationInputFile createProductOrComponentXMLFile(File file, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory) {
        return new ProductOrComponentXMLFileForZip(file, xMLInstallationFileParser, componentSourceFactory);
    }

    public InstallationInputFile createProductOrComponentJSONFile(File file, JSONInstallationFileParser jSONInstallationFileParser) {
        return new ProductOrComponentJSONFile(file, jSONInstallationFileParser);
    }

    public boolean isProductArchive(File file) {
        boolean bl = false;
        String string = "_common_";
        String string2 = "_".concat(this.platform.getArchString()).concat("_");
        String string3 = file.getName();
        if (FilenameUtils.isExtension((String)string3, (String)"zip") && !string3.contains(string) && !string3.contains(string2)) {
            bl = true;
        }
        return bl;
    }

    public InstallationInputFile createCompressedXMLOrJSONFile(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory, ContentOptimizer contentOptimizer, JSONInstallationFileParser jSONInstallationFileParser) {
        return new CompressedXMLInstallationInputFile(file, archiveFactory, xMLInstallationFileParser, componentSourceFactory, contentOptimizer);
    }
}

