/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.mathworks.install.ComponentData;
import com.mathworks.install.InputStreamProvider;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.input.ComponentSource;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install_impl.input.FileInputStreamProvider;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

final class ProductOrComponentXMLFile
implements InstallationInputFile {
    private final File file;
    private XMLInstallationFileParser xmlInstallationFileParser;
    private final ComponentSourceFactory componentSourceFactory;

    ProductOrComponentXMLFile(File file, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory) {
        this.file = file;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.componentSourceFactory = componentSourceFactory;
    }

    public File getFile() {
        return this.file;
    }

    public void parse() throws IOException, XMLParseException {
        this.xmlInstallationFileParser.readInDefinition((InputStreamProvider)new FileInputStreamProvider(this.file), new ComponentSourceProvider(){
            private FileInputStream fileInputStream;

            public void open() throws IOException {
                this.fileInputStream = new FileInputStream(FilenameUtils.removeExtension((String)ProductOrComponentXMLFile.this.file.getAbsolutePath()).concat(".enc"));
            }

            public ComponentSource getComponentSource(File file, String string, ComponentData componentData) throws IOException {
                return ProductOrComponentXMLFile.this.componentSourceFactory.createArchiveComponentSource((InputStream)this.fileInputStream);
            }

            public void close() {
                IOUtils.closeQuietly((InputStream)this.fileInputStream);
            }

            public long getDownloadSize(long l) {
                return 0L;
            }

            public void addComponent(String string) {
            }

            public void download(File file, String string, ComponentData componentData, long l, String string2, IOObserver iOObserver) throws IOException, InterruptedException {
            }
        });
    }
}

